// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 25.4.4.1.2
description: The [[Prototype]] of Promise.all Resolve Element functions
info: >
  17 ECMAScript Standard Built-in Objects:
    Unless otherwise specified every built-in function and every built-in
    constructor has the Function prototype object, which is the initial
    value of the expression Function.prototype (19.2.3), as the value of
    its [[Prototype]] internal slot.
---*/

var resolveElementFunction;
var thenable = {
  then: function(fulfill) {
    resolveElementFunction = fulfill;
  }
};
function NotPromise(executor) {
  executor(function(){}, function(){});
}
NotPromise.resolve = function(v) { return v; };
Promise.all.call(NotPromise, [thenable]);

assert.sameValue(Object.getPrototypeOf(resolveElementFunction), Function.prototype);

reportCompare(0, 0);
