/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

Components.utils.import("resource://services-sync/engines/forms.js");

function getDummyServerAndClient() {
  return {
    server: [
      {
        id: "11111",
        guid: "11111",
        name: "foo",
        fieldname: "foo",
        value: "bar",
      },
      {
        id: "22222",
        guid: "22222",
        name: "foo2",
        fieldname: "foo2",
        value: "bar2",
      },
      {
        id: "33333",
        guid: "33333",
        name: "foo3",
        fieldname: "foo3",
        value: "bar3",
      },
    ],
    client: [
      {
        id: "11111",
        guid: "11111",
        name: "foo",
        fieldname: "foo",
        value: "bar",
      },
      {
        id: "22222",
        guid: "22222",
        name: "foo2",
        fieldname: "foo2",
        value: "bar2",
      },
      {
        id: "33333",
        guid: "33333",
        name: "foo3",
        fieldname: "foo3",
        value: "bar3",
      }
    ]
  };
}

add_test(function test_valid() {
  let { server, client } = getDummyServerAndClient();
  let validator = new FormValidator();
  let { problemData, clientRecords, records, deletedRecords } =
      validator.compareClientWithServer(client, server);
  equal(clientRecords.length, 3);
  equal(records.length, 3)
  equal(deletedRecords.length, 0);
  deepEqual(problemData, validator.emptyProblemData());

  run_next_test();
});


add_test(function test_formValidatorIgnoresMissingClients() {
  // Since history form records are not deleted from the server, the
  // |FormValidator| shouldn't set the |missingClient| flag in |problemData|.
  let { server, client } = getDummyServerAndClient();
  client.pop();

  let validator = new FormValidator();
  let { problemData, clientRecords, records, deletedRecords } =
      validator.compareClientWithServer(client, server);

  equal(clientRecords.length, 2);
  equal(records.length, 3);
  equal(deletedRecords.length, 0);

  let expected = validator.emptyProblemData();
  deepEqual(problemData, expected);

  run_next_test();
});

function run_test() {
  run_next_test();
}
