/* -*- tab-width: 2; indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */


/**
   File Name:          15.1.2.4.js
   ECMA Section:       15.1.2.4  Function properties of the global object
   escape( string )

   Description:
   The escape function computes a new version of a string value in which
   certain characters have been replaced by a hexadecimal escape sequence.
   The result thus contains no special characters that might have special
   meaning within a URL.

   For characters whose Unicode encoding is 0xFF or less, a two-digit
   escape sequence of the form %xx is used in accordance with RFC1738.
   For characters whose Unicode encoding is greater than 0xFF, a four-
   digit escape sequence of the form %uxxxx is used.

   When the escape function is called with one argument string, the
   following steps are taken:

   1.  Call ToString(string).
   2.  Compute the number of characters in Result(1).
   3.  Let R be the empty string.
   4.  Let k be 0.
   5.  If k equals Result(2), return R.
   6.  Get the character at position k within Result(1).
   7.  If Result(6) is one of the 69 nonblank ASCII characters
   ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz
   0123456789 @*_+-./, go to step 14.
   8.  Compute the 16-bit unsigned integer that is the Unicode character
   encoding of Result(6).
   9.  If Result(8), is less than 256, go to step 12.
   10.  Let S be a string containing six characters "%uwxyz" where wxyz are
   four hexadecimal digits encoding the value of Result(8).
   11.  Go to step 15.
   12.  Let S be a string containing three characters "%xy" where xy are two
   hexadecimal digits encoding the value of Result(8).
   13.  Go to step 15.
   14.  Let S be a string containing the single character Result(6).
   15.  Let R be a new string value computed by concatenating the previous value
   of R and S.
   16.  Increase k by 1.
   17.  Go to step 5.

   Author:             christine@netscape.com
   Date:               28 october 1997

*/
var SECTION = "15.1.2.4";
var TITLE   = "escape(string)";

writeHeaderToLog( SECTION + " "+ TITLE);

new TestCase( "escape.length",         1,          escape.length );
new TestCase( "escape.length = null; escape.length",   1,  eval("escape.length = null; escape.length") );
new TestCase( "var MYPROPS=''; for ( var p in escape ) { MYPROPS+= p}; MYPROPS",    "",    eval("var MYPROPS=''; for ( var p in escape ) { MYPROPS+= p}; MYPROPS") );

new TestCase( "escape()",              "undefined",    escape() );
new TestCase( "escape('')",            "",             escape('') );
new TestCase( "escape( null )",        "null",         escape(null) );
new TestCase( "escape( void 0 )",      "undefined",    escape(void 0) );
new TestCase( "escape( true )",        "true",         escape( true ) );
new TestCase( "escape( false )",       "false",        escape( false ) );

new TestCase( "escape( new Boolean(true) )",   "true", escape(new Boolean(true)) );
new TestCase( "escape( new Boolean(false) )",  "false",    escape(new Boolean(false)) );

new TestCase( "escape( Number.NaN  )",                 "NaN",      escape(Number.NaN) );
new TestCase( "escape( -0 )",                          "0",        escape( -0 ) );
new TestCase( "escape( 'Infinity' )",                  "Infinity", escape( "Infinity" ) );
new TestCase( "escape( Number.POSITIVE_INFINITY )",    "Infinity", escape( Number.POSITIVE_INFINITY ) );
new TestCase( "escape( Number.NEGATIVE_INFINITY )",    "-Infinity", escape( Number.NEGATIVE_INFINITY ) );

var ASCII_TEST_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*_+-./";

new TestCase( "escape( " +ASCII_TEST_STRING+" )",    ASCII_TEST_STRING,  escape( ASCII_TEST_STRING ) );

// ASCII value less than

for ( var CHARCODE = 0; CHARCODE < 32; CHARCODE++ ) {
  new TestCase(
		"escape(String.fromCharCode("+CHARCODE+"))",
		"%"+ToHexString(CHARCODE),
		escape(String.fromCharCode(CHARCODE))  );
}
for ( var CHARCODE = 128; CHARCODE < 256; CHARCODE++ ) {
  new TestCase(
		"escape(String.fromCharCode("+CHARCODE+"))",
		"%"+ToHexString(CHARCODE),
		escape(String.fromCharCode(CHARCODE))  );
}

for ( var CHARCODE = 256; CHARCODE < 1024; CHARCODE++ ) {
  new TestCase(
		"escape(String.fromCharCode("+CHARCODE+"))",
		"%u"+ ToUnicodeString(CHARCODE),
		escape(String.fromCharCode(CHARCODE))  );
}
for ( var CHARCODE = 65500; CHARCODE < 65536; CHARCODE++ ) {
  new TestCase(
		"escape(String.fromCharCode("+CHARCODE+"))",
		"%u"+ ToUnicodeString(CHARCODE),
		escape(String.fromCharCode(CHARCODE))  );
}

test();

function ToUnicodeString( n ) {
  var string = ToHexString(n);

  for ( var PAD = (4 - string.length ); PAD > 0; PAD-- ) {
    string = "0" + string;
  }

  return string;
}
function ToHexString( n ) {
  var hex = new Array();

  for ( var mag = 1; Math.pow(16,mag) <= n ; mag++ ) {
    ;
  }

  for ( index = 0, mag -= 1; mag > 0; index++, mag-- ) {
    hex[index] = Math.floor( n / Math.pow(16,mag) );
    n -= Math.pow(16,mag) * Math.floor( n/Math.pow(16,mag) );
  }

  hex[hex.length] = n % 16;

  var string ="";

  for ( var index = 0 ; index < hex.length ; index++ ) {
    switch ( hex[index] ) {
    case 10:
      string += "A";
      break;
    case 11:
      string += "B";
      break;
    case 12:
      string += "C";
      break;
    case 13:
      string += "D";
      break;
    case 14:
      string += "E";
      break;
    case 15:
      string += "F";
      break;
    default:
      string += hex[index];
    }
  }

  if ( string.length == 1 ) {
    string = "0" + string;
  }
  return string;
}
