// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 18.2.6.3
esid: sec-decodeuricomponent-encodeduricomponent
description: >
  decodeURIComponent.name is "decodeURIComponent".
info: >
  decodeURIComponent (encodedURIComponent)

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(decodeURIComponent.name, "decodeURIComponent");

verifyNotEnumerable(decodeURIComponent, "name");
verifyNotWritable(decodeURIComponent, "name");
verifyConfigurable(decodeURIComponent, "name");

reportCompare(0, 0);
