// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2018 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_3_1_autogen.cpp:
//   Defines the GLES 3.1 entry points.

#include "libGLESv2/entry_points_gles_3_1_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/validationES31.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY ActiveShaderProgram(GLuint pipeline, GLuint program)
{
    EVENT("(GLuint pipeline = %u, GLuint program = %u)", pipeline, program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ActiveShaderProgram>(pipeline, program);

        if (context->skipValidation() || ValidateActiveShaderProgram(context, pipeline, program))
        {
            context->activeShaderProgram(pipeline, program);
        }
    }
}

void GL_APIENTRY BindImageTexture(GLuint unit,
                                  GLuint texture,
                                  GLint level,
                                  GLboolean layered,
                                  GLint layer,
                                  GLenum access,
                                  GLenum format)
{
    EVENT(
        "(GLuint unit = %u, GLuint texture = %u, GLint level = %d, GLboolean layered = %u, GLint "
        "layer = %d, GLenum access = 0x%X, GLenum format = 0x%X)",
        unit, texture, level, layered, layer, access, format);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindImageTexture>(unit, texture, level, layered, layer,
                                                            access, format);

        if (context->skipValidation() ||
            ValidateBindImageTexture(context, unit, texture, level, layered, layer, access, format))
        {
            context->bindImageTexture(unit, texture, level, layered, layer, access, format);
        }
    }
}

void GL_APIENTRY BindProgramPipeline(GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindProgramPipeline>(pipeline);

        if (context->skipValidation() || ValidateBindProgramPipeline(context, pipeline))
        {
            context->bindProgramPipeline(pipeline);
        }
    }
}

void GL_APIENTRY BindVertexBuffer(GLuint bindingindex,
                                  GLuint buffer,
                                  GLintptr offset,
                                  GLsizei stride)
{
    EVENT(
        "(GLuint bindingindex = %u, GLuint buffer = %u, GLintptr offset = %d, GLsizei stride = %d)",
        bindingindex, buffer, offset, stride);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindVertexBuffer>(bindingindex, buffer, offset, stride);

        if (context->skipValidation() ||
            ValidateBindVertexBuffer(context, bindingindex, buffer, offset, stride))
        {
            context->bindVertexBuffer(bindingindex, buffer, offset, stride);
        }
    }
}

GLuint GL_APIENTRY CreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const *strings)
{
    EVENT("(GLenum type = 0x%X, GLsizei count = %d, const GLchar *const*strings = 0x%0.8p)", type,
          count, strings);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ShaderType typePacked = FromGLenum<ShaderType>(type);
        context->gatherParams<EntryPoint::CreateShaderProgramv>(typePacked, count, strings);

        if (context->skipValidation() ||
            ValidateCreateShaderProgramv(context, typePacked, count, strings))
        {
            return context->createShaderProgramv(typePacked, count, strings);
        }
    }

    return GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
}

void GL_APIENTRY DeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
    EVENT("(GLsizei n = %d, const GLuint *pipelines = 0x%0.8p)", n, pipelines);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteProgramPipelines>(n, pipelines);

        if (context->skipValidation() || ValidateDeleteProgramPipelines(context, n, pipelines))
        {
            context->deleteProgramPipelines(n, pipelines);
        }
    }
}

void GL_APIENTRY DispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
    EVENT("(GLuint num_groups_x = %u, GLuint num_groups_y = %u, GLuint num_groups_z = %u)",
          num_groups_x, num_groups_y, num_groups_z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DispatchCompute>(num_groups_x, num_groups_y,
                                                           num_groups_z);

        if (context->skipValidation() ||
            ValidateDispatchCompute(context, num_groups_x, num_groups_y, num_groups_z))
        {
            context->dispatchCompute(num_groups_x, num_groups_y, num_groups_z);
        }
    }
}

void GL_APIENTRY DispatchComputeIndirect(GLintptr indirect)
{
    EVENT("(GLintptr indirect = %d)", indirect);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DispatchComputeIndirect>(indirect);

        if (context->skipValidation() || ValidateDispatchComputeIndirect(context, indirect))
        {
            context->dispatchComputeIndirect(indirect);
        }
    }
}

void GL_APIENTRY DrawArraysIndirect(GLenum mode, const void *indirect)
{
    EVENT("(GLenum mode = 0x%X, const void *indirect = 0x%0.8p)", mode, indirect);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawArraysIndirect>(mode, indirect);

        if (context->skipValidation() || ValidateDrawArraysIndirect(context, mode, indirect))
        {
            context->drawArraysIndirect(mode, indirect);
        }
    }
}

void GL_APIENTRY DrawElementsIndirect(GLenum mode, GLenum type, const void *indirect)
{
    EVENT("(GLenum mode = 0x%X, GLenum type = 0x%X, const void *indirect = 0x%0.8p)", mode, type,
          indirect);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawElementsIndirect>(mode, type, indirect);

        if (context->skipValidation() ||
            ValidateDrawElementsIndirect(context, mode, type, indirect))
        {
            context->drawElementsIndirect(mode, type, indirect);
        }
    }
}

void GL_APIENTRY FramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::FramebufferParameteri>(target, pname, param);

        if (context->skipValidation() ||
            ValidateFramebufferParameteri(context, target, pname, param))
        {
            context->framebufferParameteri(target, pname, param);
        }
    }
}

void GL_APIENTRY GenProgramPipelines(GLsizei n, GLuint *pipelines)
{
    EVENT("(GLsizei n = %d, GLuint *pipelines = 0x%0.8p)", n, pipelines);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenProgramPipelines>(n, pipelines);

        if (context->skipValidation() || ValidateGenProgramPipelines(context, n, pipelines))
        {
            context->genProgramPipelines(n, pipelines);
        }
    }
}

void GL_APIENTRY GetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    EVENT("(GLenum target = 0x%X, GLuint index = %u, GLboolean *data = 0x%0.8p)", target, index,
          data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetBooleani_v>(target, index, data);

        if (context->skipValidation() || ValidateGetBooleani_v(context, target, index, data))
        {
            context->getBooleani_v(target, index, data);
        }
    }
}

void GL_APIENTRY GetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetFramebufferParameteriv>(target, pname, params);

        if (context->skipValidation() ||
            ValidateGetFramebufferParameteriv(context, target, pname, params))
        {
            context->getFramebufferParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
    EVENT("(GLenum pname = 0x%X, GLuint index = %u, GLfloat *val = 0x%0.8p)", pname, index, val);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetMultisamplefv>(pname, index, val);

        if (context->skipValidation() || ValidateGetMultisamplefv(context, pname, index, val))
        {
            context->getMultisamplefv(pname, index, val);
        }
    }
}

void GL_APIENTRY GetProgramInterfaceiv(GLuint program,
                                       GLenum programInterface,
                                       GLenum pname,
                                       GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLenum pname = 0x%X, GLint *params "
        "= 0x%0.8p)",
        program, programInterface, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramInterfaceiv>(program, programInterface, pname,
                                                                 params);

        if (context->skipValidation() ||
            ValidateGetProgramInterfaceiv(context, program, programInterface, pname, params))
        {
            context->getProgramInterfaceiv(program, programInterface, pname, params);
        }
    }
}

void GL_APIENTRY GetProgramPipelineInfoLog(GLuint pipeline,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *infoLog)
{
    EVENT(
        "(GLuint pipeline = %u, GLsizei bufSize = %d, GLsizei *length = 0x%0.8p, GLchar *infoLog = "
        "0x%0.8p)",
        pipeline, bufSize, length, infoLog);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramPipelineInfoLog>(pipeline, bufSize, length,
                                                                     infoLog);

        if (context->skipValidation() ||
            ValidateGetProgramPipelineInfoLog(context, pipeline, bufSize, length, infoLog))
        {
            context->getProgramPipelineInfoLog(pipeline, bufSize, length, infoLog);
        }
    }
}

void GL_APIENTRY GetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
    EVENT("(GLuint pipeline = %u, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", pipeline, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramPipelineiv>(pipeline, pname, params);

        if (context->skipValidation() ||
            ValidateGetProgramPipelineiv(context, pipeline, pname, params))
        {
            context->getProgramPipelineiv(pipeline, pname, params);
        }
    }
}

GLuint GL_APIENTRY GetProgramResourceIndex(GLuint program,
                                           GLenum programInterface,
                                           const GLchar *name)
{
    EVENT("(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%0.8p)",
          program, programInterface, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramResourceIndex>(program, programInterface, name);

        if (context->skipValidation() ||
            ValidateGetProgramResourceIndex(context, program, programInterface, name))
        {
            return context->getProgramResourceIndex(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceIndex, GLuint>();
}

GLint GL_APIENTRY GetProgramResourceLocation(GLuint program,
                                             GLenum programInterface,
                                             const GLchar *name)
{
    EVENT("(GLuint program = %u, GLenum programInterface = 0x%X, const GLchar *name = 0x%0.8p)",
          program, programInterface, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramResourceLocation>(program, programInterface,
                                                                      name);

        if (context->skipValidation() ||
            ValidateGetProgramResourceLocation(context, program, programInterface, name))
        {
            return context->getProgramResourceLocation(program, programInterface, name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetProgramResourceLocation, GLint>();
}

void GL_APIENTRY GetProgramResourceName(GLuint program,
                                        GLenum programInterface,
                                        GLuint index,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *name)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLuint index = %u, GLsizei bufSize "
        "= %d, GLsizei *length = 0x%0.8p, GLchar *name = 0x%0.8p)",
        program, programInterface, index, bufSize, length, name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramResourceName>(program, programInterface, index,
                                                                  bufSize, length, name);

        if (context->skipValidation() ||
            ValidateGetProgramResourceName(context, program, programInterface, index, bufSize,
                                           length, name))
        {
            context->getProgramResourceName(program, programInterface, index, bufSize, length,
                                            name);
        }
    }
}

void GL_APIENTRY GetProgramResourceiv(GLuint program,
                                      GLenum programInterface,
                                      GLuint index,
                                      GLsizei propCount,
                                      const GLenum *props,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLint *params)
{
    EVENT(
        "(GLuint program = %u, GLenum programInterface = 0x%X, GLuint index = %u, GLsizei "
        "propCount = %d, const GLenum *props = 0x%0.8p, GLsizei bufSize = %d, GLsizei *length = "
        "0x%0.8p, GLint *params = 0x%0.8p)",
        program, programInterface, index, propCount, props, bufSize, length, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetProgramResourceiv>(
            program, programInterface, index, propCount, props, bufSize, length, params);

        if (context->skipValidation() ||
            ValidateGetProgramResourceiv(context, program, programInterface, index, propCount,
                                         props, bufSize, length, params))
        {
            context->getProgramResourceiv(program, programInterface, index, propCount, props,
                                          bufSize, length, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)",
        target, level, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        context->gatherParams<EntryPoint::GetTexLevelParameterfv>(targetPacked, level, pname,
                                                                  params);

        if (context->skipValidation() ||
            ValidateGetTexLevelParameterfv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
    }
}

void GL_APIENTRY GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLint level = %d, GLenum pname = 0x%X, GLint *params = 0x%0.8p)",
          target, level, pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureTarget targetPacked = FromGLenum<TextureTarget>(target);
        context->gatherParams<EntryPoint::GetTexLevelParameteriv>(targetPacked, level, pname,
                                                                  params);

        if (context->skipValidation() ||
            ValidateGetTexLevelParameteriv(context, targetPacked, level, pname, params))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
    }
}

GLboolean GL_APIENTRY IsProgramPipeline(GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsProgramPipeline>(pipeline);

        if (context->skipValidation() || ValidateIsProgramPipeline(context, pipeline))
        {
            return context->isProgramPipeline(pipeline);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
}

void GL_APIENTRY MemoryBarrier(GLbitfield barriers)
{
    EVENT("(GLbitfield barriers = 0x%X)", barriers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MemoryBarrier>(barriers);

        if (context->skipValidation() || ValidateMemoryBarrier(context, barriers))
        {
            context->memoryBarrier(barriers);
        }
    }
}

void GL_APIENTRY MemoryBarrierByRegion(GLbitfield barriers)
{
    EVENT("(GLbitfield barriers = 0x%X)", barriers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MemoryBarrierByRegion>(barriers);

        if (context->skipValidation() || ValidateMemoryBarrierByRegion(context, barriers))
        {
            context->memoryBarrierByRegion(barriers);
        }
    }
}

void GL_APIENTRY ProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat v0 = %f)", program, location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1f>(program, location, v0);

        if (context->skipValidation() || ValidateProgramUniform1f(context, program, location, v0))
        {
            context->programUniform1f(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1fv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform1fv(context, program, location, count, value))
        {
            context->programUniform1fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform1i(GLuint program, GLint location, GLint v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d)", program, location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1i>(program, location, v0);

        if (context->skipValidation() || ValidateProgramUniform1i(context, program, location, v0))
        {
            context->programUniform1i(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1iv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform1iv(context, program, location, count, value))
        {
            context->programUniform1iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint v0 = %u)", program, location, v0);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1ui>(program, location, v0);

        if (context->skipValidation() || ValidateProgramUniform1ui(context, program, location, v0))
        {
            context->programUniform1ui(program, location, v0);
        }
    }
}

void GL_APIENTRY ProgramUniform1uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform1uiv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform1uiv(context, program, location, count, value))
        {
            context->programUniform1uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f)", program,
          location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2f>(program, location, v0, v1);

        if (context->skipValidation() ||
            ValidateProgramUniform2f(context, program, location, v0, v1))
        {
            context->programUniform2f(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2fv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform2fv(context, program, location, count, value))
        {
            context->programUniform2fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d)", program,
          location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2i>(program, location, v0, v1);

        if (context->skipValidation() ||
            ValidateProgramUniform2i(context, program, location, v0, v1))
        {
            context->programUniform2i(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2iv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform2iv(context, program, location, count, value))
        {
            context->programUniform2iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u)", program,
          location, v0, v1);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2ui>(program, location, v0, v1);

        if (context->skipValidation() ||
            ValidateProgramUniform2ui(context, program, location, v0, v1))
        {
            context->programUniform2ui(program, location, v0, v1);
        }
    }
}

void GL_APIENTRY ProgramUniform2uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform2uiv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform2uiv(context, program, location, count, value))
        {
            context->programUniform2uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY
ProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = "
        "%f)",
        program, location, v0, v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3f>(program, location, v0, v1, v2);

        if (context->skipValidation() ||
            ValidateProgramUniform3f(context, program, location, v0, v1, v2))
        {
            context->programUniform3f(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3fv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform3fv(context, program, location, count, value))
        {
            context->programUniform3fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    EVENT("(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d)",
          program, location, v0, v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3i>(program, location, v0, v1, v2);

        if (context->skipValidation() ||
            ValidateProgramUniform3i(context, program, location, v0, v1, v2))
        {
            context->programUniform3i(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3iv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform3iv(context, program, location, count, value))
        {
            context->programUniform3iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = "
        "%u)",
        program, location, v0, v1, v2);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3ui>(program, location, v0, v1, v2);

        if (context->skipValidation() ||
            ValidateProgramUniform3ui(context, program, location, v0, v1, v2))
        {
            context->programUniform3ui(program, location, v0, v1, v2);
        }
    }
}

void GL_APIENTRY ProgramUniform3uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform3uiv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform3uiv(context, program, location, count, value))
        {
            context->programUniform3uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY
ProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLfloat v0 = %f, GLfloat v1 = %f, GLfloat v2 = "
        "%f, GLfloat v3 = %f)",
        program, location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4f>(program, location, v0, v1, v2, v3);

        if (context->skipValidation() ||
            ValidateProgramUniform4f(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4f(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLfloat *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4fv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform4fv(context, program, location, count, value))
        {
            context->programUniform4fv(program, location, count, value);
        }
    }
}

void GL_APIENTRY
ProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLint v0 = %d, GLint v1 = %d, GLint v2 = %d, "
        "GLint v3 = %d)",
        program, location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4i>(program, location, v0, v1, v2, v3);

        if (context->skipValidation() ||
            ValidateProgramUniform4i(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4i(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4iv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform4iv(context, program, location, count, value))
        {
            context->programUniform4iv(program, location, count, value);
        }
    }
}

void GL_APIENTRY
ProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLuint v0 = %u, GLuint v1 = %u, GLuint v2 = "
        "%u, GLuint v3 = %u)",
        program, location, v0, v1, v2, v3);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4ui>(program, location, v0, v1, v2, v3);

        if (context->skipValidation() ||
            ValidateProgramUniform4ui(context, program, location, v0, v1, v2, v3))
        {
            context->programUniform4ui(program, location, v0, v1, v2, v3);
        }
    }
}

void GL_APIENTRY ProgramUniform4uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, const GLuint *value = "
        "0x%0.8p)",
        program, location, count, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniform4uiv>(program, location, count, value);

        if (context->skipValidation() ||
            ValidateProgramUniform4uiv(context, program, location, count, value))
        {
            context->programUniform4uiv(program, location, count, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix2fv>(program, location, count,
                                                                   transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2x3fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix2x3fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2x3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2x3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix2x4fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix2x4fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix2x4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix2x4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix3fv>(program, location, count,
                                                                   transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3x2fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix3x2fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3x2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3x2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix3x4fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix3x4fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix3x4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix3x4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix4fv>(program, location, count,
                                                                   transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4x2fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix4x2fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4x2fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4x2fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY ProgramUniformMatrix4x3fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    EVENT(
        "(GLuint program = %u, GLint location = %d, GLsizei count = %d, GLboolean transpose = %u, "
        "const GLfloat *value = 0x%0.8p)",
        program, location, count, transpose, value);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ProgramUniformMatrix4x3fv>(program, location, count,
                                                                     transpose, value);

        if (context->skipValidation() ||
            ValidateProgramUniformMatrix4x3fv(context, program, location, count, transpose, value))
        {
            context->programUniformMatrix4x3fv(program, location, count, transpose, value);
        }
    }
}

void GL_APIENTRY SampleMaski(GLuint maskNumber, GLbitfield mask)
{
    EVENT("(GLuint maskNumber = %u, GLbitfield mask = 0x%X)", maskNumber, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::SampleMaski>(maskNumber, mask);

        if (context->skipValidation() || ValidateSampleMaski(context, maskNumber, mask))
        {
            context->sampleMaski(maskNumber, mask);
        }
    }
}

void GL_APIENTRY TexStorage2DMultisample(GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLboolean fixedsamplelocations)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizei samples = %d, GLenum internalformat = 0x%X, GLsizei width "
        "= %d, GLsizei height = %d, GLboolean fixedsamplelocations = %u)",
        target, samples, internalformat, width, height, fixedsamplelocations);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        context->gatherParams<EntryPoint::TexStorage2DMultisample>(
            targetPacked, samples, internalformat, width, height, fixedsamplelocations);

        if (context->skipValidation() ||
            ValidateTexStorage2DMultisample(context, targetPacked, samples, internalformat, width,
                                            height, fixedsamplelocations))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
    }
}

void GL_APIENTRY UseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
    EVENT("(GLuint pipeline = %u, GLbitfield stages = 0x%X, GLuint program = %u)", pipeline, stages,
          program);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::UseProgramStages>(pipeline, stages, program);

        if (context->skipValidation() ||
            ValidateUseProgramStages(context, pipeline, stages, program))
        {
            context->useProgramStages(pipeline, stages, program);
        }
    }
}

void GL_APIENTRY ValidateProgramPipeline(GLuint pipeline)
{
    EVENT("(GLuint pipeline = %u)", pipeline);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ValidateProgramPipeline>(pipeline);

        if (context->skipValidation() || ValidateValidateProgramPipeline(context, pipeline))
        {
            context->validateProgramPipeline(pipeline);
        }
    }
}

void GL_APIENTRY VertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
    EVENT("(GLuint attribindex = %u, GLuint bindingindex = %u)", attribindex, bindingindex);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttribBinding>(attribindex, bindingindex);

        if (context->skipValidation() ||
            ValidateVertexAttribBinding(context, attribindex, bindingindex))
        {
            context->vertexAttribBinding(attribindex, bindingindex);
        }
    }
}

void GL_APIENTRY VertexAttribFormat(GLuint attribindex,
                                    GLint size,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint relativeoffset)
{
    EVENT(
        "(GLuint attribindex = %u, GLint size = %d, GLenum type = 0x%X, GLboolean normalized = %u, "
        "GLuint relativeoffset = %u)",
        attribindex, size, type, normalized, relativeoffset);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttribFormat>(attribindex, size, type, normalized,
                                                              relativeoffset);

        if (context->skipValidation() ||
            ValidateVertexAttribFormat(context, attribindex, size, type, normalized,
                                       relativeoffset))
        {
            context->vertexAttribFormat(attribindex, size, type, normalized, relativeoffset);
        }
    }
}

void GL_APIENTRY VertexAttribIFormat(GLuint attribindex,
                                     GLint size,
                                     GLenum type,
                                     GLuint relativeoffset)
{
    EVENT(
        "(GLuint attribindex = %u, GLint size = %d, GLenum type = 0x%X, GLuint relativeoffset = "
        "%u)",
        attribindex, size, type, relativeoffset);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexAttribIFormat>(attribindex, size, type,
                                                               relativeoffset);

        if (context->skipValidation() ||
            ValidateVertexAttribIFormat(context, attribindex, size, type, relativeoffset))
        {
            context->vertexAttribIFormat(attribindex, size, type, relativeoffset);
        }
    }
}

void GL_APIENTRY VertexBindingDivisor(GLuint bindingindex, GLuint divisor)
{
    EVENT("(GLuint bindingindex = %u, GLuint divisor = %u)", bindingindex, divisor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexBindingDivisor>(bindingindex, divisor);

        if (context->skipValidation() ||
            ValidateVertexBindingDivisor(context, bindingindex, divisor))
        {
            context->vertexBindingDivisor(bindingindex, divisor);
        }
    }
}
}  // namespace gl
