# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate.helpers import MESSAGE_REFERENCE, EXTERNAL_ARGUMENT
from fluent.migrate import COPY, CONCAT, REPLACE


def migrate(ctx):
    """Bug 1419547 - Migrate Preferences::Containers to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/preferences.ftl',
        'browser/browser/preferences/preferences.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('containers-back-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/containers.dtd',
                    'backLink2.label'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('containers-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.dtd',
                    'paneContainers.title',
                )
            ),
            FTL.Message(
                id=FTL.Identifier('containers-add-button'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'addButton.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'addButton.accesskey'
                        )
                    ),
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('containers-preferences-button'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'preferencesButton.label'
                        )
                    ),
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('containers-remove-button'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'removeButton.label'
                        )
                    ),
                ]
            ),
        ]
    )

    ctx.add_transforms(
        'browser/browser/preferences/containers.ftl',
        'browser/browser/preferences/containers.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('containers-window-new'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'window.title',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            FTL.TextElement('width: '),
                            COPY(
                                'browser/chrome/browser/preferences/containers.dtd',
                                'window.width',
                            ),
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-window-update'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        REPLACE(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.updateContainerTitle',
                            {
                                '%S': EXTERNAL_ARGUMENT('name')
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            FTL.TextElement('width: '),
                            COPY(
                                'browser/chrome/browser/preferences/containers.dtd',
                                'window.width',
                            ),
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-window-close'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('key'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'windowClose.key',
                        ),
                    ),
                ],
            ),
            FTL.Term(
                id=FTL.Identifier('-containers-labels-style'),
                value=CONCAT(
                    FTL.TextElement('min-width: '),
                    COPY(
                        'browser/chrome/browser/preferences/containers.properties',
                        'containers.labelMinWidth',
                    ),
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('containers-name-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/containers.dtd',
                    'name2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'name2.accesskey',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            MESSAGE_REFERENCE('-containers-labels-style'),
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-name-text'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('placeholder'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'name.placeholder',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/containers.dtd',
                    'icon2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'icon2.accesskey',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            MESSAGE_REFERENCE('-containers-labels-style'),
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/containers.dtd',
                    'color2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'color2.accesskey',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        CONCAT(
                            MESSAGE_REFERENCE('-containers-labels-style'),
                        )
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-button-done'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'button.ok.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.dtd',
                            'button.ok.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-blue'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.blue.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-turquoise'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.turquoise.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-green'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.green.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-yellow'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.yellow.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-orange'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.orange.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-red'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.red.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-pink'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.pink.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-color-purple'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.purple.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-fingerprint'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.fingerprint.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-briefcase'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.briefcase.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-dollar'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.dollar.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-cart'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.cart.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-circle'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.circle.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-vacation'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.vacation.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-gift'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.gift.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-food'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.food.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-fruit'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.fruit.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-pet'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.pet.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-tree'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.tree.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('containers-icon-chill'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/containers.properties',
                            'containers.chill.label',
                        ),
                    ),
                ],
            ),

        ]
    )
