// |reftest| skip-if(!Intl.hasOwnProperty('Segmenter')) -- Intl.Segmenter is not enabled unconditionally
// Copyright 2018 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-Intl.Segmenter.prototype.resolvedOptions
description: Checks the "resolvedOptions" property of the Segmenter prototype object.
info: |
    Intl.Segmenter.prototype.resolvedOptions ()

    Unless specified otherwise in this document, the objects, functions, and constructors described in this standard are subject to the generic requirements and restrictions specified for standard built-in ECMAScript objects in the ECMAScript 2019 Language Specification, 10th edition, clause 17, or successor.

    Every other data property described in clauses 18 through 26 and in Annex B.2 has the attributes { [[Writable]]: true, [[Enumerable]]: false, [[Configurable]]: true } unless otherwise specified.
includes: [propertyHelper.js]
features: [Intl.Segmenter]
---*/

assert.sameValue(
  typeof Intl.Segmenter.prototype.resolvedOptions,
  "function",
  "typeof Intl.Segmenter.prototype.resolvedOptions is function"
);

verifyProperty(Intl.Segmenter.prototype, "resolvedOptions", {
  writable: true,
  enumerable: false,
  configurable: true,
});

reportCompare(0, 0);
