/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef MOZILLA_GFX_SHAREDSURFACESMEMORYREPORT_H
#define MOZILLA_GFX_SHAREDSURFACESMEMORYREPORT_H

#include <cstdint>  // for uint32_t
#include <unordered_map>
#include "ipc/IPCMessageUtils.h"
#include "mozilla/gfx/Point.h"  // for IntSize

namespace mozilla {
namespace layers {

class SharedSurfacesMemoryReport final {
 public:
  class SurfaceEntry final {
   public:
    base::ProcessId mCreatorPid;
    gfx::IntSize mSize;
    int32_t mStride;
    uint32_t mConsumers;
    bool mCreatorRef;
  };

  std::unordered_map<uint64_t, SurfaceEntry> mSurfaces;
};

}  // namespace layers
}  // namespace mozilla

namespace IPC {

template <>
struct ParamTraits<mozilla::layers::SharedSurfacesMemoryReport> {
  typedef mozilla::layers::SharedSurfacesMemoryReport paramType;

  static void Write(Message* aMsg, const paramType& aParam) {
    WriteParam(aMsg, aParam.mSurfaces);
  }

  static bool Read(const Message* aMsg, PickleIterator* aIter,
                   paramType* aResult) {
    return ReadParam(aMsg, aIter, &aResult->mSurfaces);
  }
};

template <>
struct ParamTraits<mozilla::layers::SharedSurfacesMemoryReport::SurfaceEntry>
    : public PlainOldDataSerializer<
          mozilla::layers::SharedSurfacesMemoryReport::SurfaceEntry> {};

template <class KeyType, class DataType>
struct ParamTraits<std::unordered_map<KeyType, DataType>> {
  typedef std::unordered_map<KeyType, DataType> paramType;

  static void Write(Message* aMsg, const paramType& aParam) {
    WriteParam(aMsg, aParam.size());
    for (auto i = aParam.begin(); i != aParam.end(); ++i) {
      WriteParam(aMsg, i->first);
      WriteParam(aMsg, i->second);
    }
  }

  static bool Read(const Message* aMsg, PickleIterator* aIter,
                   paramType* aResult) {
    size_t count;
    if (!ReadParam(aMsg, aIter, &count)) {
      return false;
    }
    for (; count > 0; --count) {
      KeyType k;
      DataType v;
      if (!ReadParam(aMsg, aIter, &k) || !ReadParam(aMsg, aIter, &v)) {
        return false;
      }
      aResult->insert(std::make_pair(std::move(k), std::move(v)));
    }
    return true;
  }
};

}  // namespace IPC

#endif
