/*
 * Copyright 2016 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 *
 */

//
// This file was generated using a modified version of
// the Perl script "algorithm-networksort-chooser" found here:
//
// http://search.cpan.org/dist/Algorithm-Networksort-Chooser/bin/algorithm-networksort-chooser
//

#include "networks.h"
#include "common/macros.h"

//
//
//

#define S(n)   static struct hsg_op const sn##n[]
#define X(a,b) { HSG_OP_TYPE_CMP_XCHG, { a, b }}

//
//
//

#define LS(n)  { ARRAY_LENGTH_MACRO(sn##n), sn##n }

//
//
//

S(2) = {
  X(1,2)
};
S(4) = {
  X(1,3), X(2,4), X(1,2), X(3,4), X(2,3)
};
S(6) = {
  X(1,5), X(2,6), X(1,3), X(2,4), X(3,5), X(4,6), X(1,2), X(3,4), X(5,6),
  X(2,5), X(2,3), X(4,5)
};
S(8) = {
  X(1,5), X(2,6), X(3,7), X(4,8), X(1,3), X(2,4), X(5,7), X(6,8), X(3,5),
  X(4,6), X(1,2), X(3,4), X(5,6), X(7,8), X(2,5), X(4,7), X(2,3), X(4,5), X(6,7)
};
S(10) = {
  X(5,10), X(4,9), X(3,8), X(2,7), X(1,6), X(2,5), X(7,10), X(1,4), X(6,9),
  X(1,3), X(4,7), X(8,10), X(1,2), X(3,5), X(6,8), X(9,10), X(2,3), X(5,7),
  X(8,9), X(4,6), X(3,6), X(7,9), X(2,4), X(5,8), X(3,4), X(7,8), X(4,5), X(6,7),
  X(5,6)
};
S(12) = {
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(2,4), X(6,8), X(10,12),
  X(1,3), X(5,7), X(9,11), X(2,3), X(6,7), X(10,11), X(2,6), X(7,11), X(6,10),
  X(3,7), X(2,6), X(7,11), X(1,5), X(8,12), X(4,8), X(5,9), X(1,5), X(8,12),
  X(2,5), X(8,11), X(4,9), X(3,4), X(9,10), X(3,5), X(8,10), X(4,6), X(7,9),
  X(4,5), X(6,7), X(8,9)
};
S(14) = {
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(1,3), X(5,7),
  X(9,11), X(2,4), X(6,8), X(10,12), X(1,5), X(9,13), X(2,6), X(10,14), X(3,7),
  X(4,8), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(6,11), X(7,10),
  X(4,13), X(8,12), X(2,3), X(5,9), X(2,5), X(8,14), X(3,9), X(3,5), X(6,7),
  X(10,11), X(12,14), X(4,9), X(8,13), X(7,9), X(11,13), X(4,6), X(8,10), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(7,8), X(9,10)
};
S(16) = {
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(1,3),
  X(5,7), X(9,11), X(13,15), X(2,4), X(6,8), X(10,12), X(14,16), X(1,5), X(9,13),
  X(2,6), X(10,14), X(3,7), X(11,15), X(4,8), X(12,16), X(1,9), X(2,10), X(3,11),
  X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(6,11), X(7,10), X(4,13),
  X(14,15), X(8,12), X(2,3), X(5,9), X(2,5), X(8,14), X(3,9), X(12,15), X(3,5),
  X(6,7), X(10,11), X(12,14), X(4,9), X(8,13), X(7,9), X(11,13), X(4,6), X(8,10),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(7,8), X(9,10)
};
S(18) = {
  X(1,17), X(2,18), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(9,17), X(10,18), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(5,17), X(6,18), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(3,17), X(4,18), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(2,17), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17)
};
S(20) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(9,17), X(10,18), X(11,19), X(12,20),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(5,17),
  X(6,18), X(7,19), X(8,20), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17),
  X(14,18), X(15,19), X(16,20), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(3,17), X(4,18), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(2,17), X(4,19),
  X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(2,3), X(4,5), X(6,7),
  X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19)
};
S(22) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(5,17), X(6,18),
  X(7,19), X(8,20), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(3,17), X(4,18), X(7,21), X(8,22),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(2,17), X(4,19), X(6,21),
  X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21)
};
S(24) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(9,17),
  X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(1,5),
  X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21),
  X(18,22), X(19,23), X(20,24), X(5,17), X(6,18), X(7,19), X(8,20), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(1,3),
  X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19),
  X(18,20), X(21,23), X(22,24), X(3,17), X(4,18), X(7,21), X(8,22), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(2,17), X(4,19), X(6,21),
  X(8,23), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23)
};
S(26) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25)
};
S(28) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27)
};
S(30) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29)
};
S(32) = {
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31)
};
S(34) = {
  X(1,33), X(2,34), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(17,33), X(18,34), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(9,33), X(10,34), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(5,33), X(6,34), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(3,33), X(4,34), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(2,33), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33)
};
S(36) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(17,33), X(18,34), X(19,35), X(20,36),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(9,33), X(10,34), X(11,35), X(12,36), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(5,33), X(6,34), X(7,35), X(8,36), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(3,33), X(4,34), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(2,33), X(4,35),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35)
};
S(38) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(5,33), X(6,34), X(7,35), X(8,36), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(3,33), X(4,34), X(7,37), X(8,38),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(2,33), X(4,35), X(6,37), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37)
};
S(40) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(5,33), X(6,34), X(7,35), X(8,36),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(3,33), X(4,34), X(7,37), X(8,38), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(2,33), X(4,35),
  X(6,37), X(8,39), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39)
};
S(42) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41)
};
S(44) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(34,37), X(36,39), X(38,41), X(40,43), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43)
};
S(46) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45)
};
S(48) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47)
};
S(50) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(2,33), X(4,35), X(6,37),
  X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(44,47), X(46,49), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49)
};
S(52) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51)
};
S(54) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53)
};
S(56) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55)
};
S(58) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57)
};
S(60) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51),
  X(50,53), X(52,55), X(54,57), X(56,59), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59)
};
S(62) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60),
  X(53,61), X(54,62), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59),
  X(46,61), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59),
  X(58,61), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61)
};
S(64) = {
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63)
};
S(66) = {
  X(1,65), X(2,66), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(33,65), X(34,66), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(17,65), X(18,66), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(9,65), X(10,66), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(41,65), X(42,66), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(5,65), X(6,66),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(3,65), X(4,66), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(2,65),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65)
};
S(68) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(17,65), X(18,66), X(19,67), X(20,68), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(9,65), X(10,66), X(11,67), X(12,68), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(5,65), X(6,66), X(7,67), X(8,68),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(3,65), X(4,66), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(2,65), X(4,67), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59),
  X(58,61), X(60,63), X(62,65), X(64,67), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67)
};
S(70) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(5,65), X(6,66), X(7,67), X(8,68),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(3,65), X(4,66), X(7,69), X(8,70), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(2,65), X(4,67), X(6,69), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69)
};
S(72) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(5,65), X(6,66), X(7,67), X(8,68),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(3,65), X(4,66), X(7,69), X(8,70),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(2,65), X(4,67),
  X(6,69), X(8,71), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71)
};
S(74) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70),
  X(15,71), X(16,72), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70),
  X(47,71), X(48,72), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(69,73), X(70,74), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73)
};
S(76) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(9,65), X(10,66), X(11,67), X(12,68),
  X(13,69), X(14,70), X(15,71), X(16,72), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(45,69), X(46,70), X(47,71), X(48,72), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(63,71), X(64,72), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(69,73), X(70,74), X(71,75), X(72,76), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71),
  X(58,73), X(60,75), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59),
  X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75)
};
S(78) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74),
  X(71,77), X(72,78), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16),
  X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32),
  X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48),
  X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64),
  X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77)
};
S(80) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(69,73), X(70,74), X(71,75), X(72,76), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79)
};
S(82) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(5,33), X(6,34),
  X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50),
  X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66),
  X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66),
  X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74),
  X(71,77), X(72,78), X(75,81), X(76,82), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58),
  X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74),
  X(75,77), X(76,78), X(79,81), X(80,82), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(2,65), X(4,67), X(6,69),
  X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23),
  X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39),
  X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55),
  X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71),
  X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81)
};
S(84) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(61,77), X(62,78), X(63,79), X(64,80), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60),
  X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76),
  X(69,77), X(70,78), X(71,79), X(72,80), X(9,65), X(10,66), X(11,67), X(12,68),
  X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51),
  X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67),
  X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81),
  X(82,83)
};
S(86) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70),
  X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66),
  X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82),
  X(79,83), X(80,84), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82),
  X(83,85), X(84,86), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(2,65), X(4,67), X(6,69),
  X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25),
  X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41),
  X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57),
  X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73),
  X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85)
};
S(88) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(81,85), X(82,86), X(83,87), X(84,88), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80),
  X(81,83), X(82,84), X(85,87), X(86,88), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82),
  X(83,85), X(84,86), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87)
};
S(90) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(81,85), X(82,86), X(83,87), X(84,88), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80),
  X(81,83), X(82,84), X(85,87), X(86,88), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74),
  X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82),
  X(83,85), X(84,86), X(87,89), X(88,90), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(54,85), X(56,87), X(58,89), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25),
  X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41),
  X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57),
  X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73),
  X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89),
  X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23),
  X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39),
  X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55),
  X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71),
  X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87),
  X(82,89), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89)
};
S(92) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(61,77), X(62,78), X(63,79), X(64,80), X(1,9), X(2,10), X(3,11), X(4,12),
  X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28),
  X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44),
  X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60),
  X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76),
  X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(81,85), X(82,86), X(83,87), X(84,88), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16),
  X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32),
  X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48),
  X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64),
  X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80),
  X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(83,89), X(84,90), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87),
  X(26,89), X(28,91), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19),
  X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35),
  X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51),
  X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67),
  X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83),
  X(82,85), X(84,87), X(86,89), X(88,91), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91)
};
S(94) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(5,33), X(6,34),
  X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50),
  X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66),
  X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82),
  X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(83,89), X(84,90), X(87,93), X(88,94), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58),
  X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74),
  X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90),
  X(91,93), X(92,94), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93)
};
S(96) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16),
  X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32),
  X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48),
  X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64),
  X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80),
  X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20),
  X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36),
  X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52),
  X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68),
  X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84),
  X(85,89), X(86,90), X(87,91), X(88,92), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(63,93), X(64,94), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82),
  X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(88,95), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81),
  X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95)
};
S(98) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(79,95), X(80,96), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(41,97), X(42,98), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70),
  X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86),
  X(63,87), X(64,88), X(73,97), X(74,98), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84),
  X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86),
  X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90),
  X(31,93), X(32,94), X(35,97), X(36,98), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86),
  X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81),
  X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97)
};
S(100) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13),
  X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29),
  X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45),
  X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61),
  X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77),
  X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93),
  X(86,94), X(87,95), X(88,96), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(1,5),
  X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21),
  X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37),
  X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53),
  X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69),
  X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85),
  X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(5,65),
  X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81),
  X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97),
  X(38,98), X(39,99), X(40,100), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(5,17),
  X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33),
  X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49),
  X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65),
  X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81),
  X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97),
  X(86,98), X(87,99), X(88,100), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17),
  X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33),
  X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49),
  X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65),
  X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81),
  X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97),
  X(94,98), X(95,99), X(96,100), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(3,65), X(4,66), X(7,69),
  X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85),
  X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17),
  X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33),
  X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49),
  X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65),
  X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81),
  X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97),
  X(92,98), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17),
  X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33),
  X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49),
  X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65),
  X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81),
  X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97),
  X(96,98), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(2,33), X(4,35), X(6,37),
  X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53),
  X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69),
  X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85),
  X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97),
  X(84,99), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99)
};
S(102) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13),
  X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29),
  X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45),
  X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61),
  X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77),
  X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93),
  X(86,94), X(87,95), X(88,96), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37),
  X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53),
  X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69),
  X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85),
  X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100),
  X(77,101), X(78,102), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78),
  X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94),
  X(91,95), X(92,96), X(97,101), X(98,102), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43),
  X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59),
  X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75),
  X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91),
  X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(5,17), X(6,18), X(7,19),
  X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35),
  X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51),
  X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67),
  X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83),
  X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73),
  X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89),
  X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94),
  X(67,97), X(68,98), X(71,101), X(72,102), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101),
  X(88,102), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97),
  X(96,99), X(98,101), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101)
};
S(104) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69),
  X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77),
  X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85),
  X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93),
  X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21),
  X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29),
  X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53),
  X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61),
  X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85),
  X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93),
  X(78,94), X(79,95), X(80,96), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66),
  X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82),
  X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98),
  X(95,99), X(96,100), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(3,65),
  X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81),
  X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97),
  X(36,98), X(39,101), X(40,102), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41),
  X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57),
  X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73),
  X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89),
  X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58),
  X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74),
  X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90),
  X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87),
  X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101),
  X(40,103), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103)
};
S(106) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37),
  X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45),
  X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53),
  X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61),
  X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100),
  X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(33,65),
  X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73),
  X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81),
  X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89),
  X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17),
  X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25),
  X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49),
  X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57),
  X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81),
  X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89),
  X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(1,5),
  X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21),
  X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37),
  X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53),
  X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69),
  X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85),
  X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96),
  X(97,101), X(98,102), X(99,103), X(100,104), X(5,65), X(6,66), X(7,67),
  X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83),
  X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17),
  X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33),
  X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49),
  X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65),
  X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81),
  X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97),
  X(92,99), X(94,101), X(96,103), X(98,105), X(2,5), X(4,7), X(6,9), X(8,11),
  X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27),
  X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43),
  X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59),
  X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75),
  X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91),
  X(90,93), X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105),
  X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17),
  X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33),
  X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49),
  X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65),
  X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81),
  X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97),
  X(98,99), X(100,101), X(102,103), X(104,105)
};
S(108) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(79,95), X(80,96), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(5,33),
  X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49),
  X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65),
  X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81),
  X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97),
  X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107),
  X(96,108), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(103,107), X(104,108), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101),
  X(72,102), X(75,105), X(76,106), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25),
  X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41),
  X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57),
  X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73),
  X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89),
  X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102),
  X(91,105), X(92,106), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(3,5), X(4,6), X(7,9), X(8,10),
  X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26),
  X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42),
  X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58),
  X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74),
  X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90),
  X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(103,105),
  X(104,106), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14),
  X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30),
  X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46),
  X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62),
  X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78),
  X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94),
  X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106), X(107,108),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107)
};
S(110) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103),
  X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(49,97), X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103),
  X(56,104), X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(9,65),
  X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81),
  X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97),
  X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103),
  X(80,104), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23),
  X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39),
  X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55),
  X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71),
  X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87),
  X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102),
  X(95,103), X(96,104), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78),
  X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94),
  X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109),
  X(106,110), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105),
  X(78,106), X(79,107), X(80,108), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25),
  X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41),
  X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57),
  X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73),
  X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89),
  X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100),
  X(93,105), X(94,106), X(95,107), X(96,108), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109),
  X(48,110), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17),
  X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33),
  X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49),
  X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65),
  X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81),
  X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97),
  X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18),
  X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34),
  X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50),
  X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66),
  X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82),
  X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81),
  X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97),
  X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97),
  X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77),
  X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93),
  X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107),
  X(106,109), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109)
};
S(112) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101),
  X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108),
  X(77,109), X(78,110), X(79,111), X(80,112), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(17,65), X(18,66), X(19,67),
  X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75),
  X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104),
  X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111),
  X(96,112), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(1,5),
  X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21),
  X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37),
  X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53),
  X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69),
  X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85),
  X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96),
  X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74),
  X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90),
  X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105),
  X(46,106), X(47,107), X(48,108), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105),
  X(102,106), X(103,107), X(104,108), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104),
  X(105,107), X(106,108), X(109,111), X(110,112), X(3,65), X(4,66), X(7,69),
  X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85),
  X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107),
  X(46,109), X(48,111), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25),
  X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41),
  X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57),
  X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73),
  X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89),
  X(76,91), X(78,93), X(80,95), X(82,97), X(84,99), X(86,101), X(88,103),
  X(90,105), X(92,107), X(94,109), X(96,111), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97),
  X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111)
};
S(114) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(97,113), X(98,114), X(17,65), X(18,66), X(19,67),
  X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75),
  X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104),
  X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111),
  X(96,112), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(89,113), X(90,114), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(1,5),
  X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21),
  X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37),
  X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53),
  X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69),
  X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85),
  X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96),
  X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74),
  X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90),
  X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105),
  X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(5,33), X(6,34),
  X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50),
  X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66),
  X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82),
  X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98),
  X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113),
  X(86,114), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101),
  X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113), X(100,114),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101),
  X(96,102), X(99,105), X(100,106), X(103,109), X(104,110), X(107,113),
  X(108,114), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17),
  X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33),
  X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49),
  X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65),
  X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81),
  X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97),
  X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99),
  X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59),
  X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75),
  X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91),
  X(78,93), X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105),
  X(92,107), X(94,109), X(96,111), X(98,113), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113)
};
S(116) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104),
  X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111),
  X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104),
  X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111),
  X(96,112), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(9,17),
  X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33),
  X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49),
  X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65),
  X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81),
  X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97),
  X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104),
  X(105,113), X(106,114), X(107,115), X(108,116), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88),
  X(89,93), X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103),
  X(100,104), X(105,109), X(106,110), X(107,111), X(108,112), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115),
  X(88,116), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101),
  X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113), X(100,114),
  X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22),
  X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38),
  X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54),
  X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70),
  X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86),
  X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101),
  X(96,102), X(99,105), X(100,106), X(103,109), X(104,110), X(107,113),
  X(108,114), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17),
  X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33),
  X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49),
  X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65),
  X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81),
  X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97),
  X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103),
  X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97),
  X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111),
  X(98,113), X(100,115), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115)
};
S(118) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69),
  X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77),
  X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85),
  X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93),
  X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21),
  X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29),
  X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53),
  X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61),
  X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85),
  X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93),
  X(78,94), X(79,95), X(80,96), X(97,113), X(98,114), X(99,115), X(100,116),
  X(101,117), X(102,118), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105),
  X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(61,117), X(62,118), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84),
  X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(9,17), X(10,18), X(11,19),
  X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35),
  X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51),
  X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67),
  X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83),
  X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99),
  X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114),
  X(107,115), X(108,116), X(109,117), X(110,118), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88),
  X(89,93), X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103),
  X(100,104), X(105,109), X(106,110), X(107,111), X(108,112), X(113,117),
  X(114,118), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(5,33),
  X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49),
  X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65),
  X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81),
  X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97),
  X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108),
  X(85,113), X(86,114), X(87,115), X(88,116), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66),
  X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82),
  X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98),
  X(95,99), X(96,100), X(101,105), X(102,106), X(103,107), X(104,108),
  X(109,113), X(110,114), X(111,115), X(112,116), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(113,115),
  X(114,116), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(83,113), X(84,114), X(87,117), X(88,118), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101),
  X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113), X(100,114),
  X(103,117), X(104,118), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(2,33), X(4,35), X(6,37), X(8,39),
  X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55),
  X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71),
  X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87),
  X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101),
  X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115),
  X(86,117), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105),
  X(100,107), X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117)
};
S(120) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37),
  X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45),
  X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53),
  X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61),
  X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100),
  X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107),
  X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114),
  X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(33,65),
  X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73),
  X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81),
  X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89),
  X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17),
  X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25),
  X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49),
  X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57),
  X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81),
  X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89),
  X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105),
  X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112),
  X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16),
  X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32),
  X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48),
  X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64),
  X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80),
  X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74),
  X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90),
  X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105),
  X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41),
  X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57),
  X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73),
  X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89),
  X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102),
  X(75,105), X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117),
  X(88,118), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99),
  X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113),
  X(52,115), X(54,117), X(56,119), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103),
  X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117),
  X(88,119), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119)
};
S(122) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112),
  X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119),
  X(88,120), X(89,121), X(90,122), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114), X(99,115),
  X(100,116), X(101,117), X(102,118), X(103,119), X(104,120), X(105,121),
  X(106,122), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119),
  X(96,120), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23),
  X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39),
  X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55),
  X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71),
  X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87),
  X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102),
  X(95,103), X(96,104), X(105,113), X(106,114), X(107,115), X(108,116),
  X(109,117), X(110,118), X(111,119), X(112,120), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88),
  X(89,93), X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103),
  X(100,104), X(105,109), X(106,110), X(107,111), X(108,112), X(113,117),
  X(114,118), X(115,119), X(116,120), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(111,115), X(112,116),
  X(117,121), X(118,122), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121),
  X(60,122), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111),
  X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97),
  X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121)
};
S(124) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103),
  X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110),
  X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117),
  X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(49,97), X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103),
  X(56,104), X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110),
  X(63,111), X(64,112), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103),
  X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118),
  X(95,119), X(96,120), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86),
  X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(97,101),
  X(98,102), X(99,103), X(100,104), X(105,109), X(106,110), X(107,111),
  X(108,112), X(113,117), X(114,118), X(115,119), X(116,120), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105),
  X(102,106), X(103,107), X(104,108), X(109,113), X(110,114), X(111,115),
  X(112,116), X(117,121), X(118,122), X(119,123), X(120,124), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121),
  X(60,122), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107),
  X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121),
  X(60,123), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123)
};
S(126) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(61,125), X(62,126), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101),
  X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108),
  X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115),
  X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122),
  X(91,123), X(92,124), X(93,125), X(94,126), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72),
  X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80),
  X(49,97), X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103),
  X(56,104), X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110),
  X(63,111), X(64,112), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70),
  X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86),
  X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101),
  X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116),
  X(61,117), X(62,118), X(63,119), X(64,120), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(9,17),
  X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33),
  X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49),
  X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65),
  X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81),
  X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97),
  X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104),
  X(105,113), X(106,114), X(107,115), X(108,116), X(109,117), X(110,118),
  X(111,119), X(112,120), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78),
  X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94),
  X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109),
  X(106,110), X(107,111), X(108,112), X(113,117), X(114,118), X(115,119),
  X(116,120), X(121,125), X(122,126), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(5,33),
  X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49),
  X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65),
  X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81),
  X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97),
  X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108),
  X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122), X(95,123),
  X(96,124), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116),
  X(109,121), X(110,122), X(111,123), X(112,124), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(111,115), X(112,116),
  X(117,121), X(118,122), X(119,123), X(120,124), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(113,115),
  X(114,116), X(117,119), X(118,120), X(121,123), X(122,124), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94),
  X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109),
  X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122),
  X(95,125), X(96,126), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(3,9), X(4,10), X(7,13),
  X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29),
  X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45),
  X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61),
  X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77),
  X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93),
  X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106),
  X(103,109), X(104,110), X(107,113), X(108,114), X(111,117), X(112,118),
  X(115,121), X(116,122), X(119,125), X(120,126), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103),
  X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117),
  X(88,119), X(90,121), X(92,123), X(94,125), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71),
  X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87),
  X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99), X(86,101),
  X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113), X(100,115),
  X(102,117), X(104,119), X(106,121), X(108,123), X(110,125), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105),
  X(100,107), X(102,109), X(104,111), X(106,113), X(108,115), X(110,117),
  X(112,119), X(114,121), X(116,123), X(118,125), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89),
  X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101), X(100,103),
  X(102,105), X(104,107), X(106,109), X(108,111), X(110,113), X(112,115),
  X(114,117), X(116,119), X(118,121), X(120,123), X(122,125), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125)
};
S(128) = {
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(61,125), X(62,126), X(63,127), X(64,128), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117),
  X(102,118), X(103,119), X(104,120), X(105,121), X(106,122), X(107,123),
  X(108,124), X(109,125), X(110,126), X(111,127), X(112,128), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94),
  X(87,95), X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109),
  X(102,110), X(103,111), X(104,112), X(113,121), X(114,122), X(115,123),
  X(116,124), X(117,125), X(118,126), X(119,127), X(120,128), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103),
  X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118),
  X(95,119), X(96,120), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86),
  X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(97,101),
  X(98,102), X(99,103), X(100,104), X(105,109), X(106,110), X(107,111),
  X(108,112), X(113,117), X(114,118), X(115,119), X(116,120), X(121,125),
  X(122,126), X(123,127), X(124,128), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(5,33),
  X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49),
  X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65),
  X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81),
  X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97),
  X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108),
  X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122), X(95,123),
  X(96,124), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116),
  X(109,121), X(110,122), X(111,123), X(112,124), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(111,115), X(112,116),
  X(117,121), X(118,122), X(119,123), X(120,124), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(113,115),
  X(114,116), X(117,119), X(118,120), X(121,123), X(122,124), X(125,127),
  X(126,128), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121),
  X(60,122), X(63,125), X(64,126), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41),
  X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57),
  X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73),
  X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89),
  X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102),
  X(75,105), X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117),
  X(88,118), X(91,121), X(92,122), X(95,125), X(96,126), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123),
  X(62,125), X(64,127), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119),
  X(90,121), X(92,123), X(94,125), X(96,127), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71),
  X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87),
  X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99), X(86,101),
  X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113), X(100,115),
  X(102,117), X(104,119), X(106,121), X(108,123), X(110,125), X(112,127), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(114,121), X(116,123), X(118,125), X(120,127), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123),
  X(122,125), X(124,127), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127)
};
S(130) = {
  X(1,129), X(2,130), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70),
  X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78),
  X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86),
  X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94),
  X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101),
  X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108),
  X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115),
  X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122),
  X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129),
  X(66,130), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(33,129), X(34,130),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117),
  X(102,118), X(103,119), X(104,120), X(105,121), X(106,122), X(107,123),
  X(108,124), X(109,125), X(110,126), X(111,127), X(112,128), X(17,129),
  X(18,130), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104),
  X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111),
  X(96,112), X(113,129), X(114,130), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13),
  X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29),
  X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45),
  X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61),
  X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77),
  X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93),
  X(86,94), X(87,95), X(88,96), X(97,105), X(98,106), X(99,107), X(100,108),
  X(101,109), X(102,110), X(103,111), X(104,112), X(113,121), X(114,122),
  X(115,123), X(116,124), X(117,125), X(118,126), X(119,127), X(120,128),
  X(9,129), X(10,130), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70),
  X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86),
  X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101),
  X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116),
  X(61,117), X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119),
  X(96,120), X(105,129), X(106,130), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84),
  X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99),
  X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114),
  X(107,115), X(108,116), X(109,117), X(110,118), X(111,119), X(112,120),
  X(121,129), X(122,130), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78),
  X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94),
  X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109),
  X(106,110), X(107,111), X(108,112), X(113,117), X(114,118), X(115,119),
  X(116,120), X(121,125), X(122,126), X(123,127), X(124,128), X(5,129), X(6,130),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116),
  X(109,121), X(110,122), X(111,123), X(112,124), X(117,129), X(118,130), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(121,123), X(122,124), X(125,127), X(126,128), X(3,129), X(4,130),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109),
  X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122),
  X(63,125), X(64,126), X(67,129), X(68,130), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101),
  X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113), X(84,114),
  X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126), X(99,129),
  X(100,130), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(127,129), X(128,130), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(2,129), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99),
  X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113),
  X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127),
  X(66,129), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(94,125), X(96,127), X(98,129), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71),
  X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87),
  X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99), X(86,101),
  X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113), X(100,115),
  X(102,117), X(104,119), X(106,121), X(108,123), X(110,125), X(112,127),
  X(114,129), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77),
  X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93),
  X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107),
  X(106,109), X(108,111), X(110,113), X(112,115), X(114,117), X(116,119),
  X(118,121), X(120,123), X(122,125), X(124,127), X(126,129), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129)
};
S(132) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(1,65), X(2,66), X(3,67), X(4,68),
  X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76),
  X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84),
  X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92),
  X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99),
  X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106),
  X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113),
  X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120),
  X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127),
  X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112),
  X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119),
  X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126),
  X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132), X(33,65),
  X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73),
  X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81),
  X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89),
  X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(99,131), X(100,132), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(17,129), X(18,130), X(19,131), X(20,132), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111),
  X(64,112), X(81,129), X(82,130), X(83,131), X(84,132), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105),
  X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112),
  X(113,129), X(114,130), X(115,131), X(116,132), X(1,9), X(2,10), X(3,11),
  X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27),
  X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43),
  X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59),
  X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75),
  X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91),
  X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105), X(98,106),
  X(99,107), X(100,108), X(101,109), X(102,110), X(103,111), X(104,112),
  X(113,121), X(114,122), X(115,123), X(116,124), X(117,125), X(118,126),
  X(119,127), X(120,128), X(9,129), X(10,130), X(11,131), X(12,132), X(9,65),
  X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81),
  X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97),
  X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104),
  X(57,113), X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119),
  X(64,120), X(73,129), X(74,130), X(75,131), X(76,132), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(9,17), X(10,18), X(11,19),
  X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35),
  X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51),
  X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67),
  X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83),
  X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99),
  X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114),
  X(107,115), X(108,116), X(109,117), X(110,118), X(111,119), X(112,120),
  X(121,129), X(122,130), X(123,131), X(124,132), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88),
  X(89,93), X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103),
  X(100,104), X(105,109), X(106,110), X(107,111), X(108,112), X(113,117),
  X(114,118), X(115,119), X(116,120), X(121,125), X(122,126), X(123,127),
  X(124,128), X(5,129), X(6,130), X(7,131), X(8,132), X(5,65), X(6,66), X(7,67),
  X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83),
  X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(69,129),
  X(70,130), X(71,131), X(72,132), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115),
  X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130),
  X(103,131), X(104,132), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(3,129), X(4,130), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90),
  X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105),
  X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118),
  X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125),
  X(96,126), X(99,129), X(100,130), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25),
  X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41),
  X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57),
  X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73),
  X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89),
  X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102),
  X(91,105), X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117),
  X(104,118), X(107,121), X(108,122), X(111,125), X(112,126), X(115,129),
  X(116,130), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126),
  X(127,129), X(128,130), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(2,129), X(4,131), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103),
  X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117),
  X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123),
  X(94,125), X(96,127), X(98,129), X(100,131), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131)
};
S(134) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(1,65), X(2,66),
  X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74),
  X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82),
  X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90),
  X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98),
  X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105),
  X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112),
  X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119),
  X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126),
  X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133),
  X(70,134), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(33,129), X(34,130),
  X(35,131), X(36,132), X(37,133), X(38,134), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130),
  X(99,131), X(100,132), X(101,133), X(102,134), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(9,129), X(10,130), X(11,131), X(12,132),
  X(13,133), X(14,134), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129), X(74,130),
  X(75,131), X(76,132), X(77,133), X(78,134), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(5,129), X(6,130), X(7,131), X(8,132), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(69,129),
  X(70,130), X(71,131), X(72,132), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115),
  X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130),
  X(103,131), X(104,132), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(3,129), X(4,130), X(7,133), X(8,134), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101),
  X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114),
  X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129),
  X(68,130), X(71,133), X(72,134), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41),
  X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57),
  X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73),
  X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89),
  X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102),
  X(75,105), X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117),
  X(88,118), X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130),
  X(103,133), X(104,134), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(2,129), X(4,131), X(6,133), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103),
  X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117),
  X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131),
  X(70,133), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(2,17),
  X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33),
  X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49),
  X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65),
  X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81),
  X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97),
  X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111),
  X(98,113), X(100,115), X(102,117), X(104,119), X(106,121), X(108,123),
  X(110,125), X(112,127), X(114,129), X(116,131), X(118,133), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105),
  X(100,107), X(102,109), X(104,111), X(106,113), X(108,115), X(110,117),
  X(112,119), X(114,121), X(116,123), X(118,125), X(120,127), X(122,129),
  X(124,131), X(126,133), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133)
};
S(136) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71),
  X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79),
  X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87),
  X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95),
  X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102),
  X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109),
  X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116),
  X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123),
  X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130),
  X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104),
  X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111),
  X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118),
  X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125),
  X(94,126), X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132),
  X(37,133), X(38,134), X(39,135), X(40,136), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130),
  X(99,131), X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(1,17),
  X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25),
  X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49),
  X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57),
  X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81),
  X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89),
  X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(17,129), X(18,130),
  X(19,131), X(20,132), X(21,133), X(22,134), X(23,135), X(24,136), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111),
  X(64,112), X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134),
  X(87,135), X(88,136), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130),
  X(115,131), X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(9,129), X(10,130), X(11,131),
  X(12,132), X(13,133), X(14,134), X(15,135), X(16,136), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135),
  X(80,136), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117),
  X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(5,129), X(6,130), X(7,131),
  X(8,132), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132), X(5,17),
  X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33),
  X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49),
  X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65),
  X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81),
  X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97),
  X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108),
  X(101,113), X(102,114), X(103,115), X(104,116), X(109,121), X(110,122),
  X(111,123), X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(127,131), X(128,132), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(113,115),
  X(114,116), X(117,119), X(118,120), X(121,123), X(122,124), X(125,127),
  X(126,128), X(129,131), X(130,132), X(133,135), X(134,136), X(3,129), X(4,130),
  X(7,133), X(8,134), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90),
  X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105),
  X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118),
  X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(71,133),
  X(72,134), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(2,129), X(4,131), X(6,133), X(8,135), X(2,65), X(4,67), X(6,69),
  X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85),
  X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99),
  X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113),
  X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127),
  X(66,129), X(68,131), X(70,133), X(72,135), X(2,33), X(4,35), X(6,37), X(8,39),
  X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55),
  X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71),
  X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87),
  X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101),
  X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115),
  X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129),
  X(100,131), X(102,133), X(104,135), X(2,17), X(4,19), X(6,21), X(8,23),
  X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39),
  X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55),
  X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71),
  X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87),
  X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99), X(86,101),
  X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113), X(100,115),
  X(102,117), X(104,119), X(106,121), X(108,123), X(110,125), X(112,127),
  X(114,129), X(116,131), X(118,133), X(120,135), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135)
};
S(138) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69),
  X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77),
  X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85),
  X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93),
  X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100),
  X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107),
  X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114),
  X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121),
  X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128),
  X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135),
  X(72,136), X(73,137), X(74,138), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37),
  X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45),
  X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53),
  X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61),
  X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100),
  X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107),
  X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114),
  X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121),
  X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127), X(96,128),
  X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135),
  X(40,136), X(41,137), X(42,138), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(17,129), X(18,130),
  X(19,131), X(20,132), X(21,133), X(22,134), X(23,135), X(24,136), X(25,137),
  X(26,138), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137), X(90,138),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135),
  X(16,136), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71),
  X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87),
  X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102),
  X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117),
  X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132),
  X(77,133), X(78,134), X(79,135), X(80,136), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(77,137), X(78,138), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105),
  X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116),
  X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(111,123), X(112,124),
  X(117,129), X(118,130), X(119,131), X(120,132), X(125,137), X(126,138), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(127,131), X(128,132), X(133,137), X(134,138), X(1,3),
  X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19),
  X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35),
  X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51),
  X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67),
  X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83),
  X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109),
  X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122),
  X(63,125), X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137),
  X(76,138), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(3,9), X(4,10), X(7,13),
  X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29),
  X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45),
  X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61),
  X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77),
  X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93),
  X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106),
  X(103,109), X(104,110), X(107,113), X(108,114), X(111,117), X(112,118),
  X(115,121), X(116,122), X(119,125), X(120,126), X(123,129), X(124,130),
  X(127,133), X(128,134), X(131,137), X(132,138), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126),
  X(127,129), X(128,130), X(131,133), X(132,134), X(135,137), X(136,138), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123),
  X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123),
  X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(126,133),
  X(128,135), X(130,137), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137)
};
S(140) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(1,65), X(2,66), X(3,67),
  X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75),
  X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83),
  X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91),
  X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99),
  X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106),
  X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113),
  X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120),
  X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127),
  X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134),
  X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104),
  X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111),
  X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118),
  X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125),
  X(94,126), X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132),
  X(37,133), X(38,134), X(39,135), X(40,136), X(41,137), X(42,138), X(43,139),
  X(44,140), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132), X(101,133),
  X(102,134), X(103,135), X(104,136), X(105,137), X(106,138), X(107,139),
  X(108,140), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(17,129), X(18,130),
  X(19,131), X(20,132), X(21,133), X(22,134), X(23,135), X(24,136), X(25,137),
  X(26,138), X(27,139), X(28,140), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129),
  X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136),
  X(89,137), X(90,138), X(91,139), X(92,140), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134),
  X(15,135), X(16,136), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129), X(74,130),
  X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136), X(9,33),
  X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49),
  X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65),
  X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81),
  X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97),
  X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104),
  X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119),
  X(96,120), X(105,129), X(106,130), X(107,131), X(108,132), X(109,133),
  X(110,134), X(111,135), X(112,136), X(9,17), X(10,18), X(11,19), X(12,20),
  X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36),
  X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52),
  X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68),
  X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84),
  X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99),
  X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114),
  X(107,115), X(108,116), X(109,117), X(110,118), X(111,119), X(112,120),
  X(121,129), X(122,130), X(123,131), X(124,132), X(125,133), X(126,134),
  X(127,135), X(128,136), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14),
  X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30),
  X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46),
  X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62),
  X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78),
  X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94),
  X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109),
  X(106,110), X(107,111), X(108,112), X(113,117), X(114,118), X(115,119),
  X(116,120), X(121,125), X(122,126), X(123,127), X(124,128), X(129,133),
  X(130,134), X(131,135), X(132,136), X(5,129), X(6,130), X(7,131), X(8,132),
  X(13,137), X(14,138), X(15,139), X(16,140), X(5,65), X(6,66), X(7,67), X(8,68),
  X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84),
  X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99),
  X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114),
  X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(69,129),
  X(70,130), X(71,131), X(72,132), X(77,137), X(78,138), X(79,139), X(80,140),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132),
  X(109,137), X(110,138), X(111,139), X(112,140), X(5,17), X(6,18), X(7,19),
  X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35),
  X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51),
  X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67),
  X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83),
  X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(111,123), X(112,124),
  X(117,129), X(118,130), X(119,131), X(120,132), X(125,137), X(126,138),
  X(127,139), X(128,140), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18),
  X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34),
  X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50),
  X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66),
  X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82),
  X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98),
  X(95,99), X(96,100), X(101,105), X(102,106), X(103,107), X(104,108),
  X(109,113), X(110,114), X(111,115), X(112,116), X(117,121), X(118,122),
  X(119,123), X(120,124), X(125,129), X(126,130), X(127,131), X(128,132),
  X(133,137), X(134,138), X(135,139), X(136,140), X(1,3), X(2,4), X(5,7), X(6,8),
  X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24),
  X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40),
  X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56),
  X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72),
  X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88),
  X(89,91), X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103),
  X(102,104), X(105,107), X(106,108), X(109,111), X(110,112), X(113,115),
  X(114,116), X(117,119), X(118,120), X(121,123), X(122,124), X(125,127),
  X(126,128), X(129,131), X(130,132), X(133,135), X(134,136), X(137,139),
  X(138,140), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109),
  X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122),
  X(63,125), X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137),
  X(76,138), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(3,9), X(4,10), X(7,13),
  X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29),
  X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45),
  X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61),
  X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77),
  X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93),
  X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106),
  X(103,109), X(104,110), X(107,113), X(108,114), X(111,117), X(112,118),
  X(115,121), X(116,122), X(119,125), X(120,126), X(123,129), X(124,130),
  X(127,133), X(128,134), X(131,137), X(132,138), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126),
  X(127,129), X(128,130), X(131,133), X(132,134), X(135,137), X(136,138), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(2,129), X(4,131), X(6,133), X(8,135),
  X(10,137), X(12,139), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133),
  X(72,135), X(74,137), X(76,139), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103),
  X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117),
  X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131),
  X(102,133), X(104,135), X(106,137), X(108,139), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139)
};
S(142) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131),
  X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138),
  X(75,139), X(76,140), X(77,141), X(78,142), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134),
  X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141),
  X(46,142), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132), X(101,133),
  X(102,134), X(103,135), X(104,136), X(105,137), X(106,138), X(107,139),
  X(108,140), X(109,141), X(110,142), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114), X(99,115),
  X(100,116), X(101,117), X(102,118), X(103,119), X(104,120), X(105,121),
  X(106,122), X(107,123), X(108,124), X(109,125), X(110,126), X(111,127),
  X(112,128), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137), X(90,138),
  X(91,139), X(92,140), X(93,141), X(94,142), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(125,141),
  X(126,142), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(9,129), X(10,130), X(11,131),
  X(12,132), X(13,133), X(14,134), X(15,135), X(16,136), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135),
  X(80,136), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117),
  X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(77,137), X(78,138), X(79,139), X(80,140), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116),
  X(109,121), X(110,122), X(111,123), X(112,124), X(117,129), X(118,130),
  X(119,131), X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(127,131), X(128,132), X(133,137), X(134,138),
  X(135,139), X(136,140), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(121,123), X(122,124), X(125,127), X(126,128), X(129,131),
  X(130,132), X(133,135), X(134,136), X(137,139), X(138,140), X(3,129), X(4,130),
  X(7,133), X(8,134), X(11,137), X(12,138), X(15,141), X(16,142), X(3,65),
  X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81),
  X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97),
  X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110),
  X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125),
  X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138),
  X(79,141), X(80,142), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105),
  X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118),
  X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133),
  X(104,134), X(107,137), X(108,138), X(111,141), X(112,142), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(115,129), X(116,130), X(119,133), X(120,134), X(123,137),
  X(124,138), X(127,141), X(128,142), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86),
  X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101),
  X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(111,113),
  X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(123,125),
  X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(135,137),
  X(136,138), X(139,141), X(140,142), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139),
  X(14,141), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107),
  X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121),
  X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135),
  X(74,137), X(76,139), X(78,141), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41),
  X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57),
  X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73),
  X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89),
  X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103),
  X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117),
  X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131),
  X(102,133), X(104,135), X(106,137), X(108,139), X(110,141), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77),
  X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93),
  X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107),
  X(106,109), X(108,111), X(110,113), X(112,115), X(114,117), X(116,119),
  X(118,121), X(120,123), X(122,125), X(124,127), X(126,129), X(128,131),
  X(130,133), X(132,135), X(134,137), X(136,139), X(138,141), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141)
};
S(144) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70),
  X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78),
  X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86),
  X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94),
  X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101),
  X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108),
  X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115),
  X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122),
  X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129),
  X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136),
  X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143),
  X(80,144), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(33,129), X(34,130),
  X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136), X(41,137),
  X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143), X(48,144),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(99,131), X(100,132), X(101,133), X(102,134),
  X(103,135), X(104,136), X(105,137), X(106,138), X(107,139), X(108,140),
  X(109,141), X(110,142), X(111,143), X(112,144), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(17,65), X(18,66), X(19,67),
  X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75),
  X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129),
  X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136),
  X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143),
  X(96,144), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100), X(85,101),
  X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107), X(92,108),
  X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130), X(115,131),
  X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(121,137),
  X(122,138), X(123,139), X(124,140), X(125,141), X(126,142), X(127,143),
  X(128,144), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135),
  X(16,136), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71),
  X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87),
  X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102),
  X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117),
  X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132),
  X(77,133), X(78,134), X(79,135), X(80,136), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(77,137), X(78,138), X(79,139), X(80,140), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27),
  X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43),
  X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59),
  X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75),
  X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91),
  X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106),
  X(95,107), X(96,108), X(101,113), X(102,114), X(103,115), X(104,116),
  X(109,121), X(110,122), X(111,123), X(112,124), X(117,129), X(118,130),
  X(119,131), X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(127,131), X(128,132), X(133,137), X(134,138),
  X(135,139), X(136,140), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(121,123), X(122,124), X(125,127), X(126,128), X(129,131),
  X(130,132), X(133,135), X(134,136), X(137,139), X(138,140), X(141,143),
  X(142,144), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90),
  X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105),
  X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118),
  X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(71,133),
  X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82),
  X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(127,133), X(128,134), X(131,137), X(132,138),
  X(135,141), X(136,142), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(127,129), X(128,130), X(131,133),
  X(132,134), X(135,137), X(136,138), X(139,141), X(140,142), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(2,129), X(4,131),
  X(6,133), X(8,135), X(10,137), X(12,139), X(14,141), X(16,143), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81),
  X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97),
  X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111),
  X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125),
  X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137), X(76,139),
  X(78,141), X(80,143), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119),
  X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133),
  X(104,135), X(106,137), X(108,139), X(110,141), X(112,143), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(128,143), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(126,133),
  X(128,135), X(130,137), X(132,139), X(134,141), X(136,143), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(130,133), X(132,135), X(134,137),
  X(136,139), X(138,141), X(140,143), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143)
};
S(146) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(1,65), X(2,66), X(3,67), X(4,68),
  X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76),
  X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84),
  X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92),
  X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99),
  X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106),
  X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113),
  X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120),
  X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127),
  X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134),
  X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141),
  X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112),
  X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119),
  X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126),
  X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133),
  X(38,134), X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140),
  X(45,141), X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(33,65),
  X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73),
  X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81),
  X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89),
  X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(99,131), X(100,132), X(101,133), X(102,134),
  X(103,135), X(104,136), X(105,137), X(106,138), X(107,139), X(108,140),
  X(109,141), X(110,142), X(111,143), X(112,144), X(113,145), X(114,146),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134), X(23,135),
  X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141), X(30,142),
  X(31,143), X(32,144), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130),
  X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137),
  X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138),
  X(123,139), X(124,140), X(125,141), X(126,142), X(127,143), X(128,144), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135),
  X(16,136), X(25,145), X(26,146), X(9,65), X(10,66), X(11,67), X(12,68),
  X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84),
  X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37),
  X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53),
  X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69),
  X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85),
  X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100),
  X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115),
  X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130),
  X(107,131), X(108,132), X(109,133), X(110,134), X(111,135), X(112,136),
  X(121,145), X(122,146), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124),
  X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138), X(79,139),
  X(80,140), X(85,145), X(86,146), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115),
  X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130),
  X(103,131), X(104,132), X(109,137), X(110,138), X(111,139), X(112,140),
  X(117,145), X(118,146), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(125,137), X(126,138), X(127,139),
  X(128,140), X(133,145), X(134,146), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(133,135), X(134,136), X(137,139), X(138,140), X(141,143), X(142,144),
  X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138), X(15,141),
  X(16,142), X(19,145), X(20,146), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73),
  X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89),
  X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102),
  X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117),
  X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130),
  X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(83,145),
  X(84,146), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(111,141), X(112,142), X(115,145), X(116,146),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134),
  X(131,137), X(132,138), X(135,141), X(136,142), X(139,145), X(140,146), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139), X(14,141),
  X(16,143), X(18,145), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133),
  X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111),
  X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125),
  X(96,127), X(98,129), X(100,131), X(102,133), X(104,135), X(106,137),
  X(108,139), X(110,141), X(112,143), X(114,145), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(128,143), X(130,145), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(130,137), X(132,139), X(134,141), X(136,143),
  X(138,145), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17),
  X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33),
  X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49),
  X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65),
  X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81),
  X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97),
  X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(138,141), X(140,143), X(142,145), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145)
};
S(148) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(1,65),
  X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73),
  X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81),
  X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89),
  X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97),
  X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104),
  X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111),
  X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118),
  X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125),
  X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132),
  X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139),
  X(76,140), X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146),
  X(83,147), X(84,148), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101),
  X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108),
  X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115),
  X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122),
  X(91,123), X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129),
  X(98,130), X(99,131), X(100,132), X(101,133), X(102,134), X(103,135),
  X(104,136), X(105,137), X(106,138), X(107,139), X(108,140), X(109,141),
  X(110,142), X(111,143), X(112,144), X(113,145), X(114,146), X(115,147),
  X(116,148), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(17,65), X(18,66), X(19,67),
  X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75),
  X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129),
  X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136),
  X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143),
  X(96,144), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100), X(85,101),
  X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107), X(92,108),
  X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130), X(115,131),
  X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(121,137),
  X(122,138), X(123,139), X(124,140), X(125,141), X(126,142), X(127,143),
  X(128,144), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135),
  X(16,136), X(25,145), X(26,146), X(27,147), X(28,148), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135),
  X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(109,133), X(110,134),
  X(111,135), X(112,136), X(121,145), X(122,146), X(123,147), X(124,148),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132),
  X(109,137), X(110,138), X(111,139), X(112,140), X(117,145), X(118,146),
  X(119,147), X(120,148), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(125,137), X(126,138), X(127,139),
  X(128,140), X(133,145), X(134,146), X(135,147), X(136,148), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105),
  X(102,106), X(103,107), X(104,108), X(109,113), X(110,114), X(111,115),
  X(112,116), X(117,121), X(118,122), X(119,123), X(120,124), X(125,129),
  X(126,130), X(127,131), X(128,132), X(133,137), X(134,138), X(135,139),
  X(136,140), X(141,145), X(142,146), X(143,147), X(144,148), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(19,145), X(20,146), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101),
  X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114),
  X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129),
  X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142),
  X(83,145), X(84,146), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105),
  X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118),
  X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133),
  X(104,134), X(107,137), X(108,138), X(111,141), X(112,142), X(115,145),
  X(116,146), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134),
  X(131,137), X(132,138), X(135,141), X(136,142), X(139,145), X(140,146), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139),
  X(14,141), X(16,143), X(18,145), X(20,147), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87),
  X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101),
  X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115),
  X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129),
  X(68,131), X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143),
  X(82,145), X(84,147), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119),
  X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133),
  X(104,135), X(106,137), X(108,139), X(110,141), X(112,143), X(114,145),
  X(116,147), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(136,143), X(138,145), X(140,147), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123),
  X(122,125), X(124,127), X(126,129), X(128,131), X(130,133), X(132,135),
  X(134,137), X(136,139), X(138,141), X(140,143), X(142,145), X(144,147), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147)
};
S(150) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71),
  X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79),
  X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87),
  X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95),
  X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102),
  X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109),
  X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116),
  X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123),
  X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130),
  X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137),
  X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143), X(80,144),
  X(81,145), X(82,146), X(83,147), X(84,148), X(85,149), X(86,150), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104),
  X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111),
  X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118),
  X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125),
  X(94,126), X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132),
  X(37,133), X(38,134), X(39,135), X(40,136), X(41,137), X(42,138), X(43,139),
  X(44,140), X(45,141), X(46,142), X(47,143), X(48,144), X(49,145), X(50,146),
  X(51,147), X(52,148), X(53,149), X(54,150), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130),
  X(99,131), X(100,132), X(101,133), X(102,134), X(103,135), X(104,136),
  X(105,137), X(106,138), X(107,139), X(108,140), X(109,141), X(110,142),
  X(111,143), X(112,144), X(113,145), X(114,146), X(115,147), X(116,148),
  X(117,149), X(118,150), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117),
  X(102,118), X(103,119), X(104,120), X(105,121), X(106,122), X(107,123),
  X(108,124), X(109,125), X(110,126), X(111,127), X(112,128), X(129,145),
  X(130,146), X(131,147), X(132,148), X(133,149), X(134,150), X(17,129),
  X(18,130), X(19,131), X(20,132), X(21,133), X(22,134), X(23,135), X(24,136),
  X(25,137), X(26,138), X(27,139), X(28,140), X(29,141), X(30,142), X(31,143),
  X(32,144), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137), X(90,138),
  X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144), X(17,33),
  X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41),
  X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65),
  X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73),
  X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97),
  X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104),
  X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111),
  X(96,112), X(113,129), X(114,130), X(115,131), X(116,132), X(117,133),
  X(118,134), X(119,135), X(120,136), X(121,137), X(122,138), X(123,139),
  X(124,140), X(125,141), X(126,142), X(127,143), X(128,144), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(133,141), X(134,142), X(135,143), X(136,144), X(9,129),
  X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135), X(16,136),
  X(25,145), X(26,146), X(27,147), X(28,148), X(29,149), X(30,150), X(9,65),
  X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81),
  X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97),
  X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104),
  X(57,113), X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119),
  X(64,120), X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134),
  X(79,135), X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(93,149),
  X(94,150), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117),
  X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(121,145),
  X(122,146), X(123,147), X(124,148), X(125,149), X(126,150), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(137,145), X(138,146), X(139,147),
  X(140,148), X(141,149), X(142,150), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(5,129), X(6,130), X(7,131),
  X(8,132), X(13,137), X(14,138), X(15,139), X(16,140), X(21,145), X(22,146),
  X(23,147), X(24,148), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74),
  X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90),
  X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105),
  X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116),
  X(61,121), X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131),
  X(72,132), X(77,137), X(78,138), X(79,139), X(80,140), X(85,145), X(86,146),
  X(87,147), X(88,148), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105),
  X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116),
  X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(111,123), X(112,124),
  X(117,129), X(118,130), X(119,131), X(120,132), X(125,137), X(126,138),
  X(127,139), X(128,140), X(133,145), X(134,146), X(135,147), X(136,148), X(5,9),
  X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25),
  X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41),
  X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57),
  X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73),
  X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89),
  X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100),
  X(101,105), X(102,106), X(103,107), X(104,108), X(109,113), X(110,114),
  X(111,115), X(112,116), X(117,121), X(118,122), X(119,123), X(120,124),
  X(125,129), X(126,130), X(127,131), X(128,132), X(133,137), X(134,138),
  X(135,139), X(136,140), X(141,145), X(142,146), X(143,147), X(144,148), X(1,3),
  X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19),
  X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35),
  X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51),
  X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67),
  X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83),
  X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(3,65),
  X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81),
  X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97),
  X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110),
  X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125),
  X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138),
  X(79,141), X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125),
  X(96,126), X(99,129), X(100,130), X(103,133), X(104,134), X(107,137),
  X(108,138), X(111,141), X(112,142), X(115,145), X(116,146), X(119,149),
  X(120,150), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(3,9), X(4,10), X(7,13),
  X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29),
  X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45),
  X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61),
  X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77),
  X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93),
  X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106),
  X(103,109), X(104,110), X(107,113), X(108,114), X(111,117), X(112,118),
  X(115,121), X(116,122), X(119,125), X(120,126), X(123,129), X(124,130),
  X(127,133), X(128,134), X(131,137), X(132,138), X(135,141), X(136,142),
  X(139,145), X(140,146), X(143,149), X(144,150), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126),
  X(127,129), X(128,130), X(131,133), X(132,134), X(135,137), X(136,138),
  X(139,141), X(140,142), X(143,145), X(144,146), X(147,149), X(148,150), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137),
  X(12,139), X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81),
  X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97),
  X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111),
  X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125),
  X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137), X(76,139),
  X(78,141), X(80,143), X(82,145), X(84,147), X(86,149), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99),
  X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113),
  X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127),
  X(98,129), X(100,131), X(102,133), X(104,135), X(106,137), X(108,139),
  X(110,141), X(112,143), X(114,145), X(116,147), X(118,149), X(2,17), X(4,19),
  X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35),
  X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51),
  X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67),
  X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83),
  X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(128,143), X(130,145), X(132,147), X(134,149), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(114,121), X(116,123), X(118,125), X(120,127),
  X(122,129), X(124,131), X(126,133), X(128,135), X(130,137), X(132,139),
  X(134,141), X(136,143), X(138,145), X(140,147), X(142,149), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(130,133), X(132,135), X(134,137),
  X(136,139), X(138,141), X(140,143), X(142,145), X(144,147), X(146,149), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149)
};
S(152) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69),
  X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77),
  X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85),
  X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93),
  X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100),
  X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107),
  X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114),
  X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121),
  X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128),
  X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135),
  X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142),
  X(79,143), X(80,144), X(81,145), X(82,146), X(83,147), X(84,148), X(85,149),
  X(86,150), X(87,151), X(88,152), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37),
  X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45),
  X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53),
  X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61),
  X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100),
  X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107),
  X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114),
  X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121),
  X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127), X(96,128),
  X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135),
  X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142),
  X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149),
  X(54,150), X(55,151), X(56,152), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(1,17), X(2,18), X(3,19), X(4,20),
  X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28),
  X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52),
  X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60),
  X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84),
  X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92),
  X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114), X(99,115),
  X(100,116), X(101,117), X(102,118), X(103,119), X(104,120), X(105,121),
  X(106,122), X(107,123), X(108,124), X(109,125), X(110,126), X(111,127),
  X(112,128), X(129,145), X(130,146), X(131,147), X(132,148), X(133,149),
  X(134,150), X(135,151), X(136,152), X(17,129), X(18,130), X(19,131), X(20,132),
  X(21,133), X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139),
  X(28,140), X(29,141), X(30,142), X(31,143), X(32,144), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130),
  X(115,131), X(116,132), X(117,133), X(118,134), X(119,135), X(120,136),
  X(121,137), X(122,138), X(123,139), X(124,140), X(125,141), X(126,142),
  X(127,143), X(128,144), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94),
  X(87,95), X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109),
  X(102,110), X(103,111), X(104,112), X(113,121), X(114,122), X(115,123),
  X(116,124), X(117,125), X(118,126), X(119,127), X(120,128), X(129,137),
  X(130,138), X(131,139), X(132,140), X(133,141), X(134,142), X(135,143),
  X(136,144), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134),
  X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148), X(29,149),
  X(30,150), X(31,151), X(32,152), X(9,65), X(10,66), X(11,67), X(12,68),
  X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84),
  X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117),
  X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(121,145),
  X(122,146), X(123,147), X(124,148), X(125,149), X(126,150), X(127,151),
  X(128,152), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(139,147), X(140,148), X(141,149),
  X(142,150), X(143,151), X(144,152), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124),
  X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138), X(79,139),
  X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(5,33), X(6,34),
  X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50),
  X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66),
  X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82),
  X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98),
  X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113),
  X(86,114), X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124),
  X(101,129), X(102,130), X(103,131), X(104,132), X(109,137), X(110,138),
  X(111,139), X(112,140), X(117,145), X(118,146), X(119,147), X(120,148),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107),
  X(96,108), X(101,113), X(102,114), X(103,115), X(104,116), X(109,121),
  X(110,122), X(111,123), X(112,124), X(117,129), X(118,130), X(119,131),
  X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(133,145),
  X(134,146), X(135,147), X(136,148), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104),
  X(105,107), X(106,108), X(109,111), X(110,112), X(113,115), X(114,116),
  X(117,119), X(118,120), X(121,123), X(122,124), X(125,127), X(126,128),
  X(129,131), X(130,132), X(133,135), X(134,136), X(137,139), X(138,140),
  X(141,143), X(142,144), X(145,147), X(146,148), X(149,151), X(150,152),
  X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138), X(15,141),
  X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126),
  X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141),
  X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82),
  X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(115,145), X(116,146), X(119,149), X(120,150),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(135,149), X(136,150), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13),
  X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29),
  X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45),
  X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61),
  X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77),
  X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93),
  X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106),
  X(107,109), X(108,110), X(111,113), X(112,114), X(115,117), X(116,118),
  X(119,121), X(120,122), X(123,125), X(124,126), X(127,129), X(128,130),
  X(131,133), X(132,134), X(135,137), X(136,138), X(139,141), X(140,142),
  X(143,145), X(144,146), X(147,149), X(148,150), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139),
  X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(2,65),
  X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81),
  X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97),
  X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111),
  X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125),
  X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137), X(76,139),
  X(78,141), X(80,143), X(82,145), X(84,147), X(86,149), X(88,151), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111),
  X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125),
  X(96,127), X(98,129), X(100,131), X(102,133), X(104,135), X(106,137),
  X(108,139), X(110,141), X(112,143), X(114,145), X(116,147), X(118,149),
  X(120,151), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(130,137), X(132,139), X(134,141), X(136,143),
  X(138,145), X(140,147), X(142,149), X(144,151), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89),
  X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101), X(100,103),
  X(102,105), X(104,107), X(106,109), X(108,111), X(110,113), X(112,115),
  X(114,117), X(116,119), X(118,121), X(120,123), X(122,125), X(124,127),
  X(126,129), X(128,131), X(130,133), X(132,135), X(134,137), X(136,139),
  X(138,141), X(140,143), X(142,145), X(144,147), X(146,149), X(148,151), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151)
};
S(154) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(1,65), X(2,66),
  X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74),
  X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82),
  X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90),
  X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98),
  X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105),
  X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112),
  X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119),
  X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126),
  X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133),
  X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140),
  X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(83,147),
  X(84,148), X(85,149), X(86,150), X(87,151), X(88,152), X(89,153), X(90,154),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103),
  X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110),
  X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117),
  X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124),
  X(93,125), X(94,126), X(95,127), X(96,128), X(33,129), X(34,130), X(35,131),
  X(36,132), X(37,133), X(38,134), X(39,135), X(40,136), X(41,137), X(42,138),
  X(43,139), X(44,140), X(45,141), X(46,142), X(47,143), X(48,144), X(49,145),
  X(50,146), X(51,147), X(52,148), X(53,149), X(54,150), X(55,151), X(56,152),
  X(57,153), X(58,154), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69),
  X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77),
  X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85),
  X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93),
  X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132),
  X(101,133), X(102,134), X(103,135), X(104,136), X(105,137), X(106,138),
  X(107,139), X(108,140), X(109,141), X(110,142), X(111,143), X(112,144),
  X(113,145), X(114,146), X(115,147), X(116,148), X(117,149), X(118,150),
  X(119,151), X(120,152), X(121,153), X(122,154), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(129,145), X(130,146), X(131,147), X(132,148),
  X(133,149), X(134,150), X(135,151), X(136,152), X(137,153), X(138,154),
  X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134), X(23,135),
  X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141), X(30,142),
  X(31,143), X(32,144), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130),
  X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137),
  X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138),
  X(123,139), X(124,140), X(125,141), X(126,142), X(127,143), X(128,144), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39),
  X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55),
  X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71),
  X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87),
  X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102),
  X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117),
  X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(121,145),
  X(122,146), X(123,147), X(124,148), X(125,149), X(126,150), X(127,151),
  X(128,152), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(139,147), X(140,148), X(141,149),
  X(142,150), X(143,151), X(144,152), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(93,153), X(94,154), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105),
  X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116),
  X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(125,153), X(126,154), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(3,129), X(4,130), X(7,133), X(8,134),
  X(11,137), X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149),
  X(24,150), X(27,153), X(28,154), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73),
  X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89),
  X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102),
  X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117),
  X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130),
  X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(83,145),
  X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82),
  X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(115,145), X(116,146), X(119,149), X(120,150),
  X(123,153), X(124,154), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(139,153), X(140,154), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(127,133), X(128,134), X(131,137), X(132,138),
  X(135,141), X(136,142), X(139,145), X(140,146), X(143,149), X(144,150),
  X(147,153), X(148,154), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(127,129), X(128,130), X(131,133),
  X(132,134), X(135,137), X(136,138), X(139,141), X(140,142), X(143,145),
  X(144,146), X(147,149), X(148,150), X(151,153), X(152,154), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(2,129), X(4,131), X(6,133),
  X(8,135), X(10,137), X(12,139), X(14,141), X(16,143), X(18,145), X(20,147),
  X(22,149), X(24,151), X(26,153), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103),
  X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117),
  X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131),
  X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145),
  X(84,147), X(86,149), X(88,151), X(90,153), X(2,33), X(4,35), X(6,37), X(8,39),
  X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55),
  X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71),
  X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87),
  X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101),
  X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115),
  X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129),
  X(100,131), X(102,133), X(104,135), X(106,137), X(108,139), X(110,141),
  X(112,143), X(114,145), X(116,147), X(118,149), X(120,151), X(122,153),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95),
  X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109),
  X(96,111), X(98,113), X(100,115), X(102,117), X(104,119), X(106,121),
  X(108,123), X(110,125), X(112,127), X(114,129), X(116,131), X(118,133),
  X(120,135), X(122,137), X(124,139), X(126,141), X(128,143), X(130,145),
  X(132,147), X(134,149), X(136,151), X(138,153), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(130,137), X(132,139), X(134,141), X(136,143),
  X(138,145), X(140,147), X(142,149), X(144,151), X(146,153), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(130,133), X(132,135), X(134,137),
  X(136,139), X(138,141), X(140,143), X(142,145), X(144,147), X(146,149),
  X(148,151), X(150,153), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(142,143),
  X(144,145), X(146,147), X(148,149), X(150,151), X(152,153)
};
S(156) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131),
  X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138),
  X(75,139), X(76,140), X(77,141), X(78,142), X(79,143), X(80,144), X(81,145),
  X(82,146), X(83,147), X(84,148), X(85,149), X(86,150), X(87,151), X(88,152),
  X(89,153), X(90,154), X(91,155), X(92,156), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134),
  X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141),
  X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148),
  X(53,149), X(54,150), X(55,151), X(56,152), X(57,153), X(58,154), X(59,155),
  X(60,156), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70),
  X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78),
  X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86),
  X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94),
  X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132), X(101,133),
  X(102,134), X(103,135), X(104,136), X(105,137), X(106,138), X(107,139),
  X(108,140), X(109,141), X(110,142), X(111,143), X(112,144), X(113,145),
  X(114,146), X(115,147), X(116,148), X(117,149), X(118,150), X(119,151),
  X(120,152), X(121,153), X(122,154), X(123,155), X(124,156), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(17,129), X(18,130), X(19,131), X(20,132),
  X(21,133), X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139),
  X(28,140), X(29,141), X(30,142), X(31,143), X(32,144), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130),
  X(115,131), X(116,132), X(117,133), X(118,134), X(119,135), X(120,136),
  X(121,137), X(122,138), X(123,139), X(124,140), X(125,141), X(126,142),
  X(127,143), X(128,144), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94),
  X(87,95), X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109),
  X(102,110), X(103,111), X(104,112), X(113,121), X(114,122), X(115,123),
  X(116,124), X(117,125), X(118,126), X(119,127), X(120,128), X(129,137),
  X(130,138), X(131,139), X(132,140), X(133,141), X(134,142), X(135,143),
  X(136,144), X(145,153), X(146,154), X(147,155), X(148,156), X(9,129),
  X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135), X(16,136),
  X(25,145), X(26,146), X(27,147), X(28,148), X(29,149), X(30,150), X(31,151),
  X(32,152), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71),
  X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87),
  X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102),
  X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117),
  X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132),
  X(77,133), X(78,134), X(79,135), X(80,136), X(89,145), X(90,146), X(91,147),
  X(92,148), X(93,149), X(94,150), X(95,151), X(96,152), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(109,133), X(110,134),
  X(111,135), X(112,136), X(121,145), X(122,146), X(123,147), X(124,148),
  X(125,149), X(126,150), X(127,151), X(128,152), X(9,17), X(10,18), X(11,19),
  X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35),
  X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51),
  X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67),
  X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83),
  X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99),
  X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114),
  X(107,115), X(108,116), X(109,117), X(110,118), X(111,119), X(112,120),
  X(121,129), X(122,130), X(123,131), X(124,132), X(125,133), X(126,134),
  X(127,135), X(128,136), X(137,145), X(138,146), X(139,147), X(140,148),
  X(141,149), X(142,150), X(143,151), X(144,152), X(1,5), X(2,6), X(3,7), X(4,8),
  X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24),
  X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40),
  X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56),
  X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72),
  X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88),
  X(89,93), X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103),
  X(100,104), X(105,109), X(106,110), X(107,111), X(108,112), X(113,117),
  X(114,118), X(115,119), X(116,120), X(121,125), X(122,126), X(123,127),
  X(124,128), X(129,133), X(130,134), X(131,135), X(132,136), X(137,141),
  X(138,142), X(139,143), X(140,144), X(145,149), X(146,150), X(147,151),
  X(148,152), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138),
  X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153),
  X(30,154), X(31,155), X(32,156), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73),
  X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89),
  X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100),
  X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(55,115),
  X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(69,129), X(70,130),
  X(71,131), X(72,132), X(77,137), X(78,138), X(79,139), X(80,140), X(85,145),
  X(86,146), X(87,147), X(88,148), X(93,153), X(94,154), X(95,155), X(96,156),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132),
  X(109,137), X(110,138), X(111,139), X(112,140), X(117,145), X(118,146),
  X(119,147), X(120,148), X(125,153), X(126,154), X(127,155), X(128,156),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107),
  X(96,108), X(101,113), X(102,114), X(103,115), X(104,116), X(109,121),
  X(110,122), X(111,123), X(112,124), X(117,129), X(118,130), X(119,131),
  X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(133,145),
  X(134,146), X(135,147), X(136,148), X(141,153), X(142,154), X(143,155),
  X(144,156), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(103,107), X(104,108), X(109,113),
  X(110,114), X(111,115), X(112,116), X(117,121), X(118,122), X(119,123),
  X(120,124), X(125,129), X(126,130), X(127,131), X(128,132), X(133,137),
  X(134,138), X(135,139), X(136,140), X(141,145), X(142,146), X(143,147),
  X(144,148), X(149,153), X(150,154), X(151,155), X(152,156), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(3,129), X(4,130),
  X(7,133), X(8,134), X(11,137), X(12,138), X(15,141), X(16,142), X(19,145),
  X(20,146), X(23,149), X(24,150), X(27,153), X(28,154), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126),
  X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141),
  X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94),
  X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109),
  X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122),
  X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(111,141), X(112,142), X(115,145), X(116,146),
  X(119,149), X(120,150), X(123,153), X(124,154), X(3,17), X(4,18), X(7,21),
  X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37),
  X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53),
  X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69),
  X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85),
  X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(115,129), X(116,130), X(119,133), X(120,134), X(123,137),
  X(124,138), X(127,141), X(128,142), X(131,145), X(132,146), X(135,149),
  X(136,150), X(139,153), X(140,154), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(147,153), X(148,154), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86),
  X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101),
  X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(111,113),
  X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(123,125),
  X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(135,137),
  X(136,138), X(139,141), X(140,142), X(143,145), X(144,146), X(147,149),
  X(148,150), X(151,153), X(152,154), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137),
  X(12,139), X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(24,151),
  X(26,153), X(28,155), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133),
  X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(84,147),
  X(86,149), X(88,151), X(90,153), X(92,155), X(2,33), X(4,35), X(6,37), X(8,39),
  X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55),
  X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71),
  X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87),
  X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101),
  X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115),
  X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129),
  X(100,131), X(102,133), X(104,135), X(106,137), X(108,139), X(110,141),
  X(112,143), X(114,145), X(116,147), X(118,149), X(120,151), X(122,153),
  X(124,155), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(114,121), X(116,123), X(118,125), X(120,127),
  X(122,129), X(124,131), X(126,133), X(128,135), X(130,137), X(132,139),
  X(134,141), X(136,143), X(138,145), X(140,147), X(142,149), X(144,151),
  X(146,153), X(148,155), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(138,141), X(140,143), X(142,145),
  X(144,147), X(146,149), X(148,151), X(150,153), X(152,155), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155)
};
S(158) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70),
  X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78),
  X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86),
  X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94),
  X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101),
  X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108),
  X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115),
  X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122),
  X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129),
  X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136),
  X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143),
  X(80,144), X(81,145), X(82,146), X(83,147), X(84,148), X(85,149), X(86,150),
  X(87,151), X(88,152), X(89,153), X(90,154), X(91,155), X(92,156), X(93,157),
  X(94,158), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(33,129), X(34,130),
  X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136), X(41,137),
  X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143), X(48,144),
  X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150), X(55,151),
  X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157), X(62,158),
  X(33,65), X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72),
  X(41,73), X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80),
  X(49,81), X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88),
  X(57,89), X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(99,131), X(100,132), X(101,133), X(102,134),
  X(103,135), X(104,136), X(105,137), X(106,138), X(107,139), X(108,140),
  X(109,141), X(110,142), X(111,143), X(112,144), X(113,145), X(114,146),
  X(115,147), X(116,148), X(117,149), X(118,150), X(119,151), X(120,152),
  X(121,153), X(122,154), X(123,155), X(124,156), X(125,157), X(126,158),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(133,149), X(134,150), X(135,151), X(136,152),
  X(137,153), X(138,154), X(139,155), X(140,156), X(141,157), X(142,158),
  X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134), X(23,135),
  X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141), X(30,142),
  X(31,143), X(32,144), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130),
  X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137),
  X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138),
  X(123,139), X(124,140), X(125,141), X(126,142), X(127,143), X(128,144), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(147,155), X(148,156), X(149,157), X(150,158),
  X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134), X(15,135),
  X(16,136), X(25,145), X(26,146), X(27,147), X(28,148), X(29,149), X(30,150),
  X(31,151), X(32,152), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69),
  X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85),
  X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99), X(44,100),
  X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114), X(59,115),
  X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129), X(74,130),
  X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136), X(89,145),
  X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151), X(96,152),
  X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40),
  X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56),
  X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72),
  X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88),
  X(73,97), X(74,98), X(75,99), X(76,100), X(77,101), X(78,102), X(79,103),
  X(80,104), X(89,113), X(90,114), X(91,115), X(92,116), X(93,117), X(94,118),
  X(95,119), X(96,120), X(105,129), X(106,130), X(107,131), X(108,132),
  X(109,133), X(110,134), X(111,135), X(112,136), X(121,145), X(122,146),
  X(123,147), X(124,148), X(125,149), X(126,150), X(127,151), X(128,152),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(145,149), X(146,150), X(147,151), X(148,152), X(153,157), X(154,158),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(31,155), X(32,156), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74),
  X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90),
  X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105),
  X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116),
  X(61,121), X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131),
  X(72,132), X(77,137), X(78,138), X(79,139), X(80,140), X(85,145), X(86,146),
  X(87,147), X(88,148), X(93,153), X(94,154), X(95,155), X(96,156), X(5,33),
  X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49),
  X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65),
  X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81),
  X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97),
  X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108),
  X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122), X(95,123),
  X(96,124), X(101,129), X(102,130), X(103,131), X(104,132), X(109,137),
  X(110,138), X(111,139), X(112,140), X(117,145), X(118,146), X(119,147),
  X(120,148), X(125,153), X(126,154), X(127,155), X(128,156), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105),
  X(102,106), X(103,107), X(104,108), X(109,113), X(110,114), X(111,115),
  X(112,116), X(117,121), X(118,122), X(119,123), X(120,124), X(125,129),
  X(126,130), X(127,131), X(128,132), X(133,137), X(134,138), X(135,139),
  X(136,140), X(141,145), X(142,146), X(143,147), X(144,148), X(149,153),
  X(150,154), X(151,155), X(152,156), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104),
  X(105,107), X(106,108), X(109,111), X(110,112), X(113,115), X(114,116),
  X(117,119), X(118,120), X(121,123), X(122,124), X(125,127), X(126,128),
  X(129,131), X(130,132), X(133,135), X(134,136), X(137,139), X(138,140),
  X(141,143), X(142,144), X(145,147), X(146,148), X(149,151), X(150,152),
  X(153,155), X(154,156), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137),
  X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150),
  X(27,153), X(28,154), X(31,157), X(32,158), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101),
  X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114),
  X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129),
  X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142),
  X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(95,157),
  X(96,158), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(111,141), X(112,142), X(115,145), X(116,146),
  X(119,149), X(120,150), X(123,153), X(124,154), X(127,157), X(128,158),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(135,149), X(136,150), X(139,153), X(140,154), X(143,157),
  X(144,158), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134),
  X(131,137), X(132,138), X(135,141), X(136,142), X(139,145), X(140,146),
  X(143,149), X(144,150), X(147,153), X(148,154), X(151,157), X(152,158), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146),
  X(147,149), X(148,150), X(151,153), X(152,154), X(155,157), X(156,158), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139), X(14,141),
  X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153), X(28,155),
  X(30,157), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107),
  X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121),
  X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135),
  X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(84,147), X(86,149),
  X(88,151), X(90,153), X(92,155), X(94,157), X(2,33), X(4,35), X(6,37), X(8,39),
  X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55),
  X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71),
  X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87),
  X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99), X(70,101),
  X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113), X(84,115),
  X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127), X(98,129),
  X(100,131), X(102,133), X(104,135), X(106,137), X(108,139), X(110,141),
  X(112,143), X(114,145), X(116,147), X(118,149), X(120,151), X(122,153),
  X(124,155), X(126,157), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59),
  X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75),
  X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91),
  X(78,93), X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105),
  X(92,107), X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(136,143), X(138,145), X(140,147),
  X(142,149), X(144,151), X(146,153), X(148,155), X(150,157), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(130,133), X(132,135), X(134,137),
  X(136,139), X(138,141), X(140,143), X(142,145), X(144,147), X(146,149),
  X(148,151), X(150,153), X(152,155), X(154,157), X(2,3), X(4,5), X(6,7), X(8,9),
  X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25),
  X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41),
  X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57),
  X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73),
  X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89),
  X(90,91), X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103),
  X(104,105), X(106,107), X(108,109), X(110,111), X(112,113), X(114,115),
  X(116,117), X(118,119), X(120,121), X(122,123), X(124,125), X(126,127),
  X(128,129), X(130,131), X(132,133), X(134,135), X(136,137), X(138,139),
  X(140,141), X(142,143), X(144,145), X(146,147), X(148,149), X(150,151),
  X(152,153), X(154,155), X(156,157)
};
S(160) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(1,65), X(2,66), X(3,67), X(4,68),
  X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76),
  X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84),
  X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92),
  X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99),
  X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106),
  X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113),
  X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120),
  X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127),
  X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134),
  X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141),
  X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(83,147), X(84,148),
  X(85,149), X(86,150), X(87,151), X(88,152), X(89,153), X(90,154), X(91,155),
  X(92,156), X(93,157), X(94,158), X(95,159), X(96,160), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112),
  X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119),
  X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126),
  X(95,127), X(96,128), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133),
  X(38,134), X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140),
  X(45,141), X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(51,147),
  X(52,148), X(53,149), X(54,150), X(55,151), X(56,152), X(57,153), X(58,154),
  X(59,155), X(60,156), X(61,157), X(62,158), X(63,159), X(64,160), X(33,65),
  X(34,66), X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73),
  X(42,74), X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81),
  X(50,82), X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89),
  X(58,90), X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96),
  X(97,129), X(98,130), X(99,131), X(100,132), X(101,133), X(102,134),
  X(103,135), X(104,136), X(105,137), X(106,138), X(107,139), X(108,140),
  X(109,141), X(110,142), X(111,143), X(112,144), X(113,145), X(114,146),
  X(115,147), X(116,148), X(117,149), X(118,150), X(119,151), X(120,152),
  X(121,153), X(122,154), X(123,155), X(124,156), X(125,157), X(126,158),
  X(127,159), X(128,160), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22),
  X(7,23), X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30),
  X(15,31), X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54),
  X(39,55), X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62),
  X(47,63), X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86),
  X(71,87), X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94),
  X(79,95), X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117),
  X(102,118), X(103,119), X(104,120), X(105,121), X(106,122), X(107,123),
  X(108,124), X(109,125), X(110,126), X(111,127), X(112,128), X(129,145),
  X(130,146), X(131,147), X(132,148), X(133,149), X(134,150), X(135,151),
  X(136,152), X(137,153), X(138,154), X(139,155), X(140,156), X(141,157),
  X(142,158), X(143,159), X(144,160), X(17,129), X(18,130), X(19,131), X(20,132),
  X(21,133), X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139),
  X(28,140), X(29,141), X(30,142), X(31,143), X(32,144), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37),
  X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45),
  X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69),
  X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77),
  X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100),
  X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107),
  X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130),
  X(115,131), X(116,132), X(117,133), X(118,134), X(119,135), X(120,136),
  X(121,137), X(122,138), X(123,139), X(124,140), X(125,141), X(126,142),
  X(127,143), X(128,144), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14),
  X(7,15), X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30),
  X(23,31), X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46),
  X(39,47), X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62),
  X(55,63), X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78),
  X(71,79), X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94),
  X(87,95), X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109),
  X(102,110), X(103,111), X(104,112), X(113,121), X(114,122), X(115,123),
  X(116,124), X(117,125), X(118,126), X(119,127), X(120,128), X(129,137),
  X(130,138), X(131,139), X(132,140), X(133,141), X(134,142), X(135,143),
  X(136,144), X(145,153), X(146,154), X(147,155), X(148,156), X(149,157),
  X(150,158), X(151,159), X(152,160), X(9,129), X(10,130), X(11,131), X(12,132),
  X(13,133), X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147),
  X(28,148), X(29,149), X(30,150), X(31,151), X(32,152), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135),
  X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150),
  X(95,151), X(96,152), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37),
  X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53),
  X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69),
  X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85),
  X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100),
  X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115),
  X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130),
  X(107,131), X(108,132), X(109,133), X(110,134), X(111,135), X(112,136),
  X(121,145), X(122,146), X(123,147), X(124,148), X(125,149), X(126,150),
  X(127,151), X(128,152), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21),
  X(14,22), X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37),
  X(30,38), X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53),
  X(46,54), X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69),
  X(62,70), X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85),
  X(78,86), X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100),
  X(93,101), X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(139,147), X(140,148), X(141,149),
  X(142,150), X(143,151), X(144,152), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(5,129), X(6,130), X(7,131),
  X(8,132), X(13,137), X(14,138), X(15,139), X(16,140), X(21,145), X(22,146),
  X(23,147), X(24,148), X(29,153), X(30,154), X(31,155), X(32,156), X(5,65),
  X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81),
  X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97),
  X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108),
  X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123),
  X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138),
  X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(93,153),
  X(94,154), X(95,155), X(96,156), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41),
  X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57),
  X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73),
  X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89),
  X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100),
  X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115),
  X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130),
  X(103,131), X(104,132), X(109,137), X(110,138), X(111,139), X(112,140),
  X(117,145), X(118,146), X(119,147), X(120,148), X(125,153), X(126,154),
  X(127,155), X(128,156), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(125,137), X(126,138), X(127,139),
  X(128,140), X(133,145), X(134,146), X(135,147), X(136,148), X(141,153),
  X(142,154), X(143,155), X(144,156), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(133,135), X(134,136), X(137,139), X(138,140), X(141,143), X(142,144),
  X(145,147), X(146,148), X(149,151), X(150,152), X(153,155), X(154,156),
  X(157,159), X(158,160), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137),
  X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150),
  X(27,153), X(28,154), X(31,157), X(32,158), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101),
  X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114),
  X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129),
  X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142),
  X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(95,157),
  X(96,158), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45),
  X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61),
  X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77),
  X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93),
  X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106),
  X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121),
  X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(111,141), X(112,142), X(115,145), X(116,146),
  X(119,149), X(120,150), X(123,153), X(124,154), X(127,157), X(128,158),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(135,149), X(136,150), X(139,153), X(140,154), X(143,157),
  X(144,158), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21),
  X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37),
  X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53),
  X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69),
  X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85),
  X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134),
  X(131,137), X(132,138), X(135,141), X(136,142), X(139,145), X(140,146),
  X(143,149), X(144,150), X(147,153), X(148,154), X(151,157), X(152,158), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146),
  X(147,149), X(148,150), X(151,153), X(152,154), X(155,157), X(156,158), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139),
  X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153),
  X(28,155), X(30,157), X(32,159), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103),
  X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117),
  X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131),
  X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145),
  X(84,147), X(86,149), X(88,151), X(90,153), X(92,155), X(94,157), X(96,159),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123),
  X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95),
  X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109),
  X(96,111), X(98,113), X(100,115), X(102,117), X(104,119), X(106,121),
  X(108,123), X(110,125), X(112,127), X(114,129), X(116,131), X(118,133),
  X(120,135), X(122,137), X(124,139), X(126,141), X(128,143), X(130,145),
  X(132,147), X(134,149), X(136,151), X(138,153), X(140,155), X(142,157),
  X(144,159), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(136,143), X(138,145), X(140,147),
  X(142,149), X(144,151), X(146,153), X(148,155), X(150,157), X(152,159), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123),
  X(122,125), X(124,127), X(126,129), X(128,131), X(130,133), X(132,135),
  X(134,137), X(136,139), X(138,141), X(140,143), X(142,145), X(144,147),
  X(146,149), X(148,151), X(150,153), X(152,155), X(154,157), X(156,159), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159)
};
S(162) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(1,65),
  X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73),
  X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81),
  X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89),
  X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97),
  X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104),
  X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111),
  X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118),
  X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125),
  X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132),
  X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139),
  X(76,140), X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146),
  X(83,147), X(84,148), X(85,149), X(86,150), X(87,151), X(88,152), X(89,153),
  X(90,154), X(91,155), X(92,156), X(93,157), X(94,158), X(95,159), X(96,160),
  X(97,161), X(98,162), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101),
  X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108),
  X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115),
  X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122),
  X(91,123), X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(129,161),
  X(130,162), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134),
  X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141),
  X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148),
  X(53,149), X(54,150), X(55,151), X(56,152), X(57,153), X(58,154), X(59,155),
  X(60,156), X(61,157), X(62,158), X(63,159), X(64,160), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129),
  X(98,130), X(99,131), X(100,132), X(101,133), X(102,134), X(103,135),
  X(104,136), X(105,137), X(106,138), X(107,139), X(108,140), X(109,141),
  X(110,142), X(111,143), X(112,144), X(113,145), X(114,146), X(115,147),
  X(116,148), X(117,149), X(118,150), X(119,151), X(120,152), X(121,153),
  X(122,154), X(123,155), X(124,156), X(125,157), X(126,158), X(127,159),
  X(128,160), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(133,149), X(134,150), X(135,151), X(136,152),
  X(137,153), X(138,154), X(139,155), X(140,156), X(141,157), X(142,158),
  X(143,159), X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111),
  X(64,112), X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134),
  X(87,135), X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141),
  X(94,142), X(95,143), X(96,144), X(113,161), X(114,162), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105),
  X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112),
  X(113,129), X(114,130), X(115,131), X(116,132), X(117,133), X(118,134),
  X(119,135), X(120,136), X(121,137), X(122,138), X(123,139), X(124,140),
  X(125,141), X(126,142), X(127,143), X(128,144), X(145,161), X(146,162), X(1,9),
  X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25),
  X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41),
  X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57),
  X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73),
  X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89),
  X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96),
  X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(147,155), X(148,156), X(149,157), X(150,158),
  X(151,159), X(152,160), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(9,65),
  X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81),
  X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97),
  X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104),
  X(57,113), X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119),
  X(64,120), X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134),
  X(79,135), X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(93,149),
  X(94,150), X(95,151), X(96,152), X(105,161), X(106,162), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(109,133), X(110,134),
  X(111,135), X(112,136), X(121,145), X(122,146), X(123,147), X(124,148),
  X(125,149), X(126,150), X(127,151), X(128,152), X(137,161), X(138,162),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(153,161), X(154,162), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(5,129), X(6,130), X(7,131),
  X(8,132), X(13,137), X(14,138), X(15,139), X(16,140), X(21,145), X(22,146),
  X(23,147), X(24,148), X(29,153), X(30,154), X(31,155), X(32,156), X(37,161),
  X(38,162), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(77,137), X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147),
  X(88,148), X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132),
  X(109,137), X(110,138), X(111,139), X(112,140), X(117,145), X(118,146),
  X(119,147), X(120,148), X(125,153), X(126,154), X(127,155), X(128,156),
  X(133,161), X(134,162), X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26),
  X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42),
  X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58),
  X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74),
  X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90),
  X(79,91), X(80,92), X(85,97), X(86,98), X(87,99), X(88,100), X(93,105),
  X(94,106), X(95,107), X(96,108), X(101,113), X(102,114), X(103,115),
  X(104,116), X(109,121), X(110,122), X(111,123), X(112,124), X(117,129),
  X(118,130), X(119,131), X(120,132), X(125,137), X(126,138), X(127,139),
  X(128,140), X(133,145), X(134,146), X(135,147), X(136,148), X(141,153),
  X(142,154), X(143,155), X(144,156), X(149,161), X(150,162), X(5,9), X(6,10),
  X(7,11), X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26),
  X(23,27), X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42),
  X(39,43), X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58),
  X(55,59), X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74),
  X(71,75), X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90),
  X(87,91), X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105),
  X(102,106), X(103,107), X(104,108), X(109,113), X(110,114), X(111,115),
  X(112,116), X(117,121), X(118,122), X(119,123), X(120,124), X(125,129),
  X(126,130), X(127,131), X(128,132), X(133,137), X(134,138), X(135,139),
  X(136,140), X(141,145), X(142,146), X(143,147), X(144,148), X(149,153),
  X(150,154), X(151,155), X(152,156), X(157,161), X(158,162), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(27,153),
  X(28,154), X(31,157), X(32,158), X(35,161), X(36,162), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126),
  X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141),
  X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154),
  X(95,157), X(96,158), X(99,161), X(100,162), X(3,33), X(4,34), X(7,37),
  X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53),
  X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69),
  X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85),
  X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(115,145), X(116,146), X(119,149), X(120,150),
  X(123,153), X(124,154), X(127,157), X(128,158), X(131,161), X(132,162),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(135,149), X(136,150), X(139,153), X(140,154), X(143,157),
  X(144,158), X(147,161), X(148,162), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(147,153), X(148,154), X(151,157),
  X(152,158), X(155,161), X(156,162), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13),
  X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29),
  X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45),
  X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61),
  X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77),
  X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93),
  X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106),
  X(107,109), X(108,110), X(111,113), X(112,114), X(115,117), X(116,118),
  X(119,121), X(120,122), X(123,125), X(124,126), X(127,129), X(128,130),
  X(131,133), X(132,134), X(135,137), X(136,138), X(139,141), X(140,142),
  X(143,145), X(144,146), X(147,149), X(148,150), X(151,153), X(152,154),
  X(155,157), X(156,158), X(159,161), X(160,162), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139), X(14,141),
  X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153), X(28,155),
  X(30,157), X(32,159), X(34,161), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73),
  X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89),
  X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103),
  X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117),
  X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131),
  X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145),
  X(84,147), X(86,149), X(88,151), X(90,153), X(92,155), X(94,157), X(96,159),
  X(98,161), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(130,161), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(126,133),
  X(128,135), X(130,137), X(132,139), X(134,141), X(136,143), X(138,145),
  X(140,147), X(142,149), X(144,151), X(146,153), X(148,155), X(150,157),
  X(152,159), X(154,161), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(138,141), X(140,143), X(142,145),
  X(144,147), X(146,149), X(148,151), X(150,153), X(152,155), X(154,157),
  X(156,159), X(158,161), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(142,143),
  X(144,145), X(146,147), X(148,149), X(150,151), X(152,153), X(154,155),
  X(156,157), X(158,159), X(160,161)
};
S(164) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71),
  X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79),
  X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87),
  X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95),
  X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102),
  X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109),
  X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116),
  X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123),
  X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130),
  X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137),
  X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143), X(80,144),
  X(81,145), X(82,146), X(83,147), X(84,148), X(85,149), X(86,150), X(87,151),
  X(88,152), X(89,153), X(90,154), X(91,155), X(92,156), X(93,157), X(94,158),
  X(95,159), X(96,160), X(97,161), X(98,162), X(99,163), X(100,164), X(1,33),
  X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41),
  X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49),
  X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57),
  X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97),
  X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104),
  X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111),
  X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118),
  X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125),
  X(94,126), X(95,127), X(96,128), X(129,161), X(130,162), X(131,163),
  X(132,164), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134),
  X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141),
  X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148),
  X(53,149), X(54,150), X(55,151), X(56,152), X(57,153), X(58,154), X(59,155),
  X(60,156), X(61,157), X(62,158), X(63,159), X(64,160), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129),
  X(98,130), X(99,131), X(100,132), X(101,133), X(102,134), X(103,135),
  X(104,136), X(105,137), X(106,138), X(107,139), X(108,140), X(109,141),
  X(110,142), X(111,143), X(112,144), X(113,145), X(114,146), X(115,147),
  X(116,148), X(117,149), X(118,150), X(119,151), X(120,152), X(121,153),
  X(122,154), X(123,155), X(124,156), X(125,157), X(126,158), X(127,159),
  X(128,160), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(133,149), X(134,150), X(135,151), X(136,152),
  X(137,153), X(138,154), X(139,155), X(140,156), X(141,157), X(142,158),
  X(143,159), X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163),
  X(52,164), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137), X(90,138),
  X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144), X(113,161),
  X(114,162), X(115,163), X(116,164), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(125,141),
  X(126,142), X(127,143), X(128,144), X(145,161), X(146,162), X(147,163),
  X(148,164), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(147,155), X(148,156), X(149,157), X(150,158),
  X(151,159), X(152,160), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163),
  X(44,164), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71),
  X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87),
  X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102),
  X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117),
  X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132),
  X(77,133), X(78,134), X(79,135), X(80,136), X(89,145), X(90,146), X(91,147),
  X(92,148), X(93,149), X(94,150), X(95,151), X(96,152), X(105,161), X(106,162),
  X(107,163), X(108,164), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37),
  X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53),
  X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69),
  X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85),
  X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100),
  X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115),
  X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130),
  X(107,131), X(108,132), X(109,133), X(110,134), X(111,135), X(112,136),
  X(121,145), X(122,146), X(123,147), X(124,148), X(125,149), X(126,150),
  X(127,151), X(128,152), X(137,161), X(138,162), X(139,163), X(140,164),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(153,161), X(154,162), X(155,163), X(156,164), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86),
  X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(97,101),
  X(98,102), X(99,103), X(100,104), X(105,109), X(106,110), X(107,111),
  X(108,112), X(113,117), X(114,118), X(115,119), X(116,120), X(121,125),
  X(122,126), X(123,127), X(124,128), X(129,133), X(130,134), X(131,135),
  X(132,136), X(137,141), X(138,142), X(139,143), X(140,144), X(145,149),
  X(146,150), X(147,151), X(148,152), X(153,157), X(154,158), X(155,159),
  X(156,160), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138),
  X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153),
  X(30,154), X(31,155), X(32,156), X(37,161), X(38,162), X(39,163), X(40,164),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43),
  X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59),
  X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75),
  X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91),
  X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106),
  X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121),
  X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(125,153), X(126,154), X(127,155),
  X(128,156), X(133,161), X(134,162), X(135,163), X(136,164), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(157,161), X(158,162), X(159,163), X(160,164), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(161,163), X(162,164), X(3,129), X(4,130), X(7,133), X(8,134),
  X(11,137), X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149),
  X(24,150), X(27,153), X(28,154), X(31,157), X(32,158), X(35,161), X(36,162),
  X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78),
  X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94),
  X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109),
  X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122),
  X(63,125), X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137),
  X(76,138), X(79,141), X(80,142), X(83,145), X(84,146), X(87,149), X(88,150),
  X(91,153), X(92,154), X(95,157), X(96,158), X(99,161), X(100,162), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125),
  X(96,126), X(99,129), X(100,130), X(103,133), X(104,134), X(107,137),
  X(108,138), X(111,141), X(112,142), X(115,145), X(116,146), X(119,149),
  X(120,150), X(123,153), X(124,154), X(127,157), X(128,158), X(131,161),
  X(132,162), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(139,153), X(140,154),
  X(143,157), X(144,158), X(147,161), X(148,162), X(3,9), X(4,10), X(7,13),
  X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29),
  X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45),
  X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61),
  X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77),
  X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93),
  X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106),
  X(103,109), X(104,110), X(107,113), X(108,114), X(111,117), X(112,118),
  X(115,121), X(116,122), X(119,125), X(120,126), X(123,129), X(124,130),
  X(127,133), X(128,134), X(131,137), X(132,138), X(135,141), X(136,142),
  X(139,145), X(140,146), X(143,149), X(144,150), X(147,153), X(148,154),
  X(151,157), X(152,158), X(155,161), X(156,162), X(3,5), X(4,6), X(7,9),
  X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25),
  X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41),
  X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57),
  X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73),
  X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89),
  X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101), X(100,102),
  X(103,105), X(104,106), X(107,109), X(108,110), X(111,113), X(112,114),
  X(115,117), X(116,118), X(119,121), X(120,122), X(123,125), X(124,126),
  X(127,129), X(128,130), X(131,133), X(132,134), X(135,137), X(136,138),
  X(139,141), X(140,142), X(143,145), X(144,146), X(147,149), X(148,150),
  X(151,153), X(152,154), X(155,157), X(156,158), X(159,161), X(160,162), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(2,129), X(4,131), X(6,133), X(8,135),
  X(10,137), X(12,139), X(14,141), X(16,143), X(18,145), X(20,147), X(22,149),
  X(24,151), X(26,153), X(28,155), X(30,157), X(32,159), X(34,161), X(36,163),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123),
  X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137),
  X(76,139), X(78,141), X(80,143), X(82,145), X(84,147), X(86,149), X(88,151),
  X(90,153), X(92,155), X(94,157), X(96,159), X(98,161), X(100,163), X(2,33),
  X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49),
  X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65),
  X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81),
  X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97),
  X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111),
  X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125),
  X(96,127), X(98,129), X(100,131), X(102,133), X(104,135), X(106,137),
  X(108,139), X(110,141), X(112,143), X(114,145), X(116,147), X(118,149),
  X(120,151), X(122,153), X(124,155), X(126,157), X(128,159), X(130,161),
  X(132,163), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(148,163), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(130,137), X(132,139), X(134,141), X(136,143),
  X(138,145), X(140,147), X(142,149), X(144,151), X(146,153), X(148,155),
  X(150,157), X(152,159), X(154,161), X(156,163), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89),
  X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101), X(100,103),
  X(102,105), X(104,107), X(106,109), X(108,111), X(110,113), X(112,115),
  X(114,117), X(116,119), X(118,121), X(120,123), X(122,125), X(124,127),
  X(126,129), X(128,131), X(130,133), X(132,135), X(134,137), X(136,139),
  X(138,141), X(140,143), X(142,145), X(144,147), X(146,149), X(148,151),
  X(150,153), X(152,155), X(154,157), X(156,159), X(158,161), X(160,163), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163)
};
S(166) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69),
  X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77),
  X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85),
  X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93),
  X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100),
  X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107),
  X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114),
  X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121),
  X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128),
  X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135),
  X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142),
  X(79,143), X(80,144), X(81,145), X(82,146), X(83,147), X(84,148), X(85,149),
  X(86,150), X(87,151), X(88,152), X(89,153), X(90,154), X(91,155), X(92,156),
  X(93,157), X(94,158), X(95,159), X(96,160), X(97,161), X(98,162), X(99,163),
  X(100,164), X(101,165), X(102,166), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(129,161), X(130,162), X(131,163), X(132,164), X(133,165),
  X(134,166), X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134),
  X(39,135), X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141),
  X(46,142), X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148),
  X(53,149), X(54,150), X(55,151), X(56,152), X(57,153), X(58,154), X(59,155),
  X(60,156), X(61,157), X(62,158), X(63,159), X(64,160), X(33,65), X(34,66),
  X(35,67), X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74),
  X(43,75), X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82),
  X(51,83), X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90),
  X(59,91), X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129),
  X(98,130), X(99,131), X(100,132), X(101,133), X(102,134), X(103,135),
  X(104,136), X(105,137), X(106,138), X(107,139), X(108,140), X(109,141),
  X(110,142), X(111,143), X(112,144), X(113,145), X(114,146), X(115,147),
  X(116,148), X(117,149), X(118,150), X(119,151), X(120,152), X(121,153),
  X(122,154), X(123,155), X(124,156), X(125,157), X(126,158), X(127,159),
  X(128,160), X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23),
  X(8,24), X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31),
  X(16,32), X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55),
  X(40,56), X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63),
  X(48,64), X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87),
  X(72,88), X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95),
  X(80,96), X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(133,149), X(134,150), X(135,151), X(136,152),
  X(137,153), X(138,154), X(139,155), X(140,156), X(141,157), X(142,158),
  X(143,159), X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163),
  X(52,164), X(53,165), X(54,166), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129),
  X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136),
  X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143),
  X(96,144), X(113,161), X(114,162), X(115,163), X(116,164), X(117,165),
  X(118,166), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100), X(85,101),
  X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107), X(92,108),
  X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130), X(115,131),
  X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(121,137),
  X(122,138), X(123,139), X(124,140), X(125,141), X(126,142), X(127,143),
  X(128,144), X(145,161), X(146,162), X(147,163), X(148,164), X(149,165),
  X(150,166), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(147,155), X(148,156), X(149,157), X(150,158),
  X(151,159), X(152,160), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163),
  X(44,164), X(45,165), X(46,166), X(9,65), X(10,66), X(11,67), X(12,68),
  X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83), X(28,84),
  X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(105,161), X(106,162), X(107,163), X(108,164), X(109,165),
  X(110,166), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70),
  X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86),
  X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101),
  X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116),
  X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(121,145),
  X(122,146), X(123,147), X(124,148), X(125,149), X(126,150), X(127,151),
  X(128,152), X(137,161), X(138,162), X(139,163), X(140,164), X(141,165),
  X(142,166), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(139,147), X(140,148), X(141,149),
  X(142,150), X(143,151), X(144,152), X(153,161), X(154,162), X(155,163),
  X(156,164), X(157,165), X(158,166), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(161,165), X(162,166),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(31,155), X(32,156), X(37,161), X(38,162), X(39,163), X(40,164), X(5,65),
  X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81),
  X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97),
  X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108),
  X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123),
  X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138),
  X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(93,153),
  X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43),
  X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59),
  X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75),
  X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91),
  X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106),
  X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121),
  X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(125,153), X(126,154), X(127,155),
  X(128,156), X(133,161), X(134,162), X(135,163), X(136,164), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(157,161), X(158,162), X(159,163), X(160,164), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(161,163), X(162,164), X(3,129), X(4,130), X(7,133), X(8,134),
  X(11,137), X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149),
  X(24,150), X(27,153), X(28,154), X(31,157), X(32,158), X(35,161), X(36,162),
  X(39,165), X(40,166), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74),
  X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90),
  X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105),
  X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118),
  X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(71,133),
  X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(83,145), X(84,146),
  X(87,149), X(88,150), X(91,153), X(92,154), X(95,157), X(96,158), X(99,161),
  X(100,162), X(103,165), X(104,166), X(3,33), X(4,34), X(7,37), X(8,38),
  X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54),
  X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70),
  X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86),
  X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98), X(71,101),
  X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113), X(84,114),
  X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126), X(99,129),
  X(100,130), X(103,133), X(104,134), X(107,137), X(108,138), X(111,141),
  X(112,142), X(115,145), X(116,146), X(119,149), X(120,150), X(123,153),
  X(124,154), X(127,157), X(128,158), X(131,161), X(132,162), X(135,165),
  X(136,166), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(139,153), X(140,154),
  X(143,157), X(144,158), X(147,161), X(148,162), X(151,165), X(152,166), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(127,133), X(128,134), X(131,137), X(132,138),
  X(135,141), X(136,142), X(139,145), X(140,146), X(143,149), X(144,150),
  X(147,153), X(148,154), X(151,157), X(152,158), X(155,161), X(156,162),
  X(159,165), X(160,166), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(127,129), X(128,130), X(131,133),
  X(132,134), X(135,137), X(136,138), X(139,141), X(140,142), X(143,145),
  X(144,146), X(147,149), X(148,150), X(151,153), X(152,154), X(155,157),
  X(156,158), X(159,161), X(160,162), X(163,165), X(164,166), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(2,129), X(4,131), X(6,133),
  X(8,135), X(10,137), X(12,139), X(14,141), X(16,143), X(18,145), X(20,147),
  X(22,149), X(24,151), X(26,153), X(28,155), X(30,157), X(32,159), X(34,161),
  X(36,163), X(38,165), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133),
  X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(84,147),
  X(86,149), X(88,151), X(90,153), X(92,155), X(94,157), X(96,159), X(98,161),
  X(100,163), X(102,165), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119),
  X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133),
  X(104,135), X(106,137), X(108,139), X(110,141), X(112,143), X(114,145),
  X(116,147), X(118,149), X(120,151), X(122,153), X(124,155), X(126,157),
  X(128,159), X(130,161), X(132,163), X(134,165), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(128,143), X(130,145), X(132,147), X(134,149),
  X(136,151), X(138,153), X(140,155), X(142,157), X(144,159), X(146,161),
  X(148,163), X(150,165), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19),
  X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35),
  X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51),
  X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67),
  X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83),
  X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(136,143), X(138,145), X(140,147),
  X(142,149), X(144,151), X(146,153), X(148,155), X(150,157), X(152,159),
  X(154,161), X(156,163), X(158,165), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77),
  X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93),
  X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107),
  X(106,109), X(108,111), X(110,113), X(112,115), X(114,117), X(116,119),
  X(118,121), X(120,123), X(122,125), X(124,127), X(126,129), X(128,131),
  X(130,133), X(132,135), X(134,137), X(136,139), X(138,141), X(140,143),
  X(142,145), X(144,147), X(146,149), X(148,151), X(150,153), X(152,155),
  X(154,157), X(156,159), X(158,161), X(160,163), X(162,165), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165)
};
S(168) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(1,65), X(2,66),
  X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74),
  X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82),
  X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90),
  X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98),
  X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105),
  X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112),
  X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119),
  X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126),
  X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133),
  X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140),
  X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(83,147),
  X(84,148), X(85,149), X(86,150), X(87,151), X(88,152), X(89,153), X(90,154),
  X(91,155), X(92,156), X(93,157), X(94,158), X(95,159), X(96,160), X(97,161),
  X(98,162), X(99,163), X(100,164), X(101,165), X(102,166), X(103,167),
  X(104,168), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(129,161), X(130,162),
  X(131,163), X(132,164), X(133,165), X(134,166), X(135,167), X(136,168),
  X(33,129), X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135),
  X(40,136), X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142),
  X(47,143), X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149),
  X(54,150), X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156),
  X(61,157), X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67),
  X(36,68), X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75),
  X(44,76), X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83),
  X(52,84), X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91),
  X(60,92), X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130),
  X(99,131), X(100,132), X(101,133), X(102,134), X(103,135), X(104,136),
  X(105,137), X(106,138), X(107,139), X(108,140), X(109,141), X(110,142),
  X(111,143), X(112,144), X(113,145), X(114,146), X(115,147), X(116,148),
  X(117,149), X(118,150), X(119,151), X(120,152), X(121,153), X(122,154),
  X(123,155), X(124,156), X(125,157), X(126,158), X(127,159), X(128,160),
  X(1,17), X(2,18), X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24),
  X(9,25), X(10,26), X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32),
  X(33,49), X(34,50), X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56),
  X(41,57), X(42,58), X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64),
  X(65,81), X(66,82), X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88),
  X(73,89), X(74,90), X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96),
  X(97,113), X(98,114), X(99,115), X(100,116), X(101,117), X(102,118),
  X(103,119), X(104,120), X(105,121), X(106,122), X(107,123), X(108,124),
  X(109,125), X(110,126), X(111,127), X(112,128), X(129,145), X(130,146),
  X(131,147), X(132,148), X(133,149), X(134,150), X(135,151), X(136,152),
  X(137,153), X(138,154), X(139,155), X(140,156), X(141,157), X(142,158),
  X(143,159), X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163),
  X(52,164), X(53,165), X(54,166), X(55,167), X(56,168), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(113,161), X(114,162), X(115,163), X(116,164),
  X(117,165), X(118,166), X(119,167), X(120,168), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(125,141),
  X(126,142), X(127,143), X(128,144), X(145,161), X(146,162), X(147,163),
  X(148,164), X(149,165), X(150,166), X(151,167), X(152,168), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(133,141), X(134,142), X(135,143), X(136,144), X(145,153),
  X(146,154), X(147,155), X(148,156), X(149,157), X(150,158), X(151,159),
  X(152,160), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134),
  X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148), X(29,149),
  X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163), X(44,164),
  X(45,165), X(46,166), X(47,167), X(48,168), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(105,161), X(106,162), X(107,163), X(108,164), X(109,165),
  X(110,166), X(111,167), X(112,168), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84),
  X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(121,145), X(122,146), X(123,147), X(124,148), X(125,149),
  X(126,150), X(127,151), X(128,152), X(137,161), X(138,162), X(139,163),
  X(140,164), X(141,165), X(142,166), X(143,167), X(144,168), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(137,145), X(138,146), X(139,147),
  X(140,148), X(141,149), X(142,150), X(143,151), X(144,152), X(153,161),
  X(154,162), X(155,163), X(156,164), X(157,165), X(158,166), X(159,167),
  X(160,168), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(145,149), X(146,150), X(147,151), X(148,152), X(153,157), X(154,158),
  X(155,159), X(156,160), X(161,165), X(162,166), X(163,167), X(164,168),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(31,155), X(32,156), X(37,161), X(38,162), X(39,163), X(40,164), X(5,65),
  X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81),
  X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97),
  X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108),
  X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123),
  X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138),
  X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(93,153),
  X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43),
  X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59),
  X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75),
  X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91),
  X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106),
  X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121),
  X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(125,153), X(126,154), X(127,155),
  X(128,156), X(133,161), X(134,162), X(135,163), X(136,164), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(157,161), X(158,162), X(159,163), X(160,164), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(161,163), X(162,164), X(165,167), X(166,168), X(3,129), X(4,130),
  X(7,133), X(8,134), X(11,137), X(12,138), X(15,141), X(16,142), X(19,145),
  X(20,146), X(23,149), X(24,150), X(27,153), X(28,154), X(31,157), X(32,158),
  X(35,161), X(36,162), X(39,165), X(40,166), X(3,65), X(4,66), X(7,69), X(8,70),
  X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86),
  X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101),
  X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114),
  X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129),
  X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142),
  X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(95,157),
  X(96,158), X(99,161), X(100,162), X(103,165), X(104,166), X(3,33), X(4,34),
  X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50),
  X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66),
  X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82),
  X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(115,145), X(116,146), X(119,149), X(120,150),
  X(123,153), X(124,154), X(127,157), X(128,158), X(131,161), X(132,162),
  X(135,165), X(136,166), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26),
  X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42),
  X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58),
  X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74),
  X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90),
  X(79,93), X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105),
  X(92,106), X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(139,153), X(140,154),
  X(143,157), X(144,158), X(147,161), X(148,162), X(151,165), X(152,166), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(127,133), X(128,134), X(131,137), X(132,138),
  X(135,141), X(136,142), X(139,145), X(140,146), X(143,149), X(144,150),
  X(147,153), X(148,154), X(151,157), X(152,158), X(155,161), X(156,162),
  X(159,165), X(160,166), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13), X(12,14),
  X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29), X(28,30),
  X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45), X(44,46),
  X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61), X(60,62),
  X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77), X(76,78),
  X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93), X(92,94),
  X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106), X(107,109),
  X(108,110), X(111,113), X(112,114), X(115,117), X(116,118), X(119,121),
  X(120,122), X(123,125), X(124,126), X(127,129), X(128,130), X(131,133),
  X(132,134), X(135,137), X(136,138), X(139,141), X(140,142), X(143,145),
  X(144,146), X(147,149), X(148,150), X(151,153), X(152,154), X(155,157),
  X(156,158), X(159,161), X(160,162), X(163,165), X(164,166), X(1,2), X(3,4),
  X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20),
  X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36),
  X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52),
  X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68),
  X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84),
  X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(2,129), X(4,131),
  X(6,133), X(8,135), X(10,137), X(12,139), X(14,141), X(16,143), X(18,145),
  X(20,147), X(22,149), X(24,151), X(26,153), X(28,155), X(30,157), X(32,159),
  X(34,161), X(36,163), X(38,165), X(40,167), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87),
  X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101),
  X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115),
  X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129),
  X(68,131), X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143),
  X(82,145), X(84,147), X(86,149), X(88,151), X(90,153), X(92,155), X(94,157),
  X(96,159), X(98,161), X(100,163), X(102,165), X(104,167), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99),
  X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113),
  X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127),
  X(98,129), X(100,131), X(102,133), X(104,135), X(106,137), X(108,139),
  X(110,141), X(112,143), X(114,145), X(116,147), X(118,149), X(120,151),
  X(122,153), X(124,155), X(126,157), X(128,159), X(130,161), X(132,163),
  X(134,165), X(136,167), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59),
  X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75),
  X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91),
  X(78,93), X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105),
  X(92,107), X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(148,163), X(150,165), X(152,167), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(114,121), X(116,123), X(118,125), X(120,127),
  X(122,129), X(124,131), X(126,133), X(128,135), X(130,137), X(132,139),
  X(134,141), X(136,143), X(138,145), X(140,147), X(142,149), X(144,151),
  X(146,153), X(148,155), X(150,157), X(152,159), X(154,161), X(156,163),
  X(158,165), X(160,167), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(138,141), X(140,143), X(142,145),
  X(144,147), X(146,149), X(148,151), X(150,153), X(152,155), X(154,157),
  X(156,159), X(158,161), X(160,163), X(162,165), X(164,167), X(2,3), X(4,5),
  X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19), X(20,21),
  X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35), X(36,37),
  X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51), X(52,53),
  X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67), X(68,69),
  X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83), X(84,85),
  X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167)
};
S(170) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72),
  X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80),
  X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88),
  X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96),
  X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103),
  X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110),
  X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117),
  X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124),
  X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131),
  X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138),
  X(75,139), X(76,140), X(77,141), X(78,142), X(79,143), X(80,144), X(81,145),
  X(82,146), X(83,147), X(84,148), X(85,149), X(86,150), X(87,151), X(88,152),
  X(89,153), X(90,154), X(91,155), X(92,156), X(93,157), X(94,158), X(95,159),
  X(96,160), X(97,161), X(98,162), X(99,163), X(100,164), X(101,165), X(102,166),
  X(103,167), X(104,168), X(105,169), X(106,170), X(1,33), X(2,34), X(3,35),
  X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43),
  X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51),
  X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59),
  X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(129,161), X(130,162), X(131,163), X(132,164), X(133,165),
  X(134,166), X(135,167), X(136,168), X(137,169), X(138,170), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150),
  X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157),
  X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(121,153), X(122,154), X(123,155),
  X(124,156), X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(141,157), X(142,158), X(143,159),
  X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163), X(52,164),
  X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111),
  X(64,112), X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134),
  X(87,135), X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141),
  X(94,142), X(95,143), X(96,144), X(113,161), X(114,162), X(115,163),
  X(116,164), X(117,165), X(118,166), X(119,167), X(120,168), X(121,169),
  X(122,170), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100), X(85,101),
  X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107), X(92,108),
  X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130), X(115,131),
  X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(121,137),
  X(122,138), X(123,139), X(124,140), X(125,141), X(126,142), X(127,143),
  X(128,144), X(145,161), X(146,162), X(147,163), X(148,164), X(149,165),
  X(150,166), X(151,167), X(152,168), X(153,169), X(154,170), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(133,141), X(134,142), X(135,143), X(136,144), X(145,153),
  X(146,154), X(147,155), X(148,156), X(149,157), X(150,158), X(151,159),
  X(152,160), X(161,169), X(162,170), X(9,129), X(10,130), X(11,131), X(12,132),
  X(13,133), X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147),
  X(28,148), X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162),
  X(43,163), X(44,164), X(45,165), X(46,166), X(47,167), X(48,168), X(9,65),
  X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81),
  X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97),
  X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104),
  X(57,113), X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119),
  X(64,120), X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134),
  X(79,135), X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(93,149),
  X(94,150), X(95,151), X(96,152), X(105,161), X(106,162), X(107,163),
  X(108,164), X(109,165), X(110,166), X(111,167), X(112,168), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(109,133), X(110,134),
  X(111,135), X(112,136), X(121,145), X(122,146), X(123,147), X(124,148),
  X(125,149), X(126,150), X(127,151), X(128,152), X(137,161), X(138,162),
  X(139,163), X(140,164), X(141,165), X(142,166), X(143,167), X(144,168),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(153,161), X(154,162), X(155,163), X(156,164), X(157,165),
  X(158,166), X(159,167), X(160,168), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(161,165), X(162,166),
  X(163,167), X(164,168), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148),
  X(29,153), X(30,154), X(31,155), X(32,156), X(37,161), X(38,162), X(39,163),
  X(40,164), X(45,169), X(46,170), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73),
  X(14,74), X(15,75), X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89),
  X(30,90), X(31,91), X(32,92), X(37,97), X(38,98), X(39,99), X(40,100),
  X(45,105), X(46,106), X(47,107), X(48,108), X(53,113), X(54,114), X(55,115),
  X(56,116), X(61,121), X(62,122), X(63,123), X(64,124), X(69,129), X(70,130),
  X(71,131), X(72,132), X(77,137), X(78,138), X(79,139), X(80,140), X(85,145),
  X(86,146), X(87,147), X(88,148), X(93,153), X(94,154), X(95,155), X(96,156),
  X(101,161), X(102,162), X(103,163), X(104,164), X(109,169), X(110,170),
  X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44),
  X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60),
  X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76),
  X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92),
  X(69,97), X(70,98), X(71,99), X(72,100), X(77,105), X(78,106), X(79,107),
  X(80,108), X(85,113), X(86,114), X(87,115), X(88,116), X(93,121), X(94,122),
  X(95,123), X(96,124), X(101,129), X(102,130), X(103,131), X(104,132),
  X(109,137), X(110,138), X(111,139), X(112,140), X(117,145), X(118,146),
  X(119,147), X(120,148), X(125,153), X(126,154), X(127,155), X(128,156),
  X(133,161), X(134,162), X(135,163), X(136,164), X(141,169), X(142,170),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107),
  X(96,108), X(101,113), X(102,114), X(103,115), X(104,116), X(109,121),
  X(110,122), X(111,123), X(112,124), X(117,129), X(118,130), X(119,131),
  X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(133,145),
  X(134,146), X(135,147), X(136,148), X(141,153), X(142,154), X(143,155),
  X(144,156), X(149,161), X(150,162), X(151,163), X(152,164), X(157,169),
  X(158,170), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(103,107), X(104,108), X(109,113),
  X(110,114), X(111,115), X(112,116), X(117,121), X(118,122), X(119,123),
  X(120,124), X(125,129), X(126,130), X(127,131), X(128,132), X(133,137),
  X(134,138), X(135,139), X(136,140), X(141,145), X(142,146), X(143,147),
  X(144,148), X(149,153), X(150,154), X(151,155), X(152,156), X(157,161),
  X(158,162), X(159,163), X(160,164), X(165,169), X(166,170), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(161,163), X(162,164), X(165,167), X(166,168), X(3,129), X(4,130),
  X(7,133), X(8,134), X(11,137), X(12,138), X(15,141), X(16,142), X(19,145),
  X(20,146), X(23,149), X(24,150), X(27,153), X(28,154), X(31,157), X(32,158),
  X(35,161), X(36,162), X(39,165), X(40,166), X(43,169), X(44,170), X(3,65),
  X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81),
  X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97),
  X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110),
  X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125),
  X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138),
  X(79,141), X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(91,153),
  X(92,154), X(95,157), X(96,158), X(99,161), X(100,162), X(103,165), X(104,166),
  X(107,169), X(108,170), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105),
  X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118),
  X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133),
  X(104,134), X(107,137), X(108,138), X(111,141), X(112,142), X(115,145),
  X(116,146), X(119,149), X(120,150), X(123,153), X(124,154), X(127,157),
  X(128,158), X(131,161), X(132,162), X(135,165), X(136,166), X(139,169),
  X(140,170), X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29),
  X(16,30), X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45),
  X(32,46), X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61),
  X(48,62), X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77),
  X(64,78), X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93),
  X(80,94), X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106),
  X(95,109), X(96,110), X(99,113), X(100,114), X(103,117), X(104,118),
  X(107,121), X(108,122), X(111,125), X(112,126), X(115,129), X(116,130),
  X(119,133), X(120,134), X(123,137), X(124,138), X(127,141), X(128,142),
  X(131,145), X(132,146), X(135,149), X(136,150), X(139,153), X(140,154),
  X(143,157), X(144,158), X(147,161), X(148,162), X(151,165), X(152,166),
  X(155,169), X(156,170), X(3,9), X(4,10), X(7,13), X(8,14), X(11,17), X(12,18),
  X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30), X(27,33), X(28,34),
  X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46), X(43,49), X(44,50),
  X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62), X(59,65), X(60,66),
  X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78), X(75,81), X(76,82),
  X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94), X(91,97), X(92,98),
  X(95,101), X(96,102), X(99,105), X(100,106), X(103,109), X(104,110),
  X(107,113), X(108,114), X(111,117), X(112,118), X(115,121), X(116,122),
  X(119,125), X(120,126), X(123,129), X(124,130), X(127,133), X(128,134),
  X(131,137), X(132,138), X(135,141), X(136,142), X(139,145), X(140,146),
  X(143,149), X(144,150), X(147,153), X(148,154), X(151,157), X(152,158),
  X(155,161), X(156,162), X(159,165), X(160,166), X(163,169), X(164,170), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146),
  X(147,149), X(148,150), X(151,153), X(152,154), X(155,157), X(156,158),
  X(159,161), X(160,162), X(163,165), X(164,166), X(167,169), X(168,170), X(1,2),
  X(3,4), X(5,6), X(7,8), X(9,10), X(11,12), X(13,14), X(15,16), X(17,18),
  X(19,20), X(21,22), X(23,24), X(25,26), X(27,28), X(29,30), X(31,32), X(33,34),
  X(35,36), X(37,38), X(39,40), X(41,42), X(43,44), X(45,46), X(47,48), X(49,50),
  X(51,52), X(53,54), X(55,56), X(57,58), X(59,60), X(61,62), X(63,64), X(65,66),
  X(67,68), X(69,70), X(71,72), X(73,74), X(75,76), X(77,78), X(79,80), X(81,82),
  X(83,84), X(85,86), X(87,88), X(89,90), X(91,92), X(93,94), X(95,96), X(97,98),
  X(99,100), X(101,102), X(103,104), X(105,106), X(107,108), X(109,110),
  X(111,112), X(113,114), X(115,116), X(117,118), X(119,120), X(121,122),
  X(123,124), X(125,126), X(127,128), X(129,130), X(131,132), X(133,134),
  X(135,136), X(137,138), X(139,140), X(141,142), X(143,144), X(145,146),
  X(147,148), X(149,150), X(151,152), X(153,154), X(155,156), X(157,158),
  X(159,160), X(161,162), X(163,164), X(165,166), X(167,168), X(169,170),
  X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139), X(14,141),
  X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153), X(28,155),
  X(30,157), X(32,159), X(34,161), X(36,163), X(38,165), X(40,167), X(42,169),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123),
  X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137),
  X(76,139), X(78,141), X(80,143), X(82,145), X(84,147), X(86,149), X(88,151),
  X(90,153), X(92,155), X(94,157), X(96,159), X(98,161), X(100,163), X(102,165),
  X(104,167), X(106,169), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43),
  X(14,45), X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59),
  X(30,61), X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75),
  X(46,77), X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91),
  X(62,93), X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105),
  X(76,107), X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119),
  X(90,121), X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133),
  X(104,135), X(106,137), X(108,139), X(110,141), X(112,143), X(114,145),
  X(116,147), X(118,149), X(120,151), X(122,153), X(124,155), X(126,157),
  X(128,159), X(130,161), X(132,163), X(134,165), X(136,167), X(138,169),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95),
  X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109),
  X(96,111), X(98,113), X(100,115), X(102,117), X(104,119), X(106,121),
  X(108,123), X(110,125), X(112,127), X(114,129), X(116,131), X(118,133),
  X(120,135), X(122,137), X(124,139), X(126,141), X(128,143), X(130,145),
  X(132,147), X(134,149), X(136,151), X(138,153), X(140,155), X(142,157),
  X(144,159), X(146,161), X(148,163), X(150,165), X(152,167), X(154,169), X(2,9),
  X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25),
  X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41),
  X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57),
  X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73),
  X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89),
  X(84,91), X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103),
  X(98,105), X(100,107), X(102,109), X(104,111), X(106,113), X(108,115),
  X(110,117), X(112,119), X(114,121), X(116,123), X(118,125), X(120,127),
  X(122,129), X(124,131), X(126,133), X(128,135), X(130,137), X(132,139),
  X(134,141), X(136,143), X(138,145), X(140,147), X(142,149), X(144,151),
  X(146,153), X(148,155), X(150,157), X(152,159), X(154,161), X(156,163),
  X(158,165), X(160,167), X(162,169), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13),
  X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29),
  X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45),
  X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61),
  X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77),
  X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93),
  X(92,95), X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107),
  X(106,109), X(108,111), X(110,113), X(112,115), X(114,117), X(116,119),
  X(118,121), X(120,123), X(122,125), X(124,127), X(126,129), X(128,131),
  X(130,133), X(132,135), X(134,137), X(136,139), X(138,141), X(140,143),
  X(142,145), X(144,147), X(146,149), X(148,151), X(150,153), X(152,155),
  X(154,157), X(156,159), X(158,161), X(160,163), X(162,165), X(164,167),
  X(166,169), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15),
  X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31),
  X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47),
  X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63),
  X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79),
  X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95),
  X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107), X(108,109),
  X(110,111), X(112,113), X(114,115), X(116,117), X(118,119), X(120,121),
  X(122,123), X(124,125), X(126,127), X(128,129), X(130,131), X(132,133),
  X(134,135), X(136,137), X(138,139), X(140,141), X(142,143), X(144,145),
  X(146,147), X(148,149), X(150,151), X(152,153), X(154,155), X(156,157),
  X(158,159), X(160,161), X(162,163), X(164,165), X(166,167), X(168,169)
};
S(172) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70),
  X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78),
  X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86),
  X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94),
  X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101),
  X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108),
  X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115),
  X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122),
  X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129),
  X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136),
  X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143),
  X(80,144), X(81,145), X(82,146), X(83,147), X(84,148), X(85,149), X(86,150),
  X(87,151), X(88,152), X(89,153), X(90,154), X(91,155), X(92,156), X(93,157),
  X(94,158), X(95,159), X(96,160), X(97,161), X(98,162), X(99,163), X(100,164),
  X(101,165), X(102,166), X(103,167), X(104,168), X(105,169), X(106,170),
  X(107,171), X(108,172), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38),
  X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46),
  X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54),
  X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62),
  X(31,63), X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101),
  X(70,102), X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108),
  X(77,109), X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115),
  X(84,116), X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122),
  X(91,123), X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(129,161),
  X(130,162), X(131,163), X(132,164), X(133,165), X(134,166), X(135,167),
  X(136,168), X(137,169), X(138,170), X(139,171), X(140,172), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150),
  X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157),
  X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(121,153), X(122,154), X(123,155),
  X(124,156), X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(141,157), X(142,158), X(143,159),
  X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163), X(52,164),
  X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170), X(59,171),
  X(60,172), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69), X(22,70),
  X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77), X(30,78),
  X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100), X(53,101),
  X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107), X(60,108),
  X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130), X(83,131),
  X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137), X(90,138),
  X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144), X(113,161),
  X(114,162), X(115,163), X(116,164), X(117,165), X(118,166), X(119,167),
  X(120,168), X(121,169), X(122,170), X(123,171), X(124,172), X(17,33), X(18,34),
  X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42),
  X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66),
  X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74),
  X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98),
  X(83,99), X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105),
  X(90,106), X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112),
  X(113,129), X(114,130), X(115,131), X(116,132), X(117,133), X(118,134),
  X(119,135), X(120,136), X(121,137), X(122,138), X(123,139), X(124,140),
  X(125,141), X(126,142), X(127,143), X(128,144), X(145,161), X(146,162),
  X(147,163), X(148,164), X(149,165), X(150,166), X(151,167), X(152,168),
  X(153,169), X(154,170), X(155,171), X(156,172), X(1,9), X(2,10), X(3,11),
  X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27),
  X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43),
  X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59),
  X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75),
  X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91),
  X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105), X(98,106),
  X(99,107), X(100,108), X(101,109), X(102,110), X(103,111), X(104,112),
  X(113,121), X(114,122), X(115,123), X(116,124), X(117,125), X(118,126),
  X(119,127), X(120,128), X(129,137), X(130,138), X(131,139), X(132,140),
  X(133,141), X(134,142), X(135,143), X(136,144), X(145,153), X(146,154),
  X(147,155), X(148,156), X(149,157), X(150,158), X(151,159), X(152,160),
  X(161,169), X(162,170), X(163,171), X(164,172), X(9,129), X(10,130), X(11,131),
  X(12,132), X(13,133), X(14,134), X(15,135), X(16,136), X(25,145), X(26,146),
  X(27,147), X(28,148), X(29,149), X(30,150), X(31,151), X(32,152), X(41,161),
  X(42,162), X(43,163), X(44,164), X(45,165), X(46,166), X(47,167), X(48,168),
  X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72),
  X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88),
  X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102), X(47,103),
  X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117), X(62,118),
  X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132), X(77,133),
  X(78,134), X(79,135), X(80,136), X(89,145), X(90,146), X(91,147), X(92,148),
  X(93,149), X(94,150), X(95,151), X(96,152), X(105,161), X(106,162), X(107,163),
  X(108,164), X(109,165), X(110,166), X(111,167), X(112,168), X(9,33), X(10,34),
  X(11,35), X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50),
  X(27,51), X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66),
  X(43,67), X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82),
  X(59,83), X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98),
  X(75,99), X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113),
  X(90,114), X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120),
  X(105,129), X(106,130), X(107,131), X(108,132), X(109,133), X(110,134),
  X(111,135), X(112,136), X(121,145), X(122,146), X(123,147), X(124,148),
  X(125,149), X(126,150), X(127,151), X(128,152), X(137,161), X(138,162),
  X(139,163), X(140,164), X(141,165), X(142,166), X(143,167), X(144,168),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(153,161), X(154,162), X(155,163), X(156,164), X(157,165),
  X(158,166), X(159,167), X(160,168), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(161,165), X(162,166),
  X(163,167), X(164,168), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148),
  X(29,153), X(30,154), X(31,155), X(32,156), X(37,161), X(38,162), X(39,163),
  X(40,164), X(45,169), X(46,170), X(47,171), X(48,172), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124),
  X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138), X(79,139),
  X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(93,153), X(94,154),
  X(95,155), X(96,156), X(101,161), X(102,162), X(103,163), X(104,164),
  X(109,169), X(110,170), X(111,171), X(112,172), X(5,33), X(6,34), X(7,35),
  X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51),
  X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67),
  X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83),
  X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(117,145), X(118,146), X(119,147), X(120,148), X(125,153),
  X(126,154), X(127,155), X(128,156), X(133,161), X(134,162), X(135,163),
  X(136,164), X(141,169), X(142,170), X(143,171), X(144,172), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(157,169), X(158,170), X(159,171),
  X(160,172), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(103,107), X(104,108), X(109,113),
  X(110,114), X(111,115), X(112,116), X(117,121), X(118,122), X(119,123),
  X(120,124), X(125,129), X(126,130), X(127,131), X(128,132), X(133,137),
  X(134,138), X(135,139), X(136,140), X(141,145), X(142,146), X(143,147),
  X(144,148), X(149,153), X(150,154), X(151,155), X(152,156), X(157,161),
  X(158,162), X(159,163), X(160,164), X(165,169), X(166,170), X(167,171),
  X(168,172), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(133,135), X(134,136), X(137,139), X(138,140), X(141,143), X(142,144),
  X(145,147), X(146,148), X(149,151), X(150,152), X(153,155), X(154,156),
  X(157,159), X(158,160), X(161,163), X(162,164), X(165,167), X(166,168),
  X(169,171), X(170,172), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137),
  X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150),
  X(27,153), X(28,154), X(31,157), X(32,158), X(35,161), X(36,162), X(39,165),
  X(40,166), X(43,169), X(44,170), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73),
  X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89),
  X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102),
  X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117),
  X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130),
  X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(83,145),
  X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(95,157), X(96,158),
  X(99,161), X(100,162), X(103,165), X(104,166), X(107,169), X(108,170), X(3,33),
  X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49),
  X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65),
  X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81),
  X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97),
  X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110),
  X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125),
  X(96,126), X(99,129), X(100,130), X(103,133), X(104,134), X(107,137),
  X(108,138), X(111,141), X(112,142), X(115,145), X(116,146), X(119,149),
  X(120,150), X(123,153), X(124,154), X(127,157), X(128,158), X(131,161),
  X(132,162), X(135,165), X(136,166), X(139,169), X(140,170), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(115,129), X(116,130), X(119,133), X(120,134), X(123,137),
  X(124,138), X(127,141), X(128,142), X(131,145), X(132,146), X(135,149),
  X(136,150), X(139,153), X(140,154), X(143,157), X(144,158), X(147,161),
  X(148,162), X(151,165), X(152,166), X(155,169), X(156,170), X(3,9), X(4,10),
  X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26),
  X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42),
  X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58),
  X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74),
  X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90),
  X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102), X(99,105),
  X(100,106), X(103,109), X(104,110), X(107,113), X(108,114), X(111,117),
  X(112,118), X(115,121), X(116,122), X(119,125), X(120,126), X(123,129),
  X(124,130), X(127,133), X(128,134), X(131,137), X(132,138), X(135,141),
  X(136,142), X(139,145), X(140,146), X(143,149), X(144,150), X(147,153),
  X(148,154), X(151,157), X(152,158), X(155,161), X(156,162), X(159,165),
  X(160,166), X(163,169), X(164,170), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13),
  X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29),
  X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45),
  X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61),
  X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77),
  X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93),
  X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106),
  X(107,109), X(108,110), X(111,113), X(112,114), X(115,117), X(116,118),
  X(119,121), X(120,122), X(123,125), X(124,126), X(127,129), X(128,130),
  X(131,133), X(132,134), X(135,137), X(136,138), X(139,141), X(140,142),
  X(143,145), X(144,146), X(147,149), X(148,150), X(151,153), X(152,154),
  X(155,157), X(156,158), X(159,161), X(160,162), X(163,165), X(164,166),
  X(167,169), X(168,170), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(2,129), X(4,131), X(6,133), X(8,135),
  X(10,137), X(12,139), X(14,141), X(16,143), X(18,145), X(20,147), X(22,149),
  X(24,151), X(26,153), X(28,155), X(30,157), X(32,159), X(34,161), X(36,163),
  X(38,165), X(40,167), X(42,169), X(44,171), X(2,65), X(4,67), X(6,69), X(8,71),
  X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87),
  X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99), X(38,101),
  X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113), X(52,115),
  X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127), X(66,129),
  X(68,131), X(70,133), X(72,135), X(74,137), X(76,139), X(78,141), X(80,143),
  X(82,145), X(84,147), X(86,149), X(88,151), X(90,153), X(92,155), X(94,157),
  X(96,159), X(98,161), X(100,163), X(102,165), X(104,167), X(106,169),
  X(108,171), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(130,161), X(132,163), X(134,165), X(136,167), X(138,169), X(140,171),
  X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29), X(16,31),
  X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45), X(32,47),
  X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61), X(48,63),
  X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77), X(64,79),
  X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93), X(80,95),
  X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107), X(94,109),
  X(96,111), X(98,113), X(100,115), X(102,117), X(104,119), X(106,121),
  X(108,123), X(110,125), X(112,127), X(114,129), X(116,131), X(118,133),
  X(120,135), X(122,137), X(124,139), X(126,141), X(128,143), X(130,145),
  X(132,147), X(134,149), X(136,151), X(138,153), X(140,155), X(142,157),
  X(144,159), X(146,161), X(148,163), X(150,165), X(152,167), X(154,169),
  X(156,171), X(2,9), X(4,11), X(6,13), X(8,15), X(10,17), X(12,19), X(14,21),
  X(16,23), X(18,25), X(20,27), X(22,29), X(24,31), X(26,33), X(28,35), X(30,37),
  X(32,39), X(34,41), X(36,43), X(38,45), X(40,47), X(42,49), X(44,51), X(46,53),
  X(48,55), X(50,57), X(52,59), X(54,61), X(56,63), X(58,65), X(60,67), X(62,69),
  X(64,71), X(66,73), X(68,75), X(70,77), X(72,79), X(74,81), X(76,83), X(78,85),
  X(80,87), X(82,89), X(84,91), X(86,93), X(88,95), X(90,97), X(92,99),
  X(94,101), X(96,103), X(98,105), X(100,107), X(102,109), X(104,111),
  X(106,113), X(108,115), X(110,117), X(112,119), X(114,121), X(116,123),
  X(118,125), X(120,127), X(122,129), X(124,131), X(126,133), X(128,135),
  X(130,137), X(132,139), X(134,141), X(136,143), X(138,145), X(140,147),
  X(142,149), X(144,151), X(146,153), X(148,155), X(150,157), X(152,159),
  X(154,161), X(156,163), X(158,165), X(160,167), X(162,169), X(164,171), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123),
  X(122,125), X(124,127), X(126,129), X(128,131), X(130,133), X(132,135),
  X(134,137), X(136,139), X(138,141), X(140,143), X(142,145), X(144,147),
  X(146,149), X(148,151), X(150,153), X(152,155), X(154,157), X(156,159),
  X(158,161), X(160,163), X(162,165), X(164,167), X(166,169), X(168,171), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171)
};
S(174) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(45,173), X(46,174), X(1,65), X(2,66), X(3,67), X(4,68),
  X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76),
  X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84),
  X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92),
  X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99),
  X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106),
  X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113),
  X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120),
  X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127),
  X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134),
  X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141),
  X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(83,147), X(84,148),
  X(85,149), X(86,150), X(87,151), X(88,152), X(89,153), X(90,154), X(91,155),
  X(92,156), X(93,157), X(94,158), X(95,159), X(96,160), X(97,161), X(98,162),
  X(99,163), X(100,164), X(101,165), X(102,166), X(103,167), X(104,168),
  X(105,169), X(106,170), X(107,171), X(108,172), X(109,173), X(110,174),
  X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40),
  X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48),
  X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56),
  X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64),
  X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102), X(71,103),
  X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109), X(78,110),
  X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116), X(85,117),
  X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123), X(92,124),
  X(93,125), X(94,126), X(95,127), X(96,128), X(129,161), X(130,162), X(131,163),
  X(132,164), X(133,165), X(134,166), X(135,167), X(136,168), X(137,169),
  X(138,170), X(139,171), X(140,172), X(141,173), X(142,174), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150),
  X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157),
  X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(121,153), X(122,154), X(123,155),
  X(124,156), X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(141,157), X(142,158), X(143,159),
  X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163), X(52,164),
  X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170), X(59,171),
  X(60,172), X(61,173), X(62,174), X(17,65), X(18,66), X(19,67), X(20,68),
  X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76),
  X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99),
  X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106),
  X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129),
  X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136),
  X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143),
  X(96,144), X(113,161), X(114,162), X(115,163), X(116,164), X(117,165),
  X(118,166), X(119,167), X(120,168), X(121,169), X(122,170), X(123,171),
  X(124,172), X(125,173), X(126,174), X(17,33), X(18,34), X(19,35), X(20,36),
  X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44),
  X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68),
  X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76),
  X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(125,141),
  X(126,142), X(127,143), X(128,144), X(145,161), X(146,162), X(147,163),
  X(148,164), X(149,165), X(150,166), X(151,167), X(152,168), X(153,169),
  X(154,170), X(155,171), X(156,172), X(157,173), X(158,174), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(133,141), X(134,142), X(135,143), X(136,144), X(145,153),
  X(146,154), X(147,155), X(148,156), X(149,157), X(150,158), X(151,159),
  X(152,160), X(161,169), X(162,170), X(163,171), X(164,172), X(165,173),
  X(166,174), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133), X(14,134),
  X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148), X(29,149),
  X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163), X(44,164),
  X(45,165), X(46,166), X(47,167), X(48,168), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(105,161), X(106,162), X(107,163), X(108,164), X(109,165),
  X(110,166), X(111,167), X(112,168), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84),
  X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(121,145), X(122,146), X(123,147), X(124,148), X(125,149),
  X(126,150), X(127,151), X(128,152), X(137,161), X(138,162), X(139,163),
  X(140,164), X(141,165), X(142,166), X(143,167), X(144,168), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(137,145), X(138,146), X(139,147),
  X(140,148), X(141,149), X(142,150), X(143,151), X(144,152), X(153,161),
  X(154,162), X(155,163), X(156,164), X(157,165), X(158,166), X(159,167),
  X(160,168), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(145,149), X(146,150), X(147,151), X(148,152), X(153,157), X(154,158),
  X(155,159), X(156,160), X(161,165), X(162,166), X(163,167), X(164,168),
  X(169,173), X(170,174), X(5,129), X(6,130), X(7,131), X(8,132), X(13,137),
  X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(23,147), X(24,148),
  X(29,153), X(30,154), X(31,155), X(32,156), X(37,161), X(38,162), X(39,163),
  X(40,164), X(45,169), X(46,170), X(47,171), X(48,172), X(5,65), X(6,66),
  X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76), X(21,81), X(22,82),
  X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92), X(37,97), X(38,98),
  X(39,99), X(40,100), X(45,105), X(46,106), X(47,107), X(48,108), X(53,113),
  X(54,114), X(55,115), X(56,116), X(61,121), X(62,122), X(63,123), X(64,124),
  X(69,129), X(70,130), X(71,131), X(72,132), X(77,137), X(78,138), X(79,139),
  X(80,140), X(85,145), X(86,146), X(87,147), X(88,148), X(93,153), X(94,154),
  X(95,155), X(96,156), X(101,161), X(102,162), X(103,163), X(104,164),
  X(109,169), X(110,170), X(111,171), X(112,172), X(5,33), X(6,34), X(7,35),
  X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51),
  X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67),
  X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83),
  X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(117,145), X(118,146), X(119,147), X(120,148), X(125,153),
  X(126,154), X(127,155), X(128,156), X(133,161), X(134,162), X(135,163),
  X(136,164), X(141,169), X(142,170), X(143,171), X(144,172), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(157,169), X(158,170), X(159,171),
  X(160,172), X(5,9), X(6,10), X(7,11), X(8,12), X(13,17), X(14,18), X(15,19),
  X(16,20), X(21,25), X(22,26), X(23,27), X(24,28), X(29,33), X(30,34), X(31,35),
  X(32,36), X(37,41), X(38,42), X(39,43), X(40,44), X(45,49), X(46,50), X(47,51),
  X(48,52), X(53,57), X(54,58), X(55,59), X(56,60), X(61,65), X(62,66), X(63,67),
  X(64,68), X(69,73), X(70,74), X(71,75), X(72,76), X(77,81), X(78,82), X(79,83),
  X(80,84), X(85,89), X(86,90), X(87,91), X(88,92), X(93,97), X(94,98), X(95,99),
  X(96,100), X(101,105), X(102,106), X(103,107), X(104,108), X(109,113),
  X(110,114), X(111,115), X(112,116), X(117,121), X(118,122), X(119,123),
  X(120,124), X(125,129), X(126,130), X(127,131), X(128,132), X(133,137),
  X(134,138), X(135,139), X(136,140), X(141,145), X(142,146), X(143,147),
  X(144,148), X(149,153), X(150,154), X(151,155), X(152,156), X(157,161),
  X(158,162), X(159,163), X(160,164), X(165,169), X(166,170), X(167,171),
  X(168,172), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12), X(13,15),
  X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28), X(29,31),
  X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44), X(45,47),
  X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60), X(61,63),
  X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76), X(77,79),
  X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92), X(93,95),
  X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107), X(106,108),
  X(109,111), X(110,112), X(113,115), X(114,116), X(117,119), X(118,120),
  X(121,123), X(122,124), X(125,127), X(126,128), X(129,131), X(130,132),
  X(133,135), X(134,136), X(137,139), X(138,140), X(141,143), X(142,144),
  X(145,147), X(146,148), X(149,151), X(150,152), X(153,155), X(154,156),
  X(157,159), X(158,160), X(161,163), X(162,164), X(165,167), X(166,168),
  X(169,171), X(170,172), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137),
  X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150),
  X(27,153), X(28,154), X(31,157), X(32,158), X(35,161), X(36,162), X(39,165),
  X(40,166), X(43,169), X(44,170), X(47,173), X(48,174), X(3,65), X(4,66),
  X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81), X(20,82),
  X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97), X(36,98),
  X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110), X(51,113),
  X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125), X(64,126),
  X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138), X(79,141),
  X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(91,153), X(92,154),
  X(95,157), X(96,158), X(99,161), X(100,162), X(103,165), X(104,166),
  X(107,169), X(108,170), X(111,173), X(112,174), X(3,33), X(4,34), X(7,37),
  X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53),
  X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69),
  X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85),
  X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X(71,101), X(72,102), X(75,105), X(76,106), X(79,109), X(80,110), X(83,113),
  X(84,114), X(87,117), X(88,118), X(91,121), X(92,122), X(95,125), X(96,126),
  X(99,129), X(100,130), X(103,133), X(104,134), X(107,137), X(108,138),
  X(111,141), X(112,142), X(115,145), X(116,146), X(119,149), X(120,150),
  X(123,153), X(124,154), X(127,157), X(128,158), X(131,161), X(132,162),
  X(135,165), X(136,166), X(139,169), X(140,170), X(143,173), X(144,174),
  X(3,17), X(4,18), X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30),
  X(19,33), X(20,34), X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46),
  X(35,49), X(36,50), X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62),
  X(51,65), X(52,66), X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78),
  X(67,81), X(68,82), X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94),
  X(83,97), X(84,98), X(87,101), X(88,102), X(91,105), X(92,106), X(95,109),
  X(96,110), X(99,113), X(100,114), X(103,117), X(104,118), X(107,121),
  X(108,122), X(111,125), X(112,126), X(115,129), X(116,130), X(119,133),
  X(120,134), X(123,137), X(124,138), X(127,141), X(128,142), X(131,145),
  X(132,146), X(135,149), X(136,150), X(139,153), X(140,154), X(143,157),
  X(144,158), X(147,161), X(148,162), X(151,165), X(152,166), X(155,169),
  X(156,170), X(159,173), X(160,174), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(147,153), X(148,154), X(151,157),
  X(152,158), X(155,161), X(156,162), X(159,165), X(160,166), X(163,169),
  X(164,170), X(167,173), X(168,174), X(3,5), X(4,6), X(7,9), X(8,10), X(11,13),
  X(12,14), X(15,17), X(16,18), X(19,21), X(20,22), X(23,25), X(24,26), X(27,29),
  X(28,30), X(31,33), X(32,34), X(35,37), X(36,38), X(39,41), X(40,42), X(43,45),
  X(44,46), X(47,49), X(48,50), X(51,53), X(52,54), X(55,57), X(56,58), X(59,61),
  X(60,62), X(63,65), X(64,66), X(67,69), X(68,70), X(71,73), X(72,74), X(75,77),
  X(76,78), X(79,81), X(80,82), X(83,85), X(84,86), X(87,89), X(88,90), X(91,93),
  X(92,94), X(95,97), X(96,98), X(99,101), X(100,102), X(103,105), X(104,106),
  X(107,109), X(108,110), X(111,113), X(112,114), X(115,117), X(116,118),
  X(119,121), X(120,122), X(123,125), X(124,126), X(127,129), X(128,130),
  X(131,133), X(132,134), X(135,137), X(136,138), X(139,141), X(140,142),
  X(143,145), X(144,146), X(147,149), X(148,150), X(151,153), X(152,154),
  X(155,157), X(156,158), X(159,161), X(160,162), X(163,165), X(164,166),
  X(167,169), X(168,170), X(171,173), X(172,174), X(1,2), X(3,4), X(5,6), X(7,8),
  X(9,10), X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24),
  X(25,26), X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40),
  X(41,42), X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56),
  X(57,58), X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72),
  X(73,74), X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88),
  X(89,90), X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102),
  X(103,104), X(105,106), X(107,108), X(109,110), X(111,112), X(113,114),
  X(115,116), X(117,118), X(119,120), X(121,122), X(123,124), X(125,126),
  X(127,128), X(129,130), X(131,132), X(133,134), X(135,136), X(137,138),
  X(139,140), X(141,142), X(143,144), X(145,146), X(147,148), X(149,150),
  X(151,152), X(153,154), X(155,156), X(157,158), X(159,160), X(161,162),
  X(163,164), X(165,166), X(167,168), X(169,170), X(171,172), X(173,174),
  X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139), X(14,141),
  X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153), X(28,155),
  X(30,157), X(32,159), X(34,161), X(36,163), X(38,165), X(40,167), X(42,169),
  X(44,171), X(46,173), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75),
  X(14,77), X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91),
  X(30,93), X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105),
  X(44,107), X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119),
  X(58,121), X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133),
  X(72,135), X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(84,147),
  X(86,149), X(88,151), X(90,153), X(92,155), X(94,157), X(96,159), X(98,161),
  X(100,163), X(102,165), X(104,167), X(106,169), X(108,171), X(110,173),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123),
  X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(130,161), X(132,163), X(134,165), X(136,167), X(138,169), X(140,171),
  X(142,173), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(148,163), X(150,165), X(152,167),
  X(154,169), X(156,171), X(158,173), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(126,133),
  X(128,135), X(130,137), X(132,139), X(134,141), X(136,143), X(138,145),
  X(140,147), X(142,149), X(144,151), X(146,153), X(148,155), X(150,157),
  X(152,159), X(154,161), X(156,163), X(158,165), X(160,167), X(162,169),
  X(164,171), X(166,173), X(2,5), X(4,7), X(6,9), X(8,11), X(10,13), X(12,15),
  X(14,17), X(16,19), X(18,21), X(20,23), X(22,25), X(24,27), X(26,29), X(28,31),
  X(30,33), X(32,35), X(34,37), X(36,39), X(38,41), X(40,43), X(42,45), X(44,47),
  X(46,49), X(48,51), X(50,53), X(52,55), X(54,57), X(56,59), X(58,61), X(60,63),
  X(62,65), X(64,67), X(66,69), X(68,71), X(70,73), X(72,75), X(74,77), X(76,79),
  X(78,81), X(80,83), X(82,85), X(84,87), X(86,89), X(88,91), X(90,93), X(92,95),
  X(94,97), X(96,99), X(98,101), X(100,103), X(102,105), X(104,107), X(106,109),
  X(108,111), X(110,113), X(112,115), X(114,117), X(116,119), X(118,121),
  X(120,123), X(122,125), X(124,127), X(126,129), X(128,131), X(130,133),
  X(132,135), X(134,137), X(136,139), X(138,141), X(140,143), X(142,145),
  X(144,147), X(146,149), X(148,151), X(150,153), X(152,155), X(154,157),
  X(156,159), X(158,161), X(160,163), X(162,165), X(164,167), X(166,169),
  X(168,171), X(170,173), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11), X(12,13),
  X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27), X(28,29),
  X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43), X(44,45),
  X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59), X(60,61),
  X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75), X(76,77),
  X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91), X(92,93),
  X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105), X(106,107),
  X(108,109), X(110,111), X(112,113), X(114,115), X(116,117), X(118,119),
  X(120,121), X(122,123), X(124,125), X(126,127), X(128,129), X(130,131),
  X(132,133), X(134,135), X(136,137), X(138,139), X(140,141), X(142,143),
  X(144,145), X(146,147), X(148,149), X(150,151), X(152,153), X(154,155),
  X(156,157), X(158,159), X(160,161), X(162,163), X(164,165), X(166,167),
  X(168,169), X(170,171), X(172,173)
};
S(176) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(45,173), X(46,174), X(47,175), X(48,176), X(1,65),
  X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73),
  X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81),
  X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89),
  X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97),
  X(34,98), X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104),
  X(41,105), X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111),
  X(48,112), X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118),
  X(55,119), X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125),
  X(62,126), X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132),
  X(69,133), X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139),
  X(76,140), X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146),
  X(83,147), X(84,148), X(85,149), X(86,150), X(87,151), X(88,152), X(89,153),
  X(90,154), X(91,155), X(92,156), X(93,157), X(94,158), X(95,159), X(96,160),
  X(97,161), X(98,162), X(99,163), X(100,164), X(101,165), X(102,166),
  X(103,167), X(104,168), X(105,169), X(106,170), X(107,171), X(108,172),
  X(109,173), X(110,174), X(111,175), X(112,176), X(1,33), X(2,34), X(3,35),
  X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43),
  X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51),
  X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59),
  X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(129,161), X(130,162), X(131,163), X(132,164), X(133,165),
  X(134,166), X(135,167), X(136,168), X(137,169), X(138,170), X(139,171),
  X(140,172), X(141,173), X(142,174), X(143,175), X(144,176), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150),
  X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157),
  X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(121,153), X(122,154), X(123,155),
  X(124,156), X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(141,157), X(142,158), X(143,159),
  X(144,160), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163), X(52,164),
  X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170), X(59,171),
  X(60,172), X(61,173), X(62,174), X(63,175), X(64,176), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(113,161), X(114,162), X(115,163), X(116,164),
  X(117,165), X(118,166), X(119,167), X(120,168), X(121,169), X(122,170),
  X(123,171), X(124,172), X(125,173), X(126,174), X(127,175), X(128,176),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138),
  X(123,139), X(124,140), X(125,141), X(126,142), X(127,143), X(128,144),
  X(145,161), X(146,162), X(147,163), X(148,164), X(149,165), X(150,166),
  X(151,167), X(152,168), X(153,169), X(154,170), X(155,171), X(156,172),
  X(157,173), X(158,174), X(159,175), X(160,176), X(1,9), X(2,10), X(3,11),
  X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27),
  X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43),
  X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59),
  X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75),
  X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91),
  X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105), X(98,106),
  X(99,107), X(100,108), X(101,109), X(102,110), X(103,111), X(104,112),
  X(113,121), X(114,122), X(115,123), X(116,124), X(117,125), X(118,126),
  X(119,127), X(120,128), X(129,137), X(130,138), X(131,139), X(132,140),
  X(133,141), X(134,142), X(135,143), X(136,144), X(145,153), X(146,154),
  X(147,155), X(148,156), X(149,157), X(150,158), X(151,159), X(152,160),
  X(161,169), X(162,170), X(163,171), X(164,172), X(165,173), X(166,174),
  X(167,175), X(168,176), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163),
  X(44,164), X(45,165), X(46,166), X(47,167), X(48,168), X(9,65), X(10,66),
  X(11,67), X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82),
  X(27,83), X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98),
  X(43,99), X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113),
  X(58,114), X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120),
  X(73,129), X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135),
  X(80,136), X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150),
  X(95,151), X(96,152), X(105,161), X(106,162), X(107,163), X(108,164),
  X(109,165), X(110,166), X(111,167), X(112,168), X(9,33), X(10,34), X(11,35),
  X(12,36), X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51),
  X(28,52), X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67),
  X(44,68), X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83),
  X(60,84), X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(121,145), X(122,146), X(123,147), X(124,148), X(125,149),
  X(126,150), X(127,151), X(128,152), X(137,161), X(138,162), X(139,163),
  X(140,164), X(141,165), X(142,166), X(143,167), X(144,168), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(137,145), X(138,146), X(139,147),
  X(140,148), X(141,149), X(142,150), X(143,151), X(144,152), X(153,161),
  X(154,162), X(155,163), X(156,164), X(157,165), X(158,166), X(159,167),
  X(160,168), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(145,149), X(146,150), X(147,151), X(148,152), X(153,157), X(154,158),
  X(155,159), X(156,160), X(161,165), X(162,166), X(163,167), X(164,168),
  X(169,173), X(170,174), X(171,175), X(172,176), X(5,129), X(6,130), X(7,131),
  X(8,132), X(13,137), X(14,138), X(15,139), X(16,140), X(21,145), X(22,146),
  X(23,147), X(24,148), X(29,153), X(30,154), X(31,155), X(32,156), X(37,161),
  X(38,162), X(39,163), X(40,164), X(45,169), X(46,170), X(47,171), X(48,172),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(109,169), X(110,170), X(111,171), X(112,172), X(5,33), X(6,34),
  X(7,35), X(8,36), X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50),
  X(23,51), X(24,52), X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66),
  X(39,67), X(40,68), X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82),
  X(55,83), X(56,84), X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98),
  X(71,99), X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113),
  X(86,114), X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124),
  X(101,129), X(102,130), X(103,131), X(104,132), X(109,137), X(110,138),
  X(111,139), X(112,140), X(117,145), X(118,146), X(119,147), X(120,148),
  X(125,153), X(126,154), X(127,155), X(128,156), X(133,161), X(134,162),
  X(135,163), X(136,164), X(141,169), X(142,170), X(143,171), X(144,172),
  X(5,17), X(6,18), X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28),
  X(21,33), X(22,34), X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44),
  X(37,49), X(38,50), X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60),
  X(53,65), X(54,66), X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76),
  X(69,81), X(70,82), X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92),
  X(85,97), X(86,98), X(87,99), X(88,100), X(93,105), X(94,106), X(95,107),
  X(96,108), X(101,113), X(102,114), X(103,115), X(104,116), X(109,121),
  X(110,122), X(111,123), X(112,124), X(117,129), X(118,130), X(119,131),
  X(120,132), X(125,137), X(126,138), X(127,139), X(128,140), X(133,145),
  X(134,146), X(135,147), X(136,148), X(141,153), X(142,154), X(143,155),
  X(144,156), X(149,161), X(150,162), X(151,163), X(152,164), X(157,169),
  X(158,170), X(159,171), X(160,172), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(157,161), X(158,162), X(159,163), X(160,164), X(165,169),
  X(166,170), X(167,171), X(168,172), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11),
  X(10,12), X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27),
  X(26,28), X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43),
  X(42,44), X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59),
  X(58,60), X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75),
  X(74,76), X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91),
  X(90,92), X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104),
  X(105,107), X(106,108), X(109,111), X(110,112), X(113,115), X(114,116),
  X(117,119), X(118,120), X(121,123), X(122,124), X(125,127), X(126,128),
  X(129,131), X(130,132), X(133,135), X(134,136), X(137,139), X(138,140),
  X(141,143), X(142,144), X(145,147), X(146,148), X(149,151), X(150,152),
  X(153,155), X(154,156), X(157,159), X(158,160), X(161,163), X(162,164),
  X(165,167), X(166,168), X(169,171), X(170,172), X(173,175), X(174,176),
  X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138), X(15,141),
  X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(27,153), X(28,154),
  X(31,157), X(32,158), X(35,161), X(36,162), X(39,165), X(40,166), X(43,169),
  X(44,170), X(47,173), X(48,174), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73),
  X(12,74), X(15,77), X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89),
  X(28,90), X(31,93), X(32,94), X(35,97), X(36,98), X(39,101), X(40,102),
  X(43,105), X(44,106), X(47,109), X(48,110), X(51,113), X(52,114), X(55,117),
  X(56,118), X(59,121), X(60,122), X(63,125), X(64,126), X(67,129), X(68,130),
  X(71,133), X(72,134), X(75,137), X(76,138), X(79,141), X(80,142), X(83,145),
  X(84,146), X(87,149), X(88,150), X(91,153), X(92,154), X(95,157), X(96,158),
  X(99,161), X(100,162), X(103,165), X(104,166), X(107,169), X(108,170),
  X(111,173), X(112,174), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105),
  X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118),
  X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133),
  X(104,134), X(107,137), X(108,138), X(111,141), X(112,142), X(115,145),
  X(116,146), X(119,149), X(120,150), X(123,153), X(124,154), X(127,157),
  X(128,158), X(131,161), X(132,162), X(135,165), X(136,166), X(139,169),
  X(140,170), X(143,173), X(144,174), X(3,17), X(4,18), X(7,21), X(8,22),
  X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37), X(24,38),
  X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53), X(40,54),
  X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69), X(56,70),
  X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85), X(72,86),
  X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98), X(87,101),
  X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113), X(100,114),
  X(103,117), X(104,118), X(107,121), X(108,122), X(111,125), X(112,126),
  X(115,129), X(116,130), X(119,133), X(120,134), X(123,137), X(124,138),
  X(127,141), X(128,142), X(131,145), X(132,146), X(135,149), X(136,150),
  X(139,153), X(140,154), X(143,157), X(144,158), X(147,161), X(148,162),
  X(151,165), X(152,166), X(155,169), X(156,170), X(159,173), X(160,174), X(3,9),
  X(4,10), X(7,13), X(8,14), X(11,17), X(12,18), X(15,21), X(16,22), X(19,25),
  X(20,26), X(23,29), X(24,30), X(27,33), X(28,34), X(31,37), X(32,38), X(35,41),
  X(36,42), X(39,45), X(40,46), X(43,49), X(44,50), X(47,53), X(48,54), X(51,57),
  X(52,58), X(55,61), X(56,62), X(59,65), X(60,66), X(63,69), X(64,70), X(67,73),
  X(68,74), X(71,77), X(72,78), X(75,81), X(76,82), X(79,85), X(80,86), X(83,89),
  X(84,90), X(87,93), X(88,94), X(91,97), X(92,98), X(95,101), X(96,102),
  X(99,105), X(100,106), X(103,109), X(104,110), X(107,113), X(108,114),
  X(111,117), X(112,118), X(115,121), X(116,122), X(119,125), X(120,126),
  X(123,129), X(124,130), X(127,133), X(128,134), X(131,137), X(132,138),
  X(135,141), X(136,142), X(139,145), X(140,146), X(143,149), X(144,150),
  X(147,153), X(148,154), X(151,157), X(152,158), X(155,161), X(156,162),
  X(159,165), X(160,166), X(163,169), X(164,170), X(167,173), X(168,174), X(3,5),
  X(4,6), X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21),
  X(20,22), X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37),
  X(36,38), X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53),
  X(52,54), X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69),
  X(68,70), X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85),
  X(84,86), X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98),
  X(99,101), X(100,102), X(103,105), X(104,106), X(107,109), X(108,110),
  X(111,113), X(112,114), X(115,117), X(116,118), X(119,121), X(120,122),
  X(123,125), X(124,126), X(127,129), X(128,130), X(131,133), X(132,134),
  X(135,137), X(136,138), X(139,141), X(140,142), X(143,145), X(144,146),
  X(147,149), X(148,150), X(151,153), X(152,154), X(155,157), X(156,158),
  X(159,161), X(160,162), X(163,165), X(164,166), X(167,169), X(168,170),
  X(171,173), X(172,174), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10), X(11,12),
  X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26), X(27,28),
  X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42), X(43,44),
  X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58), X(59,60),
  X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74), X(75,76),
  X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90), X(91,92),
  X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104), X(105,106),
  X(107,108), X(109,110), X(111,112), X(113,114), X(115,116), X(117,118),
  X(119,120), X(121,122), X(123,124), X(125,126), X(127,128), X(129,130),
  X(131,132), X(133,134), X(135,136), X(137,138), X(139,140), X(141,142),
  X(143,144), X(145,146), X(147,148), X(149,150), X(151,152), X(153,154),
  X(155,156), X(157,158), X(159,160), X(161,162), X(163,164), X(165,166),
  X(167,168), X(169,170), X(171,172), X(173,174), X(175,176), X(2,129), X(4,131),
  X(6,133), X(8,135), X(10,137), X(12,139), X(14,141), X(16,143), X(18,145),
  X(20,147), X(22,149), X(24,151), X(26,153), X(28,155), X(30,157), X(32,159),
  X(34,161), X(36,163), X(38,165), X(40,167), X(42,169), X(44,171), X(46,173),
  X(48,175), X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77),
  X(16,79), X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93),
  X(32,95), X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107),
  X(46,109), X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121),
  X(60,123), X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135),
  X(74,137), X(76,139), X(78,141), X(80,143), X(82,145), X(84,147), X(86,149),
  X(88,151), X(90,153), X(92,155), X(94,157), X(96,159), X(98,161), X(100,163),
  X(102,165), X(104,167), X(106,169), X(108,171), X(110,173), X(112,175),
  X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47),
  X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63),
  X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79),
  X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95),
  X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107), X(78,109),
  X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121), X(92,123),
  X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(130,161), X(132,163), X(134,165), X(136,167), X(138,169), X(140,171),
  X(142,173), X(144,175), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27),
  X(14,29), X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43),
  X(30,45), X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59),
  X(46,61), X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75),
  X(62,77), X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91),
  X(78,93), X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105),
  X(92,107), X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(148,163), X(150,165), X(152,167),
  X(154,169), X(156,171), X(158,173), X(160,175), X(2,9), X(4,11), X(6,13),
  X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29),
  X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45),
  X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61),
  X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77),
  X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93),
  X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107),
  X(102,109), X(104,111), X(106,113), X(108,115), X(110,117), X(112,119),
  X(114,121), X(116,123), X(118,125), X(120,127), X(122,129), X(124,131),
  X(126,133), X(128,135), X(130,137), X(132,139), X(134,141), X(136,143),
  X(138,145), X(140,147), X(142,149), X(144,151), X(146,153), X(148,155),
  X(150,157), X(152,159), X(154,161), X(156,163), X(158,165), X(160,167),
  X(162,169), X(164,171), X(166,173), X(168,175), X(2,5), X(4,7), X(6,9),
  X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23), X(22,25),
  X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39), X(38,41),
  X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55), X(54,57),
  X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71), X(70,73),
  X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87), X(86,89),
  X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101), X(100,103),
  X(102,105), X(104,107), X(106,109), X(108,111), X(110,113), X(112,115),
  X(114,117), X(116,119), X(118,121), X(120,123), X(122,125), X(124,127),
  X(126,129), X(128,131), X(130,133), X(132,135), X(134,137), X(136,139),
  X(138,141), X(140,143), X(142,145), X(144,147), X(146,149), X(148,151),
  X(150,153), X(152,155), X(154,157), X(156,159), X(158,161), X(160,163),
  X(162,165), X(164,167), X(166,169), X(168,171), X(170,173), X(172,175), X(2,3),
  X(4,5), X(6,7), X(8,9), X(10,11), X(12,13), X(14,15), X(16,17), X(18,19),
  X(20,21), X(22,23), X(24,25), X(26,27), X(28,29), X(30,31), X(32,33), X(34,35),
  X(36,37), X(38,39), X(40,41), X(42,43), X(44,45), X(46,47), X(48,49), X(50,51),
  X(52,53), X(54,55), X(56,57), X(58,59), X(60,61), X(62,63), X(64,65), X(66,67),
  X(68,69), X(70,71), X(72,73), X(74,75), X(76,77), X(78,79), X(80,81), X(82,83),
  X(84,85), X(86,87), X(88,89), X(90,91), X(92,93), X(94,95), X(96,97), X(98,99),
  X(100,101), X(102,103), X(104,105), X(106,107), X(108,109), X(110,111),
  X(112,113), X(114,115), X(116,117), X(118,119), X(120,121), X(122,123),
  X(124,125), X(126,127), X(128,129), X(130,131), X(132,133), X(134,135),
  X(136,137), X(138,139), X(140,141), X(142,143), X(144,145), X(146,147),
  X(148,149), X(150,151), X(152,153), X(154,155), X(156,157), X(158,159),
  X(160,161), X(162,163), X(164,165), X(166,167), X(168,169), X(170,171),
  X(172,173), X(174,175)
};
S(178) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(45,173), X(46,174), X(47,175), X(48,176), X(49,177),
  X(50,178), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69), X(6,70), X(7,71),
  X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77), X(14,78), X(15,79),
  X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85), X(22,86), X(23,87),
  X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93), X(30,94), X(31,95),
  X(32,96), X(33,97), X(34,98), X(35,99), X(36,100), X(37,101), X(38,102),
  X(39,103), X(40,104), X(41,105), X(42,106), X(43,107), X(44,108), X(45,109),
  X(46,110), X(47,111), X(48,112), X(49,113), X(50,114), X(51,115), X(52,116),
  X(53,117), X(54,118), X(55,119), X(56,120), X(57,121), X(58,122), X(59,123),
  X(60,124), X(61,125), X(62,126), X(63,127), X(64,128), X(65,129), X(66,130),
  X(67,131), X(68,132), X(69,133), X(70,134), X(71,135), X(72,136), X(73,137),
  X(74,138), X(75,139), X(76,140), X(77,141), X(78,142), X(79,143), X(80,144),
  X(81,145), X(82,146), X(83,147), X(84,148), X(85,149), X(86,150), X(87,151),
  X(88,152), X(89,153), X(90,154), X(91,155), X(92,156), X(93,157), X(94,158),
  X(95,159), X(96,160), X(97,161), X(98,162), X(99,163), X(100,164), X(101,165),
  X(102,166), X(103,167), X(104,168), X(105,169), X(106,170), X(107,171),
  X(108,172), X(109,173), X(110,174), X(111,175), X(112,176), X(113,177),
  X(114,178), X(1,33), X(2,34), X(3,35), X(4,36), X(5,37), X(6,38), X(7,39),
  X(8,40), X(9,41), X(10,42), X(11,43), X(12,44), X(13,45), X(14,46), X(15,47),
  X(16,48), X(17,49), X(18,50), X(19,51), X(20,52), X(21,53), X(22,54), X(23,55),
  X(24,56), X(25,57), X(26,58), X(27,59), X(28,60), X(29,61), X(30,62), X(31,63),
  X(32,64), X(65,97), X(66,98), X(67,99), X(68,100), X(69,101), X(70,102),
  X(71,103), X(72,104), X(73,105), X(74,106), X(75,107), X(76,108), X(77,109),
  X(78,110), X(79,111), X(80,112), X(81,113), X(82,114), X(83,115), X(84,116),
  X(85,117), X(86,118), X(87,119), X(88,120), X(89,121), X(90,122), X(91,123),
  X(92,124), X(93,125), X(94,126), X(95,127), X(96,128), X(129,161), X(130,162),
  X(131,163), X(132,164), X(133,165), X(134,166), X(135,167), X(136,168),
  X(137,169), X(138,170), X(139,171), X(140,172), X(141,173), X(142,174),
  X(143,175), X(144,176), X(145,177), X(146,178), X(33,129), X(34,130),
  X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136), X(41,137),
  X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143), X(48,144),
  X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150), X(55,151),
  X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157), X(62,158),
  X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69),
  X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77),
  X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85),
  X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93),
  X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132),
  X(101,133), X(102,134), X(103,135), X(104,136), X(105,137), X(106,138),
  X(107,139), X(108,140), X(109,141), X(110,142), X(111,143), X(112,144),
  X(113,145), X(114,146), X(115,147), X(116,148), X(117,149), X(118,150),
  X(119,151), X(120,152), X(121,153), X(122,154), X(123,155), X(124,156),
  X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(129,145), X(130,146), X(131,147), X(132,148),
  X(133,149), X(134,150), X(135,151), X(136,152), X(137,153), X(138,154),
  X(139,155), X(140,156), X(141,157), X(142,158), X(143,159), X(144,160),
  X(161,177), X(162,178), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133),
  X(22,134), X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140),
  X(29,141), X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163),
  X(52,164), X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170),
  X(59,171), X(60,172), X(61,173), X(62,174), X(63,175), X(64,176), X(17,65),
  X(18,66), X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73),
  X(26,74), X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97),
  X(50,98), X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104),
  X(57,105), X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111),
  X(64,112), X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134),
  X(87,135), X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141),
  X(94,142), X(95,143), X(96,144), X(113,161), X(114,162), X(115,163),
  X(116,164), X(117,165), X(118,166), X(119,167), X(120,168), X(121,169),
  X(122,170), X(123,171), X(124,172), X(125,173), X(126,174), X(127,175),
  X(128,176), X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38),
  X(23,39), X(24,40), X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46),
  X(31,47), X(32,48), X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70),
  X(55,71), X(56,72), X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78),
  X(63,79), X(64,80), X(81,97), X(82,98), X(83,99), X(84,100), X(85,101),
  X(86,102), X(87,103), X(88,104), X(89,105), X(90,106), X(91,107), X(92,108),
  X(93,109), X(94,110), X(95,111), X(96,112), X(113,129), X(114,130), X(115,131),
  X(116,132), X(117,133), X(118,134), X(119,135), X(120,136), X(121,137),
  X(122,138), X(123,139), X(124,140), X(125,141), X(126,142), X(127,143),
  X(128,144), X(145,161), X(146,162), X(147,163), X(148,164), X(149,165),
  X(150,166), X(151,167), X(152,168), X(153,169), X(154,170), X(155,171),
  X(156,172), X(157,173), X(158,174), X(159,175), X(160,176), X(1,9), X(2,10),
  X(3,11), X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26),
  X(19,27), X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42),
  X(35,43), X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58),
  X(51,59), X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74),
  X(67,75), X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90),
  X(83,91), X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105),
  X(98,106), X(99,107), X(100,108), X(101,109), X(102,110), X(103,111),
  X(104,112), X(113,121), X(114,122), X(115,123), X(116,124), X(117,125),
  X(118,126), X(119,127), X(120,128), X(129,137), X(130,138), X(131,139),
  X(132,140), X(133,141), X(134,142), X(135,143), X(136,144), X(145,153),
  X(146,154), X(147,155), X(148,156), X(149,157), X(150,158), X(151,159),
  X(152,160), X(161,169), X(162,170), X(163,171), X(164,172), X(165,173),
  X(166,174), X(167,175), X(168,176), X(9,129), X(10,130), X(11,131), X(12,132),
  X(13,133), X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147),
  X(28,148), X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162),
  X(43,163), X(44,164), X(45,165), X(46,166), X(47,167), X(48,168), X(57,177),
  X(58,178), X(9,65), X(10,66), X(11,67), X(12,68), X(13,69), X(14,70), X(15,71),
  X(16,72), X(25,81), X(26,82), X(27,83), X(28,84), X(29,85), X(30,86), X(31,87),
  X(32,88), X(41,97), X(42,98), X(43,99), X(44,100), X(45,101), X(46,102),
  X(47,103), X(48,104), X(57,113), X(58,114), X(59,115), X(60,116), X(61,117),
  X(62,118), X(63,119), X(64,120), X(73,129), X(74,130), X(75,131), X(76,132),
  X(77,133), X(78,134), X(79,135), X(80,136), X(89,145), X(90,146), X(91,147),
  X(92,148), X(93,149), X(94,150), X(95,151), X(96,152), X(105,161), X(106,162),
  X(107,163), X(108,164), X(109,165), X(110,166), X(111,167), X(112,168),
  X(121,177), X(122,178), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37),
  X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53),
  X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69),
  X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85),
  X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100),
  X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115),
  X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130),
  X(107,131), X(108,132), X(109,133), X(110,134), X(111,135), X(112,136),
  X(121,145), X(122,146), X(123,147), X(124,148), X(125,149), X(126,150),
  X(127,151), X(128,152), X(137,161), X(138,162), X(139,163), X(140,164),
  X(141,165), X(142,166), X(143,167), X(144,168), X(153,177), X(154,178),
  X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24),
  X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40),
  X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56),
  X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72),
  X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88),
  X(89,97), X(90,98), X(91,99), X(92,100), X(93,101), X(94,102), X(95,103),
  X(96,104), X(105,113), X(106,114), X(107,115), X(108,116), X(109,117),
  X(110,118), X(111,119), X(112,120), X(121,129), X(122,130), X(123,131),
  X(124,132), X(125,133), X(126,134), X(127,135), X(128,136), X(137,145),
  X(138,146), X(139,147), X(140,148), X(141,149), X(142,150), X(143,151),
  X(144,152), X(153,161), X(154,162), X(155,163), X(156,164), X(157,165),
  X(158,166), X(159,167), X(160,168), X(169,177), X(170,178), X(1,5), X(2,6),
  X(3,7), X(4,8), X(9,13), X(10,14), X(11,15), X(12,16), X(17,21), X(18,22),
  X(19,23), X(20,24), X(25,29), X(26,30), X(27,31), X(28,32), X(33,37), X(34,38),
  X(35,39), X(36,40), X(41,45), X(42,46), X(43,47), X(44,48), X(49,53), X(50,54),
  X(51,55), X(52,56), X(57,61), X(58,62), X(59,63), X(60,64), X(65,69), X(66,70),
  X(67,71), X(68,72), X(73,77), X(74,78), X(75,79), X(76,80), X(81,85), X(82,86),
  X(83,87), X(84,88), X(89,93), X(90,94), X(91,95), X(92,96), X(97,101),
  X(98,102), X(99,103), X(100,104), X(105,109), X(106,110), X(107,111),
  X(108,112), X(113,117), X(114,118), X(115,119), X(116,120), X(121,125),
  X(122,126), X(123,127), X(124,128), X(129,133), X(130,134), X(131,135),
  X(132,136), X(137,141), X(138,142), X(139,143), X(140,144), X(145,149),
  X(146,150), X(147,151), X(148,152), X(153,157), X(154,158), X(155,159),
  X(156,160), X(161,165), X(162,166), X(163,167), X(164,168), X(169,173),
  X(170,174), X(171,175), X(172,176), X(5,129), X(6,130), X(7,131), X(8,132),
  X(13,137), X(14,138), X(15,139), X(16,140), X(21,145), X(22,146), X(23,147),
  X(24,148), X(29,153), X(30,154), X(31,155), X(32,156), X(37,161), X(38,162),
  X(39,163), X(40,164), X(45,169), X(46,170), X(47,171), X(48,172), X(53,177),
  X(54,178), X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75),
  X(16,76), X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91),
  X(32,92), X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106),
  X(47,107), X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121),
  X(62,122), X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132),
  X(77,137), X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147),
  X(88,148), X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162),
  X(103,163), X(104,164), X(109,169), X(110,170), X(111,171), X(112,172),
  X(117,177), X(118,178), X(5,33), X(6,34), X(7,35), X(8,36), X(13,41), X(14,42),
  X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52), X(29,57), X(30,58),
  X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68), X(45,73), X(46,74),
  X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84), X(61,89), X(62,90),
  X(63,91), X(64,92), X(69,97), X(70,98), X(71,99), X(72,100), X(77,105),
  X(78,106), X(79,107), X(80,108), X(85,113), X(86,114), X(87,115), X(88,116),
  X(93,121), X(94,122), X(95,123), X(96,124), X(101,129), X(102,130), X(103,131),
  X(104,132), X(109,137), X(110,138), X(111,139), X(112,140), X(117,145),
  X(118,146), X(119,147), X(120,148), X(125,153), X(126,154), X(127,155),
  X(128,156), X(133,161), X(134,162), X(135,163), X(136,164), X(141,169),
  X(142,170), X(143,171), X(144,172), X(149,177), X(150,178), X(5,17), X(6,18),
  X(7,19), X(8,20), X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34),
  X(23,35), X(24,36), X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50),
  X(39,51), X(40,52), X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66),
  X(55,67), X(56,68), X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82),
  X(71,83), X(72,84), X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98),
  X(87,99), X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113),
  X(102,114), X(103,115), X(104,116), X(109,121), X(110,122), X(111,123),
  X(112,124), X(117,129), X(118,130), X(119,131), X(120,132), X(125,137),
  X(126,138), X(127,139), X(128,140), X(133,145), X(134,146), X(135,147),
  X(136,148), X(141,153), X(142,154), X(143,155), X(144,156), X(149,161),
  X(150,162), X(151,163), X(152,164), X(157,169), X(158,170), X(159,171),
  X(160,172), X(165,177), X(166,178), X(5,9), X(6,10), X(7,11), X(8,12),
  X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27), X(24,28),
  X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43), X(40,44),
  X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59), X(56,60),
  X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75), X(72,76),
  X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91), X(88,92),
  X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106), X(103,107),
  X(104,108), X(109,113), X(110,114), X(111,115), X(112,116), X(117,121),
  X(118,122), X(119,123), X(120,124), X(125,129), X(126,130), X(127,131),
  X(128,132), X(133,137), X(134,138), X(135,139), X(136,140), X(141,145),
  X(142,146), X(143,147), X(144,148), X(149,153), X(150,154), X(151,155),
  X(152,156), X(157,161), X(158,162), X(159,163), X(160,164), X(165,169),
  X(166,170), X(167,171), X(168,172), X(173,177), X(174,178), X(1,3), X(2,4),
  X(5,7), X(6,8), X(9,11), X(10,12), X(13,15), X(14,16), X(17,19), X(18,20),
  X(21,23), X(22,24), X(25,27), X(26,28), X(29,31), X(30,32), X(33,35), X(34,36),
  X(37,39), X(38,40), X(41,43), X(42,44), X(45,47), X(46,48), X(49,51), X(50,52),
  X(53,55), X(54,56), X(57,59), X(58,60), X(61,63), X(62,64), X(65,67), X(66,68),
  X(69,71), X(70,72), X(73,75), X(74,76), X(77,79), X(78,80), X(81,83), X(82,84),
  X(85,87), X(86,88), X(89,91), X(90,92), X(93,95), X(94,96), X(97,99),
  X(98,100), X(101,103), X(102,104), X(105,107), X(106,108), X(109,111),
  X(110,112), X(113,115), X(114,116), X(117,119), X(118,120), X(121,123),
  X(122,124), X(125,127), X(126,128), X(129,131), X(130,132), X(133,135),
  X(134,136), X(137,139), X(138,140), X(141,143), X(142,144), X(145,147),
  X(146,148), X(149,151), X(150,152), X(153,155), X(154,156), X(157,159),
  X(158,160), X(161,163), X(162,164), X(165,167), X(166,168), X(169,171),
  X(170,172), X(173,175), X(174,176), X(3,129), X(4,130), X(7,133), X(8,134),
  X(11,137), X(12,138), X(15,141), X(16,142), X(19,145), X(20,146), X(23,149),
  X(24,150), X(27,153), X(28,154), X(31,157), X(32,158), X(35,161), X(36,162),
  X(39,165), X(40,166), X(43,169), X(44,170), X(47,173), X(48,174), X(51,177),
  X(52,178), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121),
  X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(71,133), X(72,134),
  X(75,137), X(76,138), X(79,141), X(80,142), X(83,145), X(84,146), X(87,149),
  X(88,150), X(91,153), X(92,154), X(95,157), X(96,158), X(99,161), X(100,162),
  X(103,165), X(104,166), X(107,169), X(108,170), X(111,173), X(112,174),
  X(115,177), X(116,178), X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42),
  X(15,45), X(16,46), X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58),
  X(31,61), X(32,62), X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74),
  X(47,77), X(48,78), X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90),
  X(63,93), X(64,94), X(67,97), X(68,98), X(71,101), X(72,102), X(75,105),
  X(76,106), X(79,109), X(80,110), X(83,113), X(84,114), X(87,117), X(88,118),
  X(91,121), X(92,122), X(95,125), X(96,126), X(99,129), X(100,130), X(103,133),
  X(104,134), X(107,137), X(108,138), X(111,141), X(112,142), X(115,145),
  X(116,146), X(119,149), X(120,150), X(123,153), X(124,154), X(127,157),
  X(128,158), X(131,161), X(132,162), X(135,165), X(136,166), X(139,169),
  X(140,170), X(143,173), X(144,174), X(147,177), X(148,178), X(3,17), X(4,18),
  X(7,21), X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34),
  X(23,37), X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50),
  X(39,53), X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66),
  X(55,69), X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82),
  X(71,85), X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(115,129), X(116,130), X(119,133), X(120,134), X(123,137),
  X(124,138), X(127,141), X(128,142), X(131,145), X(132,146), X(135,149),
  X(136,150), X(139,153), X(140,154), X(143,157), X(144,158), X(147,161),
  X(148,162), X(151,165), X(152,166), X(155,169), X(156,170), X(159,173),
  X(160,174), X(163,177), X(164,178), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(147,153), X(148,154), X(151,157),
  X(152,158), X(155,161), X(156,162), X(159,165), X(160,166), X(163,169),
  X(164,170), X(167,173), X(168,174), X(171,177), X(172,178), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86),
  X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101),
  X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(111,113),
  X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(123,125),
  X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(135,137),
  X(136,138), X(139,141), X(140,142), X(143,145), X(144,146), X(147,149),
  X(148,150), X(151,153), X(152,154), X(155,157), X(156,158), X(159,161),
  X(160,162), X(163,165), X(164,166), X(167,169), X(168,170), X(171,173),
  X(172,174), X(175,177), X(176,178), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176),
  X(177,178), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137), X(12,139),
  X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(24,151), X(26,153),
  X(28,155), X(30,157), X(32,159), X(34,161), X(36,163), X(38,165), X(40,167),
  X(42,169), X(44,171), X(46,173), X(48,175), X(50,177), X(2,65), X(4,67),
  X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79), X(18,81), X(20,83),
  X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95), X(34,97), X(36,99),
  X(38,101), X(40,103), X(42,105), X(44,107), X(46,109), X(48,111), X(50,113),
  X(52,115), X(54,117), X(56,119), X(58,121), X(60,123), X(62,125), X(64,127),
  X(66,129), X(68,131), X(70,133), X(72,135), X(74,137), X(76,139), X(78,141),
  X(80,143), X(82,145), X(84,147), X(86,149), X(88,151), X(90,153), X(92,155),
  X(94,157), X(96,159), X(98,161), X(100,163), X(102,165), X(104,167),
  X(106,169), X(108,171), X(110,173), X(112,175), X(114,177), X(2,33), X(4,35),
  X(6,37), X(8,39), X(10,41), X(12,43), X(14,45), X(16,47), X(18,49), X(20,51),
  X(22,53), X(24,55), X(26,57), X(28,59), X(30,61), X(32,63), X(34,65), X(36,67),
  X(38,69), X(40,71), X(42,73), X(44,75), X(46,77), X(48,79), X(50,81), X(52,83),
  X(54,85), X(56,87), X(58,89), X(60,91), X(62,93), X(64,95), X(66,97), X(68,99),
  X(70,101), X(72,103), X(74,105), X(76,107), X(78,109), X(80,111), X(82,113),
  X(84,115), X(86,117), X(88,119), X(90,121), X(92,123), X(94,125), X(96,127),
  X(98,129), X(100,131), X(102,133), X(104,135), X(106,137), X(108,139),
  X(110,141), X(112,143), X(114,145), X(116,147), X(118,149), X(120,151),
  X(122,153), X(124,155), X(126,157), X(128,159), X(130,161), X(132,163),
  X(134,165), X(136,167), X(138,169), X(140,171), X(142,173), X(144,175),
  X(146,177), X(2,17), X(4,19), X(6,21), X(8,23), X(10,25), X(12,27), X(14,29),
  X(16,31), X(18,33), X(20,35), X(22,37), X(24,39), X(26,41), X(28,43), X(30,45),
  X(32,47), X(34,49), X(36,51), X(38,53), X(40,55), X(42,57), X(44,59), X(46,61),
  X(48,63), X(50,65), X(52,67), X(54,69), X(56,71), X(58,73), X(60,75), X(62,77),
  X(64,79), X(66,81), X(68,83), X(70,85), X(72,87), X(74,89), X(76,91), X(78,93),
  X(80,95), X(82,97), X(84,99), X(86,101), X(88,103), X(90,105), X(92,107),
  X(94,109), X(96,111), X(98,113), X(100,115), X(102,117), X(104,119),
  X(106,121), X(108,123), X(110,125), X(112,127), X(114,129), X(116,131),
  X(118,133), X(120,135), X(122,137), X(124,139), X(126,141), X(128,143),
  X(130,145), X(132,147), X(134,149), X(136,151), X(138,153), X(140,155),
  X(142,157), X(144,159), X(146,161), X(148,163), X(150,165), X(152,167),
  X(154,169), X(156,171), X(158,173), X(160,175), X(162,177), X(2,9), X(4,11),
  X(6,13), X(8,15), X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27),
  X(22,29), X(24,31), X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43),
  X(38,45), X(40,47), X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59),
  X(54,61), X(56,63), X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75),
  X(70,77), X(72,79), X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91),
  X(86,93), X(88,95), X(90,97), X(92,99), X(94,101), X(96,103), X(98,105),
  X(100,107), X(102,109), X(104,111), X(106,113), X(108,115), X(110,117),
  X(112,119), X(114,121), X(116,123), X(118,125), X(120,127), X(122,129),
  X(124,131), X(126,133), X(128,135), X(130,137), X(132,139), X(134,141),
  X(136,143), X(138,145), X(140,147), X(142,149), X(144,151), X(146,153),
  X(148,155), X(150,157), X(152,159), X(154,161), X(156,163), X(158,165),
  X(160,167), X(162,169), X(164,171), X(166,173), X(168,175), X(170,177), X(2,5),
  X(4,7), X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21),
  X(20,23), X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37),
  X(36,39), X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53),
  X(52,55), X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69),
  X(68,71), X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85),
  X(84,87), X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99),
  X(98,101), X(100,103), X(102,105), X(104,107), X(106,109), X(108,111),
  X(110,113), X(112,115), X(114,117), X(116,119), X(118,121), X(120,123),
  X(122,125), X(124,127), X(126,129), X(128,131), X(130,133), X(132,135),
  X(134,137), X(136,139), X(138,141), X(140,143), X(142,145), X(144,147),
  X(146,149), X(148,151), X(150,153), X(152,155), X(154,157), X(156,159),
  X(158,161), X(160,163), X(162,165), X(164,167), X(166,169), X(168,171),
  X(170,173), X(172,175), X(174,177), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(144,145), X(146,147), X(148,149), X(150,151), X(152,153),
  X(154,155), X(156,157), X(158,159), X(160,161), X(162,163), X(164,165),
  X(166,167), X(168,169), X(170,171), X(172,173), X(174,175), X(176,177)
};
S(180) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(45,173), X(46,174), X(47,175), X(48,176), X(49,177),
  X(50,178), X(51,179), X(52,180), X(1,65), X(2,66), X(3,67), X(4,68), X(5,69),
  X(6,70), X(7,71), X(8,72), X(9,73), X(10,74), X(11,75), X(12,76), X(13,77),
  X(14,78), X(15,79), X(16,80), X(17,81), X(18,82), X(19,83), X(20,84), X(21,85),
  X(22,86), X(23,87), X(24,88), X(25,89), X(26,90), X(27,91), X(28,92), X(29,93),
  X(30,94), X(31,95), X(32,96), X(33,97), X(34,98), X(35,99), X(36,100),
  X(37,101), X(38,102), X(39,103), X(40,104), X(41,105), X(42,106), X(43,107),
  X(44,108), X(45,109), X(46,110), X(47,111), X(48,112), X(49,113), X(50,114),
  X(51,115), X(52,116), X(53,117), X(54,118), X(55,119), X(56,120), X(57,121),
  X(58,122), X(59,123), X(60,124), X(61,125), X(62,126), X(63,127), X(64,128),
  X(65,129), X(66,130), X(67,131), X(68,132), X(69,133), X(70,134), X(71,135),
  X(72,136), X(73,137), X(74,138), X(75,139), X(76,140), X(77,141), X(78,142),
  X(79,143), X(80,144), X(81,145), X(82,146), X(83,147), X(84,148), X(85,149),
  X(86,150), X(87,151), X(88,152), X(89,153), X(90,154), X(91,155), X(92,156),
  X(93,157), X(94,158), X(95,159), X(96,160), X(97,161), X(98,162), X(99,163),
  X(100,164), X(101,165), X(102,166), X(103,167), X(104,168), X(105,169),
  X(106,170), X(107,171), X(108,172), X(109,173), X(110,174), X(111,175),
  X(112,176), X(113,177), X(114,178), X(115,179), X(116,180), X(1,33), X(2,34),
  X(3,35), X(4,36), X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42),
  X(11,43), X(12,44), X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50),
  X(19,51), X(20,52), X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58),
  X(27,59), X(28,60), X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98),
  X(67,99), X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105),
  X(74,106), X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112),
  X(81,113), X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119),
  X(88,120), X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126),
  X(95,127), X(96,128), X(129,161), X(130,162), X(131,163), X(132,164),
  X(133,165), X(134,166), X(135,167), X(136,168), X(137,169), X(138,170),
  X(139,171), X(140,172), X(141,173), X(142,174), X(143,175), X(144,176),
  X(145,177), X(146,178), X(147,179), X(148,180), X(33,129), X(34,130),
  X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136), X(41,137),
  X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143), X(48,144),
  X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150), X(55,151),
  X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157), X(62,158),
  X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68), X(37,69),
  X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76), X(45,77),
  X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84), X(53,85),
  X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92), X(61,93),
  X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131), X(100,132),
  X(101,133), X(102,134), X(103,135), X(104,136), X(105,137), X(106,138),
  X(107,139), X(108,140), X(109,141), X(110,142), X(111,143), X(112,144),
  X(113,145), X(114,146), X(115,147), X(116,148), X(117,149), X(118,150),
  X(119,151), X(120,152), X(121,153), X(122,154), X(123,155), X(124,156),
  X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18), X(3,19),
  X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26), X(11,27),
  X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50), X(35,51),
  X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58), X(43,59),
  X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82), X(67,83),
  X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90), X(75,91),
  X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113), X(98,114),
  X(99,115), X(100,116), X(101,117), X(102,118), X(103,119), X(104,120),
  X(105,121), X(106,122), X(107,123), X(108,124), X(109,125), X(110,126),
  X(111,127), X(112,128), X(129,145), X(130,146), X(131,147), X(132,148),
  X(133,149), X(134,150), X(135,151), X(136,152), X(137,153), X(138,154),
  X(139,155), X(140,156), X(141,157), X(142,158), X(143,159), X(144,160),
  X(161,177), X(162,178), X(163,179), X(164,180), X(17,129), X(18,130),
  X(19,131), X(20,132), X(21,133), X(22,134), X(23,135), X(24,136), X(25,137),
  X(26,138), X(27,139), X(28,140), X(29,141), X(30,142), X(31,143), X(32,144),
  X(49,161), X(50,162), X(51,163), X(52,164), X(53,165), X(54,166), X(55,167),
  X(56,168), X(57,169), X(58,170), X(59,171), X(60,172), X(61,173), X(62,174),
  X(63,175), X(64,176), X(17,65), X(18,66), X(19,67), X(20,68), X(21,69),
  X(22,70), X(23,71), X(24,72), X(25,73), X(26,74), X(27,75), X(28,76), X(29,77),
  X(30,78), X(31,79), X(32,80), X(49,97), X(50,98), X(51,99), X(52,100),
  X(53,101), X(54,102), X(55,103), X(56,104), X(57,105), X(58,106), X(59,107),
  X(60,108), X(61,109), X(62,110), X(63,111), X(64,112), X(81,129), X(82,130),
  X(83,131), X(84,132), X(85,133), X(86,134), X(87,135), X(88,136), X(89,137),
  X(90,138), X(91,139), X(92,140), X(93,141), X(94,142), X(95,143), X(96,144),
  X(113,161), X(114,162), X(115,163), X(116,164), X(117,165), X(118,166),
  X(119,167), X(120,168), X(121,169), X(122,170), X(123,171), X(124,172),
  X(125,173), X(126,174), X(127,175), X(128,176), X(17,33), X(18,34), X(19,35),
  X(20,36), X(21,37), X(22,38), X(23,39), X(24,40), X(25,41), X(26,42), X(27,43),
  X(28,44), X(29,45), X(30,46), X(31,47), X(32,48), X(49,65), X(50,66), X(51,67),
  X(52,68), X(53,69), X(54,70), X(55,71), X(56,72), X(57,73), X(58,74), X(59,75),
  X(60,76), X(61,77), X(62,78), X(63,79), X(64,80), X(81,97), X(82,98), X(83,99),
  X(84,100), X(85,101), X(86,102), X(87,103), X(88,104), X(89,105), X(90,106),
  X(91,107), X(92,108), X(93,109), X(94,110), X(95,111), X(96,112), X(113,129),
  X(114,130), X(115,131), X(116,132), X(117,133), X(118,134), X(119,135),
  X(120,136), X(121,137), X(122,138), X(123,139), X(124,140), X(125,141),
  X(126,142), X(127,143), X(128,144), X(145,161), X(146,162), X(147,163),
  X(148,164), X(149,165), X(150,166), X(151,167), X(152,168), X(153,169),
  X(154,170), X(155,171), X(156,172), X(157,173), X(158,174), X(159,175),
  X(160,176), X(1,9), X(2,10), X(3,11), X(4,12), X(5,13), X(6,14), X(7,15),
  X(8,16), X(17,25), X(18,26), X(19,27), X(20,28), X(21,29), X(22,30), X(23,31),
  X(24,32), X(33,41), X(34,42), X(35,43), X(36,44), X(37,45), X(38,46), X(39,47),
  X(40,48), X(49,57), X(50,58), X(51,59), X(52,60), X(53,61), X(54,62), X(55,63),
  X(56,64), X(65,73), X(66,74), X(67,75), X(68,76), X(69,77), X(70,78), X(71,79),
  X(72,80), X(81,89), X(82,90), X(83,91), X(84,92), X(85,93), X(86,94), X(87,95),
  X(88,96), X(97,105), X(98,106), X(99,107), X(100,108), X(101,109), X(102,110),
  X(103,111), X(104,112), X(113,121), X(114,122), X(115,123), X(116,124),
  X(117,125), X(118,126), X(119,127), X(120,128), X(129,137), X(130,138),
  X(131,139), X(132,140), X(133,141), X(134,142), X(135,143), X(136,144),
  X(145,153), X(146,154), X(147,155), X(148,156), X(149,157), X(150,158),
  X(151,159), X(152,160), X(161,169), X(162,170), X(163,171), X(164,172),
  X(165,173), X(166,174), X(167,175), X(168,176), X(9,129), X(10,130), X(11,131),
  X(12,132), X(13,133), X(14,134), X(15,135), X(16,136), X(25,145), X(26,146),
  X(27,147), X(28,148), X(29,149), X(30,150), X(31,151), X(32,152), X(41,161),
  X(42,162), X(43,163), X(44,164), X(45,165), X(46,166), X(47,167), X(48,168),
  X(57,177), X(58,178), X(59,179), X(60,180), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(105,161), X(106,162), X(107,163), X(108,164), X(109,165),
  X(110,166), X(111,167), X(112,168), X(121,177), X(122,178), X(123,179),
  X(124,180), X(9,33), X(10,34), X(11,35), X(12,36), X(13,37), X(14,38),
  X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52), X(29,53), X(30,54),
  X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68), X(45,69), X(46,70),
  X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84), X(61,85), X(62,86),
  X(63,87), X(64,88), X(73,97), X(74,98), X(75,99), X(76,100), X(77,101),
  X(78,102), X(79,103), X(80,104), X(89,113), X(90,114), X(91,115), X(92,116),
  X(93,117), X(94,118), X(95,119), X(96,120), X(105,129), X(106,130), X(107,131),
  X(108,132), X(109,133), X(110,134), X(111,135), X(112,136), X(121,145),
  X(122,146), X(123,147), X(124,148), X(125,149), X(126,150), X(127,151),
  X(128,152), X(137,161), X(138,162), X(139,163), X(140,164), X(141,165),
  X(142,166), X(143,167), X(144,168), X(153,177), X(154,178), X(155,179),
  X(156,180), X(9,17), X(10,18), X(11,19), X(12,20), X(13,21), X(14,22),
  X(15,23), X(16,24), X(25,33), X(26,34), X(27,35), X(28,36), X(29,37), X(30,38),
  X(31,39), X(32,40), X(41,49), X(42,50), X(43,51), X(44,52), X(45,53), X(46,54),
  X(47,55), X(48,56), X(57,65), X(58,66), X(59,67), X(60,68), X(61,69), X(62,70),
  X(63,71), X(64,72), X(73,81), X(74,82), X(75,83), X(76,84), X(77,85), X(78,86),
  X(79,87), X(80,88), X(89,97), X(90,98), X(91,99), X(92,100), X(93,101),
  X(94,102), X(95,103), X(96,104), X(105,113), X(106,114), X(107,115),
  X(108,116), X(109,117), X(110,118), X(111,119), X(112,120), X(121,129),
  X(122,130), X(123,131), X(124,132), X(125,133), X(126,134), X(127,135),
  X(128,136), X(137,145), X(138,146), X(139,147), X(140,148), X(141,149),
  X(142,150), X(143,151), X(144,152), X(153,161), X(154,162), X(155,163),
  X(156,164), X(157,165), X(158,166), X(159,167), X(160,168), X(169,177),
  X(170,178), X(171,179), X(172,180), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13),
  X(10,14), X(11,15), X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29),
  X(26,30), X(27,31), X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45),
  X(42,46), X(43,47), X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61),
  X(58,62), X(59,63), X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77),
  X(74,78), X(75,79), X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93),
  X(90,94), X(91,95), X(92,96), X(97,101), X(98,102), X(99,103), X(100,104),
  X(105,109), X(106,110), X(107,111), X(108,112), X(113,117), X(114,118),
  X(115,119), X(116,120), X(121,125), X(122,126), X(123,127), X(124,128),
  X(129,133), X(130,134), X(131,135), X(132,136), X(137,141), X(138,142),
  X(139,143), X(140,144), X(145,149), X(146,150), X(147,151), X(148,152),
  X(153,157), X(154,158), X(155,159), X(156,160), X(161,165), X(162,166),
  X(163,167), X(164,168), X(169,173), X(170,174), X(171,175), X(172,176),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(31,155), X(32,156), X(37,161), X(38,162), X(39,163), X(40,164), X(45,169),
  X(46,170), X(47,171), X(48,172), X(53,177), X(54,178), X(55,179), X(56,180),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(109,169), X(110,170), X(111,171), X(112,172), X(117,177),
  X(118,178), X(119,179), X(120,180), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(117,145), X(118,146), X(119,147), X(120,148), X(125,153),
  X(126,154), X(127,155), X(128,156), X(133,161), X(134,162), X(135,163),
  X(136,164), X(141,169), X(142,170), X(143,171), X(144,172), X(149,177),
  X(150,178), X(151,179), X(152,180), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(111,123), X(112,124),
  X(117,129), X(118,130), X(119,131), X(120,132), X(125,137), X(126,138),
  X(127,139), X(128,140), X(133,145), X(134,146), X(135,147), X(136,148),
  X(141,153), X(142,154), X(143,155), X(144,156), X(149,161), X(150,162),
  X(151,163), X(152,164), X(157,169), X(158,170), X(159,171), X(160,172),
  X(165,177), X(166,178), X(167,179), X(168,180), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(111,115), X(112,116),
  X(117,121), X(118,122), X(119,123), X(120,124), X(125,129), X(126,130),
  X(127,131), X(128,132), X(133,137), X(134,138), X(135,139), X(136,140),
  X(141,145), X(142,146), X(143,147), X(144,148), X(149,153), X(150,154),
  X(151,155), X(152,156), X(157,161), X(158,162), X(159,163), X(160,164),
  X(165,169), X(166,170), X(167,171), X(168,172), X(173,177), X(174,178),
  X(175,179), X(176,180), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(121,123), X(122,124), X(125,127), X(126,128), X(129,131),
  X(130,132), X(133,135), X(134,136), X(137,139), X(138,140), X(141,143),
  X(142,144), X(145,147), X(146,148), X(149,151), X(150,152), X(153,155),
  X(154,156), X(157,159), X(158,160), X(161,163), X(162,164), X(165,167),
  X(166,168), X(169,171), X(170,172), X(173,175), X(174,176), X(177,179),
  X(178,180), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(27,153),
  X(28,154), X(31,157), X(32,158), X(35,161), X(36,162), X(39,165), X(40,166),
  X(43,169), X(44,170), X(47,173), X(48,174), X(51,177), X(52,178), X(3,65),
  X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77), X(16,78), X(19,81),
  X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93), X(32,94), X(35,97),
  X(36,98), X(39,101), X(40,102), X(43,105), X(44,106), X(47,109), X(48,110),
  X(51,113), X(52,114), X(55,117), X(56,118), X(59,121), X(60,122), X(63,125),
  X(64,126), X(67,129), X(68,130), X(71,133), X(72,134), X(75,137), X(76,138),
  X(79,141), X(80,142), X(83,145), X(84,146), X(87,149), X(88,150), X(91,153),
  X(92,154), X(95,157), X(96,158), X(99,161), X(100,162), X(103,165), X(104,166),
  X(107,169), X(108,170), X(111,173), X(112,174), X(115,177), X(116,178),
  X(3,33), X(4,34), X(7,37), X(8,38), X(11,41), X(12,42), X(15,45), X(16,46),
  X(19,49), X(20,50), X(23,53), X(24,54), X(27,57), X(28,58), X(31,61), X(32,62),
  X(35,65), X(36,66), X(39,69), X(40,70), X(43,73), X(44,74), X(47,77), X(48,78),
  X(51,81), X(52,82), X(55,85), X(56,86), X(59,89), X(60,90), X(63,93), X(64,94),
  X(67,97), X(68,98), X(71,101), X(72,102), X(75,105), X(76,106), X(79,109),
  X(80,110), X(83,113), X(84,114), X(87,117), X(88,118), X(91,121), X(92,122),
  X(95,125), X(96,126), X(99,129), X(100,130), X(103,133), X(104,134),
  X(107,137), X(108,138), X(111,141), X(112,142), X(115,145), X(116,146),
  X(119,149), X(120,150), X(123,153), X(124,154), X(127,157), X(128,158),
  X(131,161), X(132,162), X(135,165), X(136,166), X(139,169), X(140,170),
  X(143,173), X(144,174), X(147,177), X(148,178), X(3,17), X(4,18), X(7,21),
  X(8,22), X(11,25), X(12,26), X(15,29), X(16,30), X(19,33), X(20,34), X(23,37),
  X(24,38), X(27,41), X(28,42), X(31,45), X(32,46), X(35,49), X(36,50), X(39,53),
  X(40,54), X(43,57), X(44,58), X(47,61), X(48,62), X(51,65), X(52,66), X(55,69),
  X(56,70), X(59,73), X(60,74), X(63,77), X(64,78), X(67,81), X(68,82), X(71,85),
  X(72,86), X(75,89), X(76,90), X(79,93), X(80,94), X(83,97), X(84,98),
  X(87,101), X(88,102), X(91,105), X(92,106), X(95,109), X(96,110), X(99,113),
  X(100,114), X(103,117), X(104,118), X(107,121), X(108,122), X(111,125),
  X(112,126), X(115,129), X(116,130), X(119,133), X(120,134), X(123,137),
  X(124,138), X(127,141), X(128,142), X(131,145), X(132,146), X(135,149),
  X(136,150), X(139,153), X(140,154), X(143,157), X(144,158), X(147,161),
  X(148,162), X(151,165), X(152,166), X(155,169), X(156,170), X(159,173),
  X(160,174), X(163,177), X(164,178), X(3,9), X(4,10), X(7,13), X(8,14),
  X(11,17), X(12,18), X(15,21), X(16,22), X(19,25), X(20,26), X(23,29), X(24,30),
  X(27,33), X(28,34), X(31,37), X(32,38), X(35,41), X(36,42), X(39,45), X(40,46),
  X(43,49), X(44,50), X(47,53), X(48,54), X(51,57), X(52,58), X(55,61), X(56,62),
  X(59,65), X(60,66), X(63,69), X(64,70), X(67,73), X(68,74), X(71,77), X(72,78),
  X(75,81), X(76,82), X(79,85), X(80,86), X(83,89), X(84,90), X(87,93), X(88,94),
  X(91,97), X(92,98), X(95,101), X(96,102), X(99,105), X(100,106), X(103,109),
  X(104,110), X(107,113), X(108,114), X(111,117), X(112,118), X(115,121),
  X(116,122), X(119,125), X(120,126), X(123,129), X(124,130), X(127,133),
  X(128,134), X(131,137), X(132,138), X(135,141), X(136,142), X(139,145),
  X(140,146), X(143,149), X(144,150), X(147,153), X(148,154), X(151,157),
  X(152,158), X(155,161), X(156,162), X(159,165), X(160,166), X(163,169),
  X(164,170), X(167,173), X(168,174), X(171,177), X(172,178), X(3,5), X(4,6),
  X(7,9), X(8,10), X(11,13), X(12,14), X(15,17), X(16,18), X(19,21), X(20,22),
  X(23,25), X(24,26), X(27,29), X(28,30), X(31,33), X(32,34), X(35,37), X(36,38),
  X(39,41), X(40,42), X(43,45), X(44,46), X(47,49), X(48,50), X(51,53), X(52,54),
  X(55,57), X(56,58), X(59,61), X(60,62), X(63,65), X(64,66), X(67,69), X(68,70),
  X(71,73), X(72,74), X(75,77), X(76,78), X(79,81), X(80,82), X(83,85), X(84,86),
  X(87,89), X(88,90), X(91,93), X(92,94), X(95,97), X(96,98), X(99,101),
  X(100,102), X(103,105), X(104,106), X(107,109), X(108,110), X(111,113),
  X(112,114), X(115,117), X(116,118), X(119,121), X(120,122), X(123,125),
  X(124,126), X(127,129), X(128,130), X(131,133), X(132,134), X(135,137),
  X(136,138), X(139,141), X(140,142), X(143,145), X(144,146), X(147,149),
  X(148,150), X(151,153), X(152,154), X(155,157), X(156,158), X(159,161),
  X(160,162), X(163,165), X(164,166), X(167,169), X(168,170), X(171,173),
  X(172,174), X(175,177), X(176,178), X(1,2), X(3,4), X(5,6), X(7,8), X(9,10),
  X(11,12), X(13,14), X(15,16), X(17,18), X(19,20), X(21,22), X(23,24), X(25,26),
  X(27,28), X(29,30), X(31,32), X(33,34), X(35,36), X(37,38), X(39,40), X(41,42),
  X(43,44), X(45,46), X(47,48), X(49,50), X(51,52), X(53,54), X(55,56), X(57,58),
  X(59,60), X(61,62), X(63,64), X(65,66), X(67,68), X(69,70), X(71,72), X(73,74),
  X(75,76), X(77,78), X(79,80), X(81,82), X(83,84), X(85,86), X(87,88), X(89,90),
  X(91,92), X(93,94), X(95,96), X(97,98), X(99,100), X(101,102), X(103,104),
  X(105,106), X(107,108), X(109,110), X(111,112), X(113,114), X(115,116),
  X(117,118), X(119,120), X(121,122), X(123,124), X(125,126), X(127,128),
  X(129,130), X(131,132), X(133,134), X(135,136), X(137,138), X(139,140),
  X(141,142), X(143,144), X(145,146), X(147,148), X(149,150), X(151,152),
  X(153,154), X(155,156), X(157,158), X(159,160), X(161,162), X(163,164),
  X(165,166), X(167,168), X(169,170), X(171,172), X(173,174), X(175,176),
  X(177,178), X(179,180), X(2,129), X(4,131), X(6,133), X(8,135), X(10,137),
  X(12,139), X(14,141), X(16,143), X(18,145), X(20,147), X(22,149), X(24,151),
  X(26,153), X(28,155), X(30,157), X(32,159), X(34,161), X(36,163), X(38,165),
  X(40,167), X(42,169), X(44,171), X(46,173), X(48,175), X(50,177), X(52,179),
  X(2,65), X(4,67), X(6,69), X(8,71), X(10,73), X(12,75), X(14,77), X(16,79),
  X(18,81), X(20,83), X(22,85), X(24,87), X(26,89), X(28,91), X(30,93), X(32,95),
  X(34,97), X(36,99), X(38,101), X(40,103), X(42,105), X(44,107), X(46,109),
  X(48,111), X(50,113), X(52,115), X(54,117), X(56,119), X(58,121), X(60,123),
  X(62,125), X(64,127), X(66,129), X(68,131), X(70,133), X(72,135), X(74,137),
  X(76,139), X(78,141), X(80,143), X(82,145), X(84,147), X(86,149), X(88,151),
  X(90,153), X(92,155), X(94,157), X(96,159), X(98,161), X(100,163), X(102,165),
  X(104,167), X(106,169), X(108,171), X(110,173), X(112,175), X(114,177),
  X(116,179), X(2,33), X(4,35), X(6,37), X(8,39), X(10,41), X(12,43), X(14,45),
  X(16,47), X(18,49), X(20,51), X(22,53), X(24,55), X(26,57), X(28,59), X(30,61),
  X(32,63), X(34,65), X(36,67), X(38,69), X(40,71), X(42,73), X(44,75), X(46,77),
  X(48,79), X(50,81), X(52,83), X(54,85), X(56,87), X(58,89), X(60,91), X(62,93),
  X(64,95), X(66,97), X(68,99), X(70,101), X(72,103), X(74,105), X(76,107),
  X(78,109), X(80,111), X(82,113), X(84,115), X(86,117), X(88,119), X(90,121),
  X(92,123), X(94,125), X(96,127), X(98,129), X(100,131), X(102,133), X(104,135),
  X(106,137), X(108,139), X(110,141), X(112,143), X(114,145), X(116,147),
  X(118,149), X(120,151), X(122,153), X(124,155), X(126,157), X(128,159),
  X(130,161), X(132,163), X(134,165), X(136,167), X(138,169), X(140,171),
  X(142,173), X(144,175), X(146,177), X(148,179), X(2,17), X(4,19), X(6,21),
  X(8,23), X(10,25), X(12,27), X(14,29), X(16,31), X(18,33), X(20,35), X(22,37),
  X(24,39), X(26,41), X(28,43), X(30,45), X(32,47), X(34,49), X(36,51), X(38,53),
  X(40,55), X(42,57), X(44,59), X(46,61), X(48,63), X(50,65), X(52,67), X(54,69),
  X(56,71), X(58,73), X(60,75), X(62,77), X(64,79), X(66,81), X(68,83), X(70,85),
  X(72,87), X(74,89), X(76,91), X(78,93), X(80,95), X(82,97), X(84,99),
  X(86,101), X(88,103), X(90,105), X(92,107), X(94,109), X(96,111), X(98,113),
  X(100,115), X(102,117), X(104,119), X(106,121), X(108,123), X(110,125),
  X(112,127), X(114,129), X(116,131), X(118,133), X(120,135), X(122,137),
  X(124,139), X(126,141), X(128,143), X(130,145), X(132,147), X(134,149),
  X(136,151), X(138,153), X(140,155), X(142,157), X(144,159), X(146,161),
  X(148,163), X(150,165), X(152,167), X(154,169), X(156,171), X(158,173),
  X(160,175), X(162,177), X(164,179), X(2,9), X(4,11), X(6,13), X(8,15),
  X(10,17), X(12,19), X(14,21), X(16,23), X(18,25), X(20,27), X(22,29), X(24,31),
  X(26,33), X(28,35), X(30,37), X(32,39), X(34,41), X(36,43), X(38,45), X(40,47),
  X(42,49), X(44,51), X(46,53), X(48,55), X(50,57), X(52,59), X(54,61), X(56,63),
  X(58,65), X(60,67), X(62,69), X(64,71), X(66,73), X(68,75), X(70,77), X(72,79),
  X(74,81), X(76,83), X(78,85), X(80,87), X(82,89), X(84,91), X(86,93), X(88,95),
  X(90,97), X(92,99), X(94,101), X(96,103), X(98,105), X(100,107), X(102,109),
  X(104,111), X(106,113), X(108,115), X(110,117), X(112,119), X(114,121),
  X(116,123), X(118,125), X(120,127), X(122,129), X(124,131), X(126,133),
  X(128,135), X(130,137), X(132,139), X(134,141), X(136,143), X(138,145),
  X(140,147), X(142,149), X(144,151), X(146,153), X(148,155), X(150,157),
  X(152,159), X(154,161), X(156,163), X(158,165), X(160,167), X(162,169),
  X(164,171), X(166,173), X(168,175), X(170,177), X(172,179), X(2,5), X(4,7),
  X(6,9), X(8,11), X(10,13), X(12,15), X(14,17), X(16,19), X(18,21), X(20,23),
  X(22,25), X(24,27), X(26,29), X(28,31), X(30,33), X(32,35), X(34,37), X(36,39),
  X(38,41), X(40,43), X(42,45), X(44,47), X(46,49), X(48,51), X(50,53), X(52,55),
  X(54,57), X(56,59), X(58,61), X(60,63), X(62,65), X(64,67), X(66,69), X(68,71),
  X(70,73), X(72,75), X(74,77), X(76,79), X(78,81), X(80,83), X(82,85), X(84,87),
  X(86,89), X(88,91), X(90,93), X(92,95), X(94,97), X(96,99), X(98,101),
  X(100,103), X(102,105), X(104,107), X(106,109), X(108,111), X(110,113),
  X(112,115), X(114,117), X(116,119), X(118,121), X(120,123), X(122,125),
  X(124,127), X(126,129), X(128,131), X(130,133), X(132,135), X(134,137),
  X(136,139), X(138,141), X(140,143), X(142,145), X(144,147), X(146,149),
  X(148,151), X(150,153), X(152,155), X(154,157), X(156,159), X(158,161),
  X(160,163), X(162,165), X(164,167), X(166,169), X(168,171), X(170,173),
  X(172,175), X(174,177), X(176,179), X(2,3), X(4,5), X(6,7), X(8,9), X(10,11),
  X(12,13), X(14,15), X(16,17), X(18,19), X(20,21), X(22,23), X(24,25), X(26,27),
  X(28,29), X(30,31), X(32,33), X(34,35), X(36,37), X(38,39), X(40,41), X(42,43),
  X(44,45), X(46,47), X(48,49), X(50,51), X(52,53), X(54,55), X(56,57), X(58,59),
  X(60,61), X(62,63), X(64,65), X(66,67), X(68,69), X(70,71), X(72,73), X(74,75),
  X(76,77), X(78,79), X(80,81), X(82,83), X(84,85), X(86,87), X(88,89), X(90,91),
  X(92,93), X(94,95), X(96,97), X(98,99), X(100,101), X(102,103), X(104,105),
  X(106,107), X(108,109), X(110,111), X(112,113), X(114,115), X(116,117),
  X(118,119), X(120,121), X(122,123), X(124,125), X(126,127), X(128,129),
  X(130,131), X(132,133), X(134,135), X(136,137), X(138,139), X(140,141),
  X(142,143), X(144,145), X(146,147), X(148,149), X(150,151), X(152,153),
  X(154,155), X(156,157), X(158,159), X(160,161), X(162,163), X(164,165),
  X(166,167), X(168,169), X(170,171), X(172,173), X(174,175), X(176,177),
  X(178,179)
};
S(182) = {
  X(1,129), X(2,130), X(3,131), X(4,132), X(5,133), X(6,134), X(7,135),
  X(8,136), X(9,137), X(10,138), X(11,139), X(12,140), X(13,141), X(14,142),
  X(15,143), X(16,144), X(17,145), X(18,146), X(19,147), X(20,148), X(21,149),
  X(22,150), X(23,151), X(24,152), X(25,153), X(26,154), X(27,155), X(28,156),
  X(29,157), X(30,158), X(31,159), X(32,160), X(33,161), X(34,162), X(35,163),
  X(36,164), X(37,165), X(38,166), X(39,167), X(40,168), X(41,169), X(42,170),
  X(43,171), X(44,172), X(45,173), X(46,174), X(47,175), X(48,176), X(49,177),
  X(50,178), X(51,179), X(52,180), X(53,181), X(54,182), X(1,65), X(2,66),
  X(3,67), X(4,68), X(5,69), X(6,70), X(7,71), X(8,72), X(9,73), X(10,74),
  X(11,75), X(12,76), X(13,77), X(14,78), X(15,79), X(16,80), X(17,81), X(18,82),
  X(19,83), X(20,84), X(21,85), X(22,86), X(23,87), X(24,88), X(25,89), X(26,90),
  X(27,91), X(28,92), X(29,93), X(30,94), X(31,95), X(32,96), X(33,97), X(34,98),
  X(35,99), X(36,100), X(37,101), X(38,102), X(39,103), X(40,104), X(41,105),
  X(42,106), X(43,107), X(44,108), X(45,109), X(46,110), X(47,111), X(48,112),
  X(49,113), X(50,114), X(51,115), X(52,116), X(53,117), X(54,118), X(55,119),
  X(56,120), X(57,121), X(58,122), X(59,123), X(60,124), X(61,125), X(62,126),
  X(63,127), X(64,128), X(65,129), X(66,130), X(67,131), X(68,132), X(69,133),
  X(70,134), X(71,135), X(72,136), X(73,137), X(74,138), X(75,139), X(76,140),
  X(77,141), X(78,142), X(79,143), X(80,144), X(81,145), X(82,146), X(83,147),
  X(84,148), X(85,149), X(86,150), X(87,151), X(88,152), X(89,153), X(90,154),
  X(91,155), X(92,156), X(93,157), X(94,158), X(95,159), X(96,160), X(97,161),
  X(98,162), X(99,163), X(100,164), X(101,165), X(102,166), X(103,167),
  X(104,168), X(105,169), X(106,170), X(107,171), X(108,172), X(109,173),
  X(110,174), X(111,175), X(112,176), X(113,177), X(114,178), X(115,179),
  X(116,180), X(117,181), X(118,182), X(1,33), X(2,34), X(3,35), X(4,36),
  X(5,37), X(6,38), X(7,39), X(8,40), X(9,41), X(10,42), X(11,43), X(12,44),
  X(13,45), X(14,46), X(15,47), X(16,48), X(17,49), X(18,50), X(19,51), X(20,52),
  X(21,53), X(22,54), X(23,55), X(24,56), X(25,57), X(26,58), X(27,59), X(28,60),
  X(29,61), X(30,62), X(31,63), X(32,64), X(65,97), X(66,98), X(67,99),
  X(68,100), X(69,101), X(70,102), X(71,103), X(72,104), X(73,105), X(74,106),
  X(75,107), X(76,108), X(77,109), X(78,110), X(79,111), X(80,112), X(81,113),
  X(82,114), X(83,115), X(84,116), X(85,117), X(86,118), X(87,119), X(88,120),
  X(89,121), X(90,122), X(91,123), X(92,124), X(93,125), X(94,126), X(95,127),
  X(96,128), X(129,161), X(130,162), X(131,163), X(132,164), X(133,165),
  X(134,166), X(135,167), X(136,168), X(137,169), X(138,170), X(139,171),
  X(140,172), X(141,173), X(142,174), X(143,175), X(144,176), X(145,177),
  X(146,178), X(147,179), X(148,180), X(149,181), X(150,182), X(33,129),
  X(34,130), X(35,131), X(36,132), X(37,133), X(38,134), X(39,135), X(40,136),
  X(41,137), X(42,138), X(43,139), X(44,140), X(45,141), X(46,142), X(47,143),
  X(48,144), X(49,145), X(50,146), X(51,147), X(52,148), X(53,149), X(54,150),
  X(55,151), X(56,152), X(57,153), X(58,154), X(59,155), X(60,156), X(61,157),
  X(62,158), X(63,159), X(64,160), X(33,65), X(34,66), X(35,67), X(36,68),
  X(37,69), X(38,70), X(39,71), X(40,72), X(41,73), X(42,74), X(43,75), X(44,76),
  X(45,77), X(46,78), X(47,79), X(48,80), X(49,81), X(50,82), X(51,83), X(52,84),
  X(53,85), X(54,86), X(55,87), X(56,88), X(57,89), X(58,90), X(59,91), X(60,92),
  X(61,93), X(62,94), X(63,95), X(64,96), X(97,129), X(98,130), X(99,131),
  X(100,132), X(101,133), X(102,134), X(103,135), X(104,136), X(105,137),
  X(106,138), X(107,139), X(108,140), X(109,141), X(110,142), X(111,143),
  X(112,144), X(113,145), X(114,146), X(115,147), X(116,148), X(117,149),
  X(118,150), X(119,151), X(120,152), X(121,153), X(122,154), X(123,155),
  X(124,156), X(125,157), X(126,158), X(127,159), X(128,160), X(1,17), X(2,18),
  X(3,19), X(4,20), X(5,21), X(6,22), X(7,23), X(8,24), X(9,25), X(10,26),
  X(11,27), X(12,28), X(13,29), X(14,30), X(15,31), X(16,32), X(33,49), X(34,50),
  X(35,51), X(36,52), X(37,53), X(38,54), X(39,55), X(40,56), X(41,57), X(42,58),
  X(43,59), X(44,60), X(45,61), X(46,62), X(47,63), X(48,64), X(65,81), X(66,82),
  X(67,83), X(68,84), X(69,85), X(70,86), X(71,87), X(72,88), X(73,89), X(74,90),
  X(75,91), X(76,92), X(77,93), X(78,94), X(79,95), X(80,96), X(97,113),
  X(98,114), X(99,115), X(100,116), X(101,117), X(102,118), X(103,119),
  X(104,120), X(105,121), X(106,122), X(107,123), X(108,124), X(109,125),
  X(110,126), X(111,127), X(112,128), X(129,145), X(130,146), X(131,147),
  X(132,148), X(133,149), X(134,150), X(135,151), X(136,152), X(137,153),
  X(138,154), X(139,155), X(140,156), X(141,157), X(142,158), X(143,159),
  X(144,160), X(161,177), X(162,178), X(163,179), X(164,180), X(165,181),
  X(166,182), X(17,129), X(18,130), X(19,131), X(20,132), X(21,133), X(22,134),
  X(23,135), X(24,136), X(25,137), X(26,138), X(27,139), X(28,140), X(29,141),
  X(30,142), X(31,143), X(32,144), X(49,161), X(50,162), X(51,163), X(52,164),
  X(53,165), X(54,166), X(55,167), X(56,168), X(57,169), X(58,170), X(59,171),
  X(60,172), X(61,173), X(62,174), X(63,175), X(64,176), X(17,65), X(18,66),
  X(19,67), X(20,68), X(21,69), X(22,70), X(23,71), X(24,72), X(25,73), X(26,74),
  X(27,75), X(28,76), X(29,77), X(30,78), X(31,79), X(32,80), X(49,97), X(50,98),
  X(51,99), X(52,100), X(53,101), X(54,102), X(55,103), X(56,104), X(57,105),
  X(58,106), X(59,107), X(60,108), X(61,109), X(62,110), X(63,111), X(64,112),
  X(81,129), X(82,130), X(83,131), X(84,132), X(85,133), X(86,134), X(87,135),
  X(88,136), X(89,137), X(90,138), X(91,139), X(92,140), X(93,141), X(94,142),
  X(95,143), X(96,144), X(113,161), X(114,162), X(115,163), X(116,164),
  X(117,165), X(118,166), X(119,167), X(120,168), X(121,169), X(122,170),
  X(123,171), X(124,172), X(125,173), X(126,174), X(127,175), X(128,176),
  X(17,33), X(18,34), X(19,35), X(20,36), X(21,37), X(22,38), X(23,39), X(24,40),
  X(25,41), X(26,42), X(27,43), X(28,44), X(29,45), X(30,46), X(31,47), X(32,48),
  X(49,65), X(50,66), X(51,67), X(52,68), X(53,69), X(54,70), X(55,71), X(56,72),
  X(57,73), X(58,74), X(59,75), X(60,76), X(61,77), X(62,78), X(63,79), X(64,80),
  X(81,97), X(82,98), X(83,99), X(84,100), X(85,101), X(86,102), X(87,103),
  X(88,104), X(89,105), X(90,106), X(91,107), X(92,108), X(93,109), X(94,110),
  X(95,111), X(96,112), X(113,129), X(114,130), X(115,131), X(116,132),
  X(117,133), X(118,134), X(119,135), X(120,136), X(121,137), X(122,138),
  X(123,139), X(124,140), X(125,141), X(126,142), X(127,143), X(128,144),
  X(145,161), X(146,162), X(147,163), X(148,164), X(149,165), X(150,166),
  X(151,167), X(152,168), X(153,169), X(154,170), X(155,171), X(156,172),
  X(157,173), X(158,174), X(159,175), X(160,176), X(1,9), X(2,10), X(3,11),
  X(4,12), X(5,13), X(6,14), X(7,15), X(8,16), X(17,25), X(18,26), X(19,27),
  X(20,28), X(21,29), X(22,30), X(23,31), X(24,32), X(33,41), X(34,42), X(35,43),
  X(36,44), X(37,45), X(38,46), X(39,47), X(40,48), X(49,57), X(50,58), X(51,59),
  X(52,60), X(53,61), X(54,62), X(55,63), X(56,64), X(65,73), X(66,74), X(67,75),
  X(68,76), X(69,77), X(70,78), X(71,79), X(72,80), X(81,89), X(82,90), X(83,91),
  X(84,92), X(85,93), X(86,94), X(87,95), X(88,96), X(97,105), X(98,106),
  X(99,107), X(100,108), X(101,109), X(102,110), X(103,111), X(104,112),
  X(113,121), X(114,122), X(115,123), X(116,124), X(117,125), X(118,126),
  X(119,127), X(120,128), X(129,137), X(130,138), X(131,139), X(132,140),
  X(133,141), X(134,142), X(135,143), X(136,144), X(145,153), X(146,154),
  X(147,155), X(148,156), X(149,157), X(150,158), X(151,159), X(152,160),
  X(161,169), X(162,170), X(163,171), X(164,172), X(165,173), X(166,174),
  X(167,175), X(168,176), X(9,129), X(10,130), X(11,131), X(12,132), X(13,133),
  X(14,134), X(15,135), X(16,136), X(25,145), X(26,146), X(27,147), X(28,148),
  X(29,149), X(30,150), X(31,151), X(32,152), X(41,161), X(42,162), X(43,163),
  X(44,164), X(45,165), X(46,166), X(47,167), X(48,168), X(57,177), X(58,178),
  X(59,179), X(60,180), X(61,181), X(62,182), X(9,65), X(10,66), X(11,67),
  X(12,68), X(13,69), X(14,70), X(15,71), X(16,72), X(25,81), X(26,82), X(27,83),
  X(28,84), X(29,85), X(30,86), X(31,87), X(32,88), X(41,97), X(42,98), X(43,99),
  X(44,100), X(45,101), X(46,102), X(47,103), X(48,104), X(57,113), X(58,114),
  X(59,115), X(60,116), X(61,117), X(62,118), X(63,119), X(64,120), X(73,129),
  X(74,130), X(75,131), X(76,132), X(77,133), X(78,134), X(79,135), X(80,136),
  X(89,145), X(90,146), X(91,147), X(92,148), X(93,149), X(94,150), X(95,151),
  X(96,152), X(105,161), X(106,162), X(107,163), X(108,164), X(109,165),
  X(110,166), X(111,167), X(112,168), X(121,177), X(122,178), X(123,179),
  X(124,180), X(125,181), X(126,182), X(9,33), X(10,34), X(11,35), X(12,36),
  X(13,37), X(14,38), X(15,39), X(16,40), X(25,49), X(26,50), X(27,51), X(28,52),
  X(29,53), X(30,54), X(31,55), X(32,56), X(41,65), X(42,66), X(43,67), X(44,68),
  X(45,69), X(46,70), X(47,71), X(48,72), X(57,81), X(58,82), X(59,83), X(60,84),
  X(61,85), X(62,86), X(63,87), X(64,88), X(73,97), X(74,98), X(75,99),
  X(76,100), X(77,101), X(78,102), X(79,103), X(80,104), X(89,113), X(90,114),
  X(91,115), X(92,116), X(93,117), X(94,118), X(95,119), X(96,120), X(105,129),
  X(106,130), X(107,131), X(108,132), X(109,133), X(110,134), X(111,135),
  X(112,136), X(121,145), X(122,146), X(123,147), X(124,148), X(125,149),
  X(126,150), X(127,151), X(128,152), X(137,161), X(138,162), X(139,163),
  X(140,164), X(141,165), X(142,166), X(143,167), X(144,168), X(153,177),
  X(154,178), X(155,179), X(156,180), X(157,181), X(158,182), X(9,17), X(10,18),
  X(11,19), X(12,20), X(13,21), X(14,22), X(15,23), X(16,24), X(25,33), X(26,34),
  X(27,35), X(28,36), X(29,37), X(30,38), X(31,39), X(32,40), X(41,49), X(42,50),
  X(43,51), X(44,52), X(45,53), X(46,54), X(47,55), X(48,56), X(57,65), X(58,66),
  X(59,67), X(60,68), X(61,69), X(62,70), X(63,71), X(64,72), X(73,81), X(74,82),
  X(75,83), X(76,84), X(77,85), X(78,86), X(79,87), X(80,88), X(89,97), X(90,98),
  X(91,99), X(92,100), X(93,101), X(94,102), X(95,103), X(96,104), X(105,113),
  X(106,114), X(107,115), X(108,116), X(109,117), X(110,118), X(111,119),
  X(112,120), X(121,129), X(122,130), X(123,131), X(124,132), X(125,133),
  X(126,134), X(127,135), X(128,136), X(137,145), X(138,146), X(139,147),
  X(140,148), X(141,149), X(142,150), X(143,151), X(144,152), X(153,161),
  X(154,162), X(155,163), X(156,164), X(157,165), X(158,166), X(159,167),
  X(160,168), X(169,177), X(170,178), X(171,179), X(172,180), X(173,181),
  X(174,182), X(1,5), X(2,6), X(3,7), X(4,8), X(9,13), X(10,14), X(11,15),
  X(12,16), X(17,21), X(18,22), X(19,23), X(20,24), X(25,29), X(26,30), X(27,31),
  X(28,32), X(33,37), X(34,38), X(35,39), X(36,40), X(41,45), X(42,46), X(43,47),
  X(44,48), X(49,53), X(50,54), X(51,55), X(52,56), X(57,61), X(58,62), X(59,63),
  X(60,64), X(65,69), X(66,70), X(67,71), X(68,72), X(73,77), X(74,78), X(75,79),
  X(76,80), X(81,85), X(82,86), X(83,87), X(84,88), X(89,93), X(90,94), X(91,95),
  X(92,96), X(97,101), X(98,102), X(99,103), X(100,104), X(105,109), X(106,110),
  X(107,111), X(108,112), X(113,117), X(114,118), X(115,119), X(116,120),
  X(121,125), X(122,126), X(123,127), X(124,128), X(129,133), X(130,134),
  X(131,135), X(132,136), X(137,141), X(138,142), X(139,143), X(140,144),
  X(145,149), X(146,150), X(147,151), X(148,152), X(153,157), X(154,158),
  X(155,159), X(156,160), X(161,165), X(162,166), X(163,167), X(164,168),
  X(169,173), X(170,174), X(171,175), X(172,176), X(177,181), X(178,182),
  X(5,129), X(6,130), X(7,131), X(8,132), X(13,137), X(14,138), X(15,139),
  X(16,140), X(21,145), X(22,146), X(23,147), X(24,148), X(29,153), X(30,154),
  X(31,155), X(32,156), X(37,161), X(38,162), X(39,163), X(40,164), X(45,169),
  X(46,170), X(47,171), X(48,172), X(53,177), X(54,178), X(55,179), X(56,180),
  X(5,65), X(6,66), X(7,67), X(8,68), X(13,73), X(14,74), X(15,75), X(16,76),
  X(21,81), X(22,82), X(23,83), X(24,84), X(29,89), X(30,90), X(31,91), X(32,92),
  X(37,97), X(38,98), X(39,99), X(40,100), X(45,105), X(46,106), X(47,107),
  X(48,108), X(53,113), X(54,114), X(55,115), X(56,116), X(61,121), X(62,122),
  X(63,123), X(64,124), X(69,129), X(70,130), X(71,131), X(72,132), X(77,137),
  X(78,138), X(79,139), X(80,140), X(85,145), X(86,146), X(87,147), X(88,148),
  X(93,153), X(94,154), X(95,155), X(96,156), X(101,161), X(102,162), X(103,163),
  X(104,164), X(109,169), X(110,170), X(111,171), X(112,172), X(117,177),
  X(118,178), X(119,179), X(120,180), X(5,33), X(6,34), X(7,35), X(8,36),
  X(13,41), X(14,42), X(15,43), X(16,44), X(21,49), X(22,50), X(23,51), X(24,52),
  X(29,57), X(30,58), X(31,59), X(32,60), X(37,65), X(38,66), X(39,67), X(40,68),
  X(45,73), X(46,74), X(47,75), X(48,76), X(53,81), X(54,82), X(55,83), X(56,84),
  X(61,89), X(62,90), X(63,91), X(64,92), X(69,97), X(70,98), X(71,99),
  X(72,100), X(77,105), X(78,106), X(79,107), X(80,108), X(85,113), X(86,114),
  X(87,115), X(88,116), X(93,121), X(94,122), X(95,123), X(96,124), X(101,129),
  X(102,130), X(103,131), X(104,132), X(109,137), X(110,138), X(111,139),
  X(112,140), X(117,145), X(118,146), X(119,147), X(120,148), X(125,153),
  X(126,154), X(127,155), X(128,156), X(133,161), X(134,162), X(135,163),
  X(136,164), X(141,169), X(142,170), X(143,171), X(144,172), X(149,177),
  X(150,178), X(151,179), X(152,180), X(5,17), X(6,18), X(7,19), X(8,20),
  X(13,25), X(14,26), X(15,27), X(16,28), X(21,33), X(22,34), X(23,35), X(24,36),
  X(29,41), X(30,42), X(31,43), X(32,44), X(37,49), X(38,50), X(39,51), X(40,52),
  X(45,57), X(46,58), X(47,59), X(48,60), X(53,65), X(54,66), X(55,67), X(56,68),
  X(61,73), X(62,74), X(63,75), X(64,76), X(69,81), X(70,82), X(71,83), X(72,84),
  X(77,89), X(78,90), X(79,91), X(80,92), X(85,97), X(86,98), X(87,99),
  X(88,100), X(93,105), X(94,106), X(95,107), X(96,108), X(101,113), X(102,114),
  X(103,115), X(104,116), X(109,121), X(110,122), X(111,123), X(112,124),
  X(117,129), X(118,130), X(119,131), X(120,132), X(125,137), X(126,138),
  X(127,139), X(128,140), X(133,145), X(134,146), X(135,147), X(136,148),
  X(141,153), X(142,154), X(143,155), X(144,156), X(149,161), X(150,162),
  X(151,163), X(152,164), X(157,169), X(158,170), X(159,171), X(160,172),
  X(165,177), X(166,178), X(167,179), X(168,180), X(5,9), X(6,10), X(7,11),
  X(8,12), X(13,17), X(14,18), X(15,19), X(16,20), X(21,25), X(22,26), X(23,27),
  X(24,28), X(29,33), X(30,34), X(31,35), X(32,36), X(37,41), X(38,42), X(39,43),
  X(40,44), X(45,49), X(46,50), X(47,51), X(48,52), X(53,57), X(54,58), X(55,59),
  X(56,60), X(61,65), X(62,66), X(63,67), X(64,68), X(69,73), X(70,74), X(71,75),
  X(72,76), X(77,81), X(78,82), X(79,83), X(80,84), X(85,89), X(86,90), X(87,91),
  X(88,92), X(93,97), X(94,98), X(95,99), X(96,100), X(101,105), X(102,106),
  X(103,107), X(104,108), X(109,113), X(110,114), X(111,115), X(112,116),
  X(117,121), X(118,122), X(119,123), X(120,124), X(125,129), X(126,130),
  X(127,131), X(128,132), X(133,137), X(134,138), X(135,139), X(136,140),
  X(141,145), X(142,146), X(143,147), X(144,148), X(149,153), X(150,154),
  X(151,155), X(152,156), X(157,161), X(158,162), X(159,163), X(160,164),
  X(165,169), X(166,170), X(167,171), X(168,172), X(173,177), X(174,178),
  X(175,179), X(176,180), X(1,3), X(2,4), X(5,7), X(6,8), X(9,11), X(10,12),
  X(13,15), X(14,16), X(17,19), X(18,20), X(21,23), X(22,24), X(25,27), X(26,28),
  X(29,31), X(30,32), X(33,35), X(34,36), X(37,39), X(38,40), X(41,43), X(42,44),
  X(45,47), X(46,48), X(49,51), X(50,52), X(53,55), X(54,56), X(57,59), X(58,60),
  X(61,63), X(62,64), X(65,67), X(66,68), X(69,71), X(70,72), X(73,75), X(74,76),
  X(77,79), X(78,80), X(81,83), X(82,84), X(85,87), X(86,88), X(89,91), X(90,92),
  X(93,95), X(94,96), X(97,99), X(98,100), X(101,103), X(102,104), X(105,107),
  X(106,108), X(109,111), X(110,112), X(113,115), X(114,116), X(117,119),
  X(118,120), X(121,123), X(122,124), X(125,127), X(126,128), X(129,131),
  X(130,132), X(133,135), X(134,136), X(137,139), X(138,140), X(141,143),
  X(142,144), X(145,147), X(146,148), X(149,151), X(150,152), X(153,155),
  X(154,156), X(157,159), X(158,160), X(161,163), X(162,164), X(165,167),
  X(166,168), X(169,171), X(170,172), X(173,175), X(174,176), X(177,179),
  X(178,180), X(3,129), X(4,130), X(7,133), X(8,134), X(11,137), X(12,138),
  X(15,141), X(16,142), X(19,145), X(20,146), X(23,149), X(24,150), X(27,153),
  X(28,154), X(31,157), X(32,158), X(35,161), X(36,162), X(39,165), X(40,166),
  X(43,169), X(44,170), X(47,173), X(48,174), X(51,177), X(52,178), X(55,181),
  X(56,182), X(3,65), X(4,66), X(7,69), X(8,70), X(11,73), X(12,74), X(15,77),
  X(16,78), X(19,81), X(20,82), X(23,85), X(24,86), X(27,89), X(28,90), X(31,93),
  X(32,94), X(35,97), X(36,98), X(39,101), X(40,102), X(43,105), X(44,106),
  X(47,109), X(48,110), X(51,113), X(52,114), X(55,117), X(56,118), X(59,121),
  X(60,122), X(63,125), X(64,126), X(67,129), X(68,130), X(71,133), X(72,134),
  X(75,137), X(76,138), X(79,141), X(80,142), X(83,145), X(84,146), X(87,149),
  X(88,150), X(91,153), X(92,154), X(95,157), X(96,158), X(99,161), X(100,162),
  X(103,165), X(104,166), X(107,169), X(108,170), X(111,173), X(112,174),
  X(115,177), X(116,178), X(119,181), X(120,182), X(3,33), X(4,34), X(7,37),
  X(8,38), X(11,41), X(12,42), X(15,45), X(16,46), X(19,49), X(20,50), X(23,53),
  X(24,54), X(27,57), X(28,58), X(31,61), X(32,62), X(35,65), X(36,66), X(39,69),
  X(40,70), X(43,73), X(44,74), X(47,77), X(48,78), X(51,81), X(52,82), X(55,85),
  X(56,86), X(59,89), X(60,90), X(63,93), X(64,94), X(67,97), X(68,98),
  X