/*
 *  Copyright 2016 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#include <map>
#include <memory>

#include "sdk/android/src/jni/classreferenceholder.h"
#include "sdk/android/src/jni/jni_helpers.h"
#include "system_wrappers/include/metrics.h"

// Enables collection of native histograms and creating them.
namespace webrtc {
namespace jni {

JNI_FUNCTION_DECLARATION(jlong,
                         Histogram_nativeCreateCounts,
                         JNIEnv* jni,
                         jclass,
                         jstring j_name,
                         jint min,
                         jint max,
                         jint buckets) {
  std::string name = JavaToStdString(jni, j_name);
  return jlongFromPointer(
      metrics::HistogramFactoryGetCounts(name, min, max, buckets));
}

JNI_FUNCTION_DECLARATION(jlong,
                         Histogram_nativeCreateEnumeration,
                         JNIEnv* jni,
                         jclass,
                         jstring j_name,
                         jint max) {
  std::string name = JavaToStdString(jni, j_name);
  return jlongFromPointer(metrics::HistogramFactoryGetEnumeration(name, max));
}

JNI_FUNCTION_DECLARATION(void,
                         Histogram_nativeAddSample,
                         JNIEnv* jni,
                         jclass,
                         jlong histogram,
                         jint sample) {
  if (histogram) {
    HistogramAdd(reinterpret_cast<metrics::Histogram*>(histogram), sample);
  }
}

}  // namespace jni
}  // namespace webrtc
