Debugging
=========


Increasing the logging verbosity
--------------------------------

To increase the internal logging verbosity you can use the
`remote.log.level` [preference].

If you use mach to start Firefox:

	./mach run --setpref "remote.log.level=Debug" --remote-debugger


Enabling logging of emitted events
----------------------------------

To dump events produced by EventEmitter,
including CDP events produced by the remote agent,
you can use the `toolkit.dump.emit` [preference]:

    ./mach run --setpref "toolkit.dump.emit=true" --remote-debugger


Logging observer notifications
------------------------------

[System observer notifications] are used extensively throughout the
code and it can sometimes be useful to log these to see what is
available and when they are fired.

The `MOZ_LOG` environment variable controls the C++ logs and takes
the name of the subsystem along with a verbosity setting.  See
[prlog.h] for more details.

	MOZ_LOG=ObserverService:5

You can optionally redirect logs away from stdout to a file:

	MOZ_LOG_FILE=service.log

This enables `LogLevel::Debug` level information and places all
output in the file service.log in your current working directory.


[preference]: ./Prefs.html
[System observer notifications]: https://developer.mozilla.org/en-US/docs/Archive/Add-ons/Overlay_Extensions/XUL_School/Observer_Notifications
[prlog.h]: https://searchfox.org/mozilla-central/source/nsprpub/pr/include/prlog.h
