/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XShapeCombineMask()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>

extern Display *display;

int avs2;

/*
** Pixmaps
** essentially a rect with dimensions 16x16
*/
#define rect_width 16
#define rect_height 16
static unsigned char rect_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


#define T_XShapeCombineMask	1
char    *TestName = "XShapeCombineMask";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window window;
GC gc;
Window root_window;
int x, y;
unsigned int width, height;
unsigned int border_width;
unsigned int depth;
Window dest;
XSetWindowAttributes xswa;
unsigned long  mask;
Pixmap src_pixmap;
XRectangle *rect_return;
int count, order;
int BorderPixel, BackgroundPixel;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XShapeCombineMask-1.(A)");
	report_assertion("A call to XShapeCombineMask(display, dest, dest_kind,");
	report_assertion("x_off, y_off, src, op) shall perform a CombineMask operation");
	report_assertion("by converting the pixmap src to a region with bits set to");
	report_assertion("one included in the region and bits set to zero excluded");
	report_assertion("with an offset from the window origin by amount x_off and");
	report_assertion("y_off, the resulting region shall be combined as specified");
	report_assertion("by the operator op with the existing client region as");
	report_assertion("specified by dest_kind of the destination window dest, and");
	report_assertion("the result shall be stored as the client region of the");
	report_assertion("destination window.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("PREP: Open display and create window");
	window = (Window) avs_xext_init();
	tet_infoline("PREP: Get geometry of parent window");
	XGetGeometry(display, window,
		   &root_window,
		   &x, &y,
		   &width, &height,
		   &border_width,
		   &depth
		   );
	tet_infoline("PREP: Create source pixmap");
	src_pixmap = XCreateBitmapFromData(display, window,
		 (char *)rect_bits, rect_width,
		 rect_height);
	tet_infoline("PREP: Create destination window");
	BorderPixel = XWhitePixel(display,XDefaultScreen(display));
	BackgroundPixel = XBlackPixel(display,XDefaultScreen(display));
	dest  = XCreateSimpleWindow(display, window,
		     (x+10), (y+10),
		     (width - 200 ), (height - 200 ), 0,
		     BorderPixel,
		     BackgroundPixel
		     );
	XSync(display, 0);
	/*
	** Combining a pixmap with defaut shapeclip region shall yield
	** region which is a pixmap only, the number of rectangles is
	** one on destination window.
	*/
	tet_infoline("PREP: Combine pixmap with default region");
	XShapeCombineMask(display,
		  dest,
		  ShapeClip,
		  100,
		  100,
		  src_pixmap,
		  ShapeSet);
	XMapWindow(display, dest);
	XSync(display, 0);
	tet_infoline("PREP: Get count and order of rectangles");
	rect_return = (XRectangle *)XShapeGetRectangles(display,
			    dest, ShapeClip,
			    &count, &order);
	tet_infoline("TEST: Count and order values");
	check_dec(1, count, "count");
	check_dec(YXBanded, order, "order");
	LKROF(pid2, AVSXTTIMEOUT);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.3116 */
/* End of included file Mdefcode.tmc.3116 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
