/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures)
 *   Display	*display;
 *   int 	timeout;
 *   int 	interval;
 *   int 	prefer_blanking;
 *   int 	allow_exposures;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetScreenSaver	1
char    *TestName = "XSetScreenSaver";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetScreenSaver function
 */
static Display	*display;
static int 	timeout;
static int 	interval;
static int 	prefer_blanking;
static int 	allow_exposures;



static	int 	origt;
static	int 	origi;
static	int 	origpb;
static	int 	origae;

static void
savesaver()
{
	startup();
	if(Dsp)
		XGetScreenSaver(Dsp, &origt, &origi, &origpb, &origae);
}

static void
resetsaver()
{
	if(Dsp)
		XSetScreenSaver(Dsp, origt, origi, origpb, origae);
	cleanup();
}



/* Value list for use in test t016 */
static int 	prefer_blankingvallist[] = {
	DontPreferBlanking,
	PreferBlanking,
	DefaultBlanking,
};



/* Value list for use in test t017 */
static int 	allow_exposuresvallist[] = {
	DontAllowExposures,
	AllowExposures,
	DefaultExposures,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	timeout = 34;
	interval = 12;
	prefer_blanking = PreferBlanking;
	allow_exposures = AllowExposures;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetScreenSaver-1.(B)");
	report_assertion("When the timeout argument is greater than zero, then the");
	report_assertion("screen saver is enabled and the value of timeout specifies");
	report_assertion("the time in seconds, until the screen saver is activated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test with timeout greater than zero.");

	tpstartup();
	setargs();
	timeout = 10;

	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test with timeout greater than zero");
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetScreenSaver-2.(B)");
	report_assertion("When timeout is 0, then the screen saver is disabled.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for timeout zero.");

	tpstartup();
	setargs();
	timeout = 0;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for timeout zero");
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2768 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetScreenSaver-3.(B)");
	report_assertion("When timeout is 0 and the screen saver is activated, then a");
	report_assertion("call to XSetScreenSaver does not deactivate the screen");
	report_assertion("saver.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2768 */

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetScreenSaver-4.(B)");
	report_assertion("When timeout is -1, then the default timeout is restored.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for timeout of -1.");

	tpstartup();
	setargs();
	timeout = -1;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for timeout of -1");
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetScreenSaver-5.(B)");
	report_assertion("If the server-dependent screen saver method uses periodic");
	report_assertion("change: The interval argument serves as a hint about how");
	report_assertion("long the change period should be, and zero hints that no");
	report_assertion("periodic change should be made.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for interval, including zero.");

	tpstartup();
	setargs();
	interval = 3;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	interval = 0;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for interval, including zero");
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetScreenSaver-6.(B)");
	report_assertion("When interval is -1, then the default interval is restored.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for default interval.");

	tpstartup();
	setargs();
	interval = -1;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for default interval");
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2768 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetScreenSaver-7.(B)");
	report_assertion("When no input from devices is generated for the specified");
	report_assertion("number of timeout seconds once the screen saver is enabled,");
	report_assertion("then the screen saver is activated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2768 */

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetScreenSaver-8.(D)");
	report_assertion("If the hardware supports video blanking: When");
	report_assertion("prefer_blanking is PreferBlanking and the screen saver is");
	report_assertion("subsequently activated, then the screen goes blank.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for PreferBlanking.");

	tpstartup();
	setargs();
	prefer_blanking = PreferBlanking;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for PreferBlanking");
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetScreenSaver-9.(B)");
	report_assertion("When prefer_blanking is DontPreferBlanking and");
	report_assertion("allow_exposures is AllowExposures or the screen can be");
	report_assertion("regenerated without sending Expose events and the screen");
	report_assertion("saver is subsequently activated, then the screen is altered");
	report_assertion("in an implementation defined way that avoids phosphor burn.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for DontPreferBlanking.");

	tpstartup();
	setargs();
	prefer_blanking = DontPreferBlanking;
	allow_exposures = AllowExposures;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for DontPreferBlanking");
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XSetScreenSaver-10.(B)");
	report_assertion("When prefer_blanking is DefaultBlanking, then the default");
	report_assertion("value for the server is restored.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for DefaultBlanking.");

	tpstartup();
	setargs();
	prefer_blanking = DefaultBlanking;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for DefaultBlanking");
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XSetScreenSaver-11.(B)");
	report_assertion("When allow_exposures is DontAllowExposures, and the screen");
	report_assertion("can not be blanked or regenerated without sending Expose");
	report_assertion("events and the screen saver would subsequently be activated,");
	report_assertion("then the screen's state does not change and the screen saver");
	report_assertion("is not activated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for DontAllowExposures.");

	tpstartup();
	setargs();
	allow_exposures = DontAllowExposures;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for DontAllowExposures");
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XSetScreenSaver-12.(B)");
	report_assertion("When allow_exposures is DefaultExposures, then the servers");
	report_assertion("default value is restored.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test for DefaultExposures.");

	tpstartup();
	setargs();
	allow_exposures = DefaultExposures;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	untested("Touch test for DefaultExposures");
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.2768 */
static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XSetScreenSaver-13.(B)");
	report_assertion("The screen saver is deactivated, and all screen states are");
	report_assertion("restored at the next keyboard or pointer input or at the");
	report_assertion("next call to XForceScreenSaver with mode ScreenSaverReset.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.2768 */

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XSetScreenSaver-14.(A)");
	report_assertion("When timeout is a negative number other than -1, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Call XSetScreenSaver with timeout of -2.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	timeout = -2;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XSetScreenSaver-15.(A)");
	report_assertion("When interval is a negative number other than -1, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Call XSetScreenSaver with interval of -2.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	interval = -2;
	startcall(display);
	if (isdeleted())
		return;
	XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.2768 */
/* End of included file Mval.tmc.2768 */

/* Including from file error/EVal.mc */
static void t016(){

#undef	VALUE_ARG
#define	VALUE_ARG prefer_blanking
#undef	VALUE_LIST
#define	VALUE_LIST prefer_blankingvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XSetScreenSaver-16.(A)");
	report_assertion("When the value of prefer_blanking is other than");
	report_assertion("DontPreferBlanking, PreferBlanking or DefaultBlanking,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file Mval.tmc.2768 */
/* End of included file Mval.tmc.2768 */

/* Including from file error/EVal.mc */
static void t017(){

#undef	VALUE_ARG
#define	VALUE_ARG allow_exposures
#undef	VALUE_LIST
#define	VALUE_LIST allow_exposuresvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XSetScreenSaver-17.(A)");
	report_assertion("When the value of allow_exposures is other than");
	report_assertion("DontAllowExposures, AllowExposures or DefaultExposures,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savesaver;
void	(*tet_cleanup)() = resetsaver;
