/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetWMNormalHints(display, w, hints)
 *   Display		*display;
 *   Window		w;
 *   XSizeHints	*hints;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetWMNormalHints	1
char    *TestName = "XSetWMNormalHints";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XSetWMNormalHints function
 */
static Display		*display;
static Window		w;
static XSizeHints	*hints;


#include	"X11/Xatom.h"
#define		NewNumPropSizeElements 18       /* ICCCM v. 1 */
static XSizeHints	sizehints_0 = { PAllHints|PBaseSize|PWinGravity,0,0,0,0,0,0,0,0,0,0, {0,0}, {0,0}, 0,0,0};
static XSizeHints	sizehints_1 = { PAllHints|PBaseSize|PWinGravity,1,2,3,4,5,6,7,8,9,10, {11,12}, {13,14}, 15, 16, 17};

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(display);
	hints = &sizehints_0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window		win;
XVisualInfo	*vp;
Atom		rtype;
int		rformat;
unsigned long	ritems, rbytes, *uls = NULL;
XSizeHints	pp;
int		i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetWMNormalHints-1.(A)");
	report_assertion("A call to XSetWMNormalHints sets the WM_NORMAL_HINTS");
	report_assertion("property for the window w to be of type WM_SIZE_HINTS,");
	report_assertion("format of 32 and to have value set to the hints in the");
	report_assertion("XSizeHints structure named by the hints argument.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_NORMAL_HINTS property with XSetWMNormalHints.");
	report_strategy("Obtain the value, type and format of the WM_NORMAL_HINTS property using XGetWindowProperty.");
	report_strategy("Verify that the type is WM_SIZE_HINTS.");
	report_strategy("Verify that the format is 32.");
	report_strategy("Verify that the value is identical to that value set by XSetWMNormalHints.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	w = win;	
	hints = &sizehints_1;
	startcall(display);
	if (isdeleted())
		return;
	XSetWMNormalHints(display, w, hints);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( XGetWindowProperty(display, win, XA_WM_NORMAL_HINTS, 0L,
			(long) NewNumPropSizeElements, False,
			AnyPropertyType, &rtype, &rformat, &ritems, &rbytes,
			(unsigned char **) &uls) != Success ) {
		delete("XGetWindowProperty() did not return Success.");
		return;
	} else
		CHECK;

	if( rtype !=  XA_WM_SIZE_HINTS ) {
		report("WM_NORMAL_HINTS property was type %lu instead of XA_WM_SIZE_HINTS (%lu)",
			(unsigned long) rtype, (unsigned long) XA_WM_SIZE_HINTS);
		FAIL;
	} else
		CHECK;

	if( rformat !=  32 ) {
		report("WM_NORMAL_HINTS property was format %d instead of 32.", rformat);
		FAIL;
	} else
		CHECK;

	/* unpack from the array of unsigned longs into pp */
	pp.flags = uls[i=0];

	pp.x = (int)uls[++i]; /* obsolete for new window mgrs, but clients */
	pp.y = (int)uls[++i];
	pp.width = (int)uls[++i];
	pp.height = (int)uls[++i]; /* should set so old wm's don't mess up */

	pp.min_width = (int)uls[++i]; pp.min_height = (int)uls[++i];
	pp.max_width = (int)uls[++i]; pp.max_height = (int)uls[++i];
    	pp.width_inc = (int)uls[++i]; pp.height_inc = (int)uls[++i];
	pp.min_aspect.x = (int)uls[++i]; pp.min_aspect.y = (int)uls[++i];
	pp.max_aspect.x = (int)uls[++i]; pp.max_aspect.y = (int)uls[++i];

	pp.base_width = (int)uls[++i];	/* added by ICCCM version 1 */
	pp.base_height = (int)uls[++i];	/* added by ICCCM version 1 */
	pp.win_gravity = (int)uls[++i];	/* added by ICCCM version 1 */

	if(pp.flags != (PAllHints|PBaseSize|PWinGravity)) {
		report("The flags component of the XSizeHints structure was %lu instead of PAllHints|PBaseSize|PWinGravity (%ld).", pp.flags, PAllHints|PBaseSize|PWinGravity);
		FAIL;
	} else
		CHECK;

	if(pp.x != 1) {
		report("The x component of the XSizeHints structure was %d instead of 1.", pp.x);
		FAIL;
	} else
		CHECK;

	if(pp.y != 2) {
		report("The y component of the XSizeHints structure was %d instead of 2.", pp.y);
		FAIL;
	} else
		CHECK;

	if(pp.width != 3) {
		report("The width component of the XSizeHints structure was %d instead of 3.", pp.width);
		FAIL;
	} else
		CHECK;

	if(pp.height != 4) {
		report("The height component of the XSizeHints structure was %d instead of 4.", pp.height);
		FAIL;
	} else
		CHECK;

	if(pp.min_width != 5) {
		report("The min_width component of the XSizeHints structure was %d instead of 5.", pp.min_width);
		FAIL;
	} else
		CHECK;

	if(pp.min_height != 6) {
		report("The min_height component of the XSizeHints structure was %d instead of 6.", pp.min_height);
		FAIL;
	} else
		CHECK;

	if(pp.max_width != 7) {
		report("The max_width component of the XSizeHints structure was %d instead of 7.", pp.max_width);
		FAIL;
	} else
		CHECK;

	if(pp.max_height != 8) {
		report("The max_height component of the XSizeHints structure was %d instead of 8.", pp.max_height);
		FAIL;
	} else
		CHECK;

	if(pp.width_inc != 9) {
		report("The width_inc component of the XSizeHints structure was %d instead of 9.", pp.width_inc);
		FAIL;
	} else
		CHECK;

	if(pp.height_inc != 10) {
		report("The height_inc component of the XSizeHints structure was %d instead of 10.", pp.height_inc);
		FAIL;
	} else
		CHECK;

	if((pp.min_aspect.x != 11) || (pp.min_aspect.y != 12)){
		report("The min_aspect components of the XSizeHints structure were %d, %d instead of 11, 12.",
			pp.min_aspect.x, pp.min_aspect.y);
		FAIL;
	} else
		CHECK;

	if((pp.max_aspect.x != 13) || (pp.max_aspect.y != 14)){
		report("The max_aspect components of the XSizeHints structure were %d, %d instead of 13, 14.",
			pp.max_aspect.x, pp.max_aspect.y);
		FAIL;
	} else
		CHECK;

	if(pp.base_width != 15) {
		report("The base_width component of the XSizeHints structure was %d instead of 15.", pp.base_width);
		FAIL;
	} else
		CHECK;

	if(pp.base_height != 16) {
		report("The base_height component of the XSizeHints structure was %d instead of 16.", pp.base_height);
		FAIL;
	} else
		CHECK;

	if(pp.win_gravity != 17) {
		report("The win_gravity component of the XSizeHints structure was %d instead of 17", pp.win_gravity);
		FAIL;
	} else
		CHECK;

	XFree((char*)uls);
	CHECKPASS(19);
	

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetWMNormalHints-2.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetWMNormalHints-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetWMNormalHints(display, w, hints);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
