/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XEqualRegion(r1, r2)
 *   Region	r1;
 *   Region	r2;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XEqualRegion	1
char    *TestName = "XEqualRegion";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XEqualRegion function
 */
static Region	r1;
static Region	r2;


static	XRectangle	rect1 = {0,0, 7,13 };
static	XRectangle	rect2 = {5,5, 10,15 };
static	XRectangle	rect3 = {0,0, 17,20 };
static	XRectangle	rect4 = {-1,-1, 1,1 };

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	r1 = 0;
	r2 = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Bool	res;
Region	R1;
Region	R2;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XEqualRegion-1.(A)");
	report_assertion("When the regions r1 and r2 have the same offset, size and");
	report_assertion("shape, then a call to XEqualRegion returns True.");

	report_strategy("Create two regions using XCreateRegion.");
	report_strategy("Set one region to the union of three rectangles one of which covers the other two using XUnionRectWithRegion.");
	report_strategy("Set the other region to the all encompassing region using XUnionRectWithRegion.");
	report_strategy("Verify that the call to XEqualRegion returns True.");

	tpstartup();
	setargs();
	R1 = makeregion();
	R2 = makeregion();
	if(isdeleted()) return;

	XUnionRectWithRegion(&rect1, R1, R1);
	XUnionRectWithRegion(&rect3, R1, R1);
	XUnionRectWithRegion(&rect2, R1, R1);
	XUnionRectWithRegion(&rect3, R2, R2);

	r1 = R1;
	r2 = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	res = XEqualRegion(r1, r2);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != True) {
		report("%s() did not return True for two equal regions.", TestName);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Bool	res;
Region	R1;
Region	R2;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XEqualRegion-2.(A)");
	report_assertion("When the regions r1 and r2 do not have the same offset,");
	report_assertion("then a call to XEqualRegion returns False.");

	report_strategy("Create regions R1 R2 using XCreateRegion.");
	report_strategy("Set R1 and R2 to the same region using XUnionRectWithRegion.");
	report_strategy("Offset R2 using XOffsetRegion.");
	report_strategy("Verify that a call to XEqualRegion returns False.");

	tpstartup();
	setargs();
	R1 = makeregion();
	R2 = makeregion();

	if(isdeleted()) return;

	XUnionRectWithRegion(&rect1, R1, R1);
	XUnionRectWithRegion(&rect1, R2, R2);
	XOffsetRegion(R2,1,0);

	r1 = R1;
	r2 = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	res = XEqualRegion(r1, r2);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != False) {
		report("%s() did not return False for regions with a different offset.", TestName);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Bool	res;
Region	R1;
Region	R2;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XEqualRegion-3.(A)");
	report_assertion("When the regions r1 and r2 do not have the same size, then");
	report_assertion("a call to XEqualRegion returns False.");

	report_strategy("Create regions R1 R2 using XCreateRegion.");
	report_strategy("Set R1 and R2 to the same region using XUnionRectWithRegion.");
	report_strategy("Change the size of R2 using XShrinkRegion.");
	report_strategy("Verify that a call to XEqualRegion returns False.");

	tpstartup();
	setargs();
	R1 = makeregion();
	R2 = makeregion();

	if(isdeleted()) return;

	XUnionRectWithRegion(&rect1, R1, R1);
	XUnionRectWithRegion(&rect1, R2, R2);
	XShrinkRegion(R2, 1, 0);

	r1 = R1;
	r2 = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	res = XEqualRegion(r1, r2);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != False) {
		report("%s() did not return False for regions with a different size.", TestName);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Bool	res;
Region	R1;
Region	R2;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XEqualRegion-4.(A)");
	report_assertion("When the regions r1 and r2 do not have the same shape, then");
	report_assertion("a call to XEqualRegion returns False.");

	report_strategy("Create regions R1 R2 using XCreateRegion.");
	report_strategy("Set R1 and R2 to the same region using XUnionRectWithRegion.");
	report_strategy("Change R2 with disjoint rectangle using XUnionRectWithRegion.");
	report_strategy("Verify that a call to XEqualRegion returns False.");

	tpstartup();
	setargs();
	R1 = makeregion();
	R2 = makeregion();

	if(isdeleted()) return;

	XUnionRectWithRegion(&rect1, R1, R1);
	XUnionRectWithRegion(&rect1, R2, R2);
	XUnionRectWithRegion(&rect4, R2, R2);

	r1 = R1;
	r2 = R2;
	startcall(Dsp);
	if (isdeleted())
		return;
	res = XEqualRegion(r1, r2);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(res != False) {
		report("%s() did not return False for two different regions.", TestName);
		FAIL;
	} else
		PASS;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
