/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return)
 *   Display		*display;
 *   int		screen;
 *   char		*user_geom;
 *   char		*def_geom;
 *   unsigned int	bwidth;
 *   XSizeHints	*hints;
 *   int		*x_return;
 *   int		*y_return;
 *   int		*width_return;
 *   int		*height_return;
 *   int		*gravity_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XWMGeometry	1
char    *TestName = "XWMGeometry";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XWMGeometry function
 */
static Display		*display;
static int		screen;
static char		*user_geom;
static char		*def_geom;
static unsigned int	bwidth;
static XSizeHints	*hints;
static int		*x_return;
static int		*y_return;
static int		*width_return;
static int		*height_return;
static int		*gravity_return;


static int 	ValueReturn;

#include	"X11/Xatom.h"
int		dint;
XSizeHints	size_hints;

XSizeHints	szhints = {	0L,
				0,0,     
				0,0,    
				38,	29,    	/* min width, min height */
				400,	300,	/* max width, max height */
				17,	18,  	/* width inc, height inc */
				{0,0},  
				{0,0},  
				20,	10,	/* base width, base height */
				SouthWestGravity};

XSizeHints	szhints1 = { PAllHints, /* Deliberate lack of PBaseSize and PWinGravity */
				0,0,     
				0,0,    
				20,	30,    	/* min width, min height */
				400,	300,	/* max width, max height */
				17,	18,  	/* width inc, height inc */
				{0,0},  
				{0,0},  
				-1,	-2,	/* base width, base height */
				-1};

XSizeHints	szhints2 = {	0L,
				0,0,     
				0,0,    
				0,0,
				0,0,
				0,0,
				{0,0},  
				{0,0},  
				0,0,
				0};



int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	screen = DefaultScreen(Dsp);
	user_geom = NULL;
	def_geom = NULL;
	bwidth = 1;
	hints = &size_hints;
	x_return = &dint;
	y_return = &dint;
	width_return = &dint;
	height_return = &dint;
	gravity_return = &dint;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	rval;
int	xr, yr, wr, hr, gr;
int	x,  y,  w,  h;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XWMGeometry-1.(A)");
	report_assertion("A call to XWMGeometry combines the geometry information");
	report_assertion("given in the user_geom, def_geom and hints arguments and");
	report_assertion("returns in x_return the x offset, in y_return the y offset,");
	report_assertion("in width_return the width ( = hints->base_width+");
	report_assertion("width*hints->width_inc), in height_return the height ( =");
	report_assertion("hints->base_height+ height*hints->height_inc) and in");
	report_assertion("gravity_return the gravity information specified by the");
	report_assertion("geometry arguments.");

	report_strategy("Call XWMGeometry with user_geom \"10x12+30+40\", def_geom = NULL,");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned width is base_width  + (10 * width_inc)");
	report_strategy("Verify that the returned height is base_height + (12 * height_inc)");
	report_strategy("Verify that the returned x-coordinate is 30.");
	report_strategy("Verify that the returned y-coordinate is 40.");
	report_strategy("");
	report_strategy("Call XWMGeometry with user_geom NULL, def_geom = \"10x12+30+40\"");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned width is base_width  + (10 * width_inc)");
	report_strategy("Verify that the returned height is base_height + (12 * height_inc)");
	report_strategy("Verify that the returned x-coordinate is 30.");
	report_strategy("Verify that the returned y-coordinate is 40.");
	report_strategy("");
	report_strategy("Call XWMGeometry with user_geom = \"10x12\", def_geom = \"2x3+30+40\"");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned width is base_width  + (10 * width_inc)");
	report_strategy("Verify that the returned height is base_height + (12 * height_inc)");
	report_strategy("Verify that the returned x-coordinate is 30.");
	report_strategy("Verify that the returned y-coordinate is 40.");
	report_strategy("");
	report_strategy("Call XWMGeometry with user_geom = \"1x1\", def_geom = NULL");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned width is min_width");
	report_strategy("Verify that the returned height is min_height ");
	report_strategy("");
	report_strategy("Call XWMGeometry with user_geom = \"40x30\", def_geom = NULL");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned width is max_width");
	report_strategy("Verify that the returned height is max_height ");
	report_strategy("");
	report_strategy("Call XWMGeometry with user_geom = \"10x12-1-2\", def_geom = NULL");
	report_strategy("    and an XSizeHints structure with min_width = 38, min_heght = 29,");
	report_strategy("    max_width = 400, max_height = 300, width_inc = 17, height_inc =18,");
	report_strategy("    base_width = 20 and base_height = 10.");
	report_strategy("Verify that the returned x-coordinate is DisplayWidth -1 - (base_width + 10 * width_inc) - 2 * bwidth");
	report_strategy("Verify that the returned y-coordinate is DisplayHeight -1 - (base_height + 10 * height_inc) - 2 * bwidth");
	report_strategy("");

	tpstartup();
	setargs();
	bwidth = 10;
	szhints.flags= PAllHints|PBaseSize|PWinGravity;
	hints = &szhints;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "10x12+30+40";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.base_width  + (10 * szhints.width_inc);
	h = szhints.base_height + (12 * szhints.height_inc);
	x = 30;
	y = 40;

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		CHECK;

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		CHECK;

	if(x != xr) {
		report("Returned x-coordinate was %d instead of %d", xr, x);
		FAIL;
	} else
		CHECK;

	if(y != yr) {
		report("Returned y-coordinate was %d instead of %d", yr, y);
		FAIL;
	} else
		CHECK;

	user_geom = NULL;
	def_geom =  "10x12+30+40";
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.base_width  + (10 * szhints.width_inc);
	h = szhints.base_height + (12 * szhints.height_inc);

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		CHECK;

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		CHECK;

	if(x != xr) {
		report("Returned x-coordinate was %d instead of %d", xr, x);
		FAIL;
	} else
		CHECK;

	if(y != yr) {
		report("Returned y-coordinate was %d instead of %d", yr, y);
		FAIL;
	} else
		CHECK;

/* When no x,y is specified by user_geom, use the def_geom */
	user_geom = "10x12";
	def_geom = "2x3+30+40";
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.base_width  + (10 * szhints.width_inc);
	h = szhints.base_height + (12 * szhints.height_inc);

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		CHECK;

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		CHECK;

	if(x != xr) {
		report("Returned x-coordinate was %d instead of %d", xr, x);
		FAIL;
	} else
		CHECK;

	if(y != yr) {
		report("Returned y-coordinate was %d instead of %d", yr, y);
		FAIL;
	} else
		CHECK;

/* Ensure that the minimums hold */
	user_geom = "1x1";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.min_width;
	h = szhints.min_height;

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		CHECK;

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		CHECK;

/* Ensure that the maximums hold */
	user_geom = "40x30";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.max_width;
	h = szhints.max_height;

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		CHECK;

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		CHECK;

/* Check that border, width and height is taken into account with negative x & y */
	user_geom = "10x12-1-2";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints.base_width  + (10 * szhints.width_inc);
	h = szhints.base_height + (12 * szhints.height_inc);
	x = DisplayWidth(display, screen) + (-1) - w - 2 * bwidth;
	y = DisplayHeight(display, screen) + (-2) - h - 2 * bwidth;


	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(x != xr) {
		report("Returned x-coordinate was %d instead of %d", xr, x);
		FAIL;
	} else
		CHECK;

	if(y != yr) {
		report("Returned y-coordinate was %d instead of %d", yr, y);
		FAIL;
	} else
		CHECK;

	CHECKPASS(18);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	rval;
int	xr, yr, wr, hr, gr;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XWMGeometry-2.(A)");
	report_assertion("The value returned in the gravity_return information is one");
	report_assertion("of NorthWestGravity, NorthGravity, NorthEastGravity,");
	report_assertion("WestGravity, CenterGravity, EastGravity, SouthWestGravity,");
	report_assertion("SouthGravity, or SouthEastGravity.");

	report_strategy("Call XWMGeometry with user_geom = \"10x20-0-0\", and an XSizeHints");
	report_strategy("  structure with gravity component set to SouthWestGravity.");
	report_strategy("Verify that the gravity returned is one of NorthWestGravity,");
	report_strategy("  NorthGravity , NorthEastGravity , WestGravity ,");
	report_strategy("  CenterGravity ,EastGravity , SouthWestGravity ,");
	report_strategy("  SouthGravity , SouthEastGravity .");

	tpstartup();
	setargs();
	user_geom = "10x20-0-0";
	def_geom = NULL;
	bwidth = 1;
	szhints.flags= PAllHints|PBaseSize|PWinGravity;
	hints = &szhints;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if( (gr != NorthWestGravity) && (gr != NorthGravity) &&(gr != NorthEastGravity) &&
	    (gr != WestGravity) && (gr != CenterGravity) && (gr != EastGravity) &&
	    (gr != SouthWestGravity) && (gr != SouthGravity) && (gr != SouthEastGravity)) {
		report("Gravity value returned was invalid : %d", gr);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int	rval;
int	xr, yr, wr, hr, gr;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XWMGeometry-3.(A)");
	report_assertion("A call to XWMGeometry returns a mask which indicates which");
	report_assertion("information came from the user_geom argument and whether the");
	report_assertion("position is relative to the right and bottom edges which is");
	report_assertion("the OR of none or any of XValue, YValue, WidthValue,");
	report_assertion("HeightValue, XNegative, or YNegative.");

	report_strategy("Call XWMGeometry with user_geom = \"40x30-9-9\"");
	report_strategy("Verify that the returned mask is (XValue | YValue | WidthValue |HeightValue | XNegative | YNegative)");
	report_strategy("Call XWMGeometry with user_geom = \"-9+9\"");
	report_strategy("Verify that the returned mask is (XValue | YValue | XNegative)");
	report_strategy("Call XWMGeometry with user_geom = \"5x5\"");
	report_strategy("Verify that the returned mask is (WidthValue | HeightValue)");
	report_strategy("Call XWMGeometry with user_geom = NULL");
	report_strategy("Verify that the returned mask is 0.");

	tpstartup();
	setargs();
	user_geom = "40x30-9-9";
	def_geom = NULL;
	bwidth = 1;
	szhints.flags= PAllHints|PBaseSize|PWinGravity;
	hints = &szhints;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(rval != (XValue | YValue | WidthValue |HeightValue | XNegative | YNegative)) {
		report("Return value was 0x%x, instead of", rval);
		report("(XValue | YValue | XWidthValue | XHeightValue | XNegative | YNegative)");
		report("with user_geom = %s", user_geom);
		FAIL;
	} else
		CHECK;

	user_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(rval != NoValue) {
		report("Return value was 0x%x, instead of NoValue with user_geom = %s", rval, user_geom);
		FAIL;
	} else
		CHECK;

	user_geom = "-9+9";
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(rval != ( XValue | YValue | XNegative)) {
		report("Return value was 0x%x, instead of", rval);
		report("(XWidthValue | XHeightValue | XNegative)");
		report("with user_geom = %s", user_geom);
		FAIL;
	} else
		CHECK;

	user_geom = "5x5";
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(rval != (WidthValue | HeightValue)) {
		report("Return value was 0x%x, instead of", rval);
		report("(XValue | YValue)");
		report("with user_geom = %s", user_geom);
		FAIL;
	} else
		CHECK;

	user_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(rval != 0) {
		report("Return value was 0x%x, instead of 0", rval);
		report("with user_geom = %s", user_geom);
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int	rval;
int	xr, yr, wr, hr, gr;
int	w;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XWMGeometry-4.(A)");
	report_assertion("When the base_width component of the XSizeHints structure");
	report_assertion("named by the hints argument is not set, then the min_width");
	report_assertion("component is used.");

	report_strategy("Call XWMGeometry with user_geom = \"10x12\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PAllHints , base_width = -1 base_height = -2,");
	report_strategy("  min_width = 20 and min_height = 30.");
	report_strategy("Verify that the returned width is min_width  + (10 * width_inc)");

	tpstartup();
	setargs();
	bwidth = 10;
	hints = &szhints1;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "10x12";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints1.min_width  + (10 * szhints1.width_inc);

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	rval;
int	xr, yr, wr, hr, gr;
int	h;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XWMGeometry-5.(A)");
	report_assertion("When the base_height component of the XSizeHints structure");
	report_assertion("named by the hints argument is not set, then the min_height");
	report_assertion("component is used.");

	report_strategy("Call XWMGeometry with user_geom = \"10x12\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PAllHints , base_width = -1 base_height = -2,");
	report_strategy("  min_width = 20 and min_height = 30.");
	report_strategy("Verify that the returned height is min_height  + (10 * height_inc)");

	tpstartup();
	setargs();
	bwidth = 10;
	hints = &szhints1;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "10x12";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	h = szhints1.min_height  + (12 * szhints1.height_inc);

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int	rval;
int	xr, yr, wr, hr, gr;
int	w;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XWMGeometry-6.(A)");
	report_assertion("When the min_width component is not set in the XSizeHints");
	report_assertion("structure named by the hints argument, then the base_width");
	report_assertion("component is used.");

	report_strategy("Call XWMGeometry with user_geom = \"1x1\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PBaseSize | PResizeInc , min_width = 21,");
	report_strategy("  min_height = 31, width_inc = -1, height_inc = -1, base_height = 20 and");
	report_strategy("  base_width = 30.");
	report_strategy("Verify that the returned width is base_width.");

	tpstartup();
	setargs();
	bwidth = 10;

	szhints2.flags = PBaseSize | PResizeInc;
	szhints2.min_width = 21;
	szhints2.min_height = 31;
	szhints2.width_inc = -1;
	szhints2.height_inc = -1;
	szhints2.base_height = 20;
	szhints2.base_width = 30;

	hints = &szhints2;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "1x1";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	w = szhints2.base_width;

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(w != wr) {
		report("Returned width was %d instead of %d", wr, w);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int	rval;
int	xr, yr, wr, hr, gr;
int	h;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XWMGeometry-7.(A)");
	report_assertion("When the min_height component is not set in the XSizeHints");
	report_assertion("structure named by the hints argument, then the base_height");
	report_assertion("component is used.");

	report_strategy("Call XWMGeometry with user_geom = \"1x1\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PBaseSize | PResizeInc , min_width = 21,");
	report_strategy("  min_height = 31, width_inc = -1, height_inc = -1, base_height = 20 and");
	report_strategy("  base_width = 30.");
	report_strategy("Verify that the returned height is base_height.");

	tpstartup();
	setargs();
	bwidth = 10;

	szhints2.flags = PBaseSize | PResizeInc;
	szhints2.min_width = 21;
	szhints2.min_height = 31;
	szhints2.width_inc = -1;
	szhints2.height_inc = -1;
	szhints2.base_height = 20;
	szhints2.base_width = 30;

	hints = &szhints2;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "1x1";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	h = szhints2.base_height;

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(h != hr) {
		report("Returned height was %d instead of %d", hr, h);
		FAIL;
	} else
		PASS;


	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int	rval;
int	xr, yr, wr, hr, gr;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XWMGeometry-8.(A)");
	report_assertion("When neither the base_width nor min_width components of the");
	report_assertion("XSizeHints structure named by the hints argument is set,");
	report_assertion("then the value 0 is used.");

	report_strategy("Call XWMGeometry with user_geom = \"1x1\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PResizeInc , min_width = 21,");
	report_strategy("  min_height = 31, width_inc = -1, height_inc = -1, base_height = 20 and");
	report_strategy("  base_width = 30.");
	report_strategy("Verify that the returned width is 0.");

	tpstartup();
	setargs();
	bwidth = 10;

	szhints2.flags = PResizeInc;
	szhints2.min_width = 21;
	szhints2.min_height = 31;
	szhints2.width_inc = -1;
	szhints2.height_inc = -1;
	szhints2.base_height = 20;
	szhints2.base_width = 30;

	hints = &szhints2;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "1x1";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(wr != 0) {
		report("Returned width was %d instead of 0", wr);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int	rval;
int	xr, yr, wr, hr, gr;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XWMGeometry-9.(A)");
	report_assertion("When neither the base_height nor min_height components of");
	report_assertion("the XSizeHints structure named by the hints argument is set,");
	report_assertion("then the value 0 is used.");

	report_strategy("Call XWMGeometry with user_geom = \"1x1\", def_geom = NULL and an XSizeHints");
	report_strategy("  structure with flags component = PResizeInc , min_width = 21,");
	report_strategy("  min_height = 31, width_inc = -1, height_inc = -1, base_height = 20 and");
	report_strategy("  base_width = 30.");
	report_strategy("Verify that the returned height is 0.");

	tpstartup();
	setargs();
	bwidth = 10;

	szhints2.flags = PResizeInc;
	szhints2.min_width = 21;
	szhints2.min_height = 31;
	szhints2.width_inc = -1;
	szhints2.height_inc = -1;
	szhints2.base_height = 20;
	szhints2.base_width = 30;

	hints = &szhints2;
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;
	gravity_return = &gr;

	user_geom = "1x1";
	def_geom = NULL;
	startcall(display);
	if (isdeleted())
		return;
	rval = XWMGeometry(display, screen, user_geom, def_geom, bwidth, hints, x_return, y_return, width_return, height_return, gravity_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	trace("user_geom = %s, def_geom = %s", user_geom == NULL ? "<NULL>": user_geom, def_geom == NULL ? "<NULL>": def_geom);

	if(hr != 0) {
		report("Returned height was %d instead of 0", hr);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
