/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetSelectionOwner(display, selection, owner, thetime)
 *   Display *display;
 *   Atom selection;
 *   Window owner;
 *   Time thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetSelectionOwner	1
char    *TestName = "XSetSelectionOwner";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_ATOM selection
#define A_WINDOW owner
#define A_DRAWABLE owner


/*
 * Arguments to the XSetSelectionOwner function
 */
static Display *display;
static Atom selection;
static Window owner;
static Time thetime;


#include "X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	selection = XA_COPYRIGHT;
	owner = defwin(display);
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *client1, *client2;
Time calltime;
Window  callwindow;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetSelectionOwner-1.(A)");
	report_assertion("A call to XSetSelectionOwner changes the owner window to");
	report_assertion("owner and the last-change time to time for the specified");
	report_assertion("selection.");

	report_strategy("Create a new client.");
	report_strategy("Obtain current server time.");
	report_strategy("Call XSetSelectionOwner to assign the owner and time for the selection.");
	report_strategy("Call XSetSelectionOwner to clear the selection.");
	report_strategy("Verify that the correct SelectionClear event occurred.");

	tpstartup();
	setargs();
/* Create a new client. */
	client1 = display;
	client2 = opendisplay();
	if (client2 == (Display *)NULL) {
		delete("Could not open client2");
		return;
	} else
		CHECK;

/* Obtain current server time. */
	calltime = gettime(client1);
	callwindow = owner;

/* Call xname to assign the owner and time for the selection. */
	thetime = calltime;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call xname to clear the selection. */
	display = client2;
	thetime = CurrentTime;
	owner = None;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client1, False);

/* Verify that the correct SelectionClear event occurred. */
	num_ev = getevent(client1, &ev);
	if (num_ev != 1) {
		delete("Expecting a single SelectionClear event");
		report("Received %d events", num_ev);
		while(num_ev !=0) {
			trace("Event: %s", eventname(ev.type));
			num_ev = getevent(client1, &ev);
		}
		return;
	} else {
		XEvent good;
		good.type = SelectionClear;
		good.xselectionclear.type = SelectionClear;
		good.xselectionclear.selection = selection;
		good.xselectionclear.display = client1;
		good.xselectionclear.window = callwindow;
		good.xselectionclear.time = calltime;
		if (checkevent(&good, &ev)) {
			FAIL;
			report("%s did not set the selection as expected",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display *calldisplay, *client2, *client3;
Time calltime;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetSelectionOwner-2.(A)");
	report_assertion("When the specified time is earlier than the current");
	report_assertion("last-change time of the specified selection or is later than");
	report_assertion("the current server time, then a call to XSetSelectionOwner");
	report_assertion("has no effect.");

	report_strategy("Create two new clients.");
	report_strategy("Obtain current server time.");
	report_strategy("Call XSetSelectionOwner to assign the owner and time for the selection.");
	report_strategy("Call XSetSelectionOwner to assign the selection to a new client and owner");
	report_strategy("	with time before last change time.");
	report_strategy("Verify that no SelectionClear event occurred.");
	report_strategy("Call XSetSelectionOwner to assign the selection to a new client and owner");
	report_strategy("	with time after current server time.");
	report_strategy("Verify that no SelectionClear event occurred.");

	tpstartup();
	setargs();
/* Create two new clients. */
	client2 = opendisplay();
	if (client2 == (Display *)NULL) {
		delete("Could not open client2");
		return;
	} else
		CHECK;

	client3 = opendisplay();
	if (client3 == (Display *)NULL) {
		delete("Could not open client3");
		return;
	} else
		CHECK;

/* Obtain current server time. */
	calldisplay = display;
	calltime = gettime(display);

/* Call xname to assign the owner and time for the selection. */
	display = calldisplay;
	thetime = calltime;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call xname to assign the selection to a new client and owner */
/* 	with time before last change time. */
	display = client2;
	owner = defwin(client2);
	thetime = calltime-1;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that no SelectionClear event occurred. */
	num_ev = getevent(calldisplay, &ev);
	if (num_ev != 0) {
		FAIL;
		report("%s called with an earlier time changed the selection",
			TestName);
		trace("Expecting 0 events");
		trace("Received %d events", num_ev);
		do {
			trace("Event: %s", eventname(ev.type));
		} while(getevent(calldisplay, &ev));
	} else
			CHECK;

/* Call xname to assign the selection to a new client and owner */
/* 	with time after current server time. */
	display = client3;
	owner = defwin(client3);
	thetime = gettime(client3)+(Time)100000;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that no SelectionClear event occurred. */
	num_ev = getevent(calldisplay, &ev);
	if (num_ev != 0) {
		FAIL;
		report("%s called with an earlier time changed the selection",
			TestName);
		trace("Expecting 0 events");
		trace("Received %d events", num_ev);
		do {
			trace("Event: %s", eventname(ev.type));
		} while(getevent(calldisplay, &ev));
	} else
			CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display *client1, *client2;
Time calltime, rettime, maxtime;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetSelectionOwner-3.(A)");
	report_assertion("When time is CurrentTime, then a call to");
	report_assertion("XSetSelectionOwner sets the last-change time of the");
	report_assertion("specified selection to the current server time.");

	report_strategy("Create a new client.");
	report_strategy("Obtain current server time.");
	report_strategy("Call XSetSelectionOwner to assign the owner and time for the selection.");
	report_strategy("Call XSetSelectionOwner to clear the selection, to obtain selection time.");
	report_strategy("Verify that the correct SelectionClear event occurred.");
	report_strategy("Verify the time returned was within acceptable limits.");

	tpstartup();
	setargs();
/* Create a new client. */
	client1 = display;
	client2 = opendisplay();
	if (client2 == (Display *)NULL) {
		delete("Could not open client2");
		return;
	} else
		CHECK;

/* Obtain current server time. */
	calltime = gettime(client1);

/* Call xname to assign the owner and time for the selection. */
	thetime = CurrentTime;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call xname to clear the selection, to obtain selection time. */
	display = client2;
	thetime = CurrentTime;
	owner = None;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client1, False);

/* Verify that the correct SelectionClear event occurred. */
	num_ev = getevent(client1, &ev);
	if (num_ev != 1) {
		delete("Expecting a single SelectionClear event");
		report("Received %d events", num_ev);
		while(num_ev !=0) {
			trace("Event: %s", eventname(ev.type));
			num_ev = getevent(client1, &ev);
		}
		return;
	} else {
		if (ev.type != SelectionClear) {
			delete("Expecting a SelectionClear event");
			report("Returned a %s event", eventname(ev.type));
			return;
		} else
			CHECK;
	}

/* Verify the time returned was within acceptable limits. */
	rettime=ev.xselectionclear.time;
	maxtime=calltime+5000*config.speedfactor;
	trace("Obtained server time: %u", calltime);
	trace("Returned server time: %u", rettime);
	trace("Upper expected time : %u", maxtime);
	if((rettime<calltime) || (rettime>maxtime)) {
		FAIL;
		report("%s did not set last modified time of selection",
			TestName);
		report("to within reasonable bounds");
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetSelectionOwner-4.(A)");
	report_assertion("When the owner window is None, then a call to");
	report_assertion("XSetSelectionOwner sets the specified selection to have no");
	report_assertion("owner.");

	report_strategy("Call XSetSelectionOwner to set the owner for the selection.");
	report_strategy("Verify that the selection was set.");
	report_strategy("Call XSetSelectionOwner to set no owner for the selection.");
	report_strategy("Verify that the selection has no owner.");

	tpstartup();
	setargs();
/* Call xname to set the owner for the selection. */
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the selection was set. */
	if(XGetSelectionOwner(display, selection) != owner) {
		delete("A call to %s did not set the selection for the test",
			TestName);
		return;
	} else
		CHECK;

/* Call xname to set no owner for the selection. */
	thetime = CurrentTime;
	owner = None;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the selection has no owner. */
	if (XGetSelectionOwner(display, selection) != None) {
		FAIL;
		report("A call to %s with owner of None failed to set the",
			TestName);
		report("selection owner to None.");
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display *client1, *client2;
Time calltime;
Window  callwindow;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetSelectionOwner-5.(A)");
	report_assertion("When the specified selection has an owner, and the");
	report_assertion("specified owner is not the same as the current owner, then");
	report_assertion("on a call to XSetSelectionOwner the current owner is sent a");
	report_assertion("SelectionClear event.");

	report_strategy("Create one new client.");
	report_strategy("Call XSetSelectionOwner to assign the owner and time for the selection.");
	report_strategy("Call XSetSelectionOwner to assign the selection to a new owner.");
	report_strategy("Verify that the correct SelectionClear event occurred.");

	tpstartup();
	setargs();
/* Create a new client. */
	client1 = display;
	client2 = opendisplay();
	if (client2 == (Display *)NULL) {
		delete("Could not open client2");
		return;
	} else
		CHECK;

	calltime = gettime(client1);

/* Call xname to assign the owner and time for the selection. */
	callwindow = owner;
	thetime = calltime;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Call xname to assign the selection to a new owner. */
	display = client2;
	thetime = CurrentTime;
	owner = defwin(client2);
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client1, False);

/* Verify that the correct SelectionClear event occurred. */
	num_ev = getevent(client1, &ev);
	if (num_ev != 1) {
		delete("Expecting a single SelectionClear event");
		report("Received %d events", num_ev);
		while(num_ev !=0) {
			trace("Event: %s", eventname(ev.type));
			num_ev = getevent(client1, &ev);
		}
		return;
	} else {
		XEvent good;
		good.type = SelectionClear;
		good.xselectionclear.type = SelectionClear;
		good.xselectionclear.selection = selection;
		good.xselectionclear.display = client1;
		good.xselectionclear.window = callwindow;
		good.xselectionclear.time = calltime;
		if (checkevent(&good, &ev)) {
			FAIL;
			report("%s did not set the selection as expected",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display *client1, *client2;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetSelectionOwner-6.(A)");
	report_assertion("When the client that is the owner of a selection is");
	report_assertion("terminated, or the owner window is destroyed, then the");
	report_assertion("selection reverts to having no owner, and the last-change");
	report_assertion("time is unaffected.");

	report_strategy("Create a new client.");
	report_strategy("Call XSetSelectionOwner to assign the owner and time for the selection.");
	report_strategy("Close the connection for client2.");
	report_strategy("Allow time for the connection to close.");
	report_strategy("Verify that the ownership of the selection reverted to None.");
	report_strategy("Assign the selection to another window.");
	report_strategy("Close the window of the selection.");
	report_strategy("Verify that the ownership of the selection reverted to None.");

	tpstartup();
	setargs();
/* Create a new client. */
	client1 = display;
	client2 = XOpenDisplay(config.display); 
	if (client2 == (Display *)NULL) {
		delete("Could not open client2");
		return;
	} else
		CHECK;

/* Call xname to assign the owner and time for the selection. */
	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Close the connection for client2. */
	XCloseDisplay(client2);

/* Allow time for the connection to close. */
	reset_delay();

/* Verify that the ownership of the selection reverted to None. */
	if (XGetSelectionOwner(client1, selection) != None) {
		FAIL;
		report("Closing the owner client did not set the selection");
		report("owner to None.");
		return;
	} else
		CHECK;

/* Assign the selection to another window. */
	display = client1;
	owner = crechild(client1, defwin(client1), (struct area *)0);
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Close the window of the selection. */
	XDestroyWindow(client1, owner);

/* Verify that the ownership of the selection reverted to None. */
	if (XGetSelectionOwner(client1, selection) != None) {
		FAIL;
		report("Closing the owner window did not set the selection");
		report("owner to None.");
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.4072 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetSelectionOwner-7.(B)");
	report_assertion("The status of a selection atom is accessible by any client");
	report_assertion("of the server.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.4072 */

/* Including from file error/EAto.mc */
/* End of included file error/EAto.mc */

/* Including from file error/EAto.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetSelectionOwner-8.(A)");
	report_assertion("When an atom argument does not name a valid Atom, then a");
	report_assertion("BadAtom error occurs.");

	report_strategy("Call test function using a value with the top bits set as the atom argument.");
	report_strategy("Verify that a BadAtom error occurs.");

	tpstartup();
	setargs();
	A_ATOM = ~0L;
	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadAtom)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAto.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetSelectionOwner-9.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetSelectionOwner(display, selection, owner, thetime);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
