/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAddCallback()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
char client_stuff[] = "This is client data";
/*
** Callback procedure.
*/
void XtCBP1_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1, 1);
	tet_infoline("TEST: client_data passed correctly");
	if (client_data != NULL) {
		if (strcmp(client_data, client_stuff) != 0) {
			sprintf(ebuf, "ERROR: expected client_data of %s, received %s", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
	else {
		sprintf(ebuf, "ERROR: expected client_data of %s, received NULL", client_stuff);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}

/*
** Callback procedure
*/
void XtCBP2_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	avs_set_event(1, avs_get_event(1)+1);
	if (client_data != NULL) {
			avs_set_event(2, avs_get_event(2)+1);
		if (strcmp(client_stuff, client_data) != 0) {
			sprintf(ebuf, "ERROR: expected client_data of %s, received %s", client_stuff, client_data);
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
	}
}


#define T_XtAddCallback	1
char    *TestName = "XtAddCallback";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAddCallback-1.(A)");
	report_assertion("A successful call to void XtAddCallback(w, callback_name,");
	report_assertion("callback, client_data) shall add the procedure callback to");
	report_assertion("the widget w's callback list specified by callback_name.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadclback1", "XtAddCallback");
	tet_infoline("PREP: Create labelw_good widget in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a callback procedure to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP1_Proc,
			client_stuff
			);
	tet_infoline("PREP: Destroy labelw_good");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Check callback procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "Callback invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1516 */
/* End of included file Mdefcode.tmc.1516 */

static void t002(){

Widget labelw_good;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAddCallback-2.(A)");
	report_assertion("A successful call to void XtAddCallback(w, callback_name,");
	report_assertion("callback, client_data) shall cause client_data to be passed");
	report_assertion("to callback when it is invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadclback2", "XtAddCallback");
	tet_infoline("PREP: Create labelw_good widget in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a callback procedure to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP1_Proc,
			client_stuff
			);
	tet_infoline("PREP: Destroy labelw_good");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Check callback procedure was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "Callback invocations count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1516 */
/* End of included file Mdefcode.tmc.1516 */

static void t003(){

Widget labelw_good;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAddCallback-3.(A)");
	report_assertion("When callback has been added multiple times in a callback");
	report_assertion("list of a widget by calls to void XtAddCallback(w,");
	report_assertion("callback_name, callback, client_data) it shall be invoked as");
	report_assertion("many times as it occurs in the specified list.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tadclback3", "XtAddCallback");
	tet_infoline("PREP: Create labelw_good widget in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add callback procedure to labelw_good widget");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP2_Proc,
			(XtPointer)NULL
			);
	tet_infoline("PREP: Add it again");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP2_Proc,
			(XtPointer)NULL
			);
	tet_infoline("PREP: And again, now with some client_data");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCBP2_Proc,
			client_stuff
			);
	tet_infoline("TEST: Destroy labelw_good");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Callback was invoked three times, once with client_data");
	status = avs_get_event(1);
	check_dec(3, status, "times XtCBP2_Proc invoked");
	status = avs_get_event(2);
	check_dec(1, status, "times XtCBP2_Proc invoked with client_data");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1516 */
/* End of included file Mdefcode.tmc.1516 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
