/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   String
 *   XtFindFile()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

char *filepath	= "/test/path/";
char *string_good1 = "/test/path/:";
Boolean FindFile1(string)
String string;
{
	check_str(string_good1, string, "String passed to predicate");
	return(TRUE);
}

char *string_good2 = "/test/path/%";
Boolean FindFile2(string)
String string;
{
	check_str(string_good2, string, "String passed to predicate");
	return(TRUE);
}
char *string_good3_1 = "/test/path/128data1";
char *string_good3_2 = "/test/path/data1128";
Boolean FindFile3(string)
String string;
{
int count3;

	count3 = avs_get_event(1);

	if (count3 == 0) {
		tet_infoline("TEST: First string passed to predicate has substitutions");
		check_str(string_good3_1, string, "First string passed to predicate");
		avs_set_event(1, 1);
		tet_infoline("PREP: Return false for first string");
		return(FALSE);
	}
	if (count3 == 1) {
		tet_infoline("TEST: Second string passed to predicate has substitutions");
		check_str(string_good3_2, string, "Second string passed to predicate");
		avs_set_event(1, 2);
		tet_infoline("PREP: Return true for second string");
		return(TRUE);
	}
	sprintf(ebuf, "ERROR: path contained two strings but predicate called %d times", count3++);
	avs_set_event(1, count3);
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}

char *string_good5 = "/test/path/%";
Boolean FindFile5(string)
String string;
{
	return(FALSE);
}


#define T_XtFindFile	1
char    *TestName = "XtFindFile";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char path[1024];
SubstitutionRec sub[2];
Cardinal num_substitutions;
String str;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtFindFile-1.(A)");
	report_assertion("A successful call to String XtFindFile(path, substitutions,");
	report_assertion("num_substitutions, predicate) shall obtain each");
	report_assertion("colon-separated string from path, replace in this string");
	report_assertion("each occurrence of a percent character followed by a");
	report_assertion("character other than a ':' or '%' with the substitution");
	report_assertion("field of the structure in the list of substitutions");
	report_assertion("specified by substitutions that has the match field equal to");
	report_assertion("the character following the percent character, pass each");
	report_assertion("resulting string to the procedure predicate, until a a");
	report_assertion("string is found for which this procedure returns True, and");
	report_assertion("return this string.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile3", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	strcpy(path, filepath);
	strcat(path, "%d%s:");
	strcat(path, filepath);
	strcat(path, "%s%d");
	tet_infoline("TEST: Call XtFindFile with path containing two file names");
	sub[0].match = 's';
	sub[0].substitution = "data1";
	sub[1].match = 'd';
	sub[1].substitution = "128";
	str = XtFindFile(path, &sub[0], 2, FindFile3);
	if (str == NULL) {
		tet_infoline("ERROR: XtFindFile returned NULL");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Returned string is second path name after substitutions");
	check_str(string_good3_2, str, "String");
	LKROF(pid2, AVSXTTIMEOUT-2);
	if (avs_get_event(1) == 0) {
		tet_infoline("ERROR: predicate was never called");
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

static void t002(){

char path[1024];
SubstitutionRec sub[1];
Cardinal num_substitutions;
String str;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtFindFile-2.(A)");
	report_assertion("When no string in the colon-separated list of strings");
	report_assertion("specified by path yields a True return from the procedure");
	report_assertion("predicate a call to String XtFindFile(path, substitutions,");
	report_assertion("num_substitutions, predicate) shall return NULL.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile5", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	strcpy(path, filepath);
	strcat(path, "%s");
	tet_infoline("TEST: No match yields NULL");
	sub[0].match = 's';
	sub[0].substitution = "data1";
	str = XtFindFile(path, &sub[0], 1, FindFile5);
	if (str != NULL) {
		tet_infoline("ERROR: XtFindFile did not return NULL");
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

static void t003(){

char path[1024];
SubstitutionRec sub[1];
Cardinal num_substitutions;
String str;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtFindFile-3.(A)");
	report_assertion("A call to String XtFindFile(path, substitutions,");
	report_assertion("num_substitutions, predicate) shall replace each %:");
	report_assertion("sequences in path by a single colon before passing it to the");
	report_assertion("procedure predicate.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile1", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	strcpy(path, filepath);
	strcat(path, "%:");
	tet_infoline("TEST: Character sequence of percent colon replaced to colon");
	sub[0].match = 's';
	sub[0].substitution = "data1";
	str = XtFindFile(path, &sub[0], 1, FindFile1);
	if (str == NULL) {
		tet_infoline("ERROR: XtFindFile returned NULL");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Returned string");
	check_str(string_good1, str, "String");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

static void t004(){

char path[1024];
SubstitutionRec sub[1];
Cardinal num_substitutions;
String str;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtFindFile-4.(A)");
	report_assertion("A call to String XtFindFile(path, substitutions,");
	report_assertion("num_substitutions, predicate) shall replace each %%");
	report_assertion("sequences in path by a single percent character before");
	report_assertion("passing it to the procedure predicate.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile2", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	strcpy(path, filepath);
	strcat(path, "%%");
	tet_infoline("TEST: Character sequence percent precent replaced with percent");
	sub[0].match = 's';
	sub[0].substitution = "data1";
	str = XtFindFile(path, &sub[0], 1, FindFile2);
	if (str == NULL) {
		tet_infoline("ERROR: XtFindFile returned NULL");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Returned string");
	check_str(string_good2, str, "String");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

/* Including from file Mdefcode.tmc.3664 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtFindFile-5.(D)");
	report_assertion("If the operating system does not interpret multiple");
	report_assertion("embedded name separators in a path in the same way as a");
	report_assertion("single seperator: A call to String XtFindFile(path,");
	report_assertion("substitutions, num_substitutions, predicate) shall replace");
	report_assertion("multiple embedded name seperators in each string specified");
	report_assertion("by path with a single seperator character after all other");
	report_assertion("substitutions are made and before passing it to the");
	report_assertion("procedure predicate.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3664 */

static void t006(){

char path[1024];
SubstitutionRec sub[1];
Cardinal num_substitutions;
String str;
char string_good4[1024];
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtFindFile-6.(A)");
	report_assertion("When predicate is NULL a call to String XtFindFile(path,");
	report_assertion("substitutions, num_substitutions, predicate) shall return a");
	report_assertion("string specified in path that matches a file that is");
	report_assertion("readable and not a directory.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile4", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	if (getcwd(path, sizeof(path)-3) == NULL) {
		tet_infoline("ERROR: getcwd() returned NULL");
		tet_result(TET_UNRESOLVED);
		exit(0);
	}
	strcat(path, "/%s");
	tet_infoline("TEST: Character sequence percent character replaced by");
	tet_infoline("      corresponding match");
	sub[0].match = 's';
	sub[0].substitution = "data1";
	str = XtFindFile(path, &sub[0], 1, NULL);
	if (str == NULL) {
		tet_infoline("ERROR: XtFindFile returned NULL");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("PREP: Get data1 file path");
	if (getcwd(string_good4, sizeof(string_good4)-6) == NULL) {
		tet_infoline("ERROR: getcwd() returned NULL");
		tet_result(TET_UNRESOLVED);
		exit(0);
	}
	strcat(string_good4, "/data1");
	tet_infoline("TEST: Returned string");
	check_str(string_good4, str, "String");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

static void t007(){

char path[1024];
SubstitutionRec sub[1];
Cardinal num_substitutions;
String str;
pid_t pid2;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtFindFile-7.(A)");
	report_assertion("When predicate is NULL and no file that is readable, not a");
	report_assertion("directory and matches any of the specified file names in");
	report_assertion("path is found a call to String XtFindFile(path,");
	report_assertion("substitutions, num_substitutions, predicate) shall return");
	report_assertion("NULL.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tfindfile4", "XtFindFile");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get path name");
	if (getcwd(path, sizeof(path)-3) == NULL) {
		tet_infoline("ERROR: getcwd() returned NULL");
		tet_result(TET_UNRESOLVED);
		exit(0);
	}
	strcat(path, "/%s");
	tet_infoline("TEST: Call XtFindFile for non-existent file");
	sub[0].match = 's';
	sub[0].substitution = "data5";
	str = XtFindFile(path, &sub[0], 1, NULL);
	if (str != NULL) {
		tet_infoline("ERROR: XtFindFile did not return NULL");
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3664 */
/* End of included file Mdefcode.tmc.3664 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
