/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtVaAppCreateShell()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtVaAppCreateShell	1
char    *TestName = "XtVaAppCreateShell";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
String name_good, class_good;
XtAppContext app_ctext_good;
Widget topLevel_good;
Boolean status;
int argcount = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaAppCreateShell-1.(A)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) shall create");
	report_assertion("a top-level shell widget that is the root of a widget tree");
	report_assertion("with name as the shall widget instance name, associate it");
	report_assertion("with the display specified by the argument display, and");
	report_assertion("return the shell widget instance.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tvapcrshl1", "XtVaAppCreateShell");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Create application context app_ctext_good");
	app_ctext_good = XtCreateApplicationContext();
	tet_infoline("PREP: Open display and initialize toolkit for app_ctext_good");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"Hello",	 /* application name use argv[0] */
		"World",	 /* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal) 0,	 /* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	);
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create additional top level widget");
	topLevel_good = XtVaAppCreateShell("Hello", "World",
		 applicationShellWidgetClass, display_good,
		 (char *)NULL);
 
	tet_infoline("TEST: TopLevel_good widget class is applicationShell");
	status = XtIsApplicationShell(topLevel_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("PREP: Get the application name and class");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name and class");
	check_str("Hello", name_good, "Application Name");
	check_str("World", class_good, "Application Class");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.4056 */
/* End of included file Mdefcode.tmc.4056 */

static void t002(){

Display *display_good;
String name_good, class_good;
XtAppContext app_ctext_good;
Widget widget_good;
Widget rowcolw_good;
XTextProperty *text_prop;
Window window_good;
int argcount = 1;
Atom actual_type;
int actual_format;
unsigned long	num_elements;
long bytes_after;
unsigned char *property_data;
int status;
String argvector[] = { "tvapcrshl2", NULL };
Arg args[2] = {
	{ "XtNwidth", 100 },
	{ "XtNheight", 100 }
};
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaAppCreateShell-2.(A)");
	report_assertion("On a successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when");
	report_assertion("widget_class is ApplicationShell or a subclass thereof the");
	report_assertion("shell widget instance created shall have WM_COMMAND property");
	report_assertion("set from the values of the XtNargv and XtNargc resources.");
	FORK(pid);
	initconfig();

	tet_infoline("PREP: Initialize the X toolkit");
	XtToolkitInitialize();
	tet_infoline("PREP: Get application context");
	app_ctext_good = XtCreateApplicationContext();;
	tet_infoline("PREP: Set up the XtToolkitError handler");
	XtAppSetErrorMsgHandler(app_ctext_good, xt_handler);
	tet_infoline("PREP: Open display and initialize toolkit for app_ctext_good");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"tvapcrshl2",	 /* application name use argv[0] */
		"test",		/* application class */
		NULL, 0,		/* command line options */
		&argcount, argvector	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create top level widget");
	widget_good = XtVaAppCreateShell("tvapcrshl2", "test",
	 applicationShellWidgetClass, display_good, XtNheight, 100, XtNwidth, 100, XtNargc, argcount, XtNargv, argvector, NULL);
	tet_infoline("PREP: Create rowcol widget");
	rowcolw_good = (Widget) CreateRowColWidget(widget_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(widget_good);
	XSync(display_good, False);
	tet_infoline("TEST: WM_CLASS property is set");
	window_good = XtWindow(widget_good);
 
	tet_infoline("TEST: Window property values");
	status = XGetWindowProperty(display_good,
		window_good,
		XA_WM_CLASS,
		(long)0,
		(long)128,
		False,
		AnyPropertyType,
		&actual_type,
		&actual_format,
		&num_elements,
		(unsigned long *)&bytes_after,
		&property_data);
	check_dec(Success, status, "Return value");
	if ( actual_format == (int)0 ) {
		sprintf(ebuf, "ERROR: Expected actual format not zero");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if ( actual_type == (Atom)None) {
		sprintf(ebuf, "ERROR: Expected actual type None Received %d", actual_type);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	check_str("tvapcrshl2", (char *)property_data, "Class");
	tet_infoline("TEST: WM_COMMAND property is set");

	status = XGetWindowProperty(display_good,
		window_good,
		XA_WM_COMMAND,
		(long)0,
		(long)128,
		False,
		AnyPropertyType,
		&actual_type,
		&actual_format,
		&num_elements,
		(unsigned long *)&bytes_after,
		&property_data);
	check_dec(Success, status, "Return value");
	if ( actual_format == (int)0 ) {
		sprintf(ebuf, "ERROR: Expected actual format not zero");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (actual_type == (Atom)None) {
		sprintf(ebuf, "ERROR: Expected actual type not None Received %d", actual_type);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.4056 */
/* End of included file Mdefcode.tmc.4056 */

static void t003(){

Display *display_good;
String name_good, class_good;
XtAppContext app_ctext_good;
Widget topLevel_good;
Boolean status;
int argcount = 0;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaAppCreateShell-3.(A)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when name is");
	report_assertion("NULL shall name the shell widget instance with the");
	report_assertion("application name passed to XtDisplayInitialize.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tvapcrshl3", "XtVaAppCreateShell");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Create application context app_ctext_good");
	app_ctext_good = XtCreateApplicationContext();
	tet_infoline("PREP: Open display and initialize toolkit for app_ctext_good");
	sleep(config.reset_delay);
	display_good = XtOpenDisplay(
		app_ctext_good,	/* application context */
		(String)config.display,	 /* display name */
		"Tvapcrshl3",	 /* application name use argv[0] */
		"World",	 /* application class */
		(XrmOptionDescRec *)NULL,
		(Cardinal) 0,	 /* command line options */
		&argcount,
		(String *)NULL	/* command line args */
	 );
	if (display_good == 0) {
		tet_infoline("ERROR: Cannot open display");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_infoline("TEST: Create additional top level widget");
	topLevel_good = XtVaAppCreateShell(NULL, "World",
		 applicationShellWidgetClass, display_good,
		 (char *)NULL);
	tet_infoline("TEST: TopLevel_good widget class is applicationShell");
	status = XtIsApplicationShell(topLevel_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("PREP: Get the application name and class");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name");
	check_str("Tvapcrshl3", name_good, "Application Name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.4056 */
/* End of included file Mdefcode.tmc.4056 */

/* Including from file Mdefcode.tmc.4056 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtVaAppCreateShell-4.(B)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when the");
	report_assertion("resource arguments specify XtNscreen shall create the");
	report_assertion("resource database for the shell widget using the resource");
	report_assertion("arguments specified in varargs style and the resource values");
	report_assertion("from the resource database of the screen specified in the");
	report_assertion("XtNscreen argument for those resources not specified in the");
	report_assertion("resource arguments.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.4056 */

/* Including from file Mdefcode.tmc.4056 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtVaAppCreateShell-5.(B)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when the");
	report_assertion("resource arguments do not specify XtNscreen, widget_class is");
	report_assertion("applicationShellWidgetClass or a subclass thereof, and the");
	report_assertion("resource database of the default screen for display");
	report_assertion("specifies the resource name.screen, class");
	report_assertion("application_class.screen shall create the resource database");
	report_assertion("for the shell widget using the resource arguments and the");
	report_assertion("resource values from the resource database of the screen");
	report_assertion("specified in the resource database of the default screen for");
	report_assertion("those resources not specified in the resource arguments.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.4056 */

/* Including from file Mdefcode.tmc.4056 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtVaAppCreateShell-6.(B)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when the");
	report_assertion("resource arguments do not specify XtNscreen, widget_class is");
	report_assertion("not applicationShellWidgetClass or a subclass thereof, and");
	report_assertion("the resource database of the default screen for display");
	report_assertion("specifies the resource name.screen, class Class.screen,");
	report_assertion("where Class is the class_name field from CoreClassPart of");
	report_assertion("widget_class, shall create the resource database for the");
	report_assertion("shell widget using the resource arguments and the resource");
	report_assertion("values from the resource database of the screen specified in");
	report_assertion("the resource database of the default screen for those");
	report_assertion("resources not specified in the resource arguments.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.4056 */

/* Including from file Mdefcode.tmc.4056 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtVaAppCreateShell-7.(B)");
	report_assertion("A successful call to Widget XtVaAppCreateShell(name,");
	report_assertion("application_class, widget_class, display,...) when the");
	report_assertion("resource arguments do not specify XtNscreen and the resource");
	report_assertion("database of the default screen for display does not specify");
	report_assertion("the resource name.screen, class application_class.screen");
	report_assertion("shall create the resource database for the shell widget");
	report_assertion("using the resource arguments and the resource values from");
	report_assertion("the resource database of the default screen for those");
	report_assertion("resources not specified in the resource arguments.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.4056 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
