/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtSetMappedWhenManaged()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Window window;

static void analyse_events2(quit)
Widget quit;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	XEvent return_event;
	Widget widget;
	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
	 if (loop_event.type == UnmapNotify) {
		if (loop_event.xany.window == window) {
			avs_set_event(1,1);
			exit(0);
		}
	 }
	} /* end for */
}

static void analyse_events(quit)
Widget quit;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	XEvent return_event;
	Widget widget;
	widget = XtParent(quit);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
	if (loop_event.type == MapNotify) {
		if (loop_event.xany.window == window) {
			avs_set_event(1,1);
			exit(0);
		}
	}
	 XtDispatchEvent(&loop_event);
	} /* end for */
}


#define T_XtSetMappedWhenManaged	1
char    *TestName = "XtSetMappedWhenManaged";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_msg;
char *msg = "Test widget";
Boolean value;
Arg args[1];
Display *display;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetMappedWhenManaged-1.(A)");
	report_assertion("When the widget w is realized, managed, and");
	report_assertion("map_when_managed is set to True a successful call to void");
	report_assertion("XtSetMappedWhenManaged(w, map_when_managed) shall map the");
	report_assertion("widget window.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tstmpwmng1", "XtSetMappedWhenManaged");
	tet_infoline("PREP: Create labelw_msg in box1w");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("TEST: Set mapped_when_managed to True");
	XtSetMappedWhenManaged(labelw_msg, False);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch MapNotify event");
	display = XtDisplay(labelw_msg);
	window = XtWindow(labelw_msg);
	XSelectInput(display, window, (unsigned long)StructureNotifyMask);
	tet_infoline("PREP: Unmap labelw_msg widget");
	XtUnmapWidget(labelw_msg);
	tet_infoline("TEST: Set mapped_when_managed to True");
	XtSetMappedWhenManaged(labelw_msg, True);
	FORK(pid2);
	tet_infoline("TEST: MapNotify event was generated for widget");
	analyse_events(click_quit);
	KROF(pid2);
	kill(pid2, SIGKILL);
	status = avs_get_event(1);
	check_dec(1, status, "MapNotify event count");
	tet_infoline("TEST: Resource value XtNmappedWhenManaged is True.");
	args[0].name = XtNmappedWhenManaged;
	XtVaGetValues(labelw_msg, XtNmappedWhenManaged, &value, (char *)NULL);
	check_dec(True, value, "XtNmappedWhenManaged");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2608 */
/* End of included file Mdefcode.tmc.2608 */

static void t002(){

Widget labelw_msg;
char *msg = "Test widget";
Boolean value;
Display *display;
int status = 0;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetMappedWhenManaged-2.(A)");
	report_assertion("When the widget w is realized, managed, and");
	report_assertion("map_when_managed is set to False a successful call to void");
	report_assertion("XtSetMappedWhenManaged(w, map_when_managed) shall unmap the");
	report_assertion("widget window.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tstmpwmng2", "XtSetMappedWhenManaged");
	tet_infoline("PREP: Create labelw_msg in box1w");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Catch MapNotify event");
	display = XtDisplay(labelw_msg);
	window = XtWindow(labelw_msg);
	XSelectInput(display, window, (unsigned long)StructureNotifyMask);
	tet_infoline("TEST Set mapped_when_managed to False");
	XtSetMappedWhenManaged(labelw_msg, False);
	FORK(pid2);
	tet_infoline("TEST: UnmapNotify event was generated for widget");
	analyse_events2(click_quit);
	KROF(pid2);
	kill(pid2, SIGKILL);
	status = avs_get_event(1);
	check_dec(1, status, "UnmapNotify event count");
	tet_infoline("TEST: Resource value XtNmappedWhenManaged is False.");
	XtVaGetValues(labelw_msg, XtNmappedWhenManaged, &value, (char *)NULL);
	check_dec(False, value, "XtNmappedWhenManaged");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2608 */
/* End of included file Mdefcode.tmc.2608 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
