/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtGeometryResult
 *   XtMakeGeometryRequest()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

/*
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
*/
#include <AvsForm.h>
#include <AvsForm2.h>
#include <AvsForm3.h>

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
        avs_set_event(1,1);
}

Widget labelw_msg1;

XtWidgetGeometry intended5;
XtWidgetGeometry geom5;

/*destroy callback for test 5*/
void XtCBP(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	XtGeometryResult result;
	XtWidgetGeometry request;
	XtWidgetGeometry reply_return;

	tet_infoline("INFO: Inside destroy callback");
        avs_set_event(2,1);
	tet_infoline("PREP: Change geometry of labelw_msg1 widget");
	request.request_mode = intended5.request_mode;
	request.x = geom5.x + 10;
	request.y = geom5.y + 10;
	request.width = geom5.width + 10;
	request.height = geom5.height + 10;
	request.border_width = geom5.border_width + 1;
	result = XtMakeGeometryRequest(labelw_msg1, &request, &reply_return);
	tet_infoline("TEST: Return value is XtGeometryNo");
	check_dec(XtGeometryNo, result, "XtGeometryNo");
}

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Logo.h>
extern WidgetClass avsCompWidgetClass, avsWidgetClass;


#define T_XtMakeGeometryRequest	1
char    *TestName = "XtMakeGeometryRequest";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget rowcolw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMakeGeometryRequest-1.(A)");
	report_assertion("When the widget w is unmanaged a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall change");
	report_assertion("those geometry fields in the widget that are specified in");
	report_assertion("the request_mode member of the structure pointed to by");
	report_assertion("request to the corresponding values specified in other");
	report_assertion("members of the structure and return XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create rowcolw widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("TEST: Change geometry of unmanaged widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(rowcolw_good, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x + 10;
	request.y = geom.y + 10;
	request.width = geom.width + 10;
	request.height = geom.height + 10;
	request.border_width = geom.border_width + 1;
	result = XtMakeGeometryRequest(rowcolw_good, &request, &reply_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t002(){

Widget rowcolw_good;
XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMakeGeometryRequest-2.(A)");
	report_assertion("When the parent of the widget w is not realized a call to");
	report_assertion("XtGeometryResult XtMakeGeometryRequest(w, request,");
	report_assertion("reply_return) shall change those geometry fields in the");
	report_assertion("widget that are specified in the request_mode member of the");
	report_assertion("structure pointed to by request to the corresponding values");
	report_assertion("specified in other members of the structure and return");
	report_assertion("XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("TEST: Change geometry of unrealized widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Change geometry of rowcolw_good widget, parent widget");
	tet_infoline("PREP: unrealized.");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(rowcolw_good, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x + 10;
	request.y = geom.y + 10;
	request.width = geom.width + 10;
	request.height = geom.height + 10;
	request.border_width = geom.border_width + 1;
	result = XtMakeGeometryRequest(rowcolw_good, &request, &reply_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t003(){

Widget labelw_good, labelw_good2;
XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMakeGeometryRequest-3.(A)");
	report_assertion("When the class of the parent of the widget w is not a");
	report_assertion("subclass of compositeWidgetClass a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall issue");
	report_assertion("an invalidParent error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt6", "XtMakeGeometryRequest");
        XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
        tet_infoline("PREP: Create core class test widgets");
        labelw_good = XtVaCreateWidget(
                        "labelw_good",
                        coreWidgetClass,
                        boxw1,
                        NULL
                        );
        labelw_good2 = XtVaCreateWidget(
                        "labelw_good2",
                        coreWidgetClass,
                        labelw_good,
                        NULL
                        );
        ConfigureDimension(topLevel, labelw_good);
        ConfigureDimension(topLevel, labelw_good2);
	tet_infoline("TEST: Call XtMakeGeometryRequest");
	result = XtMakeGeometryRequest(labelw_good2, &request, &reply_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Error handler was invoked");
        invoked = avs_get_event(1);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Error handler was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t004(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtMakeGeometryRequest-4.(A)");
	report_assertion("When the geometry_manager field of the parent of the widget");
	report_assertion("w is NULL a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall issue");
	report_assertion("an invalidGeometryManager error.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
        XtAppSetErrorMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create avsform3 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform3",
			avsform3WidgetClass,
			boxw1,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change geometry of labelw_good widget");
	request.request_mode = 0;
	request.x = 0;
	request.y = 0;
	request.width = 0;
	request.height = 0;
	request.border_width = 0;
	result = XtMakeGeometryRequest(labelw_good, &request, &reply_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Error handler was invoked");
        invoked = avs_get_event(1);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Error handler was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t005(){

Widget labelw_msg;
char *msg = "Test widget";
pid_t pid2;
int	invoked;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtMakeGeometryRequest-5.(A)");
	report_assertion("When the being_destroyed field of the widget w is True a");
	report_assertion("call to XtGeometryResult XtMakeGeometryRequest(w, request,");
	report_assertion("reply_return) shall return XtGeometryNo.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

        avs_set_event(2,0);
	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create label widget in boxw1 widget");
	labelw_msg1 = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add destroy callback procedure to labelw_msg1");
	XtAddCallback(labelw_msg1,
			XtNdestroyCallback,
			XtCBP,
			(XtPointer)NULL
			);
	tet_infoline("PREP: Get current geometry and destroy widget");
	intended5.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(labelw_msg1, &intended5, &geom5);
	XtDestroyWidget(labelw_msg1);
        LKROF(pid2, AVSXTTIMEOUT-2);
        invoked = avs_get_event(2);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Destroy callback was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        } else
		tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t006(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget rowcolw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtMakeGeometryRequest-6.(A)");
	report_assertion("When the fields x, y, width, height, and the border_width");
	report_assertion("of the widget w are all equal to their corresponding values");
	report_assertion("in request a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall return");
	report_assertion("XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create rowcolw widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("TEST: Do not change geometry of unmanaged widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(rowcolw_good, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x;
	request.y = geom.y;
	request.width = geom.width;
	request.height = geom.height;
	request.border_width = geom.border_width;
	result = XtMakeGeometryRequest(rowcolw_good, &request, &reply_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t007(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtMakeGeometryRequest-7.(A)");
	report_assertion("When at least one of x, y, width, height or the");
	report_assertion("border_width field of the widget w is not equal to its");
	report_assertion("corresponding value in request a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall call");
	report_assertion("the geometry_manager procedure of the specified widget's");
	report_assertion("parent passing request and reply_return as arguments to it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create avsform widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform",
			avsformWidgetClass,
			boxw1,
			NULL,
			0);
	tet_infoline("PREP: Create avsform2 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			formw_good,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change geometry of avsform2 widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(formw_good2, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x + 10;
	request.y = geom.y + 10;
	request.width = geom.width + 10;
	request.height = geom.height + 10;
	request.border_width = geom.border_width + 1;
	result = XtMakeGeometryRequest(formw_good2, &request, &reply_return);
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Parent's Geometry manager was invoked");
        invoked = avs_get_event(5);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Geometry manager was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

/* Including from file Mdefcode.tmc.2160 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtMakeGeometryRequest-8.(B)");
	report_assertion("On a call to XtGeometryResult XtMakeGeometryRequest(w,");
	report_assertion("request, reply_return) when the widget w is realized, at");
	report_assertion("least one of x, y, width, height or the border_width field");
	report_assertion("of the widget is not equal to its corresponding value in");
	report_assertion("request, and the call to the geometry_manager procedure of");
	report_assertion("the widget's parent returns XtGeometryYes with");
	report_assertion("request->request_mode set to a value other than");
	report_assertion("XtCWQueryOnly it shall call the XConfigureWindow Xlib");
	report_assertion("function.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2160 */

static void t009(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget formw_good, formw_good2, labelw_good;
pid_t pid2;
int invoked;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtMakeGeometryRequest-9.(A)");
	report_assertion("A call to XtGeometryResult XtMakeGeometryRequest(w,");
	report_assertion("request, reply_return) when the widget w is realized, at");
	report_assertion("least one of x, y, width, height or the border_width field");
	report_assertion("of the widget is not equal to its corresponding value in");
	report_assertion("request, and the call to the geometry_manager procedure of");
	report_assertion("the widget's parent returns XtGeometryDone shall return");
	report_assertion("XtGeometryYes.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create avsform widget in boxw1 widget");
	formw_good = XtCreateManagedWidget("avsform",
			avsformWidgetClass,
			boxw1,
			NULL,
			0);
	tet_infoline("PREP: Create avsform2 widget in avsform widget");
	formw_good2 = XtCreateManagedWidget("avsform2",
			avsform2WidgetClass,
			formw_good,
			NULL,
			0);
	labelw_good = (Widget) CreateLabelWidget("Hello", formw_good2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Change geometry of avsform2 widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(formw_good2, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x + 10;
	request.y = geom.y + 10;
	request.width = geom.width + 10;
	request.height = geom.height + 10;
	request.border_width = geom.border_width + 1;
	/*this forces the avsForm (parent) widget's geometry manager to
	return XtMakeGeometryDone*/
	avs_set_event(5, 77);
	result = XtMakeGeometryRequest(formw_good2, &request, &reply_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_infoline("TEST: Parent's Geometry manager was invoked");
        invoked = avs_get_event(5);
        if (!invoked) {
                sprintf(ebuf, "ERROR: Geometry manager was not invoked");
                tet_infoline(ebuf);
                tet_result(TET_FAIL);
        }
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

static void t010(){

XtWidgetGeometry request;
XtWidgetGeometry reply_return;
XtWidgetGeometry intended, geom;
XtGeometryResult result;
Widget rowcolw_good;
pid_t pid2;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtMakeGeometryRequest-10.(A)");
	report_assertion("A call to XtGeometryResult XtMakeGeometryRequest(w,");
	report_assertion("request, reply_return) when the widget w is realized, at");
	report_assertion("least one of x, y, width, height or the border_width field");
	report_assertion("of the widget is not equal to its corresponding value in");
	report_assertion("request, and the call to the geometry_manager procedure of");
	report_assertion("the the widget's parent neither returns XtGeometryYes with");
	report_assertion("request->request_mode set to a value other than");
	report_assertion("XtCWQueryOnly nor returns XtGeometryDone shall return what");
	report_assertion("the geometry_manager procedure returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tmkgmreqt1", "XtMakeGeometryRequest");
	tet_infoline("PREP: Create rowcolw widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("TEST: Change geometry of unmanaged widget");
	intended.request_mode = CWX|CWY|CWWidth|CWHeight|CWBorderWidth;
	XtQueryGeometry(rowcolw_good, &intended, &geom);
	request.request_mode = intended.request_mode;
	request.x = geom.x + 10;
	request.y = geom.y + 10;
	request.width = geom.width + 10;
	request.height = geom.height + 10;
	request.border_width = geom.border_width + 1;
	result = XtMakeGeometryRequest(rowcolw_good, &request, &reply_return);
	tet_infoline("TEST: return value is XtGeometryYes");
	check_dec(XtGeometryYes, result, "XtMakeGeometryRequest result");
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.2160 */
/* End of included file Mdefcode.tmc.2160 */

/* Including from file Mdefcode.tmc.2160 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtMakeGeometryRequest-11.(B)");
	report_assertion("When reply_return is NULL a call to XtGeometryResult");
	report_assertion("XtMakeGeometryRequest(w, request, reply_return) shall not");
	report_assertion("return XtGeometryAlmost.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.2160 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
