/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtMainLoop()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

extern char *event_names[];

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget labelw_msg;
XtInputId input_ret;
char *msg = "Hello World";
FILE *fid;

/*
** XtEVT_Proc
*/
void XtEVT_Proc(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
	if ( event->type == ButtonPress )
		avs_set_event(1, 1); 
	else {
		sprintf(ebuf, "ERROR: Expected ButtonPress event Received \"%s\"", event_names[event->type]);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
}
void XtEVT_Proc2(w, client_data, event, continue_to_dispatch)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean *continue_to_dispatch;
{
XKeyEvent *tevent;

	tevent = (XKeyEvent *)event;

	tet_infoline("TEST: Event timestamp returned by XtLastTimestampProcessed");
	if (tevent->time != XtLastTimestampProcessed(XtDisplay(w))) {
		sprintf(ebuf, "ERROR: event->time = %ld, XtLastTimestampProcessed returned %ld", (unsigned long)tevent->time, (unsigned long)XtLastTimestampProcessed(XtDisplay(w)));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (event->type == ButtonPress )
		avs_set_event(1, 1); 
	if (event->type == ButtonRelease )
		avs_set_event(2, 1); 
	if (event->type == KeyPress )
		avs_set_event(3, 1); 
	if (event->type == KeyRelease )
		avs_set_event(4, 1); 
}
/*
** XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(2, 1); 
	exit(0);
}

void XtTMO_Proc2(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send ButtonPress event");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
}
void XtTMO_Proc5(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Send events");
	send_event_time(labelw_msg, ButtonPress, ButtonPressMask, TRUE, 1);
	send_event_time(labelw_msg, ButtonRelease, ButtonReleaseMask, TRUE, 2);
	send_event_time(labelw_msg, KeyRelease, KeyReleaseMask, TRUE, 3);
	send_event_time(labelw_msg, KeyPress, KeyPressMask, TRUE, 4);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
}
/*
** Procedure XtIOP_Proc
*/
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(3,avs_get_event(3)+1);
	tet_infoline("TEST: InputID passed to callback matches return from XtAddInput");
	if (*id != input_ret) {
		sprintf(ebuf, "ERROR: InputId passed to callback was %#x, InputId returned by XtAddInput was %#x, should be identical", id, input_ret);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Source passed to callback matches that passed to XtAddInput");
	if (*source != fileno(fid)) {
		sprintf(ebuf, "ERROR: Source passed to callback was %#x, source passed to XtAddInput was %#x, should be identical", *source, fileno(fid));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client data passed to callback matches that passed to XtAddInput");
	if (strncmp(client_data, msg, sizeof(msg)) != 0) {
		sprintf(ebuf, "ERROR: Client_data passed to callback was \"%s\", Client_data passed to XtAddInput was \"%s\", should be identical", client_data, msg);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}


#define T_XtMainLoop	1
char    *TestName = "XtMainLoop";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtMainLoop-1.(A)");
	report_assertion("A successful call to void XtMainLoop() shall perform an");
	report_assertion("infinite loop that reads an incoming X event for the calling");
	report_assertion("process and calls the registered event handler procedure for");
	report_assertion("the widget to which the event is dispatched and not return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tmainloop1", "XtMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Send ButtonPress event");
	send_event(labelw_msg, ButtonPress, ButtonPressMask, FALSE);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Call XtMainLoop");
	FORK(pid2);
	XtMainLoop();
	tet_infoline("ERROR: XtMainLoop returned");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: ButtonPress event was received");
		invoked = avs_get_event(1);
		if(!invoked) {
			sprintf(ebuf, "ERROR: XtMainLoop() did not process ButtonPress event");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3540 */
/* End of included file Mdefcode.tmc.3540 */

static void t002(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtMainLoop-2.(A)");
	report_assertion("When there are no events in the X input queue of the");
	report_assertion("calling process a call to void XtMainLoop() shall flush the");
	report_assertion("X output buffers of each display in the calling process and");
	report_assertion("wait until an event from the X server is available.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tmainloop1", "XtMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask,
		 False,
		 XtEVT_Proc,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure which will cause event");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc2, topLevel);
	tet_infoline("TEST: XtMainLoop waits for event");
	FORK(pid2);
	XtMainLoop();
	tet_infoline("ERROR: XtMainLoop returned");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: ButtonPress event was received");
		invoked = avs_get_event(1);
		if(!invoked) {
			sprintf(ebuf, "ERROR: XtMainLoop() did not process ButtonPress event");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3540 */
/* End of included file Mdefcode.tmc.3540 */

static void t003(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtMainLoop-3.(A)");
	report_assertion("When a timeout occurs in the calling process on a call to");
	report_assertion("void XtMainLoop() while it is blocked to read an event from");
	report_assertion("the queue the designated timeout callback procedure shall be");
	report_assertion("called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tmainloop1", "XtMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Call XtMainLoop");
	FORK(pid2);
	XtMainLoop();
	tet_infoline("ERROR: XtMainLoop returned");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Timeout procedure was invoked");
		invoked = avs_get_event(2);
		if(!invoked) {
			sprintf(ebuf, "ERROR: XtMainLoop() did not invoke timeout procedure");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3540 */
/* End of included file Mdefcode.tmc.3540 */

static void t004(){

pid_t pid2;
int invoked = 0;
pid_t pid3;
int pstatus;
const char *data;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtMainLoop-4.(A)");
	report_assertion("When an input from a source occurs in the calling process");
	report_assertion("on a call to void XtMainLoop() while it is blocked to read");
	report_assertion("an event from the queue the designated input source callback");
	report_assertion("procedure shall be called.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = outfile("data1");
	FORK(pid3);
	avs_xt_hier_def("Tmainloop1", "XtMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file \"%s\" for read", data);
	tet_infoline(ebuf);
	if (( fid = (FILE *)fopen(data, "w+")) == NULL ) {
		sprintf(ebuf, "ERROR: Could not open file \"%s\"", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Register file as an input source");
	input_ret = XtAddInput(fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	FORK(pid2);
	tet_infoline("TEST: Call XtMainLoop");
	XtMainLoop();
	tet_infoline("ERROR: XtMainLoop returned");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	unlink(data);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Input procedure was invoked");
		invoked = avs_get_event(3);
		if(!invoked) {
			sprintf(ebuf, "ERROR: XtMainLoop() did not invoke input procedure");
			tet_infoline(ebuf);
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3540 */
/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtMainLoop-5.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtMainLoop() when an event obtained from the input queue");
	report_assertion("caused a server keyboard grab for a widget in the calling");
	report_assertion("process and an input method has been registered on this");
	report_assertion("event for the widget it shall cancel the grab and not call");
	report_assertion("the event handler procedure registered for the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtMainLoop-6.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtMainLoop() when an event obtained from the input queue");
	report_assertion("caused a server pointer grab for a widget in the calling");
	report_assertion("process and an input method has been registered on this");
	report_assertion("event for the widget it shall cancel the grab and not call");
	report_assertion("the event handler procedure registered for the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

static void t007(){

char *msg = "Event widget";
pid_t pid2;
int invoked = 0;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtMainLoop-7.(A)");
	report_assertion("On a call to void XtMainLoop() when an event read from the");
	report_assertion("incoming event queue for the calling process is a KeyPress,");
	report_assertion("KeyRelease, ButtonPress, ButtonRelease, MotionNotify,");
	report_assertion("EnterNotify, LeaveNotify, PropertyNotify or SelectionClear");
	report_assertion("event it shall record the timestamp from the event as the");
	report_assertion("last timestamp value that will be returned by the next call");
	report_assertion("to XtLastTimestampProcessed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tmainloop1", "XtMainLoop");
	tet_infoline("PREP: Create a test labelw_msg widget");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Register XtEVT_Proc2 to handle events to labelw_msg");
	XtAddEventHandler(labelw_msg,
		 ButtonPressMask|ButtonReleaseMask|KeyPressMask|KeyReleaseMask,
		 False,
		 XtEVT_Proc2,
		 (Widget)topLevel
		 );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure which will cause event");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO_Proc5, topLevel);
	tet_infoline("TEST: XtMainLoop waits for event");
	FORK(pid2);
	XtMainLoop();
	tet_infoline("ERROR: XtMainLoop returned");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: Events were received");
		invoked = avs_get_event(1);
		check_dec(1, invoked, "Handler invocation for ButtonPress count");
		invoked = avs_get_event(2);
		check_dec(1, invoked, "Handler invocation for ButtonRelease count");
		invoked = avs_get_event(3);
		check_dec(1, invoked, "Handler invocation for KeyPress count");
		invoked = avs_get_event(4);
		check_dec(1, invoked, "Handler invocation for KeyRelease count");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3540 */
/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtMainLoop-8.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtMainLoop() when an event read from the incoming event");
	report_assertion("queue for the calling process is a remap event, a modal");
	report_assertion("cascade exists that has a widget with spring_loaded field");
	report_assertion("set to True, and no event input filter has been registered");
	report_assertion("for the spring-loaded widget window on the specified event");
	report_assertion("it shall dispatch the event to the spring-loaded widget");
	report_assertion("following a dispatch to the widget to which the event");
	report_assertion("belonged.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtMainLoop-9.(D)");
	report_assertion("If the implementation is X11R5 or later: On a call to void");
	report_assertion("XtMainLoop() when an event read from the incoming event");
	report_assertion("queue is a remap event, a modal cascade exists that has a");
	report_assertion("widget with spring_loaded field set to True, and an event");
	report_assertion("input filter has been registered for the spring-loaded");
	report_assertion("widget window on the specified event it shall not dispatch");
	report_assertion("the event to the spring-loaded widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtMainLoop-10.(B)");
	report_assertion("When a widget in the calling process has the widget class");
	report_assertion("field compress_motion set to True a call to void");
	report_assertion("XtMainLoop() shall dispatch only the last motion event when");
	report_assertion("there are successive motion events pending for the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtMainLoop-11.(B)");
	report_assertion("When a widget in the calling process has the widget class");
	report_assertion("field compress_enterleave set to True a call to void");
	report_assertion("XtMainLoop() shall not dispatch pairs of enter and leave");
	report_assertion("events that have no intervening events to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtMainLoop-12.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeNoCompress flag set in its widget class field");
	report_assertion("compress_exposure a call to void XtMainLoop() shall cause");
	report_assertion("every exposure event for the specified widget to be");
	report_assertion("dispatched individually to its expose procedure with the");
	report_assertion("region argument set to NULL.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtMainLoop-13.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressSeries flag set in its widget class field");
	report_assertion("compress_exposure, a call to void XtMainLoop() shall cause");
	report_assertion("each series of exposure events for the specified widget to");
	report_assertion("be coalesced into a single event and dispatched to its");
	report_assertion("expose procedure when an exposure event with count equal to");
	report_assertion("zero occurs.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtMainLoop-14.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMultiple flag set in its widget class field");
	report_assertion("compress_exposure a call to void XtMainLoop() shall cause");
	report_assertion("consecutive series of exposure events for the specified");
	report_assertion("widget to be coalesced into a single event and dispatched to");
	report_assertion("its expose procedure when an exposure event whose count");
	report_assertion("equal to zero is encountered and either the event queue is");
	report_assertion("empty or the next event is not an exposure event for the");
	report_assertion("specified widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtMainLoop-15.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMaximal flag set in its widget class field");
	report_assertion("compress_exposure a call to void XtMainLoop() shall cause");
	report_assertion("all series of exposure events in the queue for the specified");
	report_assertion("widget to be coalesced into a single event without regard to");
	report_assertion("intervening non-exposure events and dispatched to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t016(){

pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtMainLoop-16.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeNoCompress and the XtExposeGraphicsExpose flags set");
	report_assertion("in its widget class field compress_exposure a call to void");
	report_assertion("XtMainLoop() shall cause all GraphicsExpose events for the");
	report_assertion("specified widget to be dispatched individually to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtMainLoop-17.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressSeries and the XtExposeGraphicsExpose flags");
	report_assertion("set in its widget class field compress_exposure a call to");
	report_assertion("void XtMainLoop() shall cause each series of GraphicsExpose");
	report_assertion("events for the specified widget to be coalesced into a");
	report_assertion("single event and dispatched to its expose procedure when a");
	report_assertion("GraphicsExpose event whose count is equal to zero is");
	report_assertion("encountered.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtMainLoop-18.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMultiple and the XtExposeGraphicsExpose");
	report_assertion("flags set in its widget class field compress_exposure a call");
	report_assertion("to void XtMainLoop() shall cause consecutive series of");
	report_assertion("GraphicsExpose events for the specified widget to be");
	report_assertion("coalesced into a single event and dispatched to its expose");
	report_assertion("procedure when a GraphicsExpose event whose count is equal");
	report_assertion("to zero is encountered and either the event queue is empty");
	report_assertion("or the next event is not an GraphicsExpose event for the");
	report_assertion("specified widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t019(){

pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtMainLoop-19.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMaximal and the XtExposeGraphicsExpose flags");
	report_assertion("set in its widget class field compress_exposure a call to");
	report_assertion("void XtMainLoop() shall cause all series of GraphicsExpose");
	report_assertion("events in the queue for the specified widget to be coalesced");
	report_assertion("into a single event without regard to intervening");
	report_assertion("non-GraphicsExpose events and dispatched to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t020(){

pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtMainLoop-20.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeNoCompress and the XtExposeGraphicsExposeMerged");
	report_assertion("flags set in its widget class field compress_exposure a call");
	report_assertion("to void XtMainLoop() shall cause all exposure and");
	report_assertion("GraphicsExpose events for the specified widget to be");
	report_assertion("dispatched individually to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t021(){

pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtMainLoop-21.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressSeries and the XtExposeGraphicsExposeMerged");
	report_assertion("flags set in its widget class field compress_exposure a call");
	report_assertion("to void XtMainLoop() shall cause each series of exposure and");
	report_assertion("GraphicsExpose events for the widget to be coalesced into a");
	report_assertion("single event and dispatched to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t022(){

pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtMainLoop-22.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMultiple and the");
	report_assertion("XtExposeGraphicsExposeMerged flags set in its widget class");
	report_assertion("field compress_exposure a call to void XtMainLoop() shall");
	report_assertion("cause consecutive series of exposure and GraphicsExpose");
	report_assertion("events for the specified widget to be coalesced into a");
	report_assertion("single event and dispatched to its expose procedure when an");
	report_assertion("exposure and a GraphicsExpose event with count equal to zero");
	report_assertion("are encountered and either the event queue is empty or the");
	report_assertion("next event is neither an exposure nor a GraphicsExpose event");
	report_assertion("for the specified widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t023(){

pid_t	pid;

 	report_purpose(23);

	report_assertion("Assertion XtMainLoop-23.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeCompressMaximal and the XtExposeGraphicsExposeMerged");
	report_assertion("flags set in its widget class field compress_exposure a call");
	report_assertion("to void XtMainLoop() shall cause all series of exposure and");
	report_assertion("GraphicsExpose events in the queue for the specified widget");
	report_assertion("to be coalesced into a single event without regard to");
	report_assertion("intervening non-exposure and non-GraphicsExpose events and");
	report_assertion("dispatched to its expose procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t024(){

pid_t	pid;

 	report_purpose(24);

	report_assertion("Assertion XtMainLoop-24.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("XtExposeNoExpose flag set with any one of");
	report_assertion("XtExposeNoCompress, XtExposeCompressSeries,");
	report_assertion("XtExposeCompressMultiple or XtExposeCompressMaximal flags");
	report_assertion("set in its widget class field compress_exposure a call to");
	report_assertion("void XtMainLoop() shall cause all NoExpose events for the");
	report_assertion("specified widget to be dispatched individually to its expose");
	report_assertion("procedure.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t025(){

pid_t	pid;

 	report_purpose(25);

	report_assertion("Assertion XtMainLoop-25.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("visible_interest field in its class record set to True a");
	report_assertion("call to void XtMainLoop() shall dispatch");
	report_assertion("VisibilityUnobscured events to the widget and set the");
	report_assertion("visible field in the core widget structure to True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t026(){

pid_t	pid;

 	report_purpose(26);

	report_assertion("Assertion XtMainLoop-26.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("visible_interest field in its class record set to True a");
	report_assertion("call to void XtMainLoop() shall dispatch");
	report_assertion("VisibilityPartiallyObscured events to the widget and set the");
	report_assertion("visible field in the core widget structure to True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t027(){

pid_t	pid;

 	report_purpose(27);

	report_assertion("Assertion XtMainLoop-27.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("visible_interest field in its class record set to True a");
	report_assertion("call to void XtMainLoop() shall dispatch");
	report_assertion("VisibilityFullyObscured events to the widget and set the");
	report_assertion("visible field in the core widget structure to False.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* Including from file Mdefcode.tmc.3540 */
static void t028(){

pid_t	pid;

 	report_purpose(28);

	report_assertion("Assertion XtMainLoop-28.(B)");
	report_assertion("When a widget in the calling process has the");
	report_assertion("visible_interest field in its class record set to False a");
	report_assertion("call to void XtMainLoop() shall not dispatch");
	report_assertion("VisibilityUnobscured, VisibilityFullyObscured, or");
	report_assertion("VisbilityPartiallyObscured events to the widget.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.3540 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
