/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_MotionNotify	1
char    *TestName = "MotionNotify";



#define	MASK		PointerMotionMask
#define	HINTMASK	PointerMotionHintMask
#define EVENT		MotionNotify
#define EVENTMASK	MASK

unsigned long		motionmasks[7] = { 	Button1MotionMask, Button2MotionMask,
						Button3MotionMask, Button4MotionMask, Button5MotionMask,
						ButtonMotionMask, PointerMotionMask };

#define MOTIONMASK 	Button1MotionMask | Button2MotionMask | \
			Button3MotionMask | Button4MotionMask | Button5MotionMask | \
			ButtonMotionMask | PointerMotionMask

unsigned long	buttonmask[7] = {	Button5MotionMask,Button4MotionMask,Button3MotionMask,
					Button2MotionMask,Button1MotionMask,ButtonMotionMask,PointerMotionMask};

unsigned int buttons[7] = { Button5, Button4, Button3, Button2, Button1, Button1, Button1 };	


int 	tet_thistest;

static void t001(){

int	i;
int	nummoves;
Display	*display = Dsp;
Display	*client2;
Window	w;
int	x, y;
XEvent	event_return;
XMotionEvent	good;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion MotionNotify-1.(A)");
	report_assertion("When the pointer is moved and the pointer motion begins and");
	report_assertion("ends in the same window, then a MotionNotify event is");
	report_assertion("generated.");

	report_strategy("Create client2.");
	report_strategy("Create window.");
	report_strategy("Move pointer to inside of window.");
	report_strategy("Set PointerMotionMask event mask bits on window.");
	report_strategy("Set PointerMotionMask event mask bits on window with client2.");
	report_strategy("Synthesize expected event.");
	report_strategy("Call XWarpPointer to move the pointer with motion beginning and");
	report_strategy("ending in window.");
	report_strategy("Verify that a MotionNotify event was received.");
	report_strategy("Verify event members.");
	report_strategy("Verify that only one MotionNotify event was received.");
	report_strategy("Verify that no other events were received.");
	report_strategy("Verify that a MotionNotify event was received by client2.");
	report_strategy("Verify event members for client2.");
	report_strategy("Verify that only one MotionNotify event was received.");
	report_strategy("Verify that no other events were received.");
	report_strategy("Call XWarpPointer to move the pointer multiple times with");
	report_strategy("motion beginning and ending in window.");
	report_strategy("Verify that multiple MotionNotify events were received.");
	report_strategy("Verify that no other events were received.");

	tpstartup();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't open display");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Move pointer to inside of window. */
	warp = warppointer(display, w, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set PointerMotionMask event mask bits on window. */
	XSelectInput(display, w, MASK);
	XSync(display, True);
/* Set PointerMotionMask event mask bits on window with client2. */
	XSelectInput(client2, w, MASK);
	XSync(client2, True);
/* Synthesize expected event. */
	x = 2;
	y = 2;
	good.type = MotionNotify;
	/* ignore serial */
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.root = DRW(display);
	good.subwindow = None;
	/* ignore time */
	good.x = x;
	good.y = y;
	ROOTCOORDSET(display, &good);	/* x_root and y_root */
	good.state = 0;
	good.is_hint = NotifyNormal;
	good.same_screen = True;
/* Call XWarpPointer to move the pointer with motion beginning and */
/* ending in window. */
	XWarpPointer(display, None, w, 0, 0, 0, 0, x, y);
/* Verify that a MotionNotify event was received. */
	XSync(display, False);
	if (!XCheckTypedWindowEvent(display, w, MotionNotify, &event_return)) {
		report("No events delivered.");
		FAIL;
	}
	else
		CHECK;
/* Verify event members. */
	/* ignore serial */
	good.serial = ((XMotionEvent *) &event_return)->serial = 0;
	/* ignore time */
	good.time = ((XMotionEvent *) &event_return)->time = 0;
	CHECKEVENT((XEvent *) &good, &event_return);
/* Verify that only one MotionNotify event was received. */
	if (XCheckTypedWindowEvent(display, w, MotionNotify, &event_return)) {
		report("Excess events generated.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were received. */
	if (XPending(display) > 0) {
		delete("Unexpected events generated.");
		return;
	}
	else
		CHECK;
/* Verify that a MotionNotify event was received by client2. */
	XSync(client2, False);
	if (!XCheckTypedWindowEvent(client2, w, MotionNotify, &event_return)) {
		report("No events delivered to client2.");
		FAIL;
	}
	else
		CHECK;
/* Verify event members for client2. */
	good.display = client2;
	/* ignore serial */
	good.serial = ((XMotionEvent *) &event_return)->serial = 0;
	/* ignore time */
	good.time = ((XMotionEvent *) &event_return)->time = 0;
	CHECKEVENT((XEvent *) &good, &event_return);
/* Verify that only one MotionNotify event was received. */
	if (XCheckTypedWindowEvent(client2, w, MotionNotify, &event_return)) {
		report("Excess events generated for client2.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were received. */
	if (XPending(client2) > 0) {
		delete("Unexpected events generated for client2.");
		return;
	}
	else
		CHECK;
/* Call XWarpPointer to move the pointer multiple times with */
/* motion beginning and ending in window. */
	XSync(display, True);
	nummoves = 5;
	for (i=0; i<nummoves; i++) {
		if (!i)
			CHECK;
		XWarpPointer(display, None, w, 0, 0, 0, 0, ++x, ++y);
		/*
		 * Some servers may only generate the expected multiple
		 * MotionNotify events when this call to XWarpPointer is
		 * followed by an XSync (or probably any other protocol
		 * request).
		 */
	}
/* Verify that multiple MotionNotify events were received. */
	XSync(display, False);
	for (i=0; i<nummoves; i++) {
		if (!XCheckTypedWindowEvent(display, w, MotionNotify, &event_return)) {
			report("Missing %d events.", nummoves - i);
			FAIL;
			break;
		}
		else
			CHECK;
	}
/* Verify that no other events were received. */
	if (XPending(display) > 0) {
		delete("Unexpected events generated.");
		return;
	}
	else
		CHECK;

	CHECKPASS(12 + nummoves);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion MotionNotify-2.(-)");
	report_assertion("When a MotionNotify event is generated, then all clients");
	report_assertion("having set PointerMotionMask event mask bits on the event");
	report_assertion("window are delivered a MotionNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

Display			*client2;
Display			*client3;
Window			w;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion MotionNotify-3.(B)");
	report_assertion("When a MotionNotify event is generated while pointer button");
	report_assertion("1 was pressed, then all clients having set Button1MotionMask");
	report_assertion("event mask bits on the event window are delivered a");
	report_assertion("MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that at least one button is supported.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select Button1MotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button1 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	if(noext(1))
		return;

	/* If extended testing is required: */

		/* Verify that at least one button is supported. */
	if(nbuttons() < 1) {
		delete("No buttons are supported.");
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select Button1MotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, Button1MotionMask);
	XSelectInput(client2, w, Button1MotionMask);
	XSelectInput(client3, w, Button1MotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button1 depressed on the window. */
	buttonpress(Dsp, Button1);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button1);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button1Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display			*client2;
Display			*client3;
Window			w;
int			b;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion MotionNotify-4.(D)");
	report_assertion("When a MotionNotify event is generated while pointer button");
	report_assertion("2 was pressed, then all clients having set Button2MotionMask");
	report_assertion("event mask bits on the event window are delivered a");
	report_assertion("MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that the server supports at least 2 buttons.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select Button2MotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button2 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that the server supports at least 2 buttons. */
	if((b = nbuttons()) < 2) {
		unsupported("Server supports only %d buttons.", b);
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select Button2MotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, Button2MotionMask);
	XSelectInput(client2, w, Button2MotionMask);
	XSelectInput(client3, w, Button2MotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button2 depressed on the window. */
	buttonpress(Dsp, Button2);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button2);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button2Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Display			*client2;
Display			*client3;
Window			w;
int 			b;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion MotionNotify-5.(D)");
	report_assertion("When a MotionNotify event is generated while pointer button");
	report_assertion("3 was pressed, then all clients having set Button3MotionMask");
	report_assertion("event mask bits on the event window are delivered a");
	report_assertion("MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that the server supports at least 3 buttons.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select Button3MotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button3 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that the server supports at least 3 buttons. */
	if((b = nbuttons()) < 3) {
		unsupported("Server supports only %d buttons.", b);
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select Button3MotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, Button3MotionMask);
	XSelectInput(client2, w, Button3MotionMask);
	XSelectInput(client3, w, Button3MotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button3 depressed on the window. */
	buttonpress(Dsp, Button3);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button3);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button3Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display			*client2;
Display			*client3;
Window			w;
int			b;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion MotionNotify-6.(D)");
	report_assertion("When a MotionNotify event is generated while pointer button");
	report_assertion("4 was pressed, then all clients having set Button4MotionMask");
	report_assertion("event mask bits on the event window are delivered a");
	report_assertion("MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that the server supports at least 4 buttons.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select Button4MotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button4 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that the server supports at least 4 buttons. */
	if((b = nbuttons()) < 4) {
		unsupported("Server supports only %d buttons.", b);
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select Button4MotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, Button4MotionMask);
	XSelectInput(client2, w, Button4MotionMask);
	XSelectInput(client3, w, Button4MotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button4 depressed on the window. */
	buttonpress(Dsp, Button4);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button4);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button4Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display			*client2;
Display			*client3;
Window			w;
int			b;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion MotionNotify-7.(D)");
	report_assertion("When a MotionNotify event is generated while pointer button");
	report_assertion("5 was pressed, then all clients having set Button5MotionMask");
	report_assertion("event mask bits on the event window are delivered a");
	report_assertion("MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that the server supports 5 buttons.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select Button5MotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button5 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that the server supports 5 buttons. */
	if((b = nbuttons()) < 5) {
		unsupported("Server supports only %d buttons.", b);
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select Button5MotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, Button5MotionMask);
	XSelectInput(client2, w, Button5MotionMask);
	XSelectInput(client3, w, Button5MotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button5 depressed on the window. */
	buttonpress(Dsp, Button5);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button5);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button5Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Display			*client2;
Display			*client3;
Window			w;
XEvent			ev;
XPointerMovedEvent	good;
PointerPlace		*ptr;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion MotionNotify-8.(B)");
	report_assertion("When a MotionNotify event is generated while at least one");
	report_assertion("pointer button was pressed, then all clients having set");
	report_assertion("ButtonMotionMask event mask bits on the event window are");
	report_assertion("delivered a MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that at least one button is supported.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a third client.");
	report_strategy("  Create a window.");
	report_strategy("  Select ButtonMotionMask as the event mask for all clients.");
	report_strategy("  Simulate a Motion event with Button1 depressed on the window.");
	report_strategy("  Verify a MotionNotify event was generated for the first client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the second client.");
	report_strategy("  Verify that event member fields were correctly set.");
	report_strategy("  Verify a MotionNotify event was generated for the third client.");
	report_strategy("  Verify that event member fields were correctly set.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that at least one button is supported. */
	if(nbuttons() < 1) {
		delete("No buttons are supported.");
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();
		/* Create a third client. */
	client3 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select ButtonMotionMask as the event mask for all clients. */
	XSelectInput(Dsp, w, ButtonMotionMask);
	XSelectInput(client2, w, ButtonMotionMask);
	XSelectInput(client3, w, ButtonMotionMask);

	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	XSync(client2, True);
	XSync(client3, True);

		/* Simulate a Motion event with Button1 depressed on the window. */
	buttonpress(Dsp, Button1);
	ptr = warppointer(Dsp, w, 10,10);
	XSync(Dsp, False);
	XSync(client2, False);
	XSync(client3, False);
	buttonrel(Dsp, Button1);

	good = ev.xmotion;
	good.type = EVENT;
	good.send_event = False;
	good.display = Dsp;
	good.window = w;
	good.root = DRW(Dsp);
	good.subwindow = None;

	good.x = 10;
	good.y = 10;
	good.x_root = ptr->nx;
	good.y_root = ptr->ny;
	good.state = Button1Mask;
	good.is_hint = NotifyNormal;
	good.same_screen = True;

		/* Verify a xname event was generated for the first client. */
	if(XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

		/* Verify that event member fields were correctly set. */
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the second client. */
	if(XCheckWindowEvent(client2, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client2;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

		/* Verify a xname event was generated for the third client. */
	if(XCheckWindowEvent(client3, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not generated.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;
		
		/* Verify that event member fields were correctly set. */
		good.display = client3;
		if (checkevent((XEvent *) &good, &ev)) {
			report("Unexpected values in delivered event");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int		i;
int		b;
int		nevents = 0;
Window		w;
XEvent		ev;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion MotionNotify-9.(B)");
	report_assertion("When a MotionNotify event is generated and a client has");
	report_assertion("selected one or more of Button1MotionMask,");
	report_assertion("Button2MotionMask, Button3MotionMask, Button4MotionMask,");
	report_assertion("Button5MotionMask, ButtonMotionMask, or PointerMotionMask");
	report_assertion("event mask bits on the event window, then only one");
	report_assertion("MotionNotify event is delivered to that client.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that at least one button is supported.");
	report_strategy("  Create a window.");
	report_strategy("  Select all the motion masks on the window.");
	report_strategy("  Simulate a Motion event with Button1 depressed on the window.");
	report_strategy("  Check that only one of the possible events was generated.");
	report_strategy("  Simulate a Motion event with all buttons pressed.");
	report_strategy("  Check that only one of the possible events was generated.");

	tpstartup();
	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that at least one button is supported. */
	if((b = nbuttons()) < 1) {
		delete("No buttons are supported.");
		return;
	} else
		CHECK;

		/* Create a window. */
	w = defwin(Dsp);

		/* Select all the motion masks on the window. */
	XSelectInput(Dsp, w, MOTIONMASK);

		/* Simulate a Motion event with Button1 depressed on the window. */
	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	warppointer(Dsp, w, 10, 10);
	XSync(Dsp, False);
	buttonrel(Dsp, Button1);

	for(i=0; i < NELEM(motionmasks); i++) {

		if(XCheckWindowEvent(Dsp, w, motionmasks[i], &ev) == False) {
			trace("%s event was not generated.", eventmaskname(motionmasks[i]));
		} else {
			nevents++;
			trace("%s event was generated.", eventmaskname(motionmasks[i]));
		}

	}

		/* Check that only one of the possible events was generated. */
	if(nevents != 1) {
		report("More than one of the selected motion events was generated.");
		FAIL;
	} else
		CHECK;

	nevents = 0;
		/* Simulate a Motion event with all buttons pressed. */
	buttonpress(Dsp, Button1);
	if(b>=2) 
		buttonpress(Dsp, Button2);

	if(b>=3) 
		buttonpress(Dsp, Button3);

	if(b>=4) 
		buttonpress(Dsp, Button4);

	if(b>=5) 
		buttonpress(Dsp, Button5);


	warppointer(Dsp, w, 0,0);
	XSync(Dsp, True);
	warppointer(Dsp, w, 10, 10);
	XSync(Dsp, False);

	for(i=0; i < NELEM(motionmasks); i++) {

		if(XCheckWindowEvent(Dsp, w, motionmasks[i], &ev) == False) {
			trace("Event selected by %s was not generated.", eventmaskname(motionmasks[i]));
		} else {
			nevents++;
			trace("Event selected by %s event was generated.", eventmaskname(motionmasks[i]));
		}

	}

	if(b>=2) 
		buttonrel(Dsp, Button2);

	if(b>=3) 
		buttonrel(Dsp, Button3);

	if(b>=4) 
		buttonrel(Dsp, Button4);

	if(b>=5) 
		buttonrel(Dsp, Button5);


		/* Check that only one of the possible events was generated. */
	if(nevents != 1) {
		report("More than one of the selected motion events was generated.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display			*client2;
Window			w;
XEvent			ev;
int			i;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion MotionNotify-10.(B)");
	report_assertion("When a MotionNotify event is generated, then clients not");
	report_assertion("having set Button1MotionMask, Button2MotionMask,");
	report_assertion("Button3MotionMask, Button4MotionMask, Button5MotionMask,");
	report_assertion("ButtonMotionMask, or PointerMotionMask event mask bits on");
	report_assertion("the event window, are not delivered a MotionNotify event.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended testing is required:");
	report_strategy("  Verify that at least one button is supported.");
	report_strategy("  Create a second client.");
	report_strategy("  Create a window.");
	report_strategy("  Select for something on the second client.");
	report_strategy("  For each supported type of motion event :");
	report_strategy("    Select the mask as the event mask for the first client.");
	report_strategy("    Simulate the motion event.");
	report_strategy("    Verify that the first client received the appropriate event.");
	report_strategy("    Verify that the second client did not receive that event.");

	tpstartup();

	/* If extended testing is required: */
	if(noext(1))
		return;

		/* Verify that at least one button is supported. */
	if(nbuttons() < 1) {
		delete("No buttons are supported.");
		return;
	} else
		CHECK;

		/* Create a second client. */
	client2 = opendisplay();

		/* Create a window. */
	w = defwin(Dsp);

		/* Select for something on the second client. */
	XSelectInput(client2, w, EnterWindowMask);

		/* For each supported type of motion event : */
	for(i = 5-nbuttons(); i<NELEM(buttonmask); i++) {
		
		trace("Iteration : %d Event mask : %s Button : %s", i, eventmaskname(buttonmask[i]), buttonname((int)buttons[i]));

			/* Select the mask as the event mask for the first client. */
		XSelectInput(Dsp, w, buttonmask[i]);

			/* Simulate the motion event. */
		warppointer(Dsp, w, 0,0);
		XSync(Dsp, False);
		XSync(client2, False);
		if(buttonmask[i] != PointerMotionMask)
			buttonpress(Dsp, buttons[i]);
		warppointer(Dsp, w, 10,10);
		XSync(Dsp, False);
		XSync(client2, False);
			
			/* Verify that the first client received the appropriate event. */
		if(XCheckWindowEvent(Dsp, w, buttonmask[i], &ev) == False) {
			report("Expected %s event was not generated.", eventmaskname(buttonmask[i]));
			FAIL;
		} else {
			CHECK;

			/* Verify that the second client did not receive that event. */
		if(XCheckWindowEvent(client2, w, buttonmask[i], &ev) != False) {
			report("Unexpected %s event was generated.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;
		}
		if(buttonmask[i] != PointerMotionMask)
			buttonrel(Dsp, buttons[i]);

	}

	CHECKPASS(1 + 2 * (nbuttons()+2));	

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.3316 */
static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion MotionNotify-11.(B)");
	report_assertion("When a MotionNotify event is delivered with is_hint set to");
	report_assertion("NotifyHint, then clients which have set");
	report_assertion("PointerMotionHintMask and one or more of Button1MotionMask,");
	report_assertion("Button2MotionMask, Button3MotionMask, Button4MotionMask,");
	report_assertion("Button5MotionMask, ButtonMotionMask, or PointerMotionMask");
	report_assertion("event mask bits on the event window may not be delivered");
	report_assertion("another MotionNotify event until either the key or button");
	report_assertion("state changes, the pointer leaves the event window or the");
	report_assertion("client calls XQueryPointer or XGetMotionEvents.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.3316 */

static void t012(){


 	report_purpose(12);

	report_assertion("Assertion MotionNotify-12.(-)");
	report_assertion("When a MotionNotify event is generated, then all clients");
	report_assertion("which have not set PointerMotionHintMask and have set one or");
	report_assertion("more of Button1MotionMask, Button2MotionMask,");
	report_assertion("Button3MotionMask, Button4MotionMask, Button5MotionMask,");
	report_assertion("ButtonMotionMask, or PointerMotionMask event mask bits on");
	report_assertion("the event window are delivered a MotionNotify event with");
	report_assertion("is_hint set to NotifyNormal.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t013(){

Display	*display = Dsp;
Display	*client2;
Window	w;
int	x, y;
XEvent	event_return;
XMotionEvent	good;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion MotionNotify-13.(A)");
	report_assertion("When a MotionNotify event is generated, then all clients");
	report_assertion("which have set PointerMotionHintMask and one or more of");
	report_assertion("Button1MotionMask, Button2MotionMask, Button3MotionMask,");
	report_assertion("Button4MotionMask, Button5MotionMask, ButtonMotionMask,");
	report_assertion("or PointerMotionMaskeventmaskbitsontheeventwindoware");
	report_assertion("delivered a MotionNotify event with is_hint set to");
	report_assertion("NotifyHint or NotifyNormal.");

	report_strategy("Create client2.");
	report_strategy("Create window.");
	report_strategy("Move pointer to inside of window.");
	report_strategy("Set PointerMotionMask and PointerMotionHintMask event mask bits on window.");
	report_strategy("Set PointerMotionMask and PointerMotionHintMask event mask bits on window");
	report_strategy("with client2.");
	report_strategy("Synthesize expected event.");
	report_strategy("Call XWarpPointer to move the pointer with motion beginning and");
	report_strategy("ending in window.");
	report_strategy("Verify that a MotionNotify event was received.");
	report_strategy("Verify event members.");
	report_strategy("Verify that only one MotionNotify event was received.");
	report_strategy("Verify that no other events were received.");
	report_strategy("Verify that a MotionNotify event was received by client2.");
	report_strategy("Verify event members for client2.");
	report_strategy("Verify that only one MotionNotify event was received.");
	report_strategy("Verify that no other events were received.");

	tpstartup();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can't open display");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Move pointer to inside of window. */
	warp = warppointer(display, w, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set PointerMotionMask and PointerMotionHintMask event mask bits on window. */
	XSelectInput(display, w, HINTMASK|MASK);
	XSync(display, True);
/* Set PointerMotionMask and PointerMotionHintMask event mask bits on window */
/* with client2. */
	XSelectInput(client2, w, HINTMASK|MASK);
	XSync(client2, True);
/* Synthesize expected event. */
	x = 2;
	y = 2;
	good.type = MotionNotify;
	/* ignore serial */
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.root = DRW(display);
	good.subwindow = None;
	/* ignore time */
	good.x = x;
	good.y = y;
	ROOTCOORDSET(display, &good);	/* x_root and y_root */
	good.state = 0;
	good.is_hint = NotifyNormal;
	good.same_screen = True;
/* Call XWarpPointer to move the pointer with motion beginning and */
/* ending in window. */
	XWarpPointer(display, None, w, 0, 0, 0, 0, x, y);
/* Verify that a MotionNotify event was received. */
	XSync(display, False);
	if (!XCheckTypedWindowEvent(display, w, MotionNotify, &event_return)) {
		report("No events delivered.");
		FAIL;
	}
	else
		CHECK;
/* Verify is_hint is set to NotifyNormal or Notify Hint */
        if(((XMotionEvent *) &event_return)->is_hint != NotifyNormal &&
	   ((XMotionEvent *) &event_return)->is_hint != NotifyHint) {
		report("is_hint was set to 0x%x, expected 0x%x or 0x%x", 
				((XMotionEvent *) &event_return)->is_hint, 
				NotifyNormal, NotifyHint);
		FAIL;
	}
	else
		CHECK;

        /* is_hint has been checked so don't bother reporting again */
        good.is_hint = event_return.xmotion.is_hint;

/* Verify event members. */
	/* ignore serial */
	good.serial = ((XMotionEvent *) &event_return)->serial = 0;
	/* ignore time */
	good.time = ((XMotionEvent *) &event_return)->time = 0;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Delivered event did not match expected event");
		FAIL;
	}
	else
		CHECK;
/* Verify that only one MotionNotify event was received. */
	if (XCheckTypedWindowEvent(display, w, MotionNotify, &event_return)) {
		report("Excess events generated.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were received. */
	if (XPending(display) > 0) {
		delete("Unexpected events generated.");
		return;
	}
	else
		CHECK;
/* Verify that a MotionNotify event was received by client2. */
	XSync(client2, False);
	if (!XCheckTypedWindowEvent(client2, w, MotionNotify, &event_return)) {
		report("No events delivered to client2.");
		FAIL;
	}
	else
		CHECK;
/* Verify is_hint is set to NotifyNormal or Notify Hint */
        if(((XMotionEvent *) &event_return)->is_hint != NotifyNormal &&
	   ((XMotionEvent *) &event_return)->is_hint != NotifyHint) {
		report("is_hint was set to 0x%x, expected 0x%x or 0x%x", 
				((XMotionEvent *) &event_return)->is_hint, 
				NotifyNormal, NotifyHint);
		FAIL;
	}
	else
		CHECK;

        /* is_hint has been checked so don't bother reporting again */
        good.is_hint = event_return.xmotion.is_hint;

/* Verify event members for client2. */
	good.display = client2;
	/* ignore serial */
	good.serial = ((XMotionEvent *) &event_return)->serial = 0;
	/* ignore time */
	good.time = ((XMotionEvent *) &event_return)->time = 0;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Delivered event did not match expected event");
		FAIL;
	}
	else
		CHECK;
/* Verify that only one MotionNotify event was received. */
	if (XCheckTypedWindowEvent(client2, w, MotionNotify, &event_return)) {
		report("Excess events generated for client2.");
		FAIL;
	}
	else
		CHECK;
/* Verify that no other events were received. */
	if (XPending(client2) > 0) {
		delete("Unexpected events generated for client2.");
		return;
	}
	else
		CHECK;

	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

XEvent			ev;
Window			w;
Window			w1;
Window			w2;
XSetWindowAttributes	atts;
int			i;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion MotionNotify-14.(B)");
	report_assertion("When a MotionNotify event is generated and no client has");
	report_assertion("selected Button1MotionMask, Button2MotionMask,");
	report_assertion("Button3MotionMask, Button4MotionMask, Button5MotionMask,");
	report_assertion("ButtonMotionMask, or PointerMotionMask event mask bits on");
	report_assertion("the source window, then the event propagates, with");
	report_assertion("propagation stopping at the root window of the screen or at");
	report_assertion("the first window with Button1MotionMask, Button2MotionMask,");
	report_assertion("Button3MotionMask, Button4MotionMask, Button5MotionMask,");
	report_assertion("ButtonMotionMask, or PointerMotionMask event mask bits in");
	report_assertion("its do-not-propagate mask, from the source window to the");
	report_assertion("first ancestor window for which some client has selected for");
	report_assertion("MotionNotify events.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If extended is required:");
	report_strategy("  Verify that at least one button is supported.");
	report_strategy("  For each supported type of motion event :");
	report_strategy("    Create a window.");
	report_strategy("    Create a child of that window.");
	report_strategy("    Create a grandchild of the window.");
	report_strategy("    Select MotionNotify events on the root window of the screen.");
	report_strategy("    Simulate a MotionNotify event on the grandchild.");
	report_strategy("    Verify that a MotionNotify event was generated on the root.");
	report_strategy("    Select MotionNotify events on the grandparent window.");
	report_strategy("    Set the do_not_propagate mask on the child to MotionNotify events.");
	report_strategy("    Simulate a MotionNotify event on the grandchild.");
	report_strategy("    Verify no MotionNotify event was generated on the grandchild.");
	report_strategy("    Verify no MotionNotify event was generated on the child.");
	report_strategy("    Verify no MotionNotify event was generated on the parent.");
	report_strategy("    Select MotionNotify events on the child window.");
	report_strategy("    Set the do_not_propagate mask of the child to NoEventMask.");
	report_strategy("    Simulate a MotionNotify event on the grandchild.");
	report_strategy("    Verify that no MotionNotify event was generated on the grandchild.");
	report_strategy("    Verify that no MotionNotify event was generated on the parent.");
	report_strategy("    Verify that a MotionNotify event was generated on the child.");

	tpstartup();
/* If extended is required: */
	if(noext(0))
		return;

/* Verify that at least one button is supported. */
	if(nbuttons() < 1) {
		delete("No buttons are supported.");
		return;
	} else
		CHECK;

/* For each supported type of motion event : */
	for(i = 5-nbuttons(); i<NELEM(buttonmask); i++) {
		trace("Iteration : %d Event mask : %s Button : %s", i, eventmaskname(buttonmask[i]), buttonname((int)buttons[i]));

/* Create a window. */
		w = defwin(Dsp);
/* Create a child of that window. */
		w1 = crechild(Dsp, w, (struct area *) NULL);
/* Create a grandchild of the window. */
		w2 = crechild(Dsp, w1, (struct area *) NULL);

/* Select xname events on the root window of the screen. */
		XSelectInput(Dsp, DRW(Dsp), buttonmask[i]);	

/* Simulate a xname event on the grandchild. */
		warppointer(Dsp, w2, 0,0);
		XSync(Dsp, False);
		if(buttonmask[i] != PointerMotionMask)
			buttonpress(Dsp, buttons[i]);
		warppointer(Dsp, w2, 1,1);
		if(buttonmask[i] != PointerMotionMask)
			buttonrel(Dsp, buttons[i]);
		XSync(Dsp, False);
	
/* Verify that a xname event was generated on the root. */
		if (XCheckWindowEvent(Dsp, DRW(Dsp), buttonmask[i], &ev) == False) {
			report("Expected event (%s) not received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

		XSelectInput(Dsp, DRW(Dsp), NoEventMask);	

/* Select xname events on the grandparent window. */
		XSelectInput(Dsp, w, buttonmask[i]);	

/* Set the do_not_propagate mask on the child to xname events. */
		atts.do_not_propagate_mask = buttonmask[i];
		XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);
	
/* Simulate a xname event on the grandchild. */
		warppointer(Dsp, w2, 0,0);
		XSync(Dsp, False);
		if(buttonmask[i] != PointerMotionMask)
			buttonpress(Dsp, buttons[i]);
		warppointer(Dsp, w2, 1,1);
		if(buttonmask[i] != PointerMotionMask)
			buttonrel(Dsp, buttons[i]);
		XSync(Dsp, False);

/* Verify no xname event was generated on the grandchild. */
		if (XCheckWindowEvent(Dsp, w2, buttonmask[i], &ev) != False) {
			report("Unexpected event (%s) received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

/* Verify no xname event was generated on the child. */
		if (XCheckWindowEvent(Dsp, w1, buttonmask[i], &ev) != False) {
			report("Unexpected event (%s) received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

/* Verify no xname event was generated on the parent. */
		if (XCheckWindowEvent(Dsp, w, buttonmask[i], &ev) != False) {
			report("Unexpected event (%s) received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

/* Select xname events on the child window. */
		XSelectInput(Dsp, w1, buttonmask[i]);	

/* Set the do_not_propagate mask of the child to NoEventMask. */
		atts.do_not_propagate_mask = NoEventMask;
		XChangeWindowAttributes(Dsp, w1, CWDontPropagate, &atts);

/* Simulate a xname event on the grandchild. */
		warppointer(Dsp, w2, 0,0);
		XSync(Dsp, False);
		if(buttonmask[i] != PointerMotionMask)
			buttonpress(Dsp, buttons[i]);
		warppointer(Dsp, w2, 1,1);
		if(buttonmask[i] != PointerMotionMask)
			buttonrel(Dsp, buttons[i]);
		XSync(Dsp, False);

/* Verify that no xname event was generated on the grandchild. */
		if (XCheckWindowEvent(Dsp, w2, buttonmask[i], &ev) != False) {
			report("Unexpected event (%s) received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

/* Verify that no xname event was generated on the parent. */
		if (XCheckWindowEvent(Dsp, w, buttonmask[i], &ev) != False) {
			report("Unexpected event (%s) received.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

/* Verify that a xname event was generated on the child. */
		if (XCheckWindowEvent(Dsp, w1, buttonmask[i], &ev) == False) {
			report("%s event was not delivered to selecting child window.", eventmaskname(buttonmask[i]));
			FAIL;
		} else
			CHECK;

	} /* for */


	CHECKPASS(1 + (nbuttons()+2)*7);	

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int	status;
Display	*display = Dsp;
Winh	*eventw;
Winh	*sourcew;
XEvent	good;
Winhg	winhg;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion MotionNotify-15.(A)");
	report_assertion("When a MotionNotify event is delivered and the source");
	report_assertion("window is an inferior of the event window and the source");
	report_assertion("window is a child of the event window, then subwindow is set");
	report_assertion("to the source window.");

	report_strategy("Create window hierarchy.");
	report_strategy("Create the hierarchy.");
	report_strategy("Move pointer to inside of window.");
	report_strategy("Select no events on the sourcew.");
	report_strategy("Set PointerMotionMask event mask bits on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer with motion beginning and");
	report_strategy("ending in window.");
	report_strategy("Verify that a MotionNotify event was received.");
	report_strategy("Verify that subwindow is set to the source window.");

	tpstartup();
/* Create window hierarchy. */
	winhg.area.x = 0;
	winhg.area.y = 0;
	winhg.area.width = W_STDWIDTH;
	winhg.area.height = W_STDHEIGHT;
	winhg.border_width = 1;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		delete("Could not create eventw");
		return;
	}
	else
		CHECK;
	winhg.area.width /= 2;
	winhg.area.height /= 2;
	sourcew = winh_adopt(display, eventw, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (sourcew == (Winh *) NULL) {
		delete("Could not create sourcew");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Move pointer to inside of window. */
	warp = warppointer(display, sourcew->window, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select no events on the sourcew. */
	if (winh_selectinput(display, sourcew, NoEventMask))
		return;
	else
		CHECK;
/* Set PointerMotionMask event mask bits on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
	XSync(display, True);
	good.type = MotionNotify;
	good.xmotion.display = display;
	good.xmotion.window = eventw->window;
	good.xmotion.subwindow = sourcew->window;
/* Call XWarpPointer to move the pointer with motion beginning and */
/* ending in window. */
	XWarpPointer(display, None, sourcew->window, 0, 0, 0, 0, 2, 2);
/* Verify that a MotionNotify event was received. */
	XSync(display, False);
	if (winh_plant(sourcew, &good, NoEventMask, WINH_NOMASK))
		return;
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else
		CHECK;
	if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that subwindow is set to the source window. */
		/* since only one event was expected, it must be first in list */
		if (eventw->delivered->event->xmotion.subwindow != sourcew->window) {
			report("Subwindow set to 0x%x, expected 0x%x",
				eventw->delivered->event->xmotion.subwindow, sourcew->window);
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int	status;
Display	*display = Dsp;
Winh	*eventw;
Winh	*ancestorw;
Winh	*sourcew;
XEvent	good;
Winhg	winhg;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion MotionNotify-16.(A)");
	report_assertion("When a MotionNotify event is delivered and the source");
	report_assertion("window is an inferior of the event window and the source");
	report_assertion("window is not a child of the event window, then subwindow is");
	report_assertion("set to the child of the event window that is an ancestor of");
	report_assertion("the source window.");

	report_strategy("Create window hierarchy.");
	report_strategy("Create the hierarchy.");
	report_strategy("Move pointer to inside of window.");
	report_strategy("Select no events on the sourcew.");
	report_strategy("Set PointerMotionMask event mask bits on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer with motion beginning and");
	report_strategy("ending in window.");
	report_strategy("Verify that a MotionNotify event was received.");
	report_strategy("Verify that subwindow is set to the source window.");

	tpstartup();
/* Create window hierarchy. */
	winhg.area.x = 0;
	winhg.area.y = 0;
	winhg.area.width = W_STDWIDTH;
	winhg.area.height = W_STDHEIGHT;
	winhg.border_width = 1;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		delete("Could not create eventw");
		return;
	}
	else
		CHECK;
	winhg.area.width /= 2;
	winhg.area.height /= 2;
	ancestorw = winh_adopt(display, eventw, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (ancestorw == (Winh *) NULL) {
		delete("Could not create ancestorw");
		return;
	}
	else
		CHECK;
	winhg.area.width /= 2;
	winhg.area.height /= 2;
	sourcew = winh_adopt(display, ancestorw, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (sourcew == (Winh *) NULL) {
		delete("Could not create sourcew");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Move pointer to inside of window. */
	warp = warppointer(display, sourcew->window, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select no events on the sourcew. */
	if (winh_selectinput(display, sourcew, NoEventMask))
		return;
	else
		CHECK;
/* Set PointerMotionMask event mask bits on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
	XSync(display, True);
	good.type = MotionNotify;
	good.xmotion.display = display;
	good.xmotion.window = eventw->window;
	good.xmotion.subwindow = ancestorw->window;
/* Call XWarpPointer to move the pointer with motion beginning and */
/* ending in window. */
	XWarpPointer(display, None, sourcew->window, 0, 0, 0, 0, 2, 2);
/* Verify that a MotionNotify event was received. */
	XSync(display, False);
	if (winh_plant(sourcew, &good, NoEventMask, WINH_NOMASK))
		return;
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else
		CHECK;
	if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that subwindow is set to the source window. */
		/* since only one event was expected, it must be first in list */
		if (eventw->delivered->event->xmotion.subwindow != ancestorw->window) {
			report("Subwindow set to 0x%x, expected 0x%x",
				eventw->delivered->event->xmotion.subwindow, ancestorw->window);
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(11);

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){


 	report_purpose(17);

	report_assertion("Assertion MotionNotify-17.(-)");
	report_assertion("When a MotionNotify event is delivered and the source");
	report_assertion("window is not an inferior of the event window, then");
	report_assertion("subwindow is set to None.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t018(){

Window			w;
Window			w2;
XEvent			ev;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion MotionNotify-18.(D)");
	report_assertion("If multiple screens are supported: When a MotionNotify");
	report_assertion("event is delivered and the event and root windows are not on");
	report_assertion("the same screen, then x and y are set to zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window on the default screen.");
	report_strategy("    Create a window on the alternate screen.");
	report_strategy("    Grab the pointer asynchronously  for the first window selecting PointerMotion and ButtonMotion events.");
	report_strategy("    Generate a PointerMotion event on the alternate window.");
	report_strategy("    Verify that a PointerMotion event was generated with respect to the grabbing window.");
	report_strategy("    Verify that the x and y event components were zero.");
	report_strategy("    Generate a ButtonMotion mask on the alternate window.");
	report_strategy("    Verify that a ButtonMotion event was generated with respect to the grabbing window. ");
	report_strategy("    Verify that the x and y event components were zero.");

	tpstartup();
/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

/* If extended testing is required: */
	if(noext(1))
		return;

/* Create a window on the default screen. */
        w = defwin(Dsp);
/* Create a window on the alternate screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
/* Grab the pointer asynchronously  for the first window selecting PointerMotion and ButtonMotion events. */
	if( XGrabPointer(Dsp, w, False, PointerMotionMask | ButtonMotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess) {
		delete("XGrabPointer() did not return GrabSuccess.");
		return;
	} else
		CHECK;
	
/* Generate a PointerMotion event on the alternate window. */
	warppointer(Dsp, w2, 0,0);
	XSync(Dsp, True);
	warppointer(Dsp, w2, 10, 10);
	XSync(Dsp, False);

/* Verify that a PointerMotion event was generated with respect to the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, PointerMotionMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(MotionNotify));
		FAIL;
	} else {
		CHECK;
/* Verify that the x and y event components were zero. */
		if(ev.xmotion.x != 0 || ev.xmotion.y != 0) {
			report("The x (value %d) and y (value %d) components of the %s event were not set to zero.",
				 ev.xmotion.x, ev.xmotion.y, eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}

/* Generate a ButtonMotion mask on the alternate window. */
	warppointer(Dsp, w2, 0,0);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	warppointer(Dsp, w2, 10, 10);
	XSync(Dsp, False);
	buttonrel(Dsp, Button1);

/* Verify that a ButtonMotion event was generated with respect to the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, ButtonMotionMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(MotionNotify));
		FAIL;
	} else {
		CHECK;
/* Verify that the x and y event components were zero. */
		if(ev.xmotion.x != 0 || ev.xmotion.y != 0) {
			report("The x (value %d) and y (value %d) components of the %s event were not set to zero.",
				ev.xmotion.x, ev.xmotion.y, eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	
	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

Window			w;
Window			w2;
XEvent			ev;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion MotionNotify-19.(D)");
	report_assertion("If multiple screens are supported: When a MotionNotify");
	report_assertion("event is delivered and the event and root windows are not on");
	report_assertion("the same screen, then same_screen is set to False.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If multiple screens are supported:");
	report_strategy("  If extended testing is required:");
	report_strategy("    Create a window on the default screen.");
	report_strategy("    Create a window on the alternate screen.");
	report_strategy("    Grab the pointer asynchronously  for the first window selecting PointerMotion and ButtonMotion events.");
	report_strategy("    Generate a PointerMotion event on the alternate window.");
	report_strategy("    Verify that a PointerMotion event was generated with respect to the grabbing window.");
	report_strategy("    Verify that same_screen event component was False.");
	report_strategy("    Generate a ButtonMotion event on the alternate window.");
	report_strategy("    Verify that a ButtonMotion event was generated with respect to the grabbing window.");
	report_strategy("    Verify that same_screen event component was False.");

	tpstartup();
/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

/* If extended testing is required: */
	if(noext(1))
		return;

/* Create a window on the default screen. */
        w = defwin(Dsp);
/* Create a window on the alternate screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);
	
/* Grab the pointer asynchronously  for the first window selecting PointerMotion and ButtonMotion events. */
	if( XGrabPointer(Dsp, w, False, PointerMotionMask | ButtonMotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime) != GrabSuccess) {
		delete("XGrabPointer() did not return GrabSuccess.");
		return;
	} else
		CHECK;
	
/* Generate a PointerMotion event on the alternate window. */
	warppointer(Dsp, w2, 0,0);
	XSync(Dsp, True);
	warppointer(Dsp, w2, 10, 10);
	XSync(Dsp, False);

/* Verify that a PointerMotion event was generated with respect to the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, PointerMotionMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(MotionNotify));
		FAIL;
	} else {
		CHECK;
/* Verify that same_screen event component was False. */
		if(ev.xmotion.same_screen != False ) {
			report("The same_screen component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}

/* Generate a ButtonMotion event on the alternate window. */
	warppointer(Dsp, w2, 0,0);
	XSync(Dsp, True);
	buttonpress(Dsp, Button1);
	warppointer(Dsp, w2, 10, 10);
	XSync(Dsp, False);
	buttonrel(Dsp, Button1);

/* Verify that a ButtonMotion event was generated with respect to the grabbing window. */
	if (XCheckWindowEvent(Dsp, w, ButtonMotionMask, &ev) == False) {
		report("Expected event (%s) not received.", eventname(MotionNotify));
		FAIL;
	} else {
		CHECK;
/* Verify that same_screen event component was False. */
		if(ev.xmotion.same_screen != False ) {
			report("The same_screen component of the %s event was not set correctly.", eventname(ButtonPress));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
