/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCvtStringToPixel()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtWMH_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(1,1);
}


#define T_XtCvtStringToPixel	1
char    *TestName = "XtCvtStringToPixel";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = "black";
Pixel res;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCvtStringToPixel-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToPixel(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is not NULL and to->size");
	report_assertion("is large enough to store an XtRPixel type shall convert the");
	report_assertion("string specified in from to an XtRPixel type, store it at");
	report_assertion("the location specified by to->addr, set to->size to the");
	report_assertion("actual size of the converted data, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstpix1", "XtCvtStringToPixel");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer)&res;
	toVal.size = sizeof(Pixel);
	res = 0;
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCvtStringToPixel return value");
	check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t002(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = "XtDefaultBackground";
Pixel res;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCvtStringToPixel-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToPixel(display, args, num_args, from, to,");
	report_assertion("converter_data) when to->addr is not NULL and to->size is");
	report_assertion("too small for an XtRPixel type shall not perform a");
	report_assertion("conversion, set the to->size field to the number of bytes");
	report_assertion("required to store the converted data, and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstpix2", "XtCvtStringToPixel");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = 0;
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(False, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: to_size");
	if (toVal.size != sizeof(Pixel)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Pixel), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t003(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = "XtDefaultBackground";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCvtStringToPixel-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Boolean XtCvtStringToPixel(display, args, num_args, from,");
	report_assertion("to, converter_data) when to->addr is NULL shall convert the");
	report_assertion("string specified in from to an XtRPixel type, allocate space");
	report_assertion("for the converted data, set to->addr to specify the location");
	report_assertion("of the data, set to->size to the size of the coverted data,");
	report_assertion("and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tcstpix3", "XtCvtStringToPixel");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(True, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: to->addr and to->size are set");
	if (!toVal.addr) {
		sprintf(ebuf, "ERROR: to->addr was not set");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (toVal.size != sizeof(Pixel)) {
		sprintf(ebuf, "ERROR: to_size not set correctly, expected %d, received %d", sizeof(Pixel), toVal.size);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t004(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = "not a real color name";
Pixel res;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCvtStringToPixel-4.(A)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToPixel(display, args, num_args, from, to,");
	report_assertion("converter_data) when the conversion is not performed due to");
	report_assertion("an improper value specified in from shall issue a warning");
	report_assertion("message and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_set_event(1, 0);
	avs_xt_hier("Tcstpix4", "XtCvtStringToPixel");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(False, status, "XtCvtStringToPixel return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t005(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
char *pixstr = "XtDefaultBackground";
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCvtStringToPixel-5.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtCvtStringToPixel(display, args, num_args, from, to,");
	report_assertion("converter_data) when args specifies an improper value shall");
	report_assertion("not perform a conversion, issue a warning message, and");
	report_assertion("return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_set_event(1, 0);
	avs_xt_hier("Tcstpix5", "XtCvtStringToPixel");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH_Proc);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args incorrectly");
	num_args = 0;
	tet_infoline("TEST: Conversion fails");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer)0;
	toVal.size = 0;
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(False, status, "conversion status");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Warning handler is called");
	status = avs_get_event(1);
	check_dec(1, status, "calls to warning handler count");
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t006(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = XtDefaultBackground;
Pixel res;
pid_t pid2;
int     argcount = 2;
char	*cargs[] = {NULL, "-rv", NULL};
char	**arg_string;
#endif
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCvtStringToPixel-6.(C)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToPixel(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultForeground and the resource reverseVideo is not");
	report_assertion("True the converted data shall specify the black pixel value");
	report_assertion("of the widget screen specified in args.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	arg_string = &cargs[0];
	avs_xt_hier_args("Tcstpix6", "XtCvtStringToPixel", arg_string, argcount);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(True, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: Conversion result");
	check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t007(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = XtDefaultForeground;
Pixel res;
pid_t pid2;
int     argcount = 2;
char	*cargs[] = {NULL, "-rv", NULL};
char	**arg_string;
#endif
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCvtStringToPixel-7.(C)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToPixel(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultForeground and the resource reverseVideo is True");
	report_assertion("the converted data shall specify the white pixel value of");
	report_assertion("the widget screen specified in args.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	arg_string = &cargs[0];
	avs_xt_hier_args("Tcstpix7", "XtCvtStringToPixel", arg_string, argcount);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(True, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: Conversion result");
	check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t008(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = "XtDefaultBackground";
Pixel res;
pid_t pid2;
int     argcount = 2;
char	*cargs[] = {NULL, "+rv", NULL};
char	**arg_string;
#endif
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCvtStringToPixel-8.(C)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToPixel(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultBackground and the resource reverseVideo is not");
	report_assertion("True the converted data shall specify the white pixel value");
	report_assertion("of the widget screen specified in args.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	arg_string = &cargs[0];
	avs_xt_hier_args("Tcstpix8", "XtCvtStringToPixel", arg_string, argcount);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(True, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: Conversion result");
	check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

static void t009(){

#if XT_X_RELEASE > 4
/* Conversion arguments and results */
Boolean status;
Display *display;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
/* String to Pixel specific */
Screen *screen;
Colormap colormap;
char *pixstr = XtDefaultForeground;
Pixel res;
pid_t pid2;
int     argcount = 2;
char	*cargs[] = {NULL, "+rv", NULL};
char	**arg_string;
#endif
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtCvtStringToPixel-9.(C)");
	report_assertion("If the implementation is X11R5 or later: On a successful");
	report_assertion("call to Boolean XtCvtStringToPixel(display, args, num_args,");
	report_assertion("from, to, converter_data) when from specifies the constant");
	report_assertion("XtDefaultForeground and the resource reverseVideo is True");
	report_assertion("the converted data shall specify the black pixel value of");
	report_assertion("the widget screen specified in args.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	arg_string = &cargs[0];
	avs_xt_hier_args("Tcstpix9", "XtCvtStringToPixel", arg_string, argcount);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Set up required conversion args");
	screen = DefaultScreenOfDisplay(display);
	args[0].addr = (XtPointer )&screen;
	args[0].size = sizeof(Screen*);
	colormap = DefaultColormapOfScreen(screen);
	args[1].addr = (XtPointer) &colormap;
	args[1].size = sizeof(Colormap);
	num_args = 2;
	tet_infoline("TEST: Conversion succeeds");
	fromVal.addr = pixstr;
	fromVal.size = strlen(pixstr)+1;
	toVal.addr = (XtPointer) &res;
	toVal.size = sizeof(Pixel);
	status = XtCvtStringToPixel(display,
			&args[0],
			&num_args,
			&fromVal,
			&toVal,
			&closure_ret);
	check_dec(True, status, "XtCvtStringToPixel return value");
	tet_infoline("TEST: Conversion result");
	check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.812 */
/* End of included file Mdefcode.tmc.812 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
