/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtVaSetSubvalues()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

void XtWMH3l_Proc(str)
String str;
{
        avs_set_event(2,1);
}

void XtWMH3_Proc(str1, str2, str3, str4, str5, car)
String str1, str2, str3, str4, *str5;
Cardinal *car;
{
	avs_set_event(2,1);
}

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

typedef struct _instance_variables {
	long foreground;
	String label;
} instance_variable_rec;
typedef struct _instance_variables2 {
	long l1;
	long l2;
} instance_variable_rec2;
static XtResource resources[] = {
	{
	XtNforeground,
	XtCForeground,
	XtRPixel, sizeof(Pixel),
	XtOffsetOf(instance_variable_rec, foreground),
	XtRString, "XtDefaultforeground"
	},
	{
	XtNlabel,
	XtCLabel,
	XtRString, sizeof(String),
	XtOffsetOf(instance_variable_rec, label),
	XtRString, "XtDefaultLabel"
	},
};


#define T_XtVaSetSubvalues	1
char    *TestName = "XtVaSetSubvalues";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaSetSubvalues-1.(A)");
	report_assertion("A call to void XtVaSetSubvalues(base, resources,");
	report_assertion("num_resources,...) shall copy the resource value specified");
	report_assertion("by the value field for the resource specified in the name");
	report_assertion("field of each name/value pair in the varargs style variable");
	report_assertion("argument list that is present in the resource list specified");
	report_assertion("by resources to the structure pointed to by base.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvastsvls1", "XtVaSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			 (ArgList) NULL,(Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 XtNlabel, "Hello World", NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &pixel,
		 XtNlabel, &string, NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3636 */
/* End of included file Mdefcode.tmc.3636 */

static void t002(){

instance_variable_rec2 base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaSetSubvalues-2.(A)");
	report_assertion("A call to void XtVaSetSubvalues(base, resources,");
	report_assertion("num_resources,...) when a resource specified in the variable");
	report_assertion("argument list is not present in the resource list specified");
	report_assertion("by resources shall not copy the resource value to the");
	report_assertion("structure base.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvastsvls1", "XtVaSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			 (ArgList) NULL,(Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	base.l1 = (long)-1;
	base.l2 = (long)-1;
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 "not real", 2, (char *)NULL);
	tet_infoline("TEST: Only correct values are set");
	check_dec(1, base.l1 , XtNforeground);
	check_dec(-1, base.l2 , "missing long value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3636 */
/* End of included file Mdefcode.tmc.3636 */

static void t003(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
int status;
char *string;
Cardinal num_args;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaSetSubvalues-3.(A)");
	report_assertion("When the name XtVaTypedArg is specified in place of a");
	report_assertion("resource name in the variable argument list a call to void");
	report_assertion("XtVaSetSubvalues(base, resources, num_resources,...) shall");
	report_assertion("issue a warning message and ignore the entry.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvastsvls1", "XtVaSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Set Warning Message Handler");
	XtAppSetWarningMsgHandler(app_ctext, XtWMH3_Proc);
	XtAppSetWarningHandler(app_ctext, XtWMH3l_Proc);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			 (ArgList) NULL,(Cardinal)0);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtNforeground, 1,
		 XtVaTypedArg, "name", "type", (XtArgVal)1, 1, XtNlabel, "Hello World", NULL);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &pixel,
		 XtNlabel, &string, NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	tet_infoline("TEST: Warning message was generated");
	status = avs_get_event(2);
	check_dec(1, status, "warning handler called");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3636 */
/* End of included file Mdefcode.tmc.3636 */

static void t004(){

instance_variable_rec base;
Cardinal num_resources;
Pixel pixel;
char *string;
Cardinal num_args;
pid_t pid2;
XtVarArgsList sublist;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtVaSetSubvalues-4.(A)");
	report_assertion("On a call to void XtVaSetSubvalues(base, resources,");
	report_assertion("num_resources,...) when the name XtVaNestedList is");
	report_assertion("specified in place of a resource name in the variable");
	report_assertion("argument list the next argument shall be interpreted as a");
	report_assertion("value specifying another varargs style variable argument");
	report_assertion("list which shall be logically inserted into the original");
	report_assertion("list at the point of declaration.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tvastsvls1", "XtVaSetSubvalues");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Initialize the base address");
	XtGetApplicationResources(topLevel, &base, resources, 2,
			 (ArgList) NULL,(Cardinal)0);
	tet_infoline("PREP: Create nested list");
	sublist = XtVaCreateArgsList(NULL, XtNforeground, (XtArgVal)1, NULL);
	tet_infoline("PREP: Set subvalues");
	XtVaSetSubvalues(&base, resources, 2, XtVaNestedList, sublist,
		 XtNlabel, "Hello World", (char *)NULL, 0);
	tet_infoline("PREP: Get subvalues");
	XtVaGetSubvalues(&base, resources, 2, XtNforeground, &pixel,
		 XtNlabel, &string, (char *)NULL);
	tet_infoline("TEST: Retrieved subvalues");
	check_dec(1, pixel , XtNforeground);
	check_str("Hello World", string , XtNlabel);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3636 */
/* End of included file Mdefcode.tmc.3636 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
