/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGetActionList()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Composite.h>
#include <AvsComp.h>
#include <AvsComp2.h>
#include <AvsRectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtGetActionList	1
char    *TestName = "XtGetActionList";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
Widget test_widget;
Widget test_widget2;
XEvent event;
Display *display;
WidgetClass	my_class;
XtActionList	my_list;
Cardinal	num_actions_return;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetActionList-1.(C)");
	report_assertion("If the implementation is X11R5 or greater: A call to void");
	report_assertion("XtGetActionList(widget_class, actions_return,");
	report_assertion("num_actions_return) shall return the action table defined by");
	report_assertion("the widget class widget_class in actions_return and the");
	report_assertion("number of action procedures on the list in");
	report_assertion("num_actions_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tgtactlst1", "XtGetActionList");
	tet_infoline("PREP: Create composite AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw", avsCompWidgetClass, boxw1, NULL);
	test_widget2 = XtVaCreateManagedWidget("avsw2", avsComp2WidgetClass, test_widget, NULL);
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Call XtGetActionList on composite AVS widget");
	my_class = avsComp2WidgetClass;
	XtGetActionList(my_class, (XtActionList *)&my_list, &num_actions_return);
	tet_infoline("TEST: Verify XtGetActionList returns proper actions");
	if (my_list == NULL) {
		sprintf(ebuf, "ERROR: actions_return should not be NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (num_actions_return != 2) {
		sprintf(ebuf, "ERROR: num_actions_return should be 2, is %d", num_actions_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (strcmp(my_list->string, "action11") != 0) {
		sprintf(ebuf, "ERROR: first action should be action11, is %s", my_list->string);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	my_list++;
	if (strcmp(my_list->string, "action12") != 0) {
		sprintf(ebuf, "ERROR: second action should be action12, is %s", my_list->string);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1052 */
/* End of included file Mdefcode.tmc.1052 */

static void t002(){

#if XT_X_RELEASE > 4
Widget test_widget;
Widget test_widget2;
XEvent event;
Display *display;
WidgetClass	my_class;
XtActionList	my_list;
Cardinal	num_actions_return;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetActionList-2.(C)");
	report_assertion("If the implementation is X11R5 or greater: A call to void");
	report_assertion("XtGetActionList(widget_class, actions_return,");
	report_assertion("num_actions_return) shall not return the action tables");
	report_assertion("defined by the superclasses of the widget class");
	report_assertion("widget_class.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tgtactlst1", "XtGetActionList");
	tet_infoline("PREP: Create composite AVS widget");
	test_widget = XtVaCreateManagedWidget("avsw", avsCompWidgetClass, boxw1, NULL);
	test_widget2 = XtVaCreateManagedWidget("avsw2", avsComp2WidgetClass, test_widget, NULL);
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Call XtGetActionList on composite AVS widget");
	my_class = avsComp2WidgetClass;
	XtGetActionList(my_class, (XtActionList *)&my_list, &num_actions_return);
	tet_infoline("TEST: Verify XtGetActionList returns proper actions");
	if (my_list == NULL) {
		sprintf(ebuf, "ERROR: actions_return should not be NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (strcmp(my_list->string, "action1") == 0) {
		sprintf(ebuf, "ERROR: superclass' actions being reported");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	my_list++;
	if (strcmp(my_list->string, "action2") == 0) {
		sprintf(ebuf, "ERROR: superclass' actions being reported");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1052 */
/* End of included file Mdefcode.tmc.1052 */

static void t003(){

#if XT_X_RELEASE > 4
Widget test_widget;
XEvent event;
Display *display;
WidgetClass	my_class, my_superclass;
XtActionList	*my_list, *my_Superclass_list;
Cardinal	num_actions_return = 10;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetActionList-3.(C)");
	report_assertion("If the implementation is X11R5 or greater: A call to void");
	report_assertion("XtGetActionList(widget_class, actions_return,");
	report_assertion("num_actions_return) when the widget class widget_class is");
	report_assertion("not initialized shall return NULL in actions_return and zero");
	report_assertion("in num_actions_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tgtactlst4","XtGetActionList");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Verify XtGetActionList indicates no actions");
	my_class = avsCompWidgetClass;
	XtGetActionList(my_class, (XtActionList *)&my_list, &num_actions_return);
	if (my_list != NULL) {
		sprintf(ebuf, "ERROR: actions_return should be NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (num_actions_return != 0) {
		sprintf(ebuf, "ERROR: num_actions_return should be 0, is %d", num_actions_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1052 */
/* End of included file Mdefcode.tmc.1052 */

static void t004(){

#if XT_X_RELEASE > 4
Widget test_widget;
Widget test_widget2;
XEvent event;
Display *display;
WidgetClass	my_class;
XtActionList	my_list;
Cardinal	num_actions_return;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGetActionList-4.(C)");
	report_assertion("If the implementation is X11R5 or greater: A call to void");
	report_assertion("XtGetActionList(widget_class, actions_return,");
	report_assertion("num_actions_return) when the widget class widget_class is");
	report_assertion("not coreWidgetClass or a subclass thereof shall return NULL");
	report_assertion("in actions_return and zero in num_actions_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tgtactlst1", "XtGetActionList");
	tet_infoline("PREP: Create AVS RectObj widget");
	test_widget = XtVaCreateManagedWidget("avsro", avsrectObjClass, topLevel, NULL);
	XtRealizeWidget(topLevel);
	/*this widget has two actions but is not a subclass of core*/
	tet_infoline("TEST: Verify XtGetActionList returns no actions");
	my_class = avsrectObjClass;
	XtGetActionList(my_class, &my_list, &num_actions_return);
	if (my_list != NULL) {
		sprintf(ebuf, "ERROR: actions_return should be NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (num_actions_return != 0) {
		sprintf(ebuf, "ERROR: num_actions_return should be 0, is %d", num_actions_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1052 */
/* End of included file Mdefcode.tmc.1052 */

static void t005(){

#if XT_X_RELEASE > 4
Widget test_widget;
XEvent event;
Display *display;
WidgetClass	my_class, my_superclass;
XtActionList	*my_list, *my_Superclass_list;
Cardinal	num_actions_return = 10;
pid_t pid2;
#endif
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtGetActionList-5.(C)");
	report_assertion("If the implementation is X11R5 or greater: A call to void");
	report_assertion("XtGetActionList(widget_class, actions_return,");
	report_assertion("num_actions_return) when the widget class widget_class does");
	report_assertion("not define any actions shall return NULL in actions_return");
	report_assertion("and zero in num_actions_return.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#if XT_X_RELEASE > 4
	FORK(pid2);
	avs_xt_hier("Tgtactlst4", "XtGetActionList");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Verify XtGetActionList indicates no actions");
	my_class =compositeWidgetClass;
	XtGetActionList(my_class, (XtActionList *)&my_list, &num_actions_return);
	if (my_list != NULL) {
		sprintf(ebuf, "ERROR: actions_return should be NULL");
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	if (num_actions_return != 0) {
		sprintf(ebuf, "ERROR: num_actions_return should be 0, is %d", num_actions_return);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.1052 */
/* End of included file Mdefcode.tmc.1052 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
