/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtAppError()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
char msg[1024];

/*
** XtEMH_Proc
*/
static void XtEMH_Proc(str)
String str;
{
	avs_set_event(1, 1);
	fprintf(stdout, "X Toolkit Error: %s", str);
}

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtAppError	1
char    *TestName = "XtAppError";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char line[80], buf[80];
FILE *stream;
char *string;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppError-1.(A)");
	report_assertion("A call to void XtAppError(app_context, message) shall");
	report_assertion("invoke the low-level error handler for the application");
	report_assertion("context app_context passing message as an argument to it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Taperror1", "XtAppError");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the file name to store error message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	tet_infoline("PREP: Register a low-level error handler");
	XtAppSetErrorHandler(app_ctext, XtEMH_Proc);
	tet_infoline("TEST: Call XtAppError");
	push_stdout("outfile", "w");
	XtAppError(app_ctext, "Hello World");
	pop_stdout();
	tet_infoline("TEST: Error handler was invoked");
	status = avs_get_event(1);
	check_dec(1, status, "XtEMH_Proc invocations count");
	tet_infoline("TEST: Open the temporary file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	strncpy(buf, string, strlen("Hello World"));
	if (strncmp("Hello World", buf, strlen("Hello World")) != 0 ) {
		sprintf(ebuf, "ERROR: Expected message to contain \"Hello World\", Received %s", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);
	unlink(msg);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.808 */
/* End of included file Mdefcode.tmc.808 */

/* Including from file Mdefcode.tmc.808 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppError-2.(B)");
	report_assertion("When no user defined low-level error handler has been");
	report_assertion("registered for the specified application context a call to");
	report_assertion("void XtAppError(app_context, message) shall invoke the");
	report_assertion("default low-level error handler provided by the Intrinsics.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.808 */

static void t003(){

char line[80], buf[80];
FILE *stream;
char *string;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppError-3.(C)");
	report_assertion("If the implementation is POSIX-based: The default low-level");
	report_assertion("error handler invoked by a call to void");
	report_assertion("XtAppError(app_context, message) shall print the message");
	report_assertion("message to the standard error of the calling process and");
	report_assertion("terminate it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	avs_xt_hier("Taperror2", "XtAppError");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get the file name to store error message");
	strcpy(msg, "/tmp/");
	strcat(msg, "outfile");
	FORK(pid2);
	tet_infoline("PREP: Redirect stderr to a file");
	push_stderr("outfile", "w");
	tet_infoline("TEST: Call XtAppError");
	XtAppError(app_ctext, "Hello World");
	pop_stderr();
	tet_infoline("ERROR: Application was not terminated");
	tet_result(TET_FAIL);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: Open the file and read the message");
	stream = (FILE *)fopen(msg, "r");
	if (stream == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	if (fgets(line, 80, stream) == NULL) {
		tet_infoline("ERROR: Message not generated");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	tet_infoline("TEST: Message is correct");
	string = (char *)strstr(line, "Hello World");
	strncpy(buf, string, strlen("Hello World"));
	if (strncmp("Hello World", buf, strlen("Hello World")) != 0 ) {
		sprintf(ebuf, "ERROR: Expected message to contain \"Hello World\", Received %s", buf);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("CLEANUP: Unlink the file");
	fclose(stream);
	unlink(msg);
	tet_result(TET_PASS);
}
else {
	tet_infoline("INFO: Not configured as a POSIX system");
	tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.808 */
/* End of included file Mdefcode.tmc.808 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
