/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtInputMask
 *   XtAppPending()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

XtInputId input_ret;
char *msg = "Hello World";
FILE *fid;
/* Procedure XtIOP_Proc */
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
}
/*
** XtTMO_Proc
*/
void XtTMO1_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
}
/*
** XtTMO_Proc
*/
void XtTMO2_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	/*
	** Queue should be empty at this point
	** KeyPress will wake up XtAppNextEvent, XtAppPending should then
	** find an empty queue.
	*/
	send_event(topLevel, KeyPress, KeyPressMask, TRUE);
}
void XtTMO3_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}


#define T_XtAppPending	1
char    *TestName = "XtAppPending";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int pending, status = 0;
int type_event = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppPending-1.(A)");
	report_assertion("When the application context specified by app_context has");
	report_assertion("at least one pending event from the X server a successful");
	report_assertion("call to XtInputMask XtAppPending(app_context) shall return a");
	report_assertion("value that has the XtIMXEvent bit set.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tappendng1", "XtAppPending");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO1_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: XtAppPending will return correct mask");
	display = XtDisplay(rowcolw);
	for (i = 1;i == 1;) {
		processing = XtAppPending(app_ctext);
		if (processing != 0) {
			if ((processing & XtIMXEvent) != 0) {
				if (XtAppPeekEvent(app_ctext, &loop_event) != True) {
					tet_infoline("ERROR: XtAppPending says event is pending but XtAppPeekEvent says not");
					tet_result(TET_FAIL);
					exit(0);
				}
					if (loop_event.type == KeyPress) {
						avs_set_event(2, 1);
					exit(0);
				}
			}
			if ((processing & XtIMTimer) != 0)
					avs_set_event(1, 1);
			XtAppNextEvent(app_ctext, &loop_event);
			XSync(display, False);
			XtDispatchEvent(&loop_event);
		}
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(1, status, "reports of timeout");
	status = avs_get_event(2);
	check_dec(1, status, "reports of keypresses");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3952 */
/* End of included file Mdefcode.tmc.3952 */

static void t002(){

pid_t pid2;
int pending, status = 0;
int type_event = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppPending-2.(A)");
	report_assertion("When the application context specified by app_context has");
	report_assertion("at least one pending timer a successful call to XtInputMask");
	report_assertion("XtAppPending(app_context) shall return a value that has the");
	report_assertion("XtIMTimer bit set.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tappendng1", "XtAppPending");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO3_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: XtAppPending will return correct mask");
	display = XtDisplay(rowcolw);
	for (i = 1;i == 1;) {
		processing = XtAppPending(app_ctext);
		if (processing != 0) {
			if ((processing & XtIMTimer) != 0) {
				avs_set_event(2, 1);
				exit(0);
			}
			XtAppNextEvent(app_ctext, &loop_event);
			XSync(display, False);
			XtDispatchEvent(&loop_event);
		}
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(2);
	check_dec(1, status, "reports of timeout");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3952 */
/* End of included file Mdefcode.tmc.3952 */

static void t003(){

pid_t pid2;
int pending, status = 0;
int type_event = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
const char *data;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppPending-3.(A)");
	report_assertion("When the application context specified by app_context has");
	report_assertion("at least one pending event from input sources other than the");
	report_assertion("X server and timer a successful call to XtInputMask");
	report_assertion("XtAppPending(app_context) shall return a value that has the");
	report_assertion("XtIMAlternateInput bit set.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = outfile("tappendng.dat");
	FORK(pid2);
	avs_xt_hier("Tappendng1", "XtAppPending");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO3_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("TEST: XtAppPending will return correct mask");
	display = XtDisplay(rowcolw);
	for (i = 1;i == 1;) {
		processing = XtAppPending(app_ctext);
		if (processing != 0) {
			if ((processing & XtIMAlternateInput) != 0) {
				avs_set_event(3, 1);
				exit(0);
			}
			XtAppNextEvent(app_ctext, &loop_event);
			XSync(display, False);
			XtDispatchEvent(&loop_event);
		}
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(data);
	status = avs_get_event(3);
	check_dec(1, status, "reports of alternate input events");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3952 */
/* End of included file Mdefcode.tmc.3952 */

static void t004(){

pid_t pid2;
int pending, status = 0;
int type_event = 0;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
const char *data;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppPending-4.(A)");
	report_assertion("When the application context specified by app_context has");
	report_assertion("pending events from more than one source a call to");
	report_assertion("XtInputMask XtAppPending(app_context) shall return a value");
	report_assertion("that is the logical OR of XtIMXEvent, XtIMTimer, and");
	report_assertion("XtIMAlternateInput bits corresponding to the pending event");
	report_assertion("sources.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	data = outfile("tappendng.dat");
	FORK(pid2);
	avs_xt_hier("Tappendng1", "XtAppPending");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO3_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	tet_infoline("PREP: Send keypress events");
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
	tet_infoline("TEST: XtAppPending will return correct mask");
	display = XtDisplay(rowcolw);
	for (i = 1;i == 1;) {
		processing = XtAppPending(app_ctext);
		if (processing != 0) {
			if ((processing & (XtIMXEvent|XtIMAlternateInput)) == (XtIMXEvent|XtIMAlternateInput)) {
				avs_set_event(2, 1);
				exit(0);
			}
			XtAppNextEvent(app_ctext, &loop_event);
			XSync(display, False);
			XtDispatchEvent(&loop_event);
		}
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	unlink(data);
	status = avs_get_event(2);
	check_dec(1, status, "reports of both X and alternate input events");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3952 */
/* End of included file Mdefcode.tmc.3952 */

static void t005(){

pid_t pid2;
int status;
XEvent loop_event;
Display *display;
XtInputMask processing;
int i;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppPending-5.(A)");
	report_assertion("When no events are pending for the application context");
	report_assertion("specified by app_context a call to XtInputMask");
	report_assertion("XtAppPending(app_context) shall flush the output buffers of");
	report_assertion("every display in the application context and return zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tappendng2", "XtAppPending");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO2_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: With no events pending zero is returned");
	display = XtDisplay(rowcolw);
	for ( i = 0; i == 0;) { /* Begin for */
		XtAppNextEvent(app_ctext, &loop_event);
		XSync(display, False);
		/*
		** no events in wait state: processing = 0
		*/
		if (loop_event.type == KeyPress) {
		processing = XtAppPending(app_ctext);
		avs_set_event(1, processing);
		exit(0);
		}
		XtDispatchEvent(&loop_event);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-2);
	status = avs_get_event(1);
	check_dec(0, status, "return when queue is empty");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.3952 */
/* End of included file Mdefcode.tmc.3952 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
