/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1)
 *   Display	*display;
 *   XDevice	*device;
 *   Window	grab_window;
 *   Bool	owner_events;
 *   unsigned int 	event_count;
 *   XEventClass *event_list;
 *   int 	this_device_mode;
 *   int 	other_devices_mode;
 *   Time	time1;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGrabDevice	1
char    *TestName = "XGrabDevice";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW grab_window
#define A_DRAWABLE grab_window


/*
 * Arguments to the XGrabDevice function
 */
static Display	*display;
static XDevice	*device;
static Window	grab_window;
static Bool	owner_events;
static unsigned int 	event_count;
static XEventClass *event_list;
static int 	this_device_mode;
static int 	other_devices_mode;
static Time	time1;


static int 	ValueReturn;


extern int MinKeyCode;
extern ExtDeviceInfo Devs;

/*
 * For all these tests note that the grab_window is automatically destroyed
 * at the end of the test, and therefore the grab is released.
 */

/*
 * Get the window that the pointer is currently in, if the pointer
 * is in a child of the given window. Otherwise it returns None.
 */
Window
getpointerwin(disp, win)
Display	*disp;
Window	win;
{
Window	child;
Window	wtmp;
int 	itmp;
unsigned uitmp;
Bool 	s;

	s = XQueryPointer(disp, win, &wtmp, &child, &itmp, &itmp, &itmp, &itmp
		, &uitmp);

	if (!s)
		delete("Could not get pointer window");

	return(child);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	grab_window = 0;
	owner_events = True;
	event_count = 0;
	event_list = NULL;
	this_device_mode = GrabModeAsync;
	other_devices_mode = GrabModeAsync;
	time1 = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	grab_window = ErrdefWindow;
}

static void t001(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGrabDevice-1.(B)");
	report_assertion("A successful call to XGrabDevice actively grabs control of");
	report_assertion("the device and returns GrabSuccess.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDevice.");
	report_strategy("Verify that it returns GrabSuccess.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret != GrabSuccess) {
		report("GrabSuccess was not returned");
		FAIL;
	} else
		CHECK;

        XUngrabDevice(Dsp, device, CurrentTime);
        XSync(Dsp,0);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	w1, w2;
int ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGrabDevice-2.(B)");
	report_assertion("A call to XGrabDevice overrides any active device grab by");
	report_assertion("this client.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create two windows.");
	report_strategy("Call XGrabDevice with one of the windows.");
	report_strategy("Call XGrabDevice with the other window.");

	tpstartup();
	setargs();
	w1 = defwin(display);
	w2 = defwin(display);

	grab_window = w1;

	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == Success)
		PASS;
	else {
		report("A second grab did not override the first");
		FAIL;
	}
        XUngrabDevice(Dsp, device, CurrentTime);
        XSync(Dsp,0);


	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	ret;
int	dfi, dfo;
XEventClass dficlass, dfoclass;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGrabDevice-3.(B)");
	report_assertion("When a successful call to GrabDevice is made, DeviceFocusIn");
	report_assertion("and DeviceFocusOut events are generated and sent to clients");
	report_assertion("requesting them.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDevice.");
	report_strategy("Verify that DeviceFocus events are received.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	device = Devs.Any;
	DeviceFocusIn(device, dfi, dficlass);
	DeviceFocusOut(device, dfo, dfoclass);
	XSelectExtensionEvent(display, grab_window, &dficlass, 1);
	XSelectExtensionEvent(display, RootWindow(display,0), &dfoclass, 1);
	XSync (display,0);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret != GrabSuccess) {
		report("GrabSuccess was not returned");
		FAIL;
	} else
		CHECK;
	XSync (display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dfi || ev.type==dfo)
		CHECK;
	    else
		FAIL;
	    }

        XUngrabDevice(Dsp, device, CurrentTime);
        XSync(Dsp,0);
	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	ret;
int	badclass;
int	dkp;
XEventClass dkpclass;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGrabDevice-4.(B)");
	report_assertion("If an event class from a device other than the grab_device");
	report_assertion("are specified on a call to GrabDevice, a BadClass error will");
	report_assertion("result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDevice, specifying event classes from another device.");
	report_strategy("Verify that a BadClass error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | NKeysMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	BadClass(display,badclass);
	grab_window = defwin(display);
	device = Devs.Key;
	DeviceKeyPress(Devs.Key, dkp, dkpclass);
	dkpclass &= 0xff;
	dkpclass |= Devs.NoKeys->device_id << 8;
	event_list = &dkpclass;
	event_count = 1;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}

	if (geterr() != badclass) {
		report("BadClass was not returned");
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int dkr;
XEventClass dkrclass;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGrabDevice-5.(B)");
	report_assertion("When other_devices_mode is GrabModeAsync, then device");
	report_assertion("event processing is unaffected by activation of the grab.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDevice with other_devices_mode set to GrabModeAsync.");
	report_strategy("Select events from another extension input device.");
	report_strategy("Verify that events can still be received from the other device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | NKeysMask))
	    {
	    untested("%s: Required input extension device not present.\n", 
		TestName);
	    return;
	    }
	device = Devs.NoKeys;

	grab_window = defwin(display);
	warppointer(display, grab_window, 1, 1);
	DeviceKeyRelease(Devs.Key, dkr, dkrclass);
	XSelectExtensionEvent(display, grab_window, &dkrclass, 1);
	other_devices_mode = GrabModeAsync;

	event_count=0;
	event_list=NULL;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (noext(1))
	    {
	    report("There is no reliable test method, but a touch test was performed");
	    return;
	    }
	devicekeypress (display, Devs.Key, MinKeyCode);
	devicekeyrel (display, Devs.Key, MinKeyCode);
	XSync(display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkr)
		CHECK;
	    }
	devicerelkeys (Devs.Key);
        XUngrabDevice(Dsp, device, CurrentTime);
        XSync(Dsp,0);

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int ret;
int dkr;
XEventClass dkrclass;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGrabDevice-6.(B)");
	report_assertion("When other_devices_mode is GrabModeSync, then the state of");
	report_assertion("the other devices, as seen by client applications, appears");
	report_assertion("to freeze, and no further device events are generated until");
	report_assertion("the grabbing client calls XAllowDeviceEvents or until the");
	report_assertion("device grab is released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDevice with other_devices_mode set to GrabModeSync.");
	report_strategy("Verify that no events are received from other devices until");
	report_strategy("XAllowDeviceEvents is called or until the device grab is released.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | NKeysMask))
	    {
	    untested("%s: Required input extension device not present.\n", 
		TestName);
	    return;
	    }
	device = Devs.NoKeys;

	grab_window = defwin(display);
	warppointer(display, grab_window, 1, 1);
	DeviceKeyRelease(Devs.Key, dkr, dkrclass);
	XSelectExtensionEvent(display, grab_window, &dkrclass, 1);
	other_devices_mode = GrabModeSync;
	event_count=0;
	event_list=NULL;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (noext(1))
	    {
	    report("There is no reliable test method, but a touch test was performed");
	    return;
	    }
	devicekeypress (display, Devs.Key, MinKeyCode);
	devicekeyrel (display, Devs.Key, MinKeyCode);
	XSync(display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkr)
		{
		report("%s: Got events from other devices when they should be frozen.\n",TestName);
		FAIL;
		}
	    }

	/* Verify that XAllowDeviceEvents releases the queued events. */

	XAllowDeviceEvents(display, device, AsyncAll, CurrentTime);
	XSync(display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkr)
		CHECK;
	    }

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	devicekeypress (display, Devs.Key, MinKeyCode);
	devicekeyrel (display, Devs.Key, MinKeyCode);
	XSync(display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkr)
		{
		report("%s: Got events from other devices when they should be frozen.\n",TestName);
		FAIL;
		}
	    }
	XUngrabDevice(display, device, CurrentTime);
	XSync(display,0);
	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkr)
		CHECK;
	    }

	CHECKPASS(2);
	devicerelkeys (Devs.Key);
	other_devices_mode = GrabModeAsync;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.365260 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGrabDevice-7.(B)");
	report_assertion("When a successful call to XGrabDevice is made, then the");
	report_assertion("last-device-grab time is set to the specified time with");
	report_assertion("CurrentTime replaced by the current X server time.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.365260 */

static void t008(){

Display	*client2;
Window	win;
XEvent	ev;
int dmn;
XEventClass dmnc;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGrabDevice-8.(B)");
	report_assertion("When the grab_window window becomes not viewable during an");
	report_assertion("active device grab, then the grab is released.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create new client, client2.");
	report_strategy("Create grab window.");
	report_strategy("Create spare window 'win' that does not overlap with the other two.");
	report_strategy("Enable events on win for client2.");
	report_strategy("Grab device.");
	report_strategy("Unmap grab_window.");
	report_strategy("Verify that grab is released by provoking device events for client2.");
	report_strategy("");
	report_strategy("Re-map grab_window.");
	report_strategy("Grab device.");
	report_strategy("Verify that grab is released by provoking device events for client2.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(ValMask| AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	DeviceMotionNotify(Devs.Valuator, dmn, dmnc);
	warppointer(display, DRW(display), 0, 0);

	client2 = opendisplay();

	grab_window = defwin(display);
	win = defwin(display);

	XSelectInput(client2, win, EnterWindowMask);
	XSelectExtensionEvent(client2, win, &dmnc, 1);
	XSync(client2, True);

	device = Devs.Valuator;
	event_list = &dmnc;
	event_count = 1;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XUnmapWindow(display, grab_window);

	/*
	 * Warp into win and force all events to be received.
	 * If the grab has been released then this will generate
	 * an event for client2.
	 */
	warppointer(display, win, 0, 0);
	XSync(client2, False);

	if (XCheckWindowEvent(client2, win, PointerMotionMask|EnterWindowMask, &ev))
		PASS;
	else {
		report("Grab was not released when grab_window was unmapped");
		FAIL;
	}

	/* Clear any extra events */
	XSync(client2, True);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGrabDevice-9.(B)");
	report_assertion("When the grab_window is not viewable, then a call to");
	report_assertion("XGrabDevice fails and returns GrabNotViewable.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create unmapped grab window.");
	report_strategy("Attempt to grab device.");
	report_strategy("Verify that XGrabDevice fails and returns GrabNotViewable.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	XUnmapWindow(display, grab_window);

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabNotViewable)
		PASS;
	else {
		report("Return value was %s, expecting GrabNotViewable", grabreplyname(ret));
		FAIL;
	}
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display	*client1;
Display	*client2;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGrabDevice-10.(B)");
	report_assertion("When the device is actively grabbed by some other client,");
	report_assertion("then a call to XGrabDevice fails and returns AlreadyGrabbed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create client2.");
	report_strategy("Grab device with client2.");
	report_strategy("Attempt to grab device with default client.");
	report_strategy("Verify that XGrabDevice fails and returns AlreadyGrabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	if ((client2 = opendisplay()) == 0)
		return;

	grab_window = defwin(Dsp);
	if (isdeleted())
		return;

	display = client2;
	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if ((client1 = opendisplay()) == 0)
		return;
	display = client1;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == AlreadyGrabbed)
		CHECK;
	else {
		report("Return value was %s, expecting AlreadyGrabbed", grabreplyname(ret));
		FAIL;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Display	*client2;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XGrabDevice-11.(B)");
	report_assertion("When the device is frozen by an active grab of another");
	report_assertion("client, then a call to XGrabDevice fails and returns");
	report_assertion("GrabFrozen.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create client2.");
	report_strategy("Grab another device and freeze the target device with client2.");
	report_strategy("Attempt to grab device with default client.");
	report_strategy("Verify that XGrabDevice fails and returns GrabFrozen.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	if ((client2 = opendisplay()) == 0)
		return;

	grab_window = defwin(display);

	if (XGrabKeyboard(client2, grab_window, True, GrabModeSync, GrabModeSync, CurrentTime) != GrabSuccess) {
		delete("Could not freeze device by grabbing keyboard");
		return;
	}
	
	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabFrozen)
		CHECK;
	else {
		report("Return value was %s, expecting GrabFrozen", grabreplyname(ret));
		FAIL;
	}

	XUngrabKeyboard (display, CurrentTime);
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XGrabDevice-12.(B)");
	report_assertion("When the specified time is earlier than the");
	report_assertion("last-device-grab time or later than the current X server");
	report_assertion("time, then a call to XGrabDevice fails and returns");
	report_assertion("GrabInvalidTime.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab device with a given time.");
	report_strategy("Release grab.");
	report_strategy("Grab device with earlier time.");
	report_strategy("Verify that XGrabDevice fails and returns GrabInvalidTime.");
	report_strategy("Get current server time.");
	report_strategy("Grab device with later time.");
	report_strategy("Verify that XGrabDevice fails and returns GrabInvalidTime.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);

	/* get time from the server */
	time1 = gettime(display);

	/* This sets the last-device-grab time */
	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (ValueReturn != GrabSuccess) {
		report("Returned value was %d, expecting GrabSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XUngrabDevice(display, device, time1);

	time1 -= 100;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabInvalidTime)
		CHECK;
	else {
		report("Return value was %s, expecting GrabInvalidTime",
			grabreplyname(ret));
		FAIL;
	}
	XUngrabDevice(display, device, time1);

	/*
	 * Get current time again and add several minutes to get a time in the
	 * future.
	 */
	time1 = gettime(display);
	time1 += ((config.speedfactor+1) * 1000000);

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret == GrabInvalidTime)
		CHECK;
	else {
		 report("Returned valued was %s, expecting GrabInvalidTime", grabreplyname(ret));
		 FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	ret;
int badclass;
XEventClass	bogus[2];
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XGrabDevice-13.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid event class, a");
	report_assertion("BadClass error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadValue.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	BadClass(display, badclass);
	bogus[0]=-1;
	bogus[1]=-1;
	event_list = bogus;
	event_count = 2;
	grab_window = defwin(display);

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	if (geterr() == badclass)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XGrabDevice-14.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid");
	report_assertion("this_devices_mode, a BadValue error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadValue.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	this_device_mode = -1;

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XGrabDevice-15.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid");
	report_assertion("other_devices_mode, a BadValue error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadValue.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	other_devices_mode = -1;

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XGrabDevice-16.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid ownerEvents, a");
	report_assertion("BadValue error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadValue.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	owner_events = -1;

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XGrabDevice-17.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid window id, a");
	report_assertion("BadWindow error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadWindow.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = 0;

	device = Devs.Any;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int 	ret;
XDevice bogus;
int baddevice;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XGrabDevice-18.(B)");
	report_assertion("If XGrabDevice is invoked with an invalid device id, a");
	report_assertion("BadDevice error will result.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Verify that XGrabDevice fails and returns BadDevice.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	grab_window = defwin(display);
	BadDevice(display,baddevice);

	bogus.device_id = 128;
	device = &bogus;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDevice(display, device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode, time1);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
