/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode)
 *   Display	*display;
 *   XDevice *device;
 *   int 	keycode;
 *   unsigned int 	modifiers;
 *   XDevice *modifier_device;
 *   Window	grab_window;
 *   Bool	owner_events;
 *   int 	event_count;
 *   XEventClass *event_list;
 *   int 	this_device_mode;
 *   int 	other_devices_mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGrabDeviceKey	1
char    *TestName = "XGrabDeviceKey";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW grab_window
#define A_DRAWABLE grab_window


/*
 * Arguments to the XGrabDeviceKey function
 */
static Display	*display;
static XDevice *device;
static int 	keycode;
static unsigned int 	modifiers;
static XDevice *modifier_device;
static Window	grab_window;
static Bool	owner_events;
static int 	event_count;
static XEventClass *event_list;
static int 	this_device_mode;
static int 	other_devices_mode;


extern int MinKeyCode;
extern ExtDeviceInfo Devs;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	keycode = AnyKey;
	modifiers = AnyModifier;
	modifier_device = 0;
	grab_window = defwin(display);
	owner_events = False;
	event_count = 0;
	event_list = 0;
	this_device_mode = GrabModeAsync;
	other_devices_mode = GrabModeAsync;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGrabDeviceKey-1.(B)");
	report_assertion("A call to XGrabDeviceKey establishes a passive grab on the");
	report_assertion("key device that is activated in the future by the specified");
	report_assertion("key being logically pressed, the specified modifier keys");
	report_assertion("being logically down, no other modifier keys being logically");
	report_assertion("down, the grab_window being the focus window or an ancestor");
	report_assertion("of the focus window or being a descendant of the focus");
	report_assertion("window that contains the pointer and a passive grab on the");
	report_assertion("same key combination not existing on any ancestor of");
	report_assertion("grab_window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	modifier_device = NULL;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (noext(1))
	    return;
	warppointer(display, grab_window, 1, 1);
	devicekeypress (display, Devs.Key, MinKeyCode);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Key, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    PASS;
	devicekeyrel (display, Devs.Key, MinKeyCode);
	devicerelkeys (Devs.Key);
	XUngrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, grab_window);
	XSync (display, 0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGrabDeviceKey-2.(B)");
	report_assertion("When the conditions for activating the grab are otherwise");
	report_assertion("satisfied and the key device is already grabbed, then no");
	report_assertion("active grab is established.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish an active grab on the target device.  Then establish a passive");
	report_strategy("grab from another client.  Press a key to activate the grab.");
	report_strategy("If the passive grab worked, the client that established the passive grab");
	report_strategy("should be able to replace it with an active grab.  If it failed, the active");
	report_strategy("grab should also fail with an error of AlreadyGrabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	modifier_device = Devs.Key;

	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    FAIL;
	else
	    CHECK;

	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != Success)
	    FAIL;
	else
	    CHECK;

	if (noext(1))
	    {
	    untested("Test extension not present - touch test only.\n");
	    return;
	    }
	warppointer(display, grab_window, 1, 1);
	devicekeypress (display, device, MinKeyCode);
	XSync (display, 0);

	ret = XGrabDevice(display, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    CHECK;
	CHECKPASS(3);
	devicekeyrel (display, device, MinKeyCode);
	devicerelkeys (device);
        XUngrabDevice(client1, device, CurrentTime);
        XUngrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, grab_window);
        XSync(client1,0);
	XSync(display,0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display *client1;
XEvent	ev;
int	dkp, dkr;
XEventClass dkpclass, dkrclass;
XDeviceKeyPressedEvent	good;
XWindowAttributes	atts;
int 	ret, n;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGrabDeviceKey-3.(B)");
	report_assertion("When the conditions for activating the grab are satisfied");
	report_assertion("and the grab subsequently becomes active, then the");
	report_assertion("last-device-grab time is set to the time at which the key");
	report_assertion("was pressed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Set and activate grab.");
	report_strategy("  Check activated.");
	report_strategy("  Check activating event received.");
	report_strategy("  Check event type and event window are DeviceKeyPress and grab_window.");
	report_strategy("  Attempt UngrabDevice at time just before event time.");
	report_strategy("  Check no longer grabbed.");
	report_strategy("  Release grab and key.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;
	else
		CHECK;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }

	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	XSync(display, True);
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	DeviceKeyPress(device, dkp, dkpclass);
	DeviceKeyRelease(device, dkr, dkrclass);
	XSelectExtensionEvent(display, grab_window, &dkpclass, 1);

	warppointer(display, grab_window, 1, 1);
	XSync(display, True);	/* Discard any events */
	devicekeypress(display, device, MinKeyCode);
	XSync(display, False);

	ret = XGrabDevice(client1, Devs.Key, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    {
	    report("Failed to activate grab, ret was %d.\n",ret);
	    FAIL;
	    }
	else
	    PASS;

	n = getevent(display, &ev);
	if (n)
		CHECK;
	else {
		report("No events received for activating grab");
		XUngrabDeviceKey (display, device, AnyKey, AnyModifier, NULL, grab_window);
		devicekeyrel(display, device, MinKeyCode);
		devicerelkeys(device);
		FAIL;
		return;
	}

	XGetWindowAttributes(display, grab_window, &atts);
	defsetevent(good, display, dkp);
	good.window = grab_window;
	good.root = DRW(display);
	good.subwindow = None;
	good.time = ((XDeviceKeyPressedEvent*)&ev)->time;
	good.x = 1;
	good.y = 1;
	good.x_root = good.x + atts.x + atts.border_width;
	good.y_root = good.y + atts.y + atts.border_width;
	good.state = modifiers;
	good.keycode = MinKeyCode;
	good.same_screen = True;
	good.deviceid = Devs.Key->device_id;

	if (check_ext_event((XEvent*)&good, &ev) == 0)
		CHECK;
	else
		FAIL;

	trace("Grabbed at time 0x%lx.",(unsigned long) good.time);
	XUngrabDevice(display, device, good.time - 1);
	XSync(display,0);
	ret = XGrabDevice(client1, Devs.Key, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    {
	    report("Last device grab time set earlier than reported event time.\n");
	    FAIL;
	    }
	else
	    CHECK;

	XUngrabDevice(display, device, good.time);
	XSync(display,0);
	ret = XGrabDevice(client1, Devs.Key, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret == AlreadyGrabbed)
	    {
	    report("Last device grab time set later than reported event time.\n");
	    FAIL;
	    }
	else
	    CHECK;
	XUngrabDeviceKey (display, device, AnyKey, AnyModifier, NULL, grab_window);
        XUngrabDevice(client1, Devs.Key, CurrentTime);
	devicekeyrel(display, device, MinKeyCode);
	devicerelkeys(device);
        XSync (display, 0);
        XSync (client1, 0);
	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

unsigned int 	mods, ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGrabDeviceKey-4.(B)");
	report_assertion("When the grab subsequently becomes active and later the");
	report_assertion("logical state of the device has the specified key released,");
	report_assertion("then the active grab is terminated automatically.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place passive grab with XGrabDeviceKey.");
	report_strategy("  Activate grab with simulated device events.");
	report_strategy("  Simulate pressing some modifier keys.");
	report_strategy("  Release the key.");
	report_strategy("  Verify that the grab has been released.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	devicekeypress(display, device, MinKeyCode);
	mods = wantmods(display, 3);
	modpress(display, mods);
	XSync(display,0);

	devicekeyrel(display, device, MinKeyCode);
	XSync(display,0);

	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    {
	    report("Grab was not released, when key was released and ");
	    report("  modifier keys were down");
	    FAIL;
	    }
	else
	    PASS;
	modrel(display, mods);
	devicerelkeys(device);
	relalldev();
        XUngrabDevice (client1, device, CurrentTime);
        XSync(client1, 0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	dkp, dkr;
XEventClass dkpclass, dkrclass;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGrabDeviceKey-5.(B)");
	report_assertion("A call to XGrabDeviceKey overrides all previous passive");
	report_assertion("grabs by the same client on the same key combinations on the");
	report_assertion("same window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place a passive grab with this_device_mode = GrabModeSync.");
	report_strategy("  Place a passive grab as before but with this_device_mode = GrabModeAsync.");
	report_strategy("  Move pointer to grab_window and activate grab.");
	report_strategy("  Verify that the device is not frozen, and thus the second");
	report_strategy("  grab overrode the first.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	DeviceKeyPress(device, dkp, dkpclass);
	DeviceKeyRelease(device, dkr, dkrclass);
	XSelectExtensionEvent(display, grab_window, &dkpclass, 1);
	XSync(display,0);
	warppointer(display, grab_window, 1, 1);

	this_device_mode = GrabModeSync;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Try to override first grab */
	this_device_mode = GrabModeAsync;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	devicekeypress(display, device, MinKeyCode);
	devicekeyrel(display, device, MinKeyCode);
	devicekeypress(display, device, MinKeyCode+1);
	devicekeyrel(display, device, MinKeyCode+1);
	devicekeypress(display, device, MinKeyCode+2);
	devicekeyrel(display, device, MinKeyCode+2);
	XSync(display,0);

	while (XPending(display)) 
	    {
	    XNextEvent(display, &ev);
	    if (ev.type==dkp)
		CHECK;
	    else
		FAIL;
	    }

	devicerelkeys(device);
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

unsigned int 	ret, mods;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGrabDeviceKey-6.(B)");
	report_assertion("When the modifiers argument is AnyModifier, then this is");
	report_assertion("equivalent to separate calls to XGrabDeviceKey for all");
	report_assertion("possible modifier combinations including no modifiers.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Place passive grab with a modifiers of AnyModifier.");
	report_strategy("  Press a bunch of modifier keys.");
	report_strategy("  Press key to activate grab.");
	report_strategy("  Verify that grab is activated.");
	report_strategy("  Release keys.");
	report_strategy("");
	report_strategy("  Press key (no modifiers).");
	report_strategy("  Verify that grab is active.");
	report_strategy("else");
	report_strategy("  Perform touch test.");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	modifiers = AnyModifier;
	device = Devs.Key;
	modifier_device = NULL;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (noext(1)) {
		untested("There is no reliable test method, but a touch test was performed");
		return;
	}

	mods = wantmods(display, 4);
	modpress(display, mods);

	/*
	 * modifiers was AnyModifier, several modifier keys are held down.
	 */
	warppointer(display, grab_window, 1, 1);
	devicekeypress(display, device, MinKeyCode);
	XSync(display,0);
	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Grab not activated for AnyModifier");
	    report("  Modifiers used %s", keymaskname((unsigned long)mods));
	    FAIL;
	    }
	else
	    CHECK;

	/* Release all keys and modifiers */
	devicekeyrel(display, device, MinKeyCode);
	relalldev();
	XSync(display,0);

	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret == AlreadyGrabbed) 
	    {
	    delete("Could not release grab for second part of test");
	    FAIL;
	    }
	else
	    {
	    XUngrabDevice(client1, device, CurrentTime);
	    XSync(client1,0);
	    CHECK;
	    }

	devicekeypress(display, device, MinKeyCode);
	XSync(display,0);
	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Grab with AnyModifier was not activated by a key press with");
	    report("  no modifiers");
	    FAIL;
	    }
	else
	    CHECK;
	CHECKPASS(3);
	devicekeyrel(display, device, MinKeyCode);
	devicerelkeys(device);
	XSync(display,0);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XModifierKeymap	*mmap;
XModifierKeymap	*newmap;
int 	i, ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XGrabDeviceKey-7.(B)");
	report_assertion("It is not required that all modifiers specified have");
	report_assertion("currently assigned KeyCodes.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extensions are available:");
	report_strategy("  Get a modifier mask.");
	report_strategy("  Remove the keycode for the modifier from the map.");
	report_strategy("  Call XGrabDeviceKey to set up a passive grab with that modifier.");
	report_strategy("  Reset the keycode in the modifier map.");
	report_strategy("  Verify that the grab can be activated with the newly set modifier.");
	report_strategy("else");
	report_strategy("  Report untested.");

	tpstartup();
	setargs();
	if (noext(1))
		return;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	modifier_device = NULL;
	modifiers = wantmods(display, 1);
	if (modifiers == 0) {
		untested("No available modifier keys");
		return;
	} else
		CHECK;

	mmap = XGetModifierMapping(display);
	if (mmap == NULL) {
		delete("Could not get modifier map");
		return;
	} else
		CHECK;

	/*
	 * Remove all the modifiers mappings.
	 */
	newmap = XNewModifiermap(mmap->max_keypermod);
	for (i = 0; i < newmap->max_keypermod*8; i++)
		newmap->modifiermap[i] = NoSymbol;

	if (XSetModifierMapping(display, newmap) == MappingSuccess)
		CHECK;
	else {
		delete("Could not remove modifier mapping");
		return;
	}

	/*
	 * Now we have a modifier that has no keycode - set up a passive grab.
	 */
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	/*
	 * Reset the modifier map, and try to activate the grab.
	 */
	if (XSetModifierMapping(display, mmap) == MappingSuccess)
		CHECK;
	else {
		delete("Could not reset modifier mapping");
		return;
	}

	warppointer(display, grab_window, 1, 1);
	XSync(display,0);
	modpress(display, modifiers);
	devicekeypress(display, device, MinKeyCode);
	XSync(display,0);

	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed) 
	    {
	    report("Passive grab not set when the modifier did not have a current keycode");
	    FAIL;
	    }
	else
	    CHECK;

	CHECKPASS(5);
	devicekeyrel(display, device, MinKeyCode);
	modrel(display, modifiers);
	devicerelkeys(device);
	relalldev();
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int i, j, ret, ndevices, nkeys, count=0;
Display *client1;
XDeviceInfo *list;
XAnyClassPtr any;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XGrabDeviceKey-8.(B)");
	report_assertion("When the keycode argument is AnyKey, then this is");
	report_assertion("equivalent to separate calls to XGrabDeviceKey for all");
	report_assertion("possible KeyCodes.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish a passive grab for AnyKey on an input extension device.");
	report_strategy("Press each of the keys on that device.");
	report_strategy("Verify that pressing each of the keys activates the grab.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	list = XListInputDevices(display, &ndevices);
	for (i=0; i<ndevices; i++, list++)
	    if (list->id == Devs.Key->device_id)
		{
		any = (XAnyClassPtr) (list->inputclassinfo);
		for (j=0; j<list->num_classes; j++)
		    {
		    if (any->class == KeyClass)
			{
			nkeys = ((XKeyInfo *) any)->num_keys;
			break;
			}
		    any = (XAnyClassPtr) ((char *) any + any->length);
		    }
		break;
		}
	modifier_device = NULL;
	warppointer(display, grab_window, 1, 1);
	for (i=0;i<nkeys;i++)
	    {
	    startcall(display);
	    if (isdeleted())
	    	return;
	    ret = XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	    endcall(display);
	    if (geterr() != Success) {
	    	report("Got %s, Expecting Success", errorname(geterr()));
	    	FAIL;
	    }
	    XSync(display,0);

	    if (noext(1))
		return;
	    devicekeypress (display, device, MinKeyCode + i);
	    XSync (display, 0);

	    ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
		GrabModeAsync, GrabModeAsync, CurrentTime);
	    if (ret != AlreadyGrabbed)
		FAIL;
	    else
		{
		CHECK;
		count++;
		}
	    XUngrabDeviceKey(display, device, AnyKey, AnyModifier,
		NULL, grab_window);
	    XSync(display,0);
	    }
	for (i=0;i<nkeys;i++)
	    devicekeyrel(display, device, MinKeyCode + i);
	devicerelkeys(device);
	CHECKPASS(count);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
Display *client1;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XGrabDeviceKey-9.(B)");
	report_assertion("When the event window for an active grab becomes not");
	report_assertion("viewable, then the grab is released automatically.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish a passive grab on an input device extension device.");
	report_strategy("Activate the grab by pressing a key on the device.");
	report_strategy("Verify that the grab is active by trying to establish another active grab");
	report_strategy("from a different client, and verifying that AlreadyGrabbed is returned.");
	report_strategy("Make the grab window non-viewable.");
	report_strategy("Attempt another active grab and verify that it works this time.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	modifier_device = NULL;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (noext(1))
	    return;
	warppointer(display, grab_window, 1, 1);
	devicekeypress (display, device, MinKeyCode);
	XSync (display, 0);

	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    FAIL;
	else
	    CHECK;
	XUnmapWindow(display,grab_window);
	XSync(display,0);

	grab_window = defwin(display);
	ret = XGrabDevice(client1, device, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != Success)
	    FAIL;
	else
	    CHECK;
	devicekeyrel (display, device, MinKeyCode);
	devicerelkeys(device);
	XSync(display,0);
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display *client1;
int minkey, maxkey, numkeys, ret;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XGrabDeviceKey-10.(B)");
	report_assertion("NULL may be specified as the modifier device. This will");
	report_assertion("cause the X keyboard to be used as the modifier device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify NULL as the modifier device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	if ((client1 = opendisplay()) == 0) {
		delete("Could not open display");
		return;
	}
	device = Devs.Key;
	modifier_device = NULL;
	modifiers = wantmods(display, 1);
	if (modifiers == 0) {
		untested("No available modifier keys");
		return;
	} else
		CHECK;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (noext(1))
	    {
	    untested("%d: No XTest extension, can't complete test.",TestName);
	    return;
	    }
	MinMaxKeys(display, device, &minkey, &maxkey, &numkeys);
	warppointer(display, grab_window, 1, 1);
	modpress(display, modifiers);
	devicekeypress (display, Devs.Key, minkey);
	XSync (display, 0);

	ret = XGrabDevice(client1, Devs.Key, grab_window, True, 0, NULL,
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	if (ret != AlreadyGrabbed)
	    {
	    report("%s: Grab failed to activate.", TestName);
	    FAIL;
	    }
	else
	    CHECK;

	modrel(display, modifiers);
	devicekeyrel (display, Devs.Key, minkey);
	devicerelkeys (Devs.Key);
	relalldev();
	XUngrabDeviceKey(display, device, AnyKey, AnyModifier,
		NULL, grab_window);
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

extern int 	MinKeyCode, MaxKeyCode;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XGrabDeviceKey-11.(B)");
	report_assertion("When the specified keycode is not in the range specified by");
	report_assertion("min_keycode and max_keycode in the connection setup or");
	report_assertion("AnyKey, then a BadValue error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDeviceKey with keycode less than min_keycode.");
	report_strategy("Verify that a BadValue error occurs.");
	report_strategy("Call XGrabDeviceKey with keycode greater than max_keycode if it is less than 255.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	keycode = MinKeyCode-1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		CHECK;

	/*
	 * Since the protocol only has one byte for the key then this
	 * assertion cannot be tested when max_keycode is 255.
	 */
	if (MaxKeyCode < 255) {

		keycode = MaxKeyCode+1;

		startcall(display);
		if (isdeleted())
			return;
		XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		XSync(display,0);

		if (geterr() == BadValue)
			CHECK;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XGrabDeviceKey-12.(B)");
	report_assertion("When an invalid value is specified for the modifiers");
	report_assertion("parameter, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGrabDeviceKey with keycode less than min_keycode.");
	report_strategy("Verify that a BadValue error occurs.");
	report_strategy("Call XGrabDeviceKey with keycode greater than max_keycode if it is less than 255.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	modifiers = ~0;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadValue)
	    CHECK;
	else
	    FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XGrabDeviceKey-13.(B)");
	report_assertion("When an invalid value is specified for the owner_events");
	report_assertion("parameter, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	owner_events = -1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadValue)
	    CHECK;
	else
	    FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XGrabDeviceKey-14.(B)");
	report_assertion("When an invalid value is specified for the this_device_mode");
	report_assertion("parameter, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	this_device_mode = -1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
	    CHECK;
	else
	    FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XGrabDeviceKey-15.(B)");
	report_assertion("When an invalid value is specified for the");
	report_assertion("other_devices_mode parameter, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	other_devices_mode = -1;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
	    CHECK;
	else
	    FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

/* Including from file error/EAcc1.mc */
/* End of included file error/EAcc1.mc */

static void t016(){

Display	*client2;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XGrabDeviceKey-16.(A)");
	report_assertion("When an attempt to grab a key/button combination already");
	report_assertion("grabbed by another client is made, then a BadAccess error");
	report_assertion("occurs.");

	report_strategy("Grab key/modifier.");
	report_strategy("Create client2.");
	report_strategy("Attempt to grab same key modifier for client2.");
	report_strategy("Verify BadAccess error.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	XGrabDeviceKey(Dsp, device, keycode, modifiers, modifier_device,
		grab_window, owner_events, event_count, event_list,
		this_device_mode, other_devices_mode);
	XSync (Dsp,0);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadAccess) {
		report("Got %s, Expecting BadAccess", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == BadAccess)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XGrabDeviceKey-17.(B)");
	report_assertion("When an invalid window parameter is specified on an");
	report_assertion("XGrabDeviceKey protocol request, a BadWindow error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab key/modifier.");
	report_strategy("Create client2.");
	report_strategy("Attempt to grab same key modifier for client2.");
	report_strategy("Verify BadAccess error.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.Key;

	grab_window = 0;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == BadWindow)
	    CHECK;
	else
	    FAIL;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t018(){

int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XGrabDeviceKey-18.(B)");
	report_assertion("When an modifier_device is specified that has no keys, a");
	report_assertion("BadMatch error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | NKeysMask))
	    {
	    untested("%s: Required input extension devices not present.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	modifier_device = Devs.NoKeys;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == BadMatch)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t019(){

int baddevice;
XDevice bogus;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XGrabDeviceKey-19.(B)");
	report_assertion("When an invalid modifier_device is specified in an");
	report_assertion("XGrabDeviceKey protocol request, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	device = Devs.Key;
	modifier_device = &bogus;
	bogus.device_id = 128;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == baddevice)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t020(){

int baddevice;
XDevice bogus;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XGrabDeviceKey-20.(B)");
	report_assertion("When an invalid device is specified in an XGrabDeviceKey");
	report_assertion("protocol request, a BadValue error results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	modifier_device = Devs.Key;
	device = &bogus;
	bogus.device_id = 128;
	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == baddevice)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.318092 */
/* End of included file Mdefcode.tmc.318092 */

static void t021(){

XEventClass eclass = -1;
int badclass;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XGrabDeviceKey-21.(B)");
	report_assertion("When an invalid event class is specified, a BadValue error");
	report_assertion("results.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify an invalid event class.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: Input extension key device not present.\n", TestName);
	    return;
	    }
	BadClass(display,badclass);
	device = Devs.Key;
	modifier_device = Devs.Key;
	event_count = 1;
	event_list = &eclass;

	startcall(display);
	if (isdeleted())
		return;
	XGrabDeviceKey(display, device, keycode, modifiers, modifier_device, grab_window, owner_events, event_count, event_list, this_device_mode, other_devices_mode);
	endcall(display);
	if (geterr() != badclass) {
		report("Got %s, Expecting badclass", errorname(geterr()));
		FAIL;
	}
	XSync (Dsp,0);

	if (geterr() == badclass)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
