/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XInstallColormap(display, colormap)
 *   Display	*display;
 *   Colormap	colormap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XInstallColormap	1
char    *TestName = "XInstallColormap";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XInstallColormap function
 */
static Display	*display;
static Colormap	colormap;



static	Colormap	*savcm;
static	int 	nsavcm;

/*
 * savcm and restorecm attempt to restore the colormaps that were
 * installed originally.  However it is possible that different
 * colour maps will end up on the required list than before.
 */
savecm()
{
	savcm = XListInstalledColormaps(display, DRW(display), &nsavcm);
}

restorecm()
{
int 	i;

	for (i = 0; i < nsavcm; i++) {
		debug(1, "Re-installing colour map 0x%x", savcm[i]);
		XInstallColormap(display, savcm[i]);
	}
	if (nsavcm && savcm)
		XFree((char*)savcm);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	colormap = ErrdefColormap;
}

static void t001(){

XVisualInfo	*vp;
Colormap	*cmp;
int 	mode;
int 	n;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XInstallColormap-1.(A)");
	report_assertion("A call to XInstallColormap installs the specified colourmap");
	report_assertion("for its associated screen.");

	report_strategy("For each visual type.");
	report_strategy("  Create colourmap.");
	report_strategy("  Install colourmap.");
	report_strategy("  Verify that new colourmap has been installed by listing the installed");
	report_strategy("  colourmaps.");

	tpstartup();
	setargs();
	savecm();

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		switch (vp->class) {
		case StaticGray:
		case StaticColor:
		case TrueColor:
			mode = AllocNone;
			break;
		default:
			mode = AllocAll;
			break;
		}
		colormap = makecolmap(display, vp->visual, mode);

		startcall(display);
		if (isdeleted())
			return;
		XInstallColormap(display, colormap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		cmp = XListInstalledColormaps(display, DRW(display), &n);
		for (i = 0; i < n; i++) {
			if (cmp[i] == colormap) {
				CHECK;
				break;
			}
		}
		if (i == n) {
			report("Colourmap was not installed");
			FAIL;
		}

		XFree((char*)cmp);
	}

	CHECKPASS(nvinf());

	restorecm();
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.362624 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XInstallColormap-2.(B)");
	report_assertion("All windows associated with the specified colourmap");
	report_assertion("immediately display with true colours.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.362624 */

/* Including from file Mdefcode.tmc.362624 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XInstallColormap-3.(B)");
	report_assertion("A call to XInstallColormap adds the specified colourmap to");
	report_assertion("the head of the required list of colourmaps for its");
	report_assertion("associated screen, and the required list is truncated to the");
	report_assertion("minimum number of installed colourmaps for the screen.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.362624 */

static void t004(){

XVisualInfo	*vp;
Window	base;
Window	w1, w2;
Window	w3nocm;
XEvent	ev;
Screen *screen;
XColormapEvent	good;
XColormapEvent	*cmp;
int 	got;
#define	GOT1	1
#define GOT2	2
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XInstallColormap-4.(A)");
	report_assertion("When the specified colourmap is not already an installed");
	report_assertion("colourmap, then a ColormapNotify event is generated on each");
	report_assertion("window that has that colourmap.");

	report_strategy("For each visual.");
	report_strategy("  Create windows.");
	report_strategy("  Create colormap for those windows.");
	report_strategy("  Set the window colour maps.");
	report_strategy("  Create another window without using the new colour map.");
	report_strategy("  Install the colour map.");
	report_strategy("  Verify that a colour map notify event is received on the windows that have");
	report_strategy("  that colour map.");
	report_strategy("  Verify that the event is not received on the other window.");

	tpstartup();
	setargs();
	defsetevent(good, display, ColormapNotify);
	good.new = False;
	good.state = ColormapInstalled;

	screen = ScreenOfDisplay(display, DefaultScreen(display));
	if (MaxCmapsOfScreen(screen) > 1) {
		untested("Cannot reliably test ColormapNotify when the server has implicit colormaps");
		report("  Server supports more than one installed colormap");
		return;
	}

	for (resetvinf(VI_WIN); nextvinf(&vp); ) {

		base = makewin(display, vp);
		w1 = crechild(display, base, (struct area *)0);
		w2 = crechild(display, base, (struct area *)0);
		w3nocm = crechild(display, base, (struct area *)0);

		colormap = makecolmap(display, vp->visual, AllocNone);
		XSetWindowColormap(display, w1, colormap);
		XSelectInput(display, w1, ColormapChangeMask);
		XSetWindowColormap(display, w2, colormap);
		XSelectInput(display, w2, ColormapChangeMask);
		XSelectInput(display, w3nocm, ColormapChangeMask);

		startcall(display);
		if (isdeleted())
			return;
		XInstallColormap(display, colormap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		while (getevent(display, &ev)) {
			cmp = (XColormapEvent*)&ev;
			/*
			 * Server is allowed to install or uninstalled implementation
			 * defined colormaps implicitly, so we have to ignore
			 * all the ones that we don't know about.
			 */
			if (cmp->colormap != colormap)
				continue;
			if (cmp->window == w3nocm) {
				report("ColormapNotify event received for window that did not have that colourmap");
				FAIL;
			} else
				CHECK;

			if (cmp->window == w1)
				got |= GOT1;
			else if (cmp->window == w2)
				got |= GOT2;
			else {
				report("ColormapNotify received on unexpected window");
				FAIL;
			}

			good.window = cmp->window;
			good.colormap = colormap;
			if (checkevent((XEvent*)&good, &ev))
				FAIL;
			else
				CHECK;
		}
	}
	if (got & GOT1)
		CHECK;
	else {
		report("Event not received on window 'w1'");
		FAIL;
	}
	if (got & GOT2)
		CHECK;
	else {
		report("Event not received on window 'w2'");
		FAIL;
	}

	CHECKPASS(nvinf()*4+2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.362624 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XInstallColormap-5.(B)");
	report_assertion("When another colourmap is installed or uninstalled as a");
	report_assertion("side effect of a call to XInstallColormap, then a");
	report_assertion("ColormapNotify event is generated on each window that has");
	report_assertion("that colourmap.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.362624 */

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XInstallColormap-6.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	XInstallColormap(display, colormap);
	endcall(display);
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
