/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XGetErrorDatabaseText(display, name, message, default_string, buffer_return, length)
 *   Display *display;
 *   char *name;
 *   char *message;
 *   char *default_string;
 *   char *buffer_return;
 *   int length;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetErrorDatabaseText	1
char    *TestName = "XGetErrorDatabaseText";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetErrorDatabaseText function
 */
static Display *display;
static char *name;
static char *message;
static char *default_string;
static char *buffer_return;
static int length;


#include "X11/Xproto.h"

static char buffer[512];

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	name = 0;
	message = 0;
	default_string = "default_string";
	buffer_return = buffer;
	length = sizeof(buffer);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetErrorDatabaseText-1.(A)");
	report_assertion("A call to XGetErrorDatabaseText returns a string in");
	report_assertion("buffer_return.");

	report_strategy("Set each character in buffer_return to non-ASCII NUL.");
	report_strategy("Set name to \"foo\".");
	report_strategy("Set message to \"bar\".");
	report_strategy("Call XGetErrorText.");
	report_strategy("Verify that there exists at least one ASCII NUL");
	report_strategy("character in buffer_return.");

	tpstartup();
	setargs();
/* Set each character in buffer_return to non-ASCII NUL. */
	for (i=0; i < sizeof(buffer); i++) {
		if (!i)
			CHECK;
		buffer[i] = 'A';
	}
	buffer_return = buffer;
/* Set name to "foo". */
	name = "foo";
/* Set message to "bar". */
	message = "bar";
/* Call XGetErrorText. */
	startcall(display);
	if (isdeleted())
		return;
	XGetErrorDatabaseText(display, name, message, default_string, buffer_return, length);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that there exists at least one ASCII NUL */
/* character in buffer_return. */
	for (i=0; i < sizeof(buffer); i++) {
		if (buffer[i] == '\0') {
			CHECK;
			break;
		}
	}
	if (i == sizeof(buffer)) {
		report("String not returned.");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	i;
char	msgbuf[512];
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetErrorDatabaseText-2.(A)");
	report_assertion("A call to XGetErrorDatabaseText with name set to the string");
	report_assertion("XProtoError and message set to the string representation of");
	report_assertion("a protocol error number returns a string terminated with");
	report_assertion("ASCII NUL in buffer_return.");

	report_strategy("Set each character in buffer_return to non-ASCII NUL.");
	report_strategy("Set name to \"XProtoError\".");
	report_strategy("Set message to the string representation of BadWindow.");
	report_strategy("Call XGetErrorText.");
	report_strategy("Verify that there exists at least one ASCII NUL");
	report_strategy("character in buffer_return.");

	tpstartup();
	setargs();
/* Set each character in buffer_return to non-ASCII NUL. */
	for (i=0; i < sizeof(buffer); i++) {
		if (!i)
			CHECK;
		buffer[i] = 'A';
	}
	buffer_return = buffer;
/* Set name to "XProtoError". */
	name = "XProtoError";
/* Set message to the string representation of BadWindow. */
	sprintf(msgbuf, "%d", BadWindow);
	message = msgbuf;
/* Call XGetErrorText. */
	startcall(display);
	if (isdeleted())
		return;
	XGetErrorDatabaseText(display, name, message, default_string, buffer_return, length);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that there exists at least one ASCII NUL */
/* character in buffer_return. */
	for (i=0; i < sizeof(buffer); i++) {
		if (buffer[i] == '\0') {
			CHECK;
			break;
		}
	}
	if (i == sizeof(buffer)) {
		report("Returned string not terminated with ASCII NUL.");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int	i;
char	msgbuf[512];
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetErrorDatabaseText-3.(A)");
	report_assertion("A call to XGetErrorDatabaseText with name set to the string");
	report_assertion("XRequest and message set to the string representation of a");
	report_assertion("major protocol number returns a string terminated with ASCII");
	report_assertion("NUL in buffer_return.");

	report_strategy("Set each character in buffer_return to non-ASCII NUL.");
	report_strategy("Set name to \"XRequest\".");
	report_strategy("Set message to the string representation of X_DestroyWindow.");
	report_strategy("Call XGetErrorText.");
	report_strategy("Verify that there exists at least one ASCII NUL");
	report_strategy("character in buffer_return.");

	tpstartup();
	setargs();
/* Set each character in buffer_return to non-ASCII NUL. */
	for (i=0; i < sizeof(buffer); i++) {
		if (!i)
			CHECK;
		buffer[i] = 'A';
	}
	buffer_return = buffer;
/* Set name to "XRequest". */
	name = "XRequest";
/* Set message to the string representation of X_DestroyWindow. */
	sprintf(msgbuf, "%d", X_DestroyWindow);
	message = msgbuf;
/* Call XGetErrorText. */
	startcall(display);
	if (isdeleted())
		return;
	XGetErrorDatabaseText(display, name, message, default_string, buffer_return, length);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that there exists at least one ASCII NUL */
/* character in buffer_return. */
	for (i=0; i < sizeof(buffer); i++) {
		if (buffer[i] == '\0') {
			CHECK;
			break;
		}
	}
	if (i == sizeof(buffer)) {
		report("Returned string not terminated with ASCII NUL.");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.360148 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetErrorDatabaseText-4.(D)");
	report_assertion("If the implementation supports an error database: The error");
	report_assertion("message database used is/usr/lib/X11/XErrorDB.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.360148 */

/* Including from file Mdefcode.tmc.360148 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetErrorDatabaseText-5.(B)");
	report_assertion("When a call to XGetErrorDatabaseText is made and no string");
	report_assertion("is found in the error database, then default_string is");
	report_assertion("returned in buffer_return.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.360148 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
