/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetIconName(display, w, icon_name_return)
 *   Display	*display;
 *   Window	w;
 *   char	**icon_name_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetIconName	1
char    *TestName = "XGetIconName";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetIconName function
 */
static Display	*display;
static Window	w;
static char	**icon_name_return;


static int 	StatusReturn;

#include	"X11/Xatom.h"
char	*iconname = "XtestIC";

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	icon_name_return = &iconname;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	win;
char	*iconname = "Xtest Icon Name";
char	*iconnameret;
Status	status;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetIconName-1.(A)");
	report_assertion("When the WM_ICON_NAME property for the window w has been");
	report_assertion("set, and has format 8 and type STRING, then a call to");
	report_assertion("XGetIconName returns that name, which can be freed with");
	report_assertion("XFree, in the icon_name_return argument and returns");
	report_assertion("non-zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the icon name for the window with XSetIconName.");
	report_strategy("Obtain the icon name with XGetIconName.");
	report_strategy("Verify that the returned name is that which was set.");
	report_strategy("Realease the allocated memory using XFree.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	XSetIconName(display, win, iconname);

	w = win;
	icon_name_return = &iconnameret;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconName(display, w, icon_name_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == False) {
		report("XGetIconName() returned False.");
		FAIL;
	} else
		CHECK;

	if(strcmp(iconname, (iconnameret != NULL) ? iconnameret : "NULL") != 0) {
		report("XGetIconName() returned \"%s\" instead of \"%s\"", iconnameret, iconname);
		FAIL;
	} else
		CHECK;

	if(iconnameret != NULL) 
		XFree(iconnameret);

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

char	*iconnameret = "XTestUninit";
char	*name = "XTestIconName";
Status	status;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetIconName-2.(A)");
	report_assertion("When the WM_ICON_NAME property for the window w has not");
	report_assertion("been set, or has format other than 8 or type other than");
	report_assertion("STRING, then a call to XGetIconName sets the string in the");
	report_assertion("icon_name_return argument to NULL and returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the value of the WM_ICON_NAME property with XGetIconName.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("Verify that the returned name was set to NULL.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_ICON_NAME property with format 16 and type STRING using XChangeProperty.");
	report_strategy("Obtain the value of the WM_ICON_NAME property with XGetIconName.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("Verify that the returned name was set to NULL.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_ICON_NAME property with format 8 type ATOM using XChangeProperty.");
	report_strategy("Obtain the value of the WM_ICON_NAME property with XGetIconName.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("Verify that the returned name was set to NULL.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

/* Property unset */

	icon_name_return = &iconnameret;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconName(display, w, icon_name_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("XGetIconName() did not return False when the WM_ICON_NAME property was unset.");
		FAIL;
	} else
		CHECK;

	if( iconnameret != NULL) {
		report("XGetIconName() returned \"%s\" instead of NULL when the WM_ICON_NAME was unset.", iconnameret);
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);

/* format 16 */
	XChangeProperty(display, w, XA_WM_ICON_NAME, XA_STRING, 16, PropModeReplace, (unsigned char *) name, strlen(name));

	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconName(display, w, icon_name_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("XGetIconName() did not return False when the WM_ICON_NAME property format was 16.");
		FAIL;
	} else
		CHECK;

	if( iconnameret != NULL) {
		report("XGetIconName() returned \"%s\" instead of NULL when the WM_ICON_NAME property format was 16.", iconnameret);
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* type XA_ATOM */
	XChangeProperty(display, w, XA_WM_ICON_NAME, XA_ATOM, 8, PropModeReplace, (unsigned char *) name, strlen(name));
	startcall(display);
	if (isdeleted())
		return;
	status = XGetIconName(display, w, icon_name_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("XGetIconName() did not return False when the WM_ICON_NAME property type was ATOM.");
		FAIL;
	} else
		CHECK;

	if( iconnameret != NULL) {
		report("XGetIconName() returned \"%s\" instead of NULL when the WM_ICON_NAME property type was ATOM", iconnameret);
		FAIL;
	} else
		CHECK;

	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetIconName-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetIconName(display, w, icon_name_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
