/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   
 *   XRefreshKeyboardMapping(event_map)
 *   XMappingEvent	*event_map;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XRefreshKeyboardMapping	1
char    *TestName = "XRefreshKeyboardMapping";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XRefreshKeyboardMapping function
 */
static XMappingEvent	*event_map;


#define XK_LATIN1
#include	"X11/keysymdef.h"
#undef XK_LATIN1

static void
cpymap(dest, src)
	XModifierKeymap *dest;
	XModifierKeymap *src;
{
	int i;
	int n;

	for(i=0,n=src->max_keypermod*8; i<n; i++)
		dest->modifiermap[i] = src->modifiermap[i];
	dest->max_keypermod = src->max_keypermod;
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	event_map = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XEvent		ev;
KeyCode		kc;
KeySym		res, old, new;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XRefreshKeyboardMapping-1.(A)");
	report_assertion("When the request component of the event_map argument is");
	report_assertion("MappingKeyboard, then a call to XRefreshKeyboardMapping");
	report_assertion("modifies the keymap information based on that specified by");
	report_assertion("the event_map argument.");

	report_strategy("Map the keycode which maps to KeySym XK_a onto XK_b using XChangeKeyboardMapping.");
	report_strategy("Verify that a MappingNotify event is generated.");
	report_strategy("Update the keymap information with XRefreshKeyboardMapping.");
	report_strategy("Obtain the KeySym corresponding to the keycode.");
	report_strategy("Verify that KeySym is XK_b.");
	report_strategy("Reset the keycode to map onto XK_a using XChangeKeyboardMapping.");

	tpstartup();
	setargs();
	old = XK_a;
	new = XK_b;

	if((kc = XKeysymToKeycode(Dsp, old)) == 0) {
		delete("XKeysymToKeycode() returned 0 for KeySym %lu.", (long) old);
		return;
	} else
		CHECK;

	XChangeKeyboardMapping(Dsp, kc, 1, &new, 1);
	XSync(Dsp, False);
	
	if( getevent(Dsp, &ev) == 0) {
		delete("Did not get an event after an XChangeKeyboardMapping()");
		XChangeKeyboardMapping(Dsp, kc, 1, &old, 1);
		return;
	} else
		CHECK;

	if(ev.type != MappingNotify) {
		delete("Got a %s event instead of a %s.", eventname(ev.type), eventname(MappingNotify));
		XChangeKeyboardMapping(Dsp, kc, 1, &old, 1);
		return;
	} else
		CHECK;

	if(ev.xmapping.request != MappingKeyboard) {
		delete("The request field was %d instead of %d (MappingKeyboard)",
				ev.xmapping.request, MappingKeyboard);
		XChangeKeyboardMapping(Dsp, kc, 1, &old, 1);
		return;
	} else
		CHECK;

	event_map = &ev.xmapping;
	startcall(Dsp);
	if (isdeleted())
		return;
	XRefreshKeyboardMapping(event_map);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if((res = XKeycodeToKeysym(Dsp, kc, 0)) == NoSymbol) {
		delete("XKeycodeToKeysym() returned NoSymbol for KeyCode %lu.", (long) kc);
		XChangeKeyboardMapping(Dsp, kc, 1, &old, 1);
		return;
	} else
		CHECK;

	if( res != new) {
		report("%s() mapped KeyCode %lu to KeySym %lu instead of %lu.", TestName, (long) kc, (long) res, (long) new);
		FAIL;
	} else
		CHECK;

	XChangeKeyboardMapping(Dsp, kc, 1, &old, 1);
	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XEvent		ev;
XModifierKeymap	*savemap = XGetModifierMapping(Dsp);
XModifierKeymap	*mmap;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XRefreshKeyboardMapping-2.(B)");
	report_assertion("When the request component of the event_map argument is");
	report_assertion("MappingModifier, then a call to XRefreshKeyboardMapping");
	report_assertion("modifies the keymap information based on that specified by");
	report_assertion("the event_map argument.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Obtain a new modifier map using XNewModifiermap.");
	report_strategy("Initialise it to have the current, valid, values.");
	report_strategy("Set the modifier map to the new map using XSetModifierMapping.");
	report_strategy("Await the mapping event.");
	report_strategy("Update the modifier mappings using XRefreshKeyboardMapping.");
	report_strategy("Release the map storage using XFreeModifiermap.");

	tpstartup();
	setargs();
	if(savemap == (XModifierKeymap *) NULL) {
		delete("XGetModifierMapping() returned NULL.");
		return;
	} else
		CHECK;

	mmap = XNewModifiermap(savemap->max_keypermod);

	if(mmap == (XModifierKeymap *) NULL) {
		delete("XNewModifiermap() returned NULL.");
		return;
	} else
		CHECK;

	cpymap(mmap, savemap);

	if(XSetModifierMapping(Dsp, mmap) != MappingSuccess) {
		delete("XSetModifierMapping() did not return MappingSuccess.");
		return;
	} else
		CHECK;

	XSync(Dsp, False);
	
	if( getevent(Dsp, &ev) == 0) {
		delete("Did not get an event after an XSetModifierMapping()");
		XSetModifierMapping(Dsp, savemap);
		return;
	} else
		CHECK;

	if(ev.type != MappingNotify) {
		delete("Got a %s event instead of a %s.", eventname(ev.type), eventname(MappingNotify));
		XSetModifierMapping(Dsp, savemap);
		return;
	} else
		CHECK;

	if(ev.xmapping.request != MappingModifier) {
		delete("The request field was %d instead of %d (MappingModifier)",
				ev.xmapping.request, MappingModifier);
		XSetModifierMapping(Dsp, savemap);
		return;
	} else
		CHECK;

	event_map = &ev.xmapping;
	startcall(Dsp);
	if (isdeleted())
		return;
	XRefreshKeyboardMapping(event_map);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSetModifierMapping(Dsp, savemap);

	XFreeModifiermap(mmap);
	XFreeModifiermap(savemap);
	CHECKUNTESTED(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XEvent		ev;
XModifierKeymap	*savemap = XGetModifierMapping(Dsp);
XModifierKeymap	*mmap1;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XRefreshKeyboardMapping-3.(B)");
	report_assertion("When the request component of the event_map argument is");
	report_assertion("other than MappingKeyboard or MappingModifier, then a call");
	report_assertion("to XRefreshKeyboardMapping does not modify the keymap");
	report_assertion("information.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Obtain a new modifier map using XNewModifiermap.");
	report_strategy("Initialise it to have the current, valid, values.");
	report_strategy("Set the modifier map to the new map using XSetModifierMapping.");
	report_strategy("Await the mapping event.");
	report_strategy("Set the request component of the event structure to MappingModifier + MappingKeyboard + MappingPointer");
	report_strategy("Update the modifier mappings using XRefreshKeyboardMapping.");

	tpstartup();
	setargs();
	if(savemap == (XModifierKeymap *) NULL) {
		delete("XGetModifierMapping() returned NULL.");
		return;
	} else
		CHECK;

	mmap1 = XNewModifiermap(savemap->max_keypermod);

	if(mmap1 == (XModifierKeymap *) NULL) {
		delete("XNewModifiermap() returned NULL.");
		return;
	} else
		CHECK;

	cpymap(mmap1, savemap);

	if(XSetModifierMapping(Dsp, mmap1) != MappingSuccess) {
		delete("XSetModifierMapping() did not return MappingSuccess.");
		return;
	} else
		CHECK;

	XSync(Dsp, False);

	if( getevent(Dsp, &ev) == 0) {
		delete("Did not get an event after an XSetModifierMapping()");
		XSetModifierMapping(Dsp, savemap);
		return;
	} else
		CHECK;

	if(ev.type != MappingNotify) {
		delete("Got a %s event instead of a %s.", eventname(ev.type), eventname(MappingNotify));
		XSetModifierMapping(Dsp, savemap);
		return;
	} else
		CHECK;

	ev.xmapping.request = MappingModifier + MappingKeyboard + 1;
	event_map = &ev.xmapping;
	startcall(Dsp);
	if (isdeleted())
		return;
	XRefreshKeyboardMapping(event_map);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSetModifierMapping(Dsp, savemap);

	XFreeModifiermap(mmap1);
	XFreeModifiermap(savemap);
	CHECKUNTESTED(5);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
