/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering)
 *   Display *display;
 *   GC gc;
 *   int clip_x_origin;
 *   int clip_y_origin;
 *   XRectangle *rectangles;
 *   int n;
 *   int ordering;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetClipRectangles	1
char    *TestName = "XSetClipRectangles";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_GC gc


/*
 * Arguments to the XSetClipRectangles function
 */
static Display *display;
static GC gc;
static int clip_x_origin;
static int clip_y_origin;
static XRectangle *rectangles;
static int n;
static int ordering;


XRectangle	crect;

int
bad_orderA(order_arg)
int	order_arg;
{
XVisualInfo *vp;
Window	win;
XGCValues	values;
XRectangle 	drects[2];
int		pass = 0, fail = 0;

	resetvinf(VI_WIN);
	nextvinf(&vp);

	win = makewin(display, vp);
	values.foreground = W_FG;
	values.background = W_BG;


	drects[0].x = 0;
	drects[0].y = 10;
	drects[0].width = drects[0].height = 5;

	drects[1].x = 10;
	drects[1].y = 5;
	drects[1].width = drects[1].height = 5;

	gc = XCreateGC(display, win, GCForeground | GCBackground, &values);


	rectangles = drects;
	n = 2;
	ordering = order_arg;

	/* 
	 startcall(display);
	 if (isdeleted())
	 	return;
	 * XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering) can't be used at the moment - 
	 endcall(display);
	 if (geterr() != Success) {
	 	report("Got %s, Expecting Success", errorname(geterr()));
	 	FAIL;
	 }
	 * it expects geterr() to have one correct return type.  
	 */

	startcall(Dsp);

	if (isdeleted()) {
		return;
	}
	XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);

	endcall(Dsp);

	if (geterr() == BadMatch) {
		trace("XSetClipRectangles returned BadMatch error.");
		CHECK;
	} else if (geterr() == Success) {
		trace("XSetClipRectangles did not return an error.");
		CHECK;
	} else {
		report("Got %s, Expecting BadMatch or Success.", errorname(geterr()));
		FAIL;
	}
	return(pass);
}

int
bad_orderB(order_arg)
int	order_arg;
{
XVisualInfo *vp;
Window	win;
XGCValues	values;
XRectangle 	drects[3];
int		pass = 0, fail = 0;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);
	values.foreground = W_FG;
	values.background = W_BG;


	drects[0].x = 20;
	drects[0].y = 5;
	drects[0].width = drects[0].height = 5;

	drects[1].x = 10;
	drects[1].y = 5;
	drects[1].width = drects[1].height = 5;

	gc = XCreateGC(display, win, GCForeground | GCBackground, &values);

	rectangles = drects;
	n = 2;
	ordering = order_arg;

	/* 
	 startcall(display);
	 if (isdeleted())
	 	return;
	 * XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering) can't be used at the moment - 
	 endcall(display);
	 if (geterr() != Success) {
	 	report("Got %s, Expecting Success", errorname(geterr()));
	 	FAIL;
	 }
	 * it expects geterr() to have one correct return type.
	 */

	startcall(Dsp);

	if (isdeleted()) {
		return;
	}
	XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);

	endcall(Dsp);

	if (geterr() == BadMatch) {
		trace("XSetClipRectangles returned BadMatch error.");
		CHECK;
	} else if (geterr() == Success) {
		trace("XSetClipRectangles did not return an error.");
		CHECK;
	} else {
		report("Got %s, Expecting BadMatch or Success.", errorname(geterr()));
		FAIL;
	}
	return(pass);
}

int
bad_orderC(order_arg)
int	order_arg;
{
XVisualInfo *vp;
Window	win;
XGCValues	values;
XRectangle 	drects[3];
int		pass = 0, fail = 0;

	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);
	values.foreground = W_FG;
	values.background = W_BG;


	drects[0].x = 20;
	drects[0].y = 5;
	drects[0].width = drects[0].height = 5;

	drects[1].x = 30;
	drects[1].y = 5;
	drects[1].width = drects[1].height = 4;

	gc = XCreateGC(display, win, GCForeground | GCBackground, &values);

	rectangles = drects;
	n = 2;
	ordering = order_arg;

	/* 
	 startcall(display);
	 if (isdeleted())
	 	return;
	 * XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering) can't be used at the moment - 
	 endcall(display);
	 if (geterr() != Success) {
	 	report("Got %s, Expecting Success", errorname(geterr()));
	 	FAIL;
	 }
	 * it expects geterr() to have one correct return type.
	 */

	startcall(Dsp);

	if (isdeleted()) {
		return;
	}
	XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);

	endcall(Dsp);

	if (geterr() == BadMatch) {
		trace("XSetClipRectangles returned BadMatch error.");
		CHECK;
	} else if (geterr() == Success) {
		trace("XSetClipRectangles did not return an error.");
		CHECK;
	} else {
		report("Got %s, Expecting BadMatch or Success.", errorname(geterr()));
		FAIL;
	}
	return(pass);
}



/* Value list for use in test t009 */
static int 	orderingvallist[] = {
	Unsorted,
	YSorted,
	YXSorted,
	YXBanded,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	gc = 0;
	clip_x_origin = 1;
	clip_y_origin = 1;
	rectangles = &crect;
	n = 1;
	ordering = Unsorted;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	gc = ErrdefGC;
}

static void t001(){

XVisualInfo *vp;
Window	win;
XGCValues	values;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetClipRectangles-1.(A)");
	report_assertion("A call to XSetClipRectangles sets the clip_mask component");
	report_assertion("of the specified GC to the specified list of rectangles and");
	report_assertion("sets the clip_x_origin and clip_y_origin components of the");
	report_assertion("specified GC to the arguments clip_x_origin and");
	report_assertion("clip_y_origin.");

	report_strategy("Create window.");
	report_strategy("Create GC bg = BlackPixel, fg = WhitePixel, fn = GXxor.");
	report_strategy("Set pixel at (0, 0) to fg with XDrawPoint.");
	report_strategy("Verify Pixel at (0, 0) is fg with XGetimage and GetPixel.");
	report_strategy("Set clip mask to rectangle (1, 1) (2, 2) with XSetClipRectangles.");
	report_strategy("Set Pixel at (2, 2) with XDrawPoint.");
	report_strategy("Verify Pixel at (2, 2) is fg with XGetimage and GetPixel.");
	report_strategy("Set pixel at (0, 0) to bg with XDrawPoint.");
	report_strategy("Verify Pixel at (0, 0) is fg with XGetimage and GetPixel.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);
	values.foreground = W_FG;
	values.background = W_BG;
	values.function = GXxor;

	gc = XCreateGC(display, win, GCForeground | GCBackground | GCFunction, &values);

	XDrawPoint(display, win, gc, 0, 0);

	if( ! checkpixel(display, win, 0, 0, W_FG)) {
		delete("Pixel at (0, 0) was not set to foreground.");
		return;
	} else 
		CHECK;

	crect.x = crect.y = 1;
	crect.width = crect.height = 1;

	startcall(display);
	if (isdeleted())
		return;
	XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawPoint(display, win, gc, 2, 2);

	if( ! checkpixel(display, win, 2, 2, W_FG)) {
		delete("Pixel at (2, 2) was not set to foreground.");
		return;
	} else 
		CHECK;

	XDrawPoint(display, win, gc, 0, 0);

	if( ! checkpixel(display, win, 0, 0, W_FG)) {
		report("Pixel at (0, 0) was not left as foreground.");
		FAIL;
	} else 
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.364092 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetClipRectangles-2.(B)");
	report_assertion("When two or more of the rectangles intersect, then no error");
	report_assertion("occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.364092 */

static void t003(){

XVisualInfo	*vp;
Window		win;
XGCValues	values;
int	i, j;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetClipRectangles-3.(A)");
	report_assertion("When the number of rectangles specified by the argument n");
	report_assertion("is zero, then the clip_mask component of the specified gc is");
	report_assertion("set to disable output on any subsequent graphics operation.");

	report_strategy("For all supported visuals:");
	report_strategy("	Create a window");
	report_strategy("	Verify that every window pixel is not set.");
	report_strategy("	Call XSetClipRectangles with a meaningful rectangle and n=0;");
	report_strategy("	Verify that every window pixel cannot be set.");

	tpstartup();
	setargs();
	values.foreground = W_FG;
	values.background = W_BG;

	crect.x = 0;
	crect.y = 0;
	crect.width = 10;
	crect.height = 20;

	for(resetvinf(VI_WIN);	nextvinf(&vp); ) {
		win = makewin(display, vp);
		gc = XCreateGC(display, win, GCForeground | GCBackground, &values);

		if( checkarea(display, win, (struct area *) 0, W_BG, 0L, 0) == False) {
			delete("Window contents were not initialised.");
			return;
		} else
			CHECK;

		n = 0;
		startcall(display);
		if (isdeleted())
			return;
		XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		for(j=0; j<W_STDHEIGHT; j++)
			for(i=0; i< W_STDWIDTH; i++)
				XDrawPoint(display, win, gc, i, j);

		if( checkarea(display, win, (struct area *) 0, W_BG, 0L, 0) == False) {
			report("Drawing was not disabled.");
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(2 * nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetClipRectangles-4.(A)");
	report_assertion("When the ordering argument is YSorted, and the specified");
	report_assertion("list of rectangles is not non-decreasing in the Y origin,");
	report_assertion("then either a BadMatch error occurs or no error occurs.");

	report_strategy("Create list of rectangles decreasing in Y origin.");
	report_strategy("Call XSetClipRectangles.");
	report_strategy("Verify that if an error occurs it is a BadMatch error.");

	tpstartup();
	setargs();
	if(bad_orderA(YSorted) == 1)
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetClipRectangles-5.(A)");
	report_assertion("When the ordering argument is YXSorted and the specified");
	report_assertion("list of rectangles is either not non-decreasing in the Y");
	report_assertion("origin or rectangles with the same Y origin are not");
	report_assertion("non-decreasing in the X origin, then either a BadMatch error");
	report_assertion("occurs or no error occurs.");

	report_strategy("Create list of rectangles decreasing in Y origin.  ");
	report_strategy("Call XSetClipRectangles.  ");
	report_strategy("Verify that if an error occurs it is a BadMatch error.  ");
	report_strategy("Create list of rectangles with");
	report_strategy("same Y origin and height and decreasing in X origin.  ");
	report_strategy("Call XSetClipRectangles.  ");
	report_strategy("Verify that if an error occurs it is a BadMatch error.  ");

	tpstartup();
	setargs();
	if(bad_orderA(YXSorted) == 1 &&
	   bad_orderB(YXSorted) == 1)
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetClipRectangles-6.(A)");
	report_assertion("When the ordering argument is YXBanded and the specified");
	report_assertion("list of rectangles is either not non-decreasing in the Y");
	report_assertion("origin or rectangles with the same Y origin are not");
	report_assertion("non-decreasing in the X origin or there is a Y scanline");
	report_assertion("included by rectangles with different Y origins or extents,");
	report_assertion("then either a BadMatch error occurs or no error occurs.");

	report_strategy("Create list of rectangles decreasing in Y origin.  ");
	report_strategy("Call XSetClipRectangles.  ");
	report_strategy("Verify that if an error occurs it is a BadMatch error.  ");
	report_strategy("Create list of rectangles with");
	report_strategy("same Y origin and height and decreasing in X origin.  ");
	report_strategy("Call XSetClipRectangles.  ");
	report_strategy("Verify that if an error occurs it is a BadMatch error.  ");
	report_strategy("Create list of rectangles with same Y origin and increasing X");
	report_strategy("origin and differing extents.  ");
	report_strategy("Call XSetClipRectangles.  ");
	report_strategy("Verify that if an error occurs it is a BadMatch error.  ");

	tpstartup();
	setargs();
	if(bad_orderA(YXBanded) == 1 &&
	   bad_orderB(YXBanded) == 1 &&
	   bad_orderC(YXBanded) == 1)
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetClipRectangles-7.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EGC.mc */
/* End of included file error/EGC.mc */

/* Including from file error/EGC.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetClipRectangles-8.(A)");
	report_assertion("When the GC argument does not name a defined GC, then a");
	report_assertion("BadGC error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Set GC id to -1 using XTestSetGContextOfGC.");
	report_strategy("Call test function using bad GC as the GC argument.");
	report_strategy("Verify that a BadGC error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_GC = badgc(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EGC.mc */

/* Including from file Mval.tmc.364092 */
/* End of included file Mval.tmc.364092 */

/* Including from file error/EVal.mc */
static void t009(){

#undef	VALUE_ARG
#define	VALUE_ARG ordering
#undef	VALUE_LIST
#define	VALUE_LIST orderingvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetClipRectangles-9.(A)");
	report_assertion("When the value of ordering is other than Unsorted, YSorted,");
	report_assertion("YXSorted or YXBanded, then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
