/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XClearArea(display, w, x, y, width, height, exposures)
 *   Display	*display;
 *   Window	w;
 *   int 	x;
 *   int 	y;
 *   unsigned int 	width;
 *   unsigned int 	height;
 *   Bool	exposures;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XClearArea	1
char    *TestName = "XClearArea";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XClearArea function
 */
static Display	*display;
static Window	w;
static int 	x;
static int 	y;
static unsigned int 	width;
static unsigned int 	height;
static Bool	exposures;



/* Value list for use in test t010 */
static int 	exposuresvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	x = 5;
	y = 6;
	width = 25;
	height = 20;
	exposures = False;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Pixmap	pm;
XVisualInfo	*vp;
struct	area 	area;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XClearArea-1.(A)");
	report_assertion("A call to XClearArea paints a rectangular area in the");
	report_assertion("window specified by the w argument with the window's");
	report_assertion("background pixel or pixmap.");

	report_strategy("For window, pixmap");
	report_strategy("	Create drawable.");
	report_strategy("	Set window background pixel to 0.");
	report_strategy("	Call XClearArea.");
	report_strategy("	Verify area is set.  Outside is untouched.");
	report_strategy("");
	report_strategy("	Set window background pixel to 1.");
	report_strategy("	Call XClearArea.");
	report_strategy("	Verify area is set.  Outside is untouched.");
	report_strategy("");
	report_strategy("	Set window background pixmap");
	report_strategy("	Call XClearArea.");
	report_strategy("	Verify area is set.  Outside is untouched.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);

		XSetWindowBackground(display, w, W_FG);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		setarea(&area, x, y, width, height);

		if (checkarea(display, w, &area, W_FG, W_BG, 0) == False) {
			tet_result(TET_FAIL);
		} else {
			CHECK;
		}

		XSetWindowBackground(display, w, W_BG);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkarea(display, w, &area, W_BG, W_BG, 0) == False) {
			tet_result(TET_FAIL);
		} else
			CHECK;

		pm = maketile(display, w);
		XSetWindowBackgroundPixmap(display, w, pm);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		/*
		 * Check the area first and then the outside.
		 */
		if (checktile(display, w, &area, 0, 0, pm) == False) {
			report("Failed with background pixmap");
			tet_result(TET_FAIL);
		} else
			CHECK;
		if (checkarea(display, w, &area,  W_BG, W_BG, CHECK_OUT) == False) {
			report("Surrounding area was modified when area cleared with background pixmap");
			tet_result(TET_FAIL);
		} else
			CHECK;
	}

	CHECKPASS(4*nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

struct	area	carea;
Pixmap	pm;
XVisualInfo	*vp;
Window	child;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XClearArea-2.(A)");
	report_assertion("On a call to XClearArea the subwindow-mode is");
	report_assertion("ClipByChildren.");

	report_strategy("Create window");
	report_strategy("Create child window overlapping area to be cleared");
	report_strategy("Call XClearArea.");
	report_strategy("Verify that the child has not been drawn upon.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);
		carea.x = x + width/2;
		carea.y = 0;
		carea.width = carea.height = 0;
		child = crechild(display, w, &carea);

		pm = maketile(display, w);
		XSetWindowBackgroundPixmap(display, w, pm);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		carea.x = carea.y = carea.width = carea.height = 0;
		if (checkarea(display, child, &carea, W_BG, W_BG, CHECK_ALL) == False) {
			report("Child window was drawn upon by clear area");
			FAIL;
		} else {
			CHECK;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	area	area;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XClearArea-3.(A)");
	report_assertion("When width is zero, then it is replaced with the current");
	report_assertion("width of the window minus x.");

	report_strategy("Call XClearArea with width equal to zero.");
	report_strategy("Call checkarea to verify that area set has height of width - x.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);

		width = 0;
		XSetWindowBackground(display, w, W_FG);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		area.x = x;
		area.y = y;
		getsize(display, w, &area.width, (unsigned int*)0);
		area.width -= x;
		area.height = height;
		if (checkarea(display, w, &area, W_FG, W_BG, 0) == True) {
			CHECK;
		} else {
			report("Fail on width 0");
			FAIL;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

struct	area	area;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XClearArea-4.(A)");
	report_assertion("When height is zero, then it is replaced with the current");
	report_assertion("height of the window minus y.");

	report_strategy("Call XClearArea with height equal to zero.");
	report_strategy("Call checkarea to verify that area has height (window height - y).");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);

		height = 0;
		XSetWindowBackground(display, w, W_FG);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		area.x = x;
		area.y = y;
		getsize(display, w, (unsigned int*)0, &area.height);
		area.width = width;
		area.height -= y;
		if (checkarea(display, w, &area, W_FG, W_BG, 0) == True) {
			CHECK;
		} else {
			report("Fail on height 0");
			FAIL;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){


 	report_purpose(5);

	report_assertion("Assertion XClearArea-5.(-)");
	report_assertion("When the window has a defined background tile, then the");
	report_assertion("rectangle clipped by any children is tiled with a plane-mask");
	report_assertion("of all ones and the GXCopy function.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t006(){

XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XClearArea-6.(A)");
	report_assertion("When the window has a background_pixmap of None, then the");
	report_assertion("contents of the window are not changed.");

	report_strategy("Create window.");
	report_strategy("Set background pixel to W_FG.");
	report_strategy("Set background pixmap to None.");
	report_strategy("Call XClearArea.");
	report_strategy("Check that the window is not changed.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);
		pattern(display, w);
		XSetWindowBackground(display, w, W_FG);
		XSetWindowBackgroundPixmap(display, w, None);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkpattern(display, w, (struct area *)0) == False) {
			report("Window was changed when background was None");
			FAIL;
		} else {
			CHECK;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

struct	area	area;
Window	child;
Window	win;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XClearArea-7.(A)");
	report_assertion("When the window has a background_pixmap of ParentRelative");
	report_assertion("and the parent has a background_pixmap of None, then the");
	report_assertion("contents of the window are not changed.");

	report_strategy("Create parent window.");
	report_strategy("Create a child window covering the parent.");
	report_strategy("Set parent window background to none.");
	report_strategy("Set child window background pixmap to ParentRelative.");
	report_strategy("Clear area of child");
	report_strategy("Verify that there was no change to the child.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		win = makewin(display, vp);
		area.x = area.y = area.width = area.height = 0;
		child = crechild(display, win, &area);
		pattern(display, child);

		/*
		 * Set parent to None, child to Parent Relative.
		 */
		XSetWindowBackgroundPixmap(display, win, None);
		XSetWindowBackgroundPixmap(display, child, ParentRelative);

		w = child;
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (checkpattern(display, child, (struct area *)0) == False) {
			report("Window was changed when background was ParentRelative");
			FAIL;
		} else {
			CHECK;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XEvent	event;
XExposeEvent	ge;
XVisualInfo	*vp;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XClearArea-8.(A)");
	report_assertion("When exposures is True, then one or more Expose events are");
	report_assertion("generated for regions of the rectangle that are either");
	report_assertion("visible or are being retained in backing store.");

	report_strategy("Set exposures to True.");
	report_strategy("Call XClearArea.");
	report_strategy("Check that an expose event is received.");

	tpstartup();
	setargs();
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		w = makewin(display, vp);
		exposures = True;

		XSelectInput(display, w, ALLEVENTS);
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		XSelectInput(display, w, NoEventMask);

		if (getevent(display, &event) != 1 || event.type != Expose) {
			report("Expecting one Expose event");
			tet_result(TET_FAIL);
			return;
		}

		ge.type = Expose;
		ge.display = display;
		ge.window = w;
		ge.x = x;
		ge.y = y;
		ge.width = width;
		ge.height = height;
		ge.count = 0;

		n = checkevent((XEvent*)&ge, (XEvent*)&event);
		if (n == 0)
			CHECK;
		else {
			report("error in %d field%s of event", n, (n!=1)?"s":"");
			FAIL;
		}
	}
	CHECKPASS(nvinf());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EMat1.mc */
/* End of included file error/EMat1.mc */

/* Including from file error/EMat1.mc */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XClearArea-9.(A)");
	report_assertion("When a drawable argument is an InputOnly window then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create an InputOnly window.");
	report_strategy("Call test function using InputOnly window as the drawable argument.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_DRAWABLE = (Drawable)iponlywin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XClearArea(display, w, x, y, width, height, exposures);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EMat1.mc */

/* Including from file Mval.tmc.361600 */
/* End of included file Mval.tmc.361600 */

/* Including from file error/EVal.mc */
static void t010(){

#undef	VALUE_ARG
#define	VALUE_ARG exposures
#undef	VALUE_LIST
#define	VALUE_LIST exposuresvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XClearArea-10.(A)");
	report_assertion("When the value of exposures is other than True or False,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		XClearArea(display, w, x, y, width, height, exposures);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XClearArea-11.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XClearArea(display, w, x, y, width, height, exposures);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
