/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XGetFontProperty(font_struct, atom, value_return)
 *   XFontStruct	*font_struct;
 *   Atom	atom;
 *   unsigned long	*value_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetFontProperty	1
char    *TestName = "XGetFontProperty";

/*
 * Defines for different argument types
 */
#define A_ATOM atom


/*
 * Arguments to the XGetFontProperty function
 */
static XFontStruct	*font_struct;
static Atom	atom;
static unsigned long	*value_return;


#include	"X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	font_struct = 0;
	atom = 0;
	value_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	atom = ErrdefAtom;
}

static void t001(){

unsigned long	val;
Bool	ret;
int 	i;
XFontProp	*fprop;
extern	XFontStruct	xtfont0;	/* Known good version */
extern	char	*xtfont0cpright;	/* Known good version */
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetFontProperty-1.(A)");
	report_assertion("When the property specified by the atom argument is");
	report_assertion("defined, then a call to XGetFontProperty returns the value");
	report_assertion("of the property atom in the XFontStruct named by the");
	report_assertion("argument font_struct and returns True.");

	report_strategy("Retrieve properties that are known to be defined for the test fonts.");
	report_strategy("Verify that True is returned.");
	report_strategy("Verify that the value of the properties are correct.");

	tpstartup();
	setargs();
	font_struct = XLoadQueryFont(Dsp, "xtfont0");
	if (font_struct == NULL || isdeleted()) {
		delete("Could not load font, check that VSW5 fonts are installed");
		return;
	}

	value_return = &val;

	for (i = 0; i < xtfont0.n_properties; i++) {
		fprop = &xtfont0.properties[i];
		atom = fprop->name;

		startcall(Dsp);
		if (isdeleted())
			return;
		ret = XGetFontProperty(font_struct, atom, value_return);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if (ret != True) {
			report("call did not return True for atom %s", atomname(atom));
			FAIL;
			continue;
		} else
			CHECK;

		if (atom == XA_COPYRIGHT) {
		char	*crstr;

			XSetErrorHandler(error_status);
			reseterr();
			crstr = XGetAtomName(Dsp, val);
			XSetErrorHandler(unexp_err);
			switch (geterr()) {
			case Success:
				break;
			case BadAtom:
				report("copyright string atom did not exist");
				FAIL;
				break;
			default:
				delete("Call to XGetAtomName failed");
				return;
			}

			if (strcmp(crstr, xtfont0cpright) == 0)
				CHECK;
			else {
				report("XA_COPYRIGHT was '%s',", crstr);
				report(" expecting '%s'", xtfont0cpright);
				FAIL;
			}

		} else {
			/* Compare value */
			if (fprop->card32 == val)
				CHECK;
			else {
				report("value of %s was %d, expecting %d",
					atomname(atom), val, fprop->card32);
				FAIL;
			}
		}
	}
	CHECKPASS(2*xtfont0.n_properties);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

unsigned long	val;
Bool	ret;
extern	XFontStruct	xtfont0;	/* Known good version */
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetFontProperty-2.(A)");
	report_assertion("When the property specified by the atom argument is not");
	report_assertion("defined, then a call to XGetFontProperty returns False.");

	report_strategy("Use the XA_RGB_DEFAULT_MAP atom which is not defined in the VSW5 fonts,");
	report_strategy("(and is unlikely to be defined in a font..)");
	report_strategy("Verify that False is returned.");

	tpstartup();
	setargs();
	font_struct = XLoadQueryFont(Dsp, "xtfont0");
	if (font_struct == NULL || isdeleted()) {
		delete("Could not load font, check that VSW5 fonts are installed");
		return;
	}

	value_return = &val;

	atom = XA_RGB_DEFAULT_MAP;

	startcall(Dsp);
	if (isdeleted())
		return;
	ret = XGetFontProperty(font_struct, atom, value_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret != False)
		FAIL;
	else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
