/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtRemoveAllCallbacks()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/*
** XtCBP_ProcOne()
*/
XtCallbackProc XtCBP_ProcOne(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	sprintf(ebuf, "ERROR: Deleted Callback XtCBP_ProcOne invoked");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}
/*
** XtCBP_ProcTwo()
*/
XtCallbackProc XtCBP_ProcTwo(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
	sprintf(ebuf, "ERROR: Deleted Callback XtCBP_ProcTwo invoked");
	tet_infoline(ebuf);
	tet_result(TET_FAIL);
}


#define T_XtRemoveAllCallbacks	1
char    *TestName = "XtRemoveAllCallbacks";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget labelw_good;
XtCallbackRec callbacks[] = {
	{ (XtCallbackProc)XtCBP_ProcOne, (XtPointer) NULL },
	{ (XtCallbackProc)XtCBP_ProcTwo, (XtPointer) NULL },
	{ (XtCallbackProc) NULL, (XtPointer) NULL }
};
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRemoveAllCallbacks-1.(A)");
	report_assertion("A successful call to void XtRemoveAllCallbacks(w,");
	report_assertion("callback_name) shall delete all callback procedures from the");
	report_assertion("widget w's callback list specified by callback_name.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Trmalcbks1", "XtRemoveAllCallbacks");
	tet_infoline("PREP: Create labelw_good widget Hello in boxw1 widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Add a list of destroy callback procedures to labelw_good widget");
	XtAddCallbacks(labelw_good,
			XtNdestroyCallback,
			&callbacks[0]
			);
	tet_infoline("PREP: Remove the callbacks from the list");
	XtRemoveAllCallbacks(labelw_good, XtNdestroyCallback);
	tet_infoline("TEST: Destroying the widget does not invoke functions");
	XtDestroyWidget(labelw_good);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364836 */
/* End of included file Mdefcode.tmc.364836 */

/* Including from file Mdefcode.tmc.364836 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtRemoveAllCallbacks-2.(B)");
	report_assertion("A successful call to void XtRemoveAllCallbacks(w,");
	report_assertion("callback_name) shall free all storage associated with the");
	report_assertion("callback list specified by callback_name.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364836 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
