/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCheckSubclass()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

/* Toolkit definitions */
#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsComp.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtEM_Proc(name, type, class, defaulttp, params, num_params)
String name, type, class, defaulttp, *params;
Cardinal *num_params;
{
String par[10];
int i;
char buffer[1000];
	avs_set_event(1,1);
        XtGetErrorDatabaseText(name, type, class, defaulttp, buffer, 1000);
        i = *num_params;
        memmove((char *)par, (char *)params, i*sizeof(String));
        memset(&par[i], 0, (10-i)*sizeof(String));
        sprintf(ebuf, buffer, par[0], par[1], par[2], par[3], par[4], par[5], par[6], par[7], par[8],par[9]);
	tet_infoline("TEST: Error message contains message passed to XtCheckSubClass");
	if (strstr(ebuf, "ApTest") == NULL) {
		tet_infoline("ERROR: Error message does not contain message passed to XtCheckSubClass");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Error message contains object's actual class");
	if (strstr(ebuf, "Label") == NULL) {
		tet_infoline("ERROR: Error message does not contain object's actual class");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Error message contains expected class");
	if (strstr(ebuf, "Command") == NULL) {
		tet_infoline("ERROR: Error message does not contain expected class");
		tet_result(TET_FAIL);
	}
}

void XtEM_Proc2(name, type, class, defaulttp, params, num_params)
String name, type, class, defaulttp, *params;
Cardinal *num_params;
{
	avs_set_event(1,1);
}

void test1sub();
void test2sub();
void test3sub();


#define T_XtCheckSubclass	1
char    *TestName = "XtCheckSubclass";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCheckSubclass-1.(A)");
	report_assertion("A call to void XtCheckSubclass(w, widget_class, message)");
	report_assertion("when the class of the widget w is neither equal to nor is a");
	report_assertion("subclass of the class widget_class shall construct an error");
	report_assertion("message from message, widget_class, and the actual class of");
	report_assertion("w and call XtErrorMsg().");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	test1sub();

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364148 */
/* End of included file Mdefcode.tmc.364148 */

static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCheckSubclass-2.(A)");
	report_assertion("A call to void XtCheckSubclass(w, widget_class, message)");
	report_assertion("when the class of the widget w is equal to or is a subclass");
	report_assertion("of the class widget_class shall not generate an error");
	report_assertion("message.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	test2sub();

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364148 */
/* End of included file Mdefcode.tmc.364148 */

static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCheckSubclass-3.(A)");
	report_assertion("When a module is not compiled with the compiler symbol");
	report_assertion("DEBUG defined a call to void XtCheckSubclass(w,");
	report_assertion("widget_class, message) shall result in no code to be");
	report_assertion("executed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	test3sub();

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.364148 */
/* End of included file Mdefcode.tmc.364148 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
