/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <AvsRectObj.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtIsRealized	1
char    *TestName = "XtIsRealized";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Boolean status;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtIsRealized-1.(A)");
	report_assertion("A call to Boolean XtIsRealized(w) shall return True when");
	report_assertion("the window for the widget w has a non-zero ID.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tisrealiz1", "XtIsRealized");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Widget labelw is realized shall return True");
	status = XtIsRealized(labelw);
	check_dec(True, status, "Return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364268 */
/* End of included file Mdefcode.tmc.364268 */

static void t002(){

Boolean status;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtIsRealized-2.(A)");
	report_assertion("A call to Boolean XtIsRealized(w) shall when the widget w");
	report_assertion("has not been realized shall return a value other than True.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tisrealiz2", "XtIsRealized");
	tet_infoline("TEST: labelw widget NOT realized - shall return False");
	status = XtIsRealized(labelw);
	check_dec(False, status, "Return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364268 */
/* End of included file Mdefcode.tmc.364268 */

static void t003(){

Widget test_widget;
Boolean status;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtIsRealized-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to Boolean");
	report_assertion("XtIsRealized(w) when w is not a widget shall return the");
	report_assertion("state of the nearest widget ancestor.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Tisrealiz1", "XtIsRealized");
        tet_infoline("PREP: Create AVS RectObj widget");
        test_widget = XtVaCreateManagedWidget("avsro", avsrectObjClass, topLevel, NULL);

	tet_infoline("TEST: XtIsRealized returns False");
	status = XtIsRealized(test_widget);
	check_dec(False, status, "Return value");
	tet_infoline("PREP: Realize nearest widget ancenstor");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: XtIsRealized returns True");
	status = XtIsRealized(test_widget);
	check_dec(True, status, "Return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364268 */
/* End of included file Mdefcode.tmc.364268 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
