/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtRealizeWidget()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtRealizeWidget	1
char    *TestName = "XtRealizeWidget";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file Mdefcode.tmc.364276 */
static void t001(){

pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtRealizeWidget-1.(B)");
	report_assertion("A call to void XtRealizeWidget(w) shall bind all action");
	report_assertion("names in the translation table of the widget w to");
	report_assertion("procedures.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

static void t002(){

Window window_good;
Widget widget_good, labelw_good;
Display *display_good;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtRealizeWidget-2.(A)");
	report_assertion("A call to void XtRealizeWidget(w) when the widget w is");
	report_assertion("already realized shall return immediately.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Trealwdgt2", "XtRealizeWidget");
	tet_infoline("PREP: Create test label widget `Hello' in box widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Call XtRealize again");
	XtRealizeWidget(topLevel);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364276 */
/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtRealizeWidget-3.(B)");
	report_assertion("A call to void XtRealizeWidget(w) shall make a post order");
	report_assertion("traversal of the widget tree starting at the widget w and");
	report_assertion("call each non-NULL change_managed procedure of all composite");
	report_assertion("widgets that have one or more managed children in the");
	report_assertion("reverse order of their appearance in the CompositePart");
	report_assertion("children list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtRealizeWidget-4.(B)");
	report_assertion("A call to void XtRealizeWidget(w) when the widget w is not");
	report_assertion("a subclass of compositeWidgetClass shall return without");
	report_assertion("realizing or mapping its children.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtRealizeWidget-5.(B)");
	report_assertion("A successful call to void XtRealizeWidget(w) shall");
	report_assertion("recursively descend the widget tree starting at the widget w");
	report_assertion("and call the realize procedures of all the managed children");
	report_assertion("in the reverse order of their appearance in the");
	report_assertion("CompositePart children list, passing to them the widget, a");
	report_assertion("XtValueMask, and a XSetWindowAttributes structure as");
	report_assertion("parameters.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtRealizeWidget-6.(B)");
	report_assertion("A successful call to void XtRealizeWidget(w) shall set the");
	report_assertion("background_pixmap, border_pixmap, and the colormap fields of");
	report_assertion("the XSetWindowAttributes structure to their corresponding");
	report_assertion("fields in the widget core structure before passing it to the");
	report_assertion("realize procedures of the managed children.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtRealizeWidget-7.(B)");
	report_assertion("A successful call to void XtRealizeWidget(w) shall set the");
	report_assertion("event_mask field of the XSetWindowAttributes structure to");
	report_assertion("indicate the event handlers registered, the event");
	report_assertion("translations specified, the expose field is non-NULL, and");
	report_assertion("the visible_interest field is True before passing it to the");
	report_assertion("realize procedures of the managed children.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtRealizeWidget-8.(B)");
	report_assertion("A successful call to void XtRealizeWidget(w) shall set the");
	report_assertion("bit_gravity field of the XSetWindowAttributes structure,");
	report_assertion("before passing it to the realize procedures of the managed");
	report_assertion("children, to NorthWestGravity when the expose field of the");
	report_assertion("widget core structure is NULL.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtRealizeWidget-9.(B)");
	report_assertion("A successful call to void XtRealizeWidget(w) shall map the");
	report_assertion("windows of all the managed children that have the");
	report_assertion("mapped_when_managed field set to True.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

static void t010(){

Window window_good;
Widget widget_good;
Display *display_good;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtRealizeWidget-10.(A)");
	report_assertion("A successful call to void XtRealizeWidget(w) when the");
	report_assertion("widget w is a top-level shell widget and has the");
	report_assertion("mapped_when_managed field set to True shall map the widget");
	report_assertion("window.");
	FORK(pid);
	initconfig();

	avs_xt_hier("Trealwdgt2", "XtRealizeWidget");
	tet_infoline("TEST: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Check XtWindow() returns valid window id");
	if ((window_good = XtWindow(topLevel) ) <= 0 ) {
		sprintf(ebuf, "ERROR: Expected Valid window id returned %d", window_good);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
		exit(0);
	}
	tet_infoline("TEST: Window id is correct");
	display_good = XtDisplay(topLevel);
	widget_good = XtWindowToWidget(display_good, window_good);
	check_str("VSW5 X Toolkit Tests", XtName(topLevel), "widget name");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.364276 */
/* End of included file Mdefcode.tmc.364276 */

/* Including from file Mdefcode.tmc.364276 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtRealizeWidget-11.(B)");
	report_assertion("A call to void XtRealizeWidget(w) when the widget w is a");
	report_assertion("top-level shell widget and has the mapped_when_managed field");
	report_assertion("set to a value other than True shall not map the widget");
	report_assertion("window.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.364276 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
