/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2001 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtVaAppInitialize()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/Xatom.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
char *msg="/tmp/outfile";
char *args11[] = {
	"-background", "green",
	"-bd", "green",
	"-bg", "green",
	"-borderwidth", "3",
	"-bordercolor", "red",
	"-bw", "3",
	"-fg", "green",
	"-font", XtDefaultFont,
	"-fn", XtDefaultFont,
	"-foreground", "blue",
	"-geometry", "100x100",
	"-iconic", 
	"-reverse",
	"-rv",
	"+rv",
	"-selectionTimeout", "50",
	"-synchronous",
	"+synchronous",
	"-title", "ApTest",
	"-xnlLanguage", "C",
	NULL};


typedef struct _instance_variables {
        long foreground;
        String label;
} instance_variable_rec;

static XtResource resources[] = {
        {
        XtNforeground,
        XtCForeground,
        XtRPixel, sizeof(Pixel),
        XtOffsetOf(instance_variable_rec, foreground),
        XtRString, "XtDefaultForeground"
        },
        {
        XtNlabel,
        XtCLabel,
        XtRString, sizeof(String),
        XtOffsetOf(instance_variable_rec, label),
        XtRString, "very bad idea"
        },
};


#define T_XtVaAppInitialize	1
char    *TestName = "XtVaAppInitialize";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t	pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtVaAppInitialize-1.(A)");
	report_assertion("A call to Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) shall initialize the");
	report_assertion("Intrinsics internals, create an application context for the");
	report_assertion("calling application and return the context in");
	report_assertion("app_context_return, open a display, create a top-level shell");
	report_assertion("widget that is the root of a widget tree, and return the");
	report_assertion("shell widget instance.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	tet_infoline("TEST: Initialize toolkit");
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL,
		(String *)NULL,
		(char *)NULL
	);
	avs_set_event(1,1);
	tet_infoline("TEST: Widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	display_good = XtDisplay(widget_good);
	tet_infoline("PREP: Get application name and class");
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	tet_infoline("TEST: Application name and class.");
	check_str("main", name_good, "Name");
	check_str("TVaAppInitialize", class_good, "Class");
	KROF(pid2);
	if (avs_get_event(1) != 1) {
		tet_infoline("ERROR: Process terminated by XtVaAppInitialize ");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t002(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t	pid2;
FILE *stream;
char line[80], *retval;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtVaAppInitialize-2.(A)");
	report_assertion("When the display cannot be opened a call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall issue an error message and");
	report_assertion("terminate the application.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	tet_infoline("TEST: Initialize toolkit");
	FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "PREP: Direct error message to %s", msg);
	tet_infoline(ebuf);
	push_stderr("outfile", "w");
	sprintf(ebuf, "DISPLAY=%s", "notarealdisplay");
	putenv(ebuf);
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL,
		(String *)NULL,
		(char *)NULL
	);
	avs_set_event(1,1);
	pop_stderr();
	KROF(pid2);
	tet_infoline("TEST: Open the file and read the message");
	stream = (FILE *)fopen(msg, "r");
	retval = fgets(line, 80, stream) ;
	if (retval == NULL) {
		tet_infoline("ERROR: No error message issued");
		tet_result(TET_FAIL);
		unlink(msg);
		exit(0);
	}
	unlink(msg);
	if (avs_get_event(1) ==  1) {
		tet_infoline("ERROR: Process not terminated by XtVaAppInitialize ");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtVaAppInitialize-3.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall create a resource database");
	report_assertion("for the display.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

static void t004(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
Boolean status;
pid_t	pid2;
int     argc_count;
char    **argv_string;
int     count = 3;
char    *argvals[4];
char    *display_name;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtVaAppInitialize-4.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -display option is");
	report_assertion("specified in argv_in_out shall use this value as the display");
	report_assertion("to be opened and initialized.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();


	FORK(pid2);
	tet_infoline("TEST: Initialize toolkit");
	sleep(config.reset_delay);
	tet_infoline("PREP: Set arguments to include -display");
	argvals[0] = "tinitlize";
	argvals[1] = "-display";
	argvals[2] = (char *)config.display;
	argvals[3] = (char *)NULL;
	argc_count = count;
	argv_string = &argvals[0];
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string,
		(String *)NULL,
		(ArgList)NULL,
		(char *)NULL
	);
	avs_set_event(1,1);
	display_good = XtDisplay(widget_good);
	tet_infoline("TEST: Display name is correct");
	display_name = XDisplayString(display_good);
	check_str(config.display, display_name, "Display name");
	KROF(pid2);
	if (avs_get_event(1) != 1) {
		tet_infoline("ERROR: Process terminated by XtVaAppInitialize ");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t005(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
char *display_name;
int argcount = 0;
Boolean status;
pid_t	pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtVaAppInitialize-5.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -display option is not");
	report_assertion("specified in argv and the DISPLAY environment variable is");
	report_assertion("set shall use this value as the display to be opened and");
	report_assertion("initialized.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
	tet_infoline("PREP: Set DISPLAY");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit");
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL,
		(String *)NULL,
		(char *)NULL
	);
	avs_set_event(1,1);
	display_good = XtDisplay(widget_good);
	tet_infoline("TEST: Display name is correct");
	display_name = XDisplayString(display_good);
	check_str(config.display, display_name, "Display name");
	KROF(pid2);
	if (avs_get_event(1) != 1) {
		tet_infoline("ERROR: Process terminated by XtVaAppInitialize ");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t006(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 3;
char    *argvals[4];
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtVaAppInitialize-6.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -name option is specified");
	report_assertion("in argv_in_out shall use this value as the application name");
	report_assertion("to query the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	argvals[0] = "tinitlize";
        argvals[1] = "-name";
        argvals[2] = "testname";
        argvals[3] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string,
		(String *)NULL,
		(char *)NULL
	);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t007(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int pstatus;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtVaAppInitialize-7.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -name option is not");
	report_assertion("specified in argv and the environment variable RESOURCE_NAME");
	report_assertion("is set shall use this value as the application name to query");
	report_assertion("the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
        tet_infoline("PREP: Set up env variable RESOURCE_NAME");
        putenv("RESOURCE_NAME=testname2");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argcount,
		(String *)NULL,
		(String *)NULL,
		(char *)NULL
	);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname2", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t008(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 1;
char    *argvals[4];
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtVaAppInitialize-8.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -name option is not");
	report_assertion("specified in argv_in_out, the environment variable");
	report_assertion("RESOURCE_NAME is not set, and argv_in_out[0] is not an empty");
	report_assertion("string shall use this value as the application name to query");
	report_assertion("the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	argvals[0] = "testname3";
        argvals[1] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string,
		(String *)NULL,
		(char *)NULL
	);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("testname3", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t009(){

XtAppContext app_ctext_return;
Widget widget_good;
Display *display_good;
String name_good, class_good;
char name[20], class[20];
int argcount = 0;
Boolean status;
pid_t pid2;
int	pstatus;
int     argc_count;
char    **argv_string;
int     count = 1;
char    *argvals[4];
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtVaAppInitialize-9.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the -name option is not");
	report_assertion("specified in argv_in_out, the environment variable");
	report_assertion("RESOURCE_NAME is not set, and argv_in_out[0] is an empty");
	report_assertion("string shall use the string main as the application name to");
	report_assertion("query the server and screen resource databases for the");
	report_assertion("name.xnlLanguage resource to create the resource database");
	report_assertion("for the display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	argvals[0] = "";
        argvals[1] = (char *)NULL;
        argc_count = count;
        argv_string = &argvals[0];
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc_count,
		argv_string,
		(String *)NULL,
		(char *)NULL
	);
	tet_infoline("TEST: widget_good class is applicationShell");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	tet_infoline("TEST: Application name and class");
	display_good = XtDisplay(widget_good);
	XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
	check_str("main", name_good, "Application Name");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
	} else
                tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t010(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext_return;
Display *display;
int queued_events, events;
int argc = 2;
pid_t pid2;
int     pstatus;
    /*
    ** -synchronous on
    ** +synchronous off
    */
char *argv[] = { "tinitlize", "-synchronous", NULL };
Widget widget_good;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtVaAppInitialize-10.(A)");
	report_assertion("When the synchronize resource is set to True in the");
	report_assertion("resource database created by a successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) it shall put Xlib into synchronous");
	report_assertion("mode for this display connection.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit and open display");
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc,
		argv,
		(String *)NULL,
		(ArgList)NULL,
		NULL
	);
	avs_set_event(1,1);
	display = XtDisplay(widget_good);
	tet_infoline("PREP: Create a window for events");
	scr = DefaultScreen(display);
	window = XCreateWindow(display, RootWindow(display, scr),
	       0, 0, 5, 5, 0, /* x,y,wid,ht,brd width */
	       DefaultDepth(display, scr),
	       InputOutput,
	       DefaultVisual(display, scr),
	       (XtValueMask) 0,
	       (XSetWindowAttributes *) 0);
	tet_infoline("TEST: Check Xlib is in synchronous mode");
	queued_events = XQLength(display);
	XSelectInput(display, window,
	     (unsigned long)PropertyChangeMask);
	for (events = 0; events < 3; events++)
		XChangeProperty(display, window, XA_RESOURCE_MANAGER, XA_STRING, 8,0, (unsigned char *)property_data, 16);
	check_dec(3+queued_events, XQLength(display), "queue length");
	KROF3(pid2, pstatus, AVSXTTIMEOUT-2);
	if (avs_get_event(1) != 1) {
		tet_infoline("ERROR: Process terminated by XtVaAppInitialize ");
		tet_result(TET_FAIL);
		exit(1);
	}
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtVaAppInitialize-11.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) shall determine a");
	report_assertion("language string for the display by searching the following");
	report_assertion("sources in the specified order: - the resource database");
	report_assertion("created from the command line. - the resource");
	report_assertion("application_name.xnlLanguage, class");
	report_assertion("application_class.XnlLanguage in the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("if it exists, or in the user preference resource file");
	report_assertion("otherwise. - the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtVaAppInitialize-12.(D)");
	report_assertion("If the implementation is X11R5 or later and is POSIX-based:");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall use the LANG environment");
	report_assertion("variable as the environment value to search when determining");
	report_assertion("the language string for the display.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtVaAppInitialize-13.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) shall set the language");
	report_assertion("string for the display to the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("exists, and a language string is not found on the command");
	report_assertion("line, in this property, or in the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtVaAppInitialize-14.(D)");
	report_assertion("If the implementation is X11R5 or later: A successful call");
	report_assertion("to Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) shall set the language");
	report_assertion("string for the display to the empty string if the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen zero");
	report_assertion("does not exist and a language string is not found on the");
	report_assertion("command line, in the user preference resource file, or in");
	report_assertion("the environment.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtVaAppInitialize-15.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall associate with the default");
	report_assertion("screen of the display a resource database created by");
	report_assertion("combining entries from the following sources, in order, with");
	report_assertion("the first named source having the highest precedence: - the");
	report_assertion("application command line - the user's environment resource");
	report_assertion("file - per-screen resource specifications from the server,");
	report_assertion("as returned by XScreenResourceString() - per display");
	report_assertion("resource specifications from the server (the server's");
	report_assertion("RESOURCE_MANAGER property for the root window of screen");
	report_assertion("zero) if they exist, otherwise the user preference file -");
	report_assertion("the application-specific user resource file. - the");
	report_assertion("application-specific class resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

static void t016(){

Display	*display_good;
String	name_good, class_good;
int	argcount = 20;
instance_variable_rec base;
pid_t pid2;
Widget widget_good;
XtAppContext app_ctext_return;
pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtVaAppInitialize-16.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall recognize options specified");
	report_assertion("on the command line that are in the standard table of");
	report_assertion("options in section 4.4 of the specification or in the table");
	report_assertion("specific to the application specified by options and");
	report_assertion("num_options.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

        FORK(pid2);
	sleep(config.reset_delay);
	tet_infoline("PREP: Set DISPLAY");
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize toolkit");
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argcount,
		args11,
		(String *)NULL,
		(ArgList)NULL,
		NULL
	);
        tet_infoline("TEST: Retrieve resource values from resource database");
        XtGetApplicationResources(widget_good,
		&base,
		resources,
		1,
		(ArgList)NULL,
		(Cardinal)0);
        LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

static void t017(){

Window window;
int scr;
static char *property_data = "Hello World";
XtAppContext app_ctext;
Display *display;
int queued_events, events;
XrmValue args[2];
Cardinal num_args;
XrmValue fromVal;
XrmValue toVal;
Boolean closure;
XtPointer closure_ret = (XtPointer *) &closure;
int argc = 2;
char *argv[] = { "tdsplyintl2", "+rv", NULL };
Screen *screen;
Colormap colormap;
pid_t pid2;
Pixel res;
Boolean status;
XtAppContext app_ctext_return;
Widget widget_good;
pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtVaAppInitialize-17.(A)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the reverseVideo resource is");
	report_assertion("define as True on the command line shall use the value of");
	report_assertion("XtDefaultForeground instead of XtDefaultBackground and vice");
	report_assertion("versa in the resource database created for the display.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

        FORK(pid2);
	sleep(config.reset_delay);
	sprintf(ebuf, "DISPLAY=%s", config.display);
	putenv(ebuf);
	tet_infoline("TEST: Initialize and application with +rv in args");
	widget_good = XtVaAppInitialize(&app_ctext_return,
		"TVaAppInitialize",
		(XrmOptionDescList)NULL,
		(Cardinal)0,
		&argc,
		argv,
		(String *)NULL,
		(ArgList)NULL,
		NULL
	);
	display = XtDisplay(widget_good);
	tet_infoline("PREP: Set up required conversion args");
        screen = DefaultScreenOfDisplay(display);
        args[0].addr = (XtPointer )&screen;
        args[0].size = sizeof(Screen*);
        colormap = DefaultColormapOfScreen(screen);
        args[1].addr = (XtPointer) &colormap;
        args[1].size = sizeof(Colormap);
        num_args = 2;
        tet_infoline("TEST: Convert XtDefaultForeground");
        fromVal.addr = XtDefaultForeground;
        fromVal.size = strlen(XtDefaultForeground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XBlackPixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        tet_infoline("TEST: Convert XtDefaultBackground");
        fromVal.addr = XtDefaultBackground;
        fromVal.size = strlen(XtDefaultBackground)+1;
        toVal.addr = (XtPointer) &res;
        toVal.size = sizeof(Pixel);
        status = XtCvtStringToPixel(display,
                        &args[0],
                        &num_args,
                        &fromVal,
                        &toVal,
                        &closure_ret);
        check_dec(True, status, "XtCvtStringToPixel return value");
        tet_infoline("TEST: Conversion result");
        check_dec(XWhitePixelOfScreen(DefaultScreenOfDisplay(display)), res, "returned pixel");
        LKROF(pid2, AVSXTTIMEOUT-2);
        tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360832 */
/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtVaAppInitialize-18.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) when the environment");
	report_assertion("variable XENVIRONMENT exists shall use the value of this");
	report_assertion("variable as the name of the user environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t019(){

pid_t	pid;

 	report_purpose(19);

	report_assertion("Assertion XtVaAppInitialize-19.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) when the environment");
	report_assertion("variable XENVIRONMENT does not exist shall use the file.Xdefaults-host,");
	report_assertion("where host is the name of the system running the");
	report_assertion("application, in the user's home directory as the user");
	report_assertion("environment resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t020(){

pid_t	pid;

 	report_purpose(20);

	report_assertion("Assertion XtVaAppInitialize-20.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall set the values from the");
	report_assertion("higher precedence sources of the resource database being");
	report_assertion("created for the display as the current resource database");
	report_assertion("before determining the file name for the");
	report_assertion("application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t021(){

pid_t	pid;

 	report_purpose(21);

	report_assertion("Assertion XtVaAppInitialize-21.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) when the environment");
	report_assertion("variable XUSERFILESEARCHPATH is defined shall use the result");
	report_assertion("of calling XtResolvePathname(display, path, NULL, NULL,");
	report_assertion("NULL, NULL, 0, NULL) with the value of this variable as path");
	report_assertion("as the name of the application-specific user resource file.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t022(){

pid_t	pid;

 	report_purpose(22);

	report_assertion("Assertion XtVaAppInitialize-22.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) when the environment");
	report_assertion("variable XUSERFILESEARCHPATH is not defined and the");
	report_assertion("environment variable XAPPLRESDIR is not defined shall use");
	report_assertion("the result of calling XtResolvePathname(display, path, NULL,");
	report_assertion("NULL, NULL, NULL, 0, NULL) as the name of the");
	report_assertion("application-specific user resource file where path contains");
	report_assertion("at least entries containing $HOME as the directory prefix");
	report_assertion("plus the following substitutions, in the order specified: -");
	report_assertion("%C, %N, %L or %C, %N, %l, %t, %c - %C, %N, %l - %C, %N - %N,");
	report_assertion("%L or %N, %l, %t, %c - %N, %l - %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t023(){

pid_t	pid;

 	report_purpose(23);

	report_assertion("Assertion XtVaAppInitialize-23.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("Widget XtVaAppInitialize(app_context_return,");
	report_assertion("application_class, options, num_options, argc_in_out,");
	report_assertion("argv_in_out, fallback_resources,...) when the environment");
	report_assertion("variable XUSERFILESEARCHPATH is not defined and the");
	report_assertion("environment variable XAPPLRESDIR is defined shall use the");
	report_assertion("result of calling XtResolvePathname(display, path, NULL,");
	report_assertion("NULL, NULL, NULL, 0, NULL) as the name of the");
	report_assertion("application-specific user resource file where path contains");
	report_assertion("at least entries containing the following directory prefixes");
	report_assertion("and substitutions, in the order specified: - $XPPLRESDIR");
	report_assertion("with %C, %N, %L or %C, %N, %l, %t, %c - $XPPLRESDIR with %C,");
	report_assertion("%N, %l - $XPPLRESDIR with %C, %N - $XPPLRESDIR with %N, %L");
	report_assertion("or %N, %l, %t, %c - $XPPLRESDIR with %N, %l - $XPPLRESDIR");
	report_assertion("with %N - $HOME with %N");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t024(){

pid_t	pid;

 	report_purpose(24);

	report_assertion("Assertion XtVaAppInitialize-24.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall use the result of calling");
	report_assertion("XtResolvePathname(display, app-defaults, NULL, NULL, NULL,");
	report_assertion("NULL, 0, NULL) as the name of the application-specific class");
	report_assertion("resource file, with the values from the higher precedence");
	report_assertion("sources of the resource database being created for the");
	report_assertion("display set as the current resource database before the call");
	report_assertion("is made.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t025(){

pid_t	pid;

 	report_purpose(25);

	report_assertion("Assertion XtVaAppInitialize-25.(B)");
	report_assertion("On a successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) the shell widget instance created");
	report_assertion("shall have WM_COMMAND property set from the values of the");
	report_assertion("XtNargv and XtNargc resources.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t026(){

pid_t	pid;

 	report_purpose(26);

	report_assertion("Assertion XtVaAppInitialize-26.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) shall name the shell widget");
	report_assertion("instance with the application name passed to");
	report_assertion("XtDisplayInitialize.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t027(){

pid_t	pid;

 	report_purpose(27);

	report_assertion("Assertion XtVaAppInitialize-27.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the varargs style variable");
	report_assertion("argument list specifies the XtNscreen argument shall create");
	report_assertion("the resource database for the shell widget using the");
	report_assertion("resource values specified in the variable argument list and");
	report_assertion("resource values from the resource database of the screen");
	report_assertion("specified by the XtNscreen argument for those resources not");
	report_assertion("specified in the variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t028(){

pid_t	pid;

 	report_purpose(28);

	report_assertion("Assertion XtVaAppInitialize-28.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the variable argument list");
	report_assertion("does not specify the XtNscreen argument and the resource");
	report_assertion("database of the default screen for display specifies the");
	report_assertion("resource name.screen, class application_class.screen shall");
	report_assertion("create the resource database for the shell widget using the");
	report_assertion("resource values specified in the variable argument list and");
	report_assertion("resource values from the resource database of the screen");
	report_assertion("specified in the resource database of the default screen for");
	report_assertion("those resources not specified in the variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* Including from file Mdefcode.tmc.360832 */
static void t029(){

pid_t	pid;

 	report_purpose(29);

	report_assertion("Assertion XtVaAppInitialize-29.(B)");
	report_assertion("A successful call to Widget");
	report_assertion("XtVaAppInitialize(app_context_return, application_class,");
	report_assertion("options, num_options, argc_in_out, argv_in_out,");
	report_assertion("fallback_resources,...) when the variable argument list");
	report_assertion("does not specify the XtNscreen argument and the resource");
	report_assertion("database of the default screen for display does not specify");
	report_assertion("the resource name.screen, class application_class.screen");
	report_assertion("shall create the resource database for the shell widget");
	report_assertion("using the resource values specified in the variable argument");
	report_assertion("list and resource values from the resource database of the");
	report_assertion("default screen for those resources not specified in the");
	report_assertion("variable argument list.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360832 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
