/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtGrabButton()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#ifdef XTESTEXTENSION
#include <X11/extensions/XTest.h>
#endif

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
Widget labelw_msg;

#ifdef XTESTEXTENSION
static void
analyse_events(TestWidget)
Widget TestWidget;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	Window window;
	Widget widget;
	app_context = XtWidgetToApplicationContext(TestWidget);
	display = XtDisplay(TestWidget);
	/*
	** Poll events
	*/
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
	 XtDispatchEvent(&loop_event);
	 if (loop_event.type == ButtonPress) {
		tet_infoline("INFO: ButtonPress event received");
	}
	 if (loop_event.type == ButtonRelease) {
		tet_infoline("TEST: Button release sent to grab widget");
	 	if (XtWindow(TestWidget) != loop_event.xbutton.window) {
			tet_infoline("ERROR: Event not sent to grab window");
			tet_result(TET_FAIL);
			exit(0);
		}
		else {
			tet_result(TET_PASS);
			exit(0);
		}
	}
	} /* end for */
}
Widget labelw, click_pass, click_fail;
char label[80];

/*
** procedure XtTMO_Proc
*/
void XtTMO_Proc2(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
XEvent event;
	tet_infoline("ERROR: Timed out waiting for input");
	tet_result(TET_UNRESOLVED);
	exit(0);
}

/*
** procedure XtTMO_Proc
*/
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	Position rootx, rooty;

	XtAppAddTimeOut(app_ctext, (unsigned long)4000, XtTMO_Proc2, topLevel);
	tet_infoline("PREP: Move inside of grab widget");
	XtTranslateCoords(labelw_msg, 0,0,&rootx, &rooty);
	XTestFakeMotionEvent(XtDisplay(labelw_msg), -1, rootx+100, rooty, CurrentTime);
	tet_infoline("PREP: Depress button");
	XTestFakeButtonEvent(XtDisplay(labelw_msg), 1, True, CurrentTime);
	tet_infoline("PREP: Move outside of grab widget");
	XTestFakeMotionEvent(XtDisplay(labelw_msg), -1, rootx-100, rooty, CurrentTime);
	tet_infoline("PREP: Release button");
	XTestFakeButtonEvent(XtDisplay(labelw_msg), 1, False, CurrentTime);
}
#endif


#define T_XtGrabButton	1
char    *TestName = "XtGrabButton";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
int status;
Window window;
int ret_value;
char *msg = "This is the grab widget\n";
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGrabButton-1.(A)");
	report_assertion("When the widget widget is realized a successful call to");
	report_assertion("void XtGrabButton(widget, button, modifiers, owner_events,");
	report_assertion("event_mask, pointer_mode, keyboard_mode, confine_to, cursor)");
	report_assertion("shall call XGrabButton to establish a passive button grab");
	report_assertion("for the specified widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#ifdef XTESTEXTENSION
	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tgrabbutn1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtGrabButton") );
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	sprintf(ebuf, "PREP: Create label requesting user input");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppAddTimeOut(app_ctext, (unsigned long)500, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Issue XtGrabButton");
	XtGrabButton(labelw_msg, AnyButton, AnyModifier, True,
		 ButtonPressMask|ButtonReleaseMask, GrabModeAsync,
		 GrabModeAsync, XtWindow(labelw_msg), None);
	analyse_events(labelw_msg);
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
#else
	tet_infoline("INFO: XTEST extension is not configured");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360912 */
/* End of included file Mdefcode.tmc.360912 */

static void t002(){

Display *display;
int status;
Window window;
int ret_value;
char *msg = "This is the grab widget\n";
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGrabButton-2.(A)");
	report_assertion("When the widget widget is not realized a successful call to");
	report_assertion("void XtGrabButton(widget, button, modifiers, owner_events,");
	report_assertion("event_mask, pointer_mode, keyboard_mode, confine_to, cursor)");
	report_assertion("shall cause XGrabButton to be called to establish a passive");
	report_assertion("button grab for the specified widget when the widget is");
	report_assertion("realized.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#ifdef XTESTEXTENSION
	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tgrabbutn1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtGrabButton") );
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	sprintf(ebuf, "PREP: Create label requesting user input");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	XtAppAddTimeOut(app_ctext, (unsigned long)500, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Issue XtGrabButton");
	XtGrabButton(labelw_msg, AnyButton, AnyModifier, True,
		 ButtonPressMask|ButtonReleaseMask, GrabModeAsync,
		 GrabModeAsync, XtWindow(labelw_msg), None);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	analyse_events(labelw_msg);
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
#else
	tet_infoline("INFO: XTEST extension is not configured");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360912 */
/* End of included file Mdefcode.tmc.360912 */

static void t003(){

Display *display;
int status;
Window window;
int ret_value;
char *msg = "This is the grab widget\n";
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGrabButton-3.(A)");
	report_assertion("When the widget widget is realized a successful call to");
	report_assertion("void XtGrabButton(widget, button, modifiers, owner_events,");
	report_assertion("event_mask, pointer_mode, keyboard_mode, confine_to, cursor)");
	report_assertion("shall cause XGrabButton to be called, to establish a passive");
	report_assertion("button grab for the specified widget, when the widget is");
	report_assertion("next realized following an unrealize action on the widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

#ifdef XTESTEXTENSION
/*this test does not pass prior do R6.4gamma due to issues with
consistency of the spec, test suite, and sample code*/
if (config.coverage < 2) {
	FORK(pid2);
	xt_tomultiple=3;
	tet_infoline("PREP: Initialize toolkit, Open display and Create topLevel root widget");
	topLevel = (Widget) avs_xt_init("Tgrabbutn1", NULL, 0);
	tet_infoline("PREP: Set up the XtToolkitError handler");
	app_ctext = XtWidgetToApplicationContext(topLevel);
	XtAppSetErrorMsgHandler(app_ctext, xt_handler);
	tet_infoline("PREP: Set up widget tree of depth eight (8) return panedw widget");
	panedw = (Widget) avs_xt_tree(topLevel);
	tet_infoline("PREP: Create boxw1 widget in panedw widget");
	boxw1 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Get the label widget name");
	strcpy(label, (char *)title("XtGrabButton") );
	labelw = (Widget) CreateLabelWidget(label, boxw1);
	tet_infoline("PREP: Create boxw2 widget in panedw widget");
	boxw2 = (Widget) CreateBoxWidget(panedw);
	tet_infoline("PREP: Set height and width of boxw2 widget");
	ConfigureDimension(topLevel, boxw2);
	sprintf(ebuf, "PREP: Create label requesting user input");
	labelw_msg = (Widget) CreateLabelWidget(msg, boxw1);
	XtAppAddTimeOut(app_ctext, (unsigned long)500, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Issue XtGrabButton");
	XtGrabButton(labelw_msg, AnyButton, AnyModifier, True,
		 ButtonPressMask|ButtonReleaseMask, GrabModeAsync,
		 GrabModeAsync, XtWindow(labelw_msg), None);
	tet_infoline("PREP: Unrealize grab widget");
	XtUnrealizeWidget(labelw_msg);
	tet_infoline("PREP: Realize grab widget");
	XtManageChild(labelw_msg);
	analyse_events(labelw_msg);
	LKROF(pid2, (AVSXTTIMEOUT-2)*xt_tomultiple);
} else {
	tet_infoline("INFO: Test surpressed due to XT_COVERAGE value");
	tet_result(TET_UNTESTED);
}
#else
	tet_infoline("INFO: XTEST extension is not configured");
	tet_result(TET_UNSUPPORTED);
#endif

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360912 */
/* End of included file Mdefcode.tmc.360912 */

/* Including from file Mdefcode.tmc.360912 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGrabButton-4.(B)");
	report_assertion("After a passive button grab is established for the widget");
	report_assertion("widget by a call to void XtGrabButton(widget, button,");
	report_assertion("modifiers, owner_events, event_mask, pointer_mode,");
	report_assertion("keyboard_mode, confine_to, cursor) when a ButtonPress event");
	report_assertion("matching button and modifiers occurs in the specified");
	report_assertion("widget, a modal cascade exists, and the widget widget is not");
	report_assertion("in the active subset of the modal cascade the grab shall not");
	report_assertion("be performed.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360912 */

/* Including from file Mdefcode.tmc.360912 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtGrabButton-5.(D)");
	report_assertion("If the implementation is X11R5 or later: After a passive");
	report_assertion("button grab is established for the widget widget by a call");
	report_assertion("to void XtGrabButton(widget, button, modifiers,");
	report_assertion("owner_events, event_mask, pointer_mode, keyboard_mode,");
	report_assertion("confine_to, cursor) when a ButtonPress event matching button");
	report_assertion("and modifiers occurs in the specified widget and an input");
	report_assertion("method exists for the widget widget the grab shall not be");
	report_assertion("performed.");
	report_assertion("Reason for omission: Temporarily can't be implemented");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.360912 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
