/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtUngrabPointer()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

static void analyse_events(w, w2)
Widget w,w2;
{
	XtAppContext app_context;
	Display *display;
	XEvent loop_event;
	int ret_value;
	Window window;
	Widget widget;
	widget = XtParent(w);
	app_context = XtWidgetToApplicationContext(widget);
	display = XtDisplay(widget);
	for (;;) {
	 XtAppNextEvent(app_context, &loop_event);
	 XSync(display, False);
	 if ( loop_event.type == MotionNotify ) {
	 	avs_set_event(1,1);
		exit(0);
	 }
	if (loop_event.type == Expose) {
		if (loop_event.xexpose.window == XtWindow(w)) {
		tet_infoline("PREP: Grab the pointer");
		ret_value = XtGrabPointer(w,True, FocusChangeMask,
		 GrabModeAsync, GrabModeAsync, XtWindow(w), None, CurrentTime);
		check_dec((long)GrabSuccess, ret_value, "XtGrabPointer return value");
		tet_infoline("PREP: Ungrab the pointer");
		XtUngrabPointer(w, CurrentTime);
		tet_infoline("PREP: Move the pointer");
		XWarpPointer(XtDisplay(w), XtWindow(w), XtWindow(w2), 1, 1 , 0, 0, 100,1);
		}
	}
	 XtDispatchEvent(&loop_event);
	} /* end for */
}
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	exit(0);
}

XtAppContext app_ctext ;
Widget topLevel, panedw, boxw1, boxw2 ;
Widget labelw, rowcolw, click_quit ;



#define T_XtUngrabPointer	1
char    *TestName = "XtUngrabPointer";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
int status;
Window window;
int ret_value;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtUngrabPointer-1.(A)");
	report_assertion("A successful call to void XtUngrabPointer(widget, time)");
	report_assertion("shall cancel the active pointer grab for the widget widget.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tunpointr1", "XtUngrabPointer");
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	analyse_events(panedw, boxw1);
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_infoline("TEST: MotionNotify events were not received.");
	status = avs_get_event(1);
	check_dec(0, status, "motion notify event count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.360092 */
/* End of included file Mdefcode.tmc.360092 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
