/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtInputMask
 *   XtPending()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
/*
** XtTMO1_Proc
*/
void XtTMO1_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("PREP: Generate some events");
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
	send_event(topLevel, KeyPress, KeyPressMask, TRUE );
}
/*
** XtTMO2_Proc
*/
void XtTMO2_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	/*
	** Queue should be empty at this point
	** KeyPress will wake up XtNextEvent, XtPending should then
	** find an empty queue.
	*/
	send_event(topLevel, KeyPress, KeyPressMask, TRUE);
}


#define T_XtPending	1
char    *TestName = "XtPending";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int pending, status = 0;
int type_event = 0;
XEvent loop_event;
Display *display;
Boolean processing;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtPending-1.(A)");
	report_assertion("When the calling process has at least one pending event");
	report_assertion("from the X server or an alternate source a successful call");
	report_assertion("to Boolean XtPending() shall return a nonzero value.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tpending1", "XtPending");
	FORK(pid2);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO1_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	display = XtDisplay(rowcolw);
	for (i = 0; i == 0;) {
		XtNextEvent( &loop_event);
		/*upon timeout we'll be sent two keypresses*/
		/*when the first appears see the second is pending*/
		if (loop_event.type == KeyPress) {
			processing = XtPending();
			avs_set_event(1, processing);
			exit(0);
		}
		XSync(display, False);
		XtDispatchEvent(&loop_event);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else {
		tet_infoline("TEST: XtPending returns non-zero value");
		status = avs_get_event(1);
		if (status == 0) {
			tet_infoline("Expected non-zero return from XtPending with events in the queue, received 0");
			tet_result(TET_FAIL);
		}
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362392 */
/* End of included file Mdefcode.tmc.362392 */

static void t002(){

pid_t pid2;
int status;
XEvent loop_event;
Display *display;
Boolean processing;
int i;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtPending-2.(A)");
	report_assertion("When no events are pending for the calling process a call");
	report_assertion("to Boolean XtPending() shall flush the output buffers of");
	report_assertion("every display in the calling process and return zero.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tpending2", "XtPending");
	FORK(pid2);
	tet_infoline("PREP: Register timeout");
	XtAddTimeOut(AVSXTLOOPTIMEOUT, XtTMO2_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: With no events pending zero is returned");
	display = XtDisplay(rowcolw);
	for (i = 0; i == 0;) { /* Begin for */
		XtNextEvent(&loop_event);
		XSync(display, False);
		/*
		** no events in wait state: processing = 0
		*/
		if (loop_event.type == KeyPress) {
			processing = XtPending();
			avs_set_event(1, processing);
			exit(0);
		}
		XtDispatchEvent(&loop_event);
	} /*end for */
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_result(TET_UNRESOLVED);
        }
	else {
		status = avs_get_event(1);
		check_dec(0, status, "XtPending return when queue is empty");
		tet_result(TET_PASS);
	}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.362392 */
/* End of included file Mdefcode.tmc.362392 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
