//===========================================================================
//
//      strcoll.cxx
//
//      Real function definition for ANSI string strcoll() function - not
//      that there is an inline alternative
//
//===========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:
//
//####DESCRIPTIONEND####
//
//===========================================================================

// CONFIGURATION

#include <pkgconf/libc.h>   // Configuration header

// Include the C library?
#ifdef CYGPKG_LIBC     

// INCLUDES

// We don't want the inline versions of string functions defined here

#ifdef CYGIMP_LIBC_STRING_INLINES
#undef CYGIMP_LIBC_STRING_INLINES
#endif

#include <cyg/infra/cyg_type.h>    // Common type definitions
#include <cyg/infra/cyg_trac.h>    // Tracing support
#include <cyg/infra/cyg_ass.h>     // Assertion support
#include <string.h>                // Header for this file
#include "clibincl/stringsupp.hxx" // Useful string function support and
                                   // prototypes

// EXPORTED SYMBOLS

externC int
strcoll( const char *s1, const char *s2 ) CYGPRI_LIBC_WEAK_ALIAS("_strcoll");


int
_strcoll( const char *s1, const char *s2 )
{
    int retval;

    CYG_REPORT_FUNCNAMETYPE( "_strcoll", "returning %d" );
    CYG_REPORT_FUNCARG2( "s1=%08x, s2=%d", s1, s2 );

    CYG_CHECK_DATA_PTR( s1, "s1 is not a valid pointer!" );
    CYG_CHECK_DATA_PTR( s2, "s2 is not a valid pointer!" );

    retval = _strcmp(s1, s2);

    return retval;
} // _strcoll()


#endif // ifdef CYGPKG_LIBC     

// EOF strcoll.cxx
