//=================================================================
//
//        eCosTestSerial.h
//
//        Serial test class
//
//=================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998, 1999 Cygnus Solutions.
// All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//=================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     sdf
// Contributors:  sdf
// Date:          1999-04-01
// Description:   This class abstracts the serial port for use in the testing infrastructure
// Usage:
//
// To Do:
//  o Unix body
//
//####DESCRIPTIONEND####

#ifndef _CECOSSERIAL_H
#define _CECOSSERIAL_H

#include "eCosTestUtils.h"
class CeCosTestSerial;
class CeCosTestSocket;
extern int SSRead (CeCosTestSerial &serial,CeCosTestSocket &socket,void *pBuf,unsigned int nSize,unsigned int &nRead);

class CeCosTestSerial {
    friend int SSRead (CeCosTestSerial &serial,CeCosTestSocket &socket,void *pBuf,unsigned int nSize,unsigned int &nRead);
public:
    enum StopBitsType { ONE, ONE_POINT_FIVE, TWO };
    CeCosTestSerial(const char *pszPort,int nBaud); // ctor and open all in one go
    CeCosTestSerial(); // Call Open() later
    virtual ~CeCosTestSerial(); // Call Open() later

    bool Open(const char *pszPort,int nBaud);

    // Set various line characteristics.  This can be done with the line open or closed.
    bool SetBaud(unsigned int nBaud,bool bApplySettingsNow=true);
    bool SetParity(bool bParityOn,bool bApplySettingsNow=true);
    bool SetDataBits(int n,bool bApplySettingsNow=true);
    bool SetStopBits(StopBitsType n,bool bApplySettingsNow=true);
    bool SetReadTimeOuts(int nTotal,int nBetweenChars,bool bApplySettingsNow=true); // mSec
    bool SetWriteTimeOuts(int nTotal,int nBetweenChars,bool bApplySettingsNow=true); // mSec

    bool ApplySettings();
    
    // Get them:
    int  GetParity() const { return m_bParity; }
    int  GetDataBits() const { return m_nDataBits; }
    StopBitsType GetStopBits() const { return m_nStopBits; }
    unsigned int GetBaud() const { return m_nBaud; }
    bool GetReadTimeOuts(int &nTotal,int &nBetweenChars) const {nTotal=m_nTotalReadTimeout; nBetweenChars=m_nInterCharReadTimeout; }// mSec
    bool GetWriteTimeOuts(int &nTotal,int &nBetweenChars) const {nTotal=m_nTotalWriteTimeout; nBetweenChars=m_nInterCharWriteTimeout; }// mSec
    bool GetBlockingReads() const { return m_bBlockingReads; }
    bool Close();

    bool Flush (void);

    // Use to test success after open ctor
    bool Ok() { return 0!=m_pHandle; }

    bool Read (void *pBuf,unsigned int nSize,unsigned int &nRead);
    bool Write(void *pBuf,unsigned int nSize,unsigned int &nWritten);

    // Will read up to the length of the string provided:
    bool Read (CeCosTestUtils::String &str);
    bool Write(const CeCosTestUtils::String &str);

    // Use in the event of an error that needs to be cleared before the next operation:
    bool ClearError();

    bool SetBlockingReads(bool b,bool bApplySettingsNow=true);
protected:
    void *m_pHandle;
    int m_nDataBits;
    StopBitsType m_nStopBits;
    bool m_bParity;
    unsigned int m_nBaud;
    int m_nTotalReadTimeout,m_nTotalWriteTimeout;
    int m_nInterCharReadTimeout,m_nInterCharWriteTimeout; 
    bool m_bBlockingReads;
    CeCosTestUtils::String m_strPort;
};
#endif
