//=================================================================
//
//        zlib2.c
//
//        zlib decompression test 2
//
//==========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     jskov
// Contributors:  jskov
// Date:          2001-03-09
// Description:   Tests zlib compression of gz compressed image.
//####DESCRIPTIONEND####


#include <cyg/hal/hal_arch.h>           // CYGNUM_HAL_STACK_SIZE_TYPICAL

#include <cyg/kernel/kapi.h>

#include <cyg/infra/testcase.h>

#ifdef CYGFUN_KERNEL_API_C

#include <cyg/compress/zlib.h>
#include <stdlib.h>

#define NTHREADS 1
#define STACKSIZE (CYGNUM_HAL_STACK_SIZE_TYPICAL > 8192 ? CYGNUM_HAL_STACK_SIZE_TYPICAL : 8192)

static cyg_handle_t thread[NTHREADS];

static cyg_thread thread_obj[NTHREADS];
static char stack[NTHREADS][STACKSIZE];


unsigned char gzip_test[] = {
0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x8d, 0x56, 0xdb, 0x6e, 0xe3, 0x36,
0x10, 0xed, 0x33, 0xbf, 0x82, 0x08, 0x50, 0x74, 0x03, 0xb8, 0xee, 0xa6, 0xed, 0x6e, 0x2f, 0x6f,
0xd9, 0x24, 0x8b, 0x06, 0xd8, 0x4b, 0x91, 0x2c, 0xba, 0xe8, 0x23, 0x4d, 0x8d, 0x6c, 0x22, 0x12,
0xa9, 0x92, 0x94, 0x9d, 0xfc, 0x7d, 0xcf, 0x0c, 0x25, 0x59, 0x72, 0x1a, 0xa0, 0x7e, 0x32, 0x45,
0x72, 0xe6, 0xcc, 0xcc, 0x99, 0x33, 0xbc, 0xa3, 0x4a, 0xff, 0x61, 0xb2, 0xa6, 0xab, 0x90, 0xf4,
0x9f, 0xfd, 0xa6, 0x71, 0x56, 0x7f, 0x70, 0x96, 0x7c, 0x22, 0xbd, 0xbf, 0x58, 0x5f, 0x28, 0xfc,
0x2e, 0xd6, 0xfa, 0xfa, 0xe6, 0xfd, 0xed, 0xa7, 0xdb, 0x2f, 0xb7, 0x9f, 0x3f, 0xdd, 0xf3, 0x1a,
0x5f, 0xce, 0xae, 0x82, 0xcf, 0xd1, 0x6d, 0xfa, 0x1c, 0xe2, 0x99, 0x6e, 0xc9, 0xf8, 0xa4, 0xc9,
0xd8, 0x9d, 0x26, 0x9f, 0x5d, 0x7e, 0xd2, 0x79, 0x07, 0xab, 0x36, 0x92, 0xc9, 0x94, 0x74, 0x88,
0xca, 0x8e, 0xc7, 0xb1, 0xcc, 0x01, 0xdb, 0x54, 0x76, 0x5d, 0xf0, 0x3a, 0xd4, 0xfa, 0x63, 0xa8,
0x5c, 0xed, 0xac, 0xac, 0xd3, 0x9a, 0x7d, 0xfc, 0xb8, 0xf4, 0xa1, 0xff, 0xa2, 0x98, 0xb0, 0x39,
0xfa, 0x12, 0x03, 0xa1, 0xdd, 0x38, 0x3f, 0xd9, 0xc0, 0x27, 0xf5, 0x39, 0xba, 0x2d, 0x3e, 0x35,
0xfa, 0x2a, 0x54, 0xb4, 0xd2, 0x5d, 0x74, 0xb8, 0xba, 0x30, 0xae, 0xfb, 0x84, 0x98, 0x37, 0x4f,
0xda, 0xa8, 0x99, 0xf9, 0x95, 0x36, 0xbe, 0x12, 0xa3, 0xcb, 0xc3, 0xad, 0xa9, 0x88, 0x0f, 0x73,
0x38, 0xaa, 0x33, 0x31, 0x3b, 0xdb, 0x37, 0x26, 0xea, 0xd9, 0x55, 0x41, 0xfb, 0x93, 0xa0, 0xdd,
0x53, 0x84, 0x6d, 0x76, 0x3d, 0x87, 0xb9, 0xc0, 0xc4, 0xb9, 0x58, 0xba, 0x00, 0xc0, 0xff, 0x0e,
0x66, 0x79, 0x51, 0x31, 0xc0, 0xc5, 0xcd, 0x95, 0x76, 0xbe, 0xe4, 0xdc, 0x1a, 0x94, 0xcb, 0x79,
0xdb, 0xf4, 0x95, 0xf3, 0x5b, 0xdd, 0x85, 0x28, 0x07, 0x14, 0x8c, 0x44, 0x0a, 0xb5, 0x20, 0xfc,
0x19, 0x08, 0x6f, 0x1a, 0xb2, 0x39, 0x06, 0x8f, 0x22, 0x5f, 0xbb, 0x54, 0x02, 0x60, 0x7f, 0x1f,
0xc9, 0xee, 0x8c, 0x77, 0xa9, 0x1d, 0x61, 0x1b, 0xd5, 0x8e, 0x9f, 0xf4, 0x96, 0x3c, 0x45, 0xd3,
0x34, 0xc8, 0x98, 0xb5, 0xd4, 0x65, 0x44, 0x08, 0xbf, 0x8c, 0x2f, 0x85, 0x3a, 0x1f, 0x4c, 0x24,
0x5d, 0xd1, 0x9e, 0x9a, 0xd0, 0xb5, 0xa8, 0x3d, 0x0a, 0xdd, 0xb6, 0xbd, 0x67, 0x0a, 0xd4, 0x43,
0x64, 0x74, 0xf4, 0x9a, 0x23, 0xac, 0xd7, 0x14, 0x39, 0xc2, 0xca, 0x64, 0x23, 0xc8, 0xde, 0x30,
0xb2, 0x47, 0xb2, 0x7d, 0x36, 0x9b, 0x66, 0xca, 0xdc, 0x3c, 0x9b, 0xec, 0xd0, 0x78, 0xb1, 0xd8,
0xea, 0xc0, 0x51, 0x21, 0x34, 0xe3, 0xf5, 0x7d, 0xe8, 0xa3, 0x25, 0x39, 0xb2, 0x86, 0xa1, 0xb7,
0x30, 0x74, 0x0b, 0xd7, 0x0e, 0x29, 0xbb, 0x2e, 0x90, 0x28, 0xce, 0x2b, 0xe1, 0x7c, 0xe5, 0xf6,
0xae, 0xea, 0xb1, 0x0f, 0x6c, 0x85, 0xa9, 0xca, 0x55, 0xfc, 0xa7, 0x76, 0xf0, 0x65, 0xca, 0xb1,
0x67, 0x36, 0xc6, 0x80, 0x67, 0xfe, 0x94, 0x0f, 0xe0, 0x02, 0xe9, 0x48, 0xff, 0xf4, 0x2e, 0x16,
0x46, 0xdd, 0x3c, 0xee, 0xdc, 0xc6, 0x65, 0x7d, 0x29, 0x61, 0xfd, 0x02, 0x34, 0x1f, 0x4c, 0xdc,
0xe2, 0xfa, 0xd7, 0x10, 0x1f, 0xa6, 0xd4, 0xea, 0x03, 0x56, 0xfa, 0xb0, 0x73, 0x5c, 0x38, 0x29,
0x3a, 0x4d, 0xd1, 0xaa, 0x81, 0x22, 0x53, 0x09, 0xf5, 0x50, 0x42, 0x7d, 0x70, 0x99, 0x8f, 0x63,
0x17, 0x8e, 0xf5, 0x96, 0x8f, 0xfb, 0xe2, 0x95, 0x69, 0x9f, 0x29, 0xb6, 0xa9, 0xd0, 0xc6, 0xa5,
0xb1, 0x81, 0x05, 0xc5, 0xaf, 0x8c, 0xa2, 0xac, 0x8f, 0x99, 0xc0, 0x99, 0x2a, 0xd8, 0x9e, 0xeb,
0x25, 0x87, 0x7e, 0xc3, 0xa1, 0x05, 0xb5, 0x26, 0xb0, 0x48, 0xba, 0xa9, 0x2a, 0x27, 0x2c, 0x41,
0xdb, 0x02, 0x59, 0x85, 0x72, 0xf2, 0x52, 0xd5, 0x31, 0xb4, 0x85, 0x06, 0xfd, 0x26, 0x65, 0xe3,
0xad, 0x00, 0x07, 0xab, 0x7a, 0x9b, 0x7b, 0x90, 0x02, 0x68, 0xc8, 0x31, 0xfc, 0x05, 0x97, 0xa7,
0x08, 0xd9, 0x74, 0x17, 0x69, 0xef, 0x42, 0x9f, 0x4e, 0xda, 0x5f, 0x7f, 0xdd, 0x91, 0x3f, 0x21,
0x40, 0x52, 0x11, 0x8e, 0x4d, 0x2a, 0x55, 0x32, 0x3a, 0x51, 0x74, 0x24, 0x21, 0xd7, 0xae, 0x21,
0xf4, 0x82, 0x59, 0x18, 0xc1, 0x85, 0xdf, 0x95, 0xd2, 0xfc, 0xbb, 0x5c, 0xeb, 0xcb, 0x97, 0xc3,
0xd0, 0x63, 0x18, 0xe5, 0x30, 0xcb, 0x14, 0xb2, 0x22, 0x86, 0x8d, 0x98, 0x96, 0x4f, 0xc6, 0x79,
0x6e, 0xac, 0x67, 0x9d, 0x2c, 0x77, 0x5e, 0x88, 0x62, 0x70, 0xff, 0xae, 0xb8, 0xf7, 0x74, 0x28,
0xe6, 0x8a, 0x30, 0x16, 0x9b, 0x25, 0xc1, 0x2c, 0x2b, 0xa3, 0x7e, 0xc9, 0x95, 0x53, 0x37, 0x2f,
0x7b, 0x80, 0x14, 0xbf, 0x46, 0xed, 0x16, 0x17, 0xc6, 0xda, 0xcd, 0xc8, 0xca, 0xd6, 0x41, 0xb5,
0x0e, 0xea, 0x1b, 0xd5, 0xd4, 0xb5, 0xc2, 0xa6, 0xc2, 0x43, 0x26, 0x04, 0x25, 0x0b, 0x41, 0x38,
0x76, 0xf7, 0xff, 0x25, 0x3b, 0xd7, 0xe3, 0x44, 0x76, 0x21, 0x55, 0x4a, 0x0c, 0xe3, 0x6f, 0x16,
0x63, 0xd9, 0xb5, 0x82, 0xc2, 0x21, 0xb5, 0x43, 0x21, 0x75, 0xef, 0x2b, 0x21, 0xc7, 0x91, 0xb1,
0x5c, 0x66, 0xa6, 0xb7, 0x69, 0x30, 0x1a, 0xaa, 0xa7, 0x25, 0x05, 0x96, 0x9c, 0x3f, 0xa1, 0xf9,
0x05, 0x8f, 0xa4, 0x19, 0xe2, 0x79, 0xd7, 0x23, 0x7b, 0x90, 0x1c, 0xb6, 0x53, 0xf4, 0xa3, 0x64,
0x7a, 0x61, 0x9b, 0xa5, 0xaa, 0x35, 0x0f, 0x5c, 0xe3, 0x76, 0x21, 0xce, 0x20, 0x8b, 0xcb, 0xab,
0xa3, 0xb6, 0x2a, 0x08, 0x21, 0x1f, 0xe9, 0xc1, 0x39, 0xec, 0x4c, 0x85, 0xc4, 0xa8, 0x69, 0xfa,
0xa1, 0x5f, 0x52, 0x0a, 0xd6, 0x99, 0xa2, 0x93, 0x48, 0x78, 0x6d, 0x2c, 0xa9, 0x8a, 0x6a, 0xe7,
0x0b, 0xff, 0x06, 0xbe, 0x72, 0xb6, 0xbb, 0x3c, 0x8c, 0x23, 0xb8, 0x91, 0x01, 0x19, 0x1a, 0xa9,
0x93, 0x6b, 0xc4, 0xbd, 0x48, 0x3e, 0x8c, 0x67, 0x38, 0x9d, 0x06, 0x03, 0x64, 0xef, 0x28, 0x96,
0x2b, 0xe9, 0x24, 0xdd, 0x40, 0xcc, 0x79, 0x2f, 0x49, 0x02, 0x94, 0x14, 0x16, 0x51, 0x20, 0x6a,
0x96, 0x36, 0x53, 0x8c, 0x9a, 0xe8, 0x12, 0x87, 0x64, 0xb6, 0x0c, 0x38, 0xcf, 0x9a, 0x53, 0x3d,
0x23, 0x9c, 0xf1, 0xa2, 0xb2, 0xfa, 0x40, 0x08, 0xf7, 0xc1, 0x87, 0x83, 0x47, 0x25, 0xf7, 0x06,
0xb8, 0xe0, 0xf4, 0x44, 0xac, 0xca, 0xac, 0x9a, 0x0d, 0xc4, 0xef, 0x92, 0xb6, 0xbb, 0x80, 0xe2,
0xac, 0xf5, 0x97, 0x25, 0x8f, 0x30, 0xa8, 0xbc, 0xde, 0x90, 0x62, 0x39, 0x17, 0x4c, 0x91, 0x12,
0x87, 0xcf, 0x1e, 0xa3, 0xdd, 0xb9, 0x3d, 0x20, 0x70, 0x8d, 0x78, 0x70, 0x07, 0x08, 0x35, 0xc9,
0x48, 0x56, 0xa6, 0xc3, 0x12, 0xa3, 0x1c, 0x39, 0x05, 0x4d, 0xc7, 0x7b, 0x92, 0x0f, 0x6e, 0xe4,
0xef, 0xcb, 0x5d, 0x2e, 0xde, 0xc4, 0x6d, 0x10, 0xe9, 0x80, 0xfb, 0x3c, 0xb4, 0x26, 0xd8, 0x5c,
0x64, 0x8f, 0x44, 0xef, 0x58, 0x94, 0x0b, 0x6b, 0xf8, 0x91, 0xf1, 0x77, 0xe8, 0x8f, 0x72, 0x77,
0x32, 0x22, 0x90, 0x5a, 0xda, 0xe2, 0xef, 0x30, 0x2a, 0xe8, 0x91, 0xa2, 0x75, 0x89, 0x3d, 0x21,
0x63, 0x3b, 0xae, 0x1e, 0x73, 0xb8, 0x3c, 0x1e, 0x18, 0x57, 0xf3, 0xc4, 0x7b, 0xa2, 0xd5, 0x4c,
0x94, 0x81, 0x6a, 0xa3, 0x3a, 0xaf, 0x96, 0x64, 0x17, 0xfb, 0x75, 0x2f, 0x62, 0xb9, 0x2f, 0xaf,
0x9b, 0x51, 0xc2, 0xd5, 0xb1, 0x21, 0x52, 0x8f, 0x2c, 0x94, 0x56, 0xb9, 0xc7, 0x1c, 0xe5, 0x43,
0x6f, 0xf9, 0x01, 0xf6, 0x1e, 0xd7, 0x67, 0xe0, 0x20, 0x86, 0x2b, 0x55, 0x62, 0x29, 0x64, 0xa5,
0xc2, 0xc6, 0xe1, 0x39, 0x36, 0x8e, 0x1b, 0xe1, 0x18, 0xbf, 0x1c, 0xd2, 0xb8, 0x68, 0x50, 0xc8,
0xcd, 0x93, 0x10, 0xc9, 0x0d, 0xf1, 0x70, 0x28, 0x2d, 0xfc, 0x8c, 0x94, 0x94, 0x78, 0x60, 0xba,
0x38, 0xed, 0xfa, 0xd8, 0x85, 0x24, 0xda, 0xab, 0xca, 0x28, 0x99, 0xb8, 0xbd, 0xd2, 0x67, 0xc3,
0x9d, 0x31, 0xa3, 0xaf, 0xcc, 0x79, 0xe9, 0xc1, 0x70, 0xe0, 0x3c, 0x55, 0x50, 0x0f, 0x9b, 0x15,
0xfb, 0xf2, 0xe5, 0xff, 0x4a, 0xb8, 0x6f, 0xd0, 0x05, 0x72, 0xae, 0x7c, 0x1c, 0x4a, 0xdb, 0x1a,
0x6f, 0xb6, 0xc4, 0x53, 0x8a, 0x7d, 0xa5, 0x7e, 0x7a, 0x5d, 0xae, 0x10, 0x0f, 0x09, 0x41, 0xa1,
0x05, 0xe2, 0xd1, 0xd8, 0xcc, 0x37, 0x84, 0xb5, 0x07, 0x97, 0x4a, 0x63, 0xbc, 0xda, 0x9c, 0x2b,
0x50, 0x17, 0xa9, 0xdd, 0xb9, 0xae, 0x8c, 0x8a, 0x1a, 0xb9, 0xc0, 0x40, 0xb7, 0x6c, 0xf3, 0xd5,
0x9b, 0xd7, 0xdf, 0x9e, 0x8b, 0x9f, 0x10, 0x47, 0x1e, 0xab, 0xd0, 0x67, 0x1e, 0x66, 0xf2, 0x8e,
0x4a, 0x60, 0x8a, 0xbc, 0x5e, 0xc1, 0x59, 0x8f, 0x20, 0x2d, 0xb7, 0xd2, 0xc2, 0x20, 0x63, 0x52,
0x05, 0x53, 0x21, 0x14, 0xbf, 0x03, 0xef, 0x86, 0x37, 0xf5, 0x3b, 0x3c, 0x76, 0xaa, 0xe9, 0x3d,
0x28, 0x19, 0xaf, 0x06, 0xfd, 0x1f, 0x8e, 0xa8, 0x6a, 0x7c, 0x85, 0x49, 0xb5, 0xaa, 0x1f, 0x38,
0xbd, 0x20, 0x0b, 0xab, 0xa4, 0x84, 0x22, 0x02, 0x74, 0x3c, 0x54, 0xca, 0xa3, 0xa6, 0xd6, 0xd6,
0x85, 0x59, 0xf2, 0x16, 0xe2, 0xec, 0xdd, 0xbd, 0xfc, 0x9a, 0x5f, 0xab, 0x61, 0x13, 0xdd, 0x39,
0x07, 0x86, 0x24, 0x3f, 0x8d, 0x2a, 0x36, 0x4c, 0xa2, 0x38, 0xe7, 0xee, 0x5c, 0x26, 0xd7, 0xea,
0x9b, 0x7f, 0x01, 0x21, 0xe0, 0xda, 0x98, 0x30, 0x0c, 0x00, 0x00};

unsigned char gzip_test_ref[] =
"Red Hat eCos Public License v1.1\n"
"\n"
"\n"
"\n"
"1. DEFINITIONS\n"
"\n"
"1.1. \"Contributor\" means each entity that creates or\n"
"contributes to the creation of Modifications.\n"
"\n"
"1.2. \"Contributor Version\" means the combination of the\n"
"Original Code, prior Modifications used by a\n"
"Contributor, and the Modifications made by that\n"
"particular Contributor.\n"
"\n"
"1.3. \"Covered Code\" means the Original Code or\n"
"Modifications or the combination of the Original Code\n"
"and Modifications, in each case including portions\n"
"thereof.\n"
"\n"
"1.4. \"Electronic Distribution Mechanism\" means a\n"
"mechanism generally accepted in the software development\n"
"community for the electronic transfer of data.\n"
"\n"
"1.5. \"Executable\" means Covered Code in any form other\n"
"than Source Code.\n"
"1.6. \"Initial Developer\" means the individual or entity\n"
"identified as the Initial Developer in the Source Code\n"
"notice required by Exhibit A.\n"
"\n"
"1.7. \"Larger Work\" means a work which combines Covered\n"
"Code or portions thereof with code not governed by the\n"
"terms of this License.\n"
"\n"
"1.8. \"License\" means this document.\n"
"\n"
"1.9. \"Modifications\" means any addition to or deletion\n"
"from the substance or structure of either the Original\n"
"Code or any previous Modifications. When Covered Code is\n"
"released as a series of files, a Modification is:\n"
"\n"
"     A. Any addition to or deletion from the\n"
"     contents of a file containing Original Code or\n"
"     previous Modifications.\n"
"\n"
"     B. Any new file that contains any part of the\n"
"     Original Code or previous Modifications.\n"
"\n"
"1.10. \"Original Code\" means Source Code of computer\n"
"software code which is described in the Source Code\n"
"notice required by Exhibit A as Original Code, and\n"
"which, at the time of its release under this License is\n"
"not already Covered Code governed by this License.\n"
"\n"
"1.11. \"Source Code\" means the preferred form of the\n"
"Covered Code for making modifications to it, including\n"
"all modules it contains, plus any associated interface\n"
"definition files, scripts used to control compilation\n"
"and installation of an Executable, or a list of source\n"
"code differential comparisons against either the\n"
"Original Code or another well known, available Covered\n"
"Code of the Contributor's choice. The Source Code can be\n"
"in a compressed or archival form, provided the\n"
"appropriate decompression or de-archiving software is\n"
"widely available for no charge.\n"
"\n"
"1.12. \"You\" means an individual or a legal entity\n"
"exercising rights under, and complying with all of the\n"
"terms of, this License or a future version of this\n"
"License issued under Section 6.1. For legal entities,\n"
"\"You\" includes any entity which controls, is controlled\n"
"by, or is under common control with You. For purposes of\n"
"this definition, \"control\" means (a) the power, direct\n"
"or indirect, to cause the direction or management of\n"
"such entity, whether by contract or otherwise, or (b)\n"
"ownership of fifty percent (50%) or more of the\n"
"outstanding shares or beneficial ownership of such\n"
"entity.\n"
"\n"
"1.13. \"Red Hat Branded Code\" is code that Red Hat\n"
"distributes and/or permits others to distribute under\n"
"different terms than the Red Hat eCos Public License.\n"
"Red Hat's Branded Code may contain part or all of the\n"
"Covered Code.\n";

static void entry0( cyg_addrword_t data )
{
    int i;
    unsigned long len;
    int err;
    int buf_size = sizeof(gzip_test_ref)+512;
    unsigned char* unpacked = malloc(buf_size);
    
    if (NULL == unpacked)
        CYG_TEST_NA("Not enough memory for buffers");

    CYG_TEST_INFO("Decompressing");
    len = buf_size;
    err = uncompress(unpacked, &len, gzip_test, sizeof(gzip_test));

    switch (err) {
    case Z_OK:
        break;
    case Z_MEM_ERROR:
        CYG_TEST_NA("Not enough memory for decompression");
        break;
    case Z_BUF_ERROR:
        CYG_TEST_FAIL_FINISH("Decompressed data larger than original");
        break;
    case Z_DATA_ERROR:
        CYG_TEST_FAIL_FINISH("Decompression failed");
        break;
    default:
        CYG_TEST_FAIL_FINISH("Unknown decompression error");
        break;
    }

    for (i = 0; i < sizeof(gzip_test_ref)-1; i++) {
        if (gzip_test_ref[i] != unpacked[i])
            CYG_TEST_FAIL_FINISH("Verify failed");
    }

    CYG_TEST_PASS_FINISH("zlib2 OK");
}

void zlib2_main( void )
{
    CYG_TEST_INIT();

    cyg_thread_create(4, entry0 , (cyg_addrword_t)0, "zlib1",
        (void *)stack[0], STACKSIZE,&thread[0], &thread_obj[0]);
    cyg_thread_resume(thread[0]);

    cyg_scheduler_start();

    CYG_TEST_FAIL_FINISH("Not reached");
}

externC void
cyg_start( void )
{ 
    zlib2_main();
}

#else /* def CYGFUN_KERNEL_API_C */
externC void
cyg_start( void )
{
    CYG_TEST_INIT();
    CYG_TEST_NA("Kernel C API layer disabled");
}
#endif /* def CYGFUN_KERNEL_API_C */

// EOF zlib1.c
