//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that taking the address of an overloaded member function
// is allowed even where the address value is not immediately
// assigned to a variable (of the appropriate type) but rather
// serves as an operand of a trinary ?: operator.

struct base
{
	int member;

	void member_1 (int i) { member = i; }
	void member_1 (int i, int j) { member = i+j; }
	void member_2 (int i) { member = i; }
	void member_2 (int i, int j) { member = i+j; }
};

typedef void (base::*mfp_t) (int, int);

mfp_t mfp;
int i;

int main ()
{
	mfp = i ? &base::member_1 : &base::member_2;
	return 0;
}
